<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Backup extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Backup Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFiles($headers){
        $url = $this->api->getUrl('backupFiles');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function getDevices($headers, $userName){
        $url = $this->api->getUrl('backupDevices', array('userName' => $userName));
        Model::req($url,$headers,$userName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        if($this->curl->http_status_code == 200){
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        }else{
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code
            );
        }
        $this->log('url: '.$url, 'info');
        $this->log('result: '.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileVersions($headers){
        $url = $this->api->getUrl('backupFileVersions');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileChunks($headers){
        $url = $this->api->getUrl('fileChunks');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $dataString
     * @return array
     */
    public function backupFileDelete($headers, $dataString){
        $url = $this->api->getParacloudUrl('backupFileDelete');
        Model::req($url,$headers,$dataString);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url, $dataString);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function download($headers)
    {
        $pms = new Pms();
        $blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
        }
        $url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$_SESSION['cloudName'].DS.'portal'.DS.'download'.DS.'files'.DS;
        $url = $url.$this->getStringForGetFromArray($headers);
        Model::req($url,$headers,$data);
        $this->log("url: ".$url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function downloadShare($headers)
    {
        $pms = new Pms();
        $blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
        }
	$url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$headers['cloudName'].DS.'portal'.DS.'download'.DS.'files'.DS;        
        $url = $url.$this->getStringForGetFromArray($headers);
        Model::req($url,$headers,$data);
        $this->log("url: ".$url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function searchInDevices($headers){
        $url = $this->api->getUrl('searchDevices');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllDevices($headers){
        $url = $this->api->getUrl('listOfDevices');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function shareFile($headers, $elements){
        $url = $this->api->getUrl('syncFileShare');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function updateSharePolicy($headers, $elements){
        $url = $this->api->getUrl('updateSharePolicy');
        Model::req($url,$headers,$elements);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @param $policyName
     * @return array
     */
    public function getPolicy($headers, $policyName){
        $url = $this->api->getUrl('getPolicy', array('policyName' => $policyName));
        Model::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function isSharedOrNot($headers){
        $url = $this->api->getUrl('isSharedOrNot');
        Model::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getUserBackupPolicy($headers){
        $url = $this->api->getUrl('getUserBackupPolicy');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $xml
     * @return array
     */
    public function unShare($headers, $xml){
        $url = $this->api->getUrl('unShare');
        Model::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->curl->post($url, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
        Model::req($url,$headers,$cloudDetails);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function downloadFolder($headers, $userName, $fileName,$syncRevisionId,$filePath,$deviceUUID,$gatewayName){
        //$this->curl->setTimeout(1200);
	$this->curl->setTimeout(0);
        $url = $this->api->getUrl('downloadFolder', array('userName' => $userName,'fileName'=> $fileName, 'syncRevisionId'=>$syncRevisionId, 'filePath'=>$filePath, 'deviceUUID'=>$deviceUUID));
        Model::req($url,$headers,$userName);
        $this->curl->setHeaders($headers);
        $url = $url.'?userName='.$userName.'&fileName='.$fileName.'&gatewayName='.$gatewayName.'&deviceUUID='.$deviceUUID.'&syncRevisionId='.$syncRevisionId;
        $this->log("URL : ".$url,"info");
        $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        $this->log('result: '.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteFolderNew($headers){
        $url = $this->api->getUrl('deleteFolderNew');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
            );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getFiles1($headers){
//        $url = $this->api->getUrl('backupFiles1');
        $pageNumber = 1;
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/cloud/".CLOUD_NAME."/backup/mail/msgs/child?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getFilesOutlookNavigate($headers, $url){
//        $url = $this->api->getUrl('backupFiles1');
        $url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function viewOutlook($headers){
        $url = $this->api->getUrl('viewOutlook');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getSearchResultsOutlook($headers, $searchType, $pageNumber){
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/cloud/".CLOUD_NAME."/search/file?pageNumber=".$pageNumber;
//        $url = $this->api->getUrl($searchType);
        Model::req($url,$headers,$searchType);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getSearchResultsOutlookNavigate($headers, $searchType, $url){
	$url = PROTOCOL.PARACLOUD_IP.$url;
//        $url = $this->api->getUrl($searchType);
        Model::req($url,$headers,$searchType);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getDevicesForRestorePage($headers, $deviceUUID){
        $url = $this->api->getUrl('getDevicesForRestorePage', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function initiateRestores($headers, $data){
        $url = $this->api->getParacloudUrl('initiateRestores');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function deleteRestores($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestores', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOneDriveUserBackupPolicy($headers){
         $url = $this->api->getUrl('getOneDriveUserBackupPolicy');
         Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'url' => $url,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }

    public function initiateRestoresOneDrive($headers, $data){
	    $this->log("blukeypttttttttttttttt called","info");
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function deleteRestoresOneDrive($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }    

    public function initiateRestoresOutlook($headers, $data){
            $this->log("blukeypttttttttttttttt called","info");
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteRestoresOutlook($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function initiateRestoresOutlookFile($headers, $data){
            $this->log("blukeypttttttttttttttt called","info");
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteRestoresOutlookFile($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getAllDevices11($headers,$pageNumber){
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/device/all?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        if($this->curl->http_status_code == 200){
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response
            );
        }else{
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code
            );
        }
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function getDeviceId($headers, $deviceId){
        $url = $this->api->getUrl('getDeviceId', array('deviceId' => $deviceId));
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function initiateRestoresOutlookSearchFileGS($headers, $data){
        $url = $this->api->getBlukryptUrl('initiateRestoresOneDrive');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function deleteRestoresOutlookSearchFileGS($headers, $deviceUUID){
        $url = $this->api->getParacloudUrl('deleteRestoresOneDrive', array('deviceUUID' => $deviceUUID));
        Model::req($url,$headers,$deviceUUID);
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function changePasswordForFirstlogin($headers){
        $url = $this->api->getUrl('changePasswordForFirstlogin');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function sendShareEmail($headers,$data){
        $url = $this->api->getUrl('sendEmailBackup');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function selectedFles($headers, $data){
        $this->curl->setTimeout(0);
        $url = $this->api->getUrl('selectedFles');
        Model::req($url,$headers,$userName);
        $this->curl->setHeaders($headers);
        $this->log("URL : ".$url,"info");
        $this->curl->post($url, $data);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
        $this->log('result: '.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
