<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use DOMDocument;
use Helpers\Auth;
use Helpers\Url;
use Models\User;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class UserController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;
    protected $_codeLength = 6;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('user');
        $this->_model = new User();
    }

    /**
     * Display for my account details
     * @param string $username
     */
    public function myAccount($username = ''){       
        $username = !empty($username) ? htmlentities($username) : base64_encode($this->session->get('userName'));
	$username = htmlentities($username);
        $this->auth->checkLoggedInUser($username);
        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $username);
        $this->log('USERNAMEEEE: '.$username , 'info');
        if(Auth::checkCloudPermission('serverBackup') && Auth::checkUserPermission('admin') == false){
            Url::redirect('servers');
        }
        $enableChangePasswordUser = 'false';
        $enableChangePasswordAdmin = 'false';
	$backupFlag = 'false';
	$ODBFlag = 'false';
        $this->log("before ","info");
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $this->log("after ","info");
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
	$showAuditHistory = $cloudProperties['body']->{'cloudPropertyElement'}->{'showAuditHistory'};
        $this->session->put('showAuditHistory',$showAuditHistory);
        if($this->session->get('admin') == true){
                $this->session->put('showAuditHistory',true);
        }else if($this->session->get('readOnlyAdmin') == true){
                $this->session->put('showAuditHistory',$showAuditHistory);
        }else{
                $this->session->put('showAuditHistory',true);
        }
        $this->log('passwordChangeEnforce_cloud : '.$passwordChangeEnforce , 'info');
        $this->log('canUserChangePassword_cloud : '.$canUserChangePassword , 'info');
        $this->log('canAdminChangeUserPassword_cloud : '.$canAdminChangeUserPassword , 'info'); 
            if($canUserChangePassword == '1'){
            $enableChangePasswordUser = 'true';
            }
            if($canAdminChangeUserPassword == '1'){
            $enableChangePasswordAdmin = 'true';
            }

    	if($passwordChangeEnforce != true){
        	if(Auth::checkCloudPermission('sync') == true){
		    $enableChangePasswordUser = 'false';
		    $enableChangePasswordAdmin = 'false';
		    $syncPolicyName = (string)$userDetails['body']->{'sync-policy-name'};
		    $result1 = $this->_model->getSyncPolicy(array('token' => $this->session->get('token')), $syncPolicyName);
		    $canUserChangePassword = (boolean)$result1['body']->{'syncPolicyElement'}->{'canUserChangePassword'};
		    $canAdminChangeUserPassword = (boolean)$result1['body']->{'syncPolicyElement'}->{'canAdminChangeUserPassword'};
		    if($canUserChangePassword == '1'){
		    $enableChangePasswordUser = 'true';
		    }
		    if($canAdminChangeUserPassword == '1'){
		    $enableChangePasswordAdmin = 'true';
		    }
		    $this->log('canUserChangePasswordSSSSS : '.$enableChangePasswordUser , 'info');
		    $this->log('canAdminChangeUserPasswordSSSSS : '.$enableChangePasswordAdmin , 'info');
        	}

		if(Auth::checkCloudPermission('backup') == true){
		    $enableChangePasswordUser = 'false';
		    $enableChangePasswordAdmin = 'false';
		    $policyName = (string)$userDetails['body']->{'policy-name'};
		    $result = $this->_model->getPolicy(array('token' => $this->session->get('token')), $policyName);
		    $canUserChangePassword = (boolean)$result['body']->{'backupPolicyElement'}->{'canUserChangePassword'};
		    $canAdminChangeUserPassword = (boolean)$result['body']->{'backupPolicyElement'}->{'canAdminChangeUserPassword'};
		    if($canUserChangePassword == '1'){
		    $enableChangePasswordUser = 'true';
		    }
		    if($canAdminChangeUserPassword == '1'){
		    $enableChangePasswordAdmin = 'true';
		    }
		    $this->log('canUserChangePasswordBBBB : '.$enableChangePasswordUser , 'info');
		    $this->log('canAdminChangeUserPasswordBBBBB : '.$enableChangePasswordAdmin , 'info');
		}

		if(Auth::checkCloudPermission('sync') == true && Auth::checkCloudPermission('backup') == true){
			$enableChangePasswordUser = 'false';
			$enableChangePasswordAdmin = 'false';
			$policyName = (string)$userDetails['body']->{'policy-name'};
			$syncPolicyName = (string)$userDetails['body']->{'sync-policy-name'};
			$result = $this->_model->getPolicy(array('token' => $this->session->get('token')), $policyName);
			$result1 = $this->_model->getSyncPolicy(array('token' => $this->session->get('token')), $syncPolicyName);
			$canUserChangePasswordBkp = (boolean)$result['body']->{'backupPolicyElement'}->{'canUserChangePassword'};
			$canAdminChangeUserPasswordBkp = (boolean)$result['body']->{'backupPolicyElement'}->{'canAdminChangeUserPassword'};
			$canUserChangePasswordSync = (boolean)$result1['body']->{'syncPolicyElement'}->{'canUserChangePassword'};
			$this->log("hhhhhhhhhhh : ".json_encode($result1),"info");
			$canAdminChangeUserPasswordSync = (boolean)$result1['body']->{'syncPolicyElement'}->{'canAdminChangeUserPassword'};
			if($canUserChangePasswordBkp == '1' && $canUserChangePasswordSync == '1'){
			    $enableChangePasswordUser = 'true';
			}
			if($canAdminChangeUserPasswordBkp == '1' && $canAdminChangeUserPasswordSync == '1'){
			    $enableChangePasswordAdmin = 'true';
			}
			$this->log('canUserChangePasswordBkp : '.$canUserChangePasswordBkp , 'info');
			$this->log('canAdminChangeUserPasswordBkp : '.$canAdminChangeUserPasswordBkp , 'info');
			$this->log('canUserChangePasswordSync : '.$canUserChangePasswordSync , 'info');
			$this->log('canAdminChangeUserPasswordSync : '.$canAdminChangeUserPasswordSync , 'info');
		}
    	}
        $this->log('enableChangePasswordUser : '.$enableChangePasswordUser , 'info');
        $this->log('enableChangePasswordAdmin : '.$enableChangePasswordAdmin , 'info');
        if($enableChangePasswordAdmin == 'false'){
            $this->log('enableChangePasswordAdmin_______>', 'info');
        }

        $this->log("ffffffffffffffffff: ".$result1['body']->{'syncPolicyElement'}->{'canUserChangePassword'},"info");
	$overridePolicySettings = $cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'};
	$canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$allowEndUserTocontrolRestore = $cloudProperties['body']->{'cloudPropertyElement'}->{'allowEndUserTocontrolRestore'};
	$isAdminDeleteBackupFile = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
	if($this->session->get('firstLogin1') == "true" && $this->session->get('localUser') == '1' && $this->session->get('userName') == $userDetails['body']->{'user-name'}){
            $this->log("hhhhhhhhhhhh","info");
            $visible = 'visible';
        }
        if($userDetails['body']->{'response-code'} != 500){
            $data = array(
                'title' => $this->language->get('indexPageName'),
                'subPageName' => $this->language->get('profilePage'),
                'active' => 'users',
                'csrf_token' => $this->setCSRFToken(),
                'userDetails' => $userDetails['body'],
                'loggedInUser' => $this->session->all(),
                'popup' => $visible,
                'canAdminRestore' => $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'},
                'canAdminRestoreBackupPolicy' => $userDetails['body']->{'backupPolicyElement'}->{'canAdminRestore'},
		'canAdminRestoreOneDrivePolicy' => $userDetails['body']->{'officeBackupPolicyElement'}->{'canAdminRestore'},
                'showLatestBkpInfo' => $cloudProperties['body']->{'cloudPropertyElement'}->{'showLatestBkpInfo'},
                'enableChangePasswordUser' => $enableChangePasswordUser,
                'enableChangePasswordAdmin' => $enableChangePasswordAdmin,
                'activateEdit' => !empty($username && $this->session->get('admin') == true) ? true : false,
		'overridePolicySettings' => $overridePolicySettings,
		'canAdminRestoreAll' => $canAdminRestoreAll,
		'allowEndUserTocontrolRestore' => $allowEndUserTocontrolRestore,
		'isAdminDeleteBackupFile' => $isAdminDeleteBackupFile,
            );
	
	$showButtons = 'false';
        $showBackupButtons = 'false';
        $showOnedriveButtons = 'false';
        $canAdminRestoreBackupPolicy = $userDetails['body']->{'backupPolicyElement'}->{'canAdminRestore'};
        if($cloudProperties['body']->{'cloudPropertyElement'}->{'allowEndUserTocontrolRestore'} == true){
                $data['allowEndUserTocontrolRestoreGS'] = 'true';
        }else{
                $data['allowEndUserTocontrolRestoreGS'] = 'false';
        }
        if($userDetails['body']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == true){
                $data['allowEndUserTocontrolRestoreBP'] = 'true';
        }else{
                $data['allowEndUserTocontrolRestoreBP'] = 'false';
        }
        if($userDetails['body']->{'officeBackupPolicyElement'}->{'allowEndUserTocontrolRestore'} == true){
                $data['allowEndUserTocontrolRestoreOP'] = 'true';
        }else{
                $data['allowEndUserTocontrolRestoreOP'] = 'false';
        }
        $canAdminRestoreOneDrivePolicy = $userDetails['body']->{'officeBackupPolicyElement'}->{'canAdminRestore'};
        if($cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'} == true){
                if($cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'} == true && $cloudProperties['body']->{'cloudPropertyElement'}->{'allowEndUserTocontrolRestore'} == false){
                        $showButtons = 'true';
                }
                if($cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'} == true && $cloudProperties['body']->{'cloudPropertyElement'}->{'allowEndUserTocontrolRestore'} == true){
                        $showButtons = 'true';
                }
        }else{
                $this->log("elseeeeeeeeee","info");
		if($userDetails['body']->{'backupPolicyElement'}->{'canAdminRestore'} == false){
                        $this->log("for backup : ".$userDetails['body']->{'backupPolicyElement'}->{'canAdminRestore'},"info");
                }
                if(($userDetails['body']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true' && $userDetails['body']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true') || ($userDetails['body']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true' && $userDetails['body']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'false')){
                        $this->log("yessssssssssssssssssssss","info");
                        $showBackupButtons = 'true';
                }
                if(($userDetails['body']->{'officeBackupPolicyElement'}->{'canAdminRestore'} == 'true' && $userDetails['body']->{'officeBackupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true') || ($userDetails['body']->{'officeBackupPolicyElement'}->{'canAdminRestore'} == 'true' && $userDetails['body']->{'officeBackupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'false')){
                        $showOnedriveButtons = 'true';
                }
        }
        $data['showButtons'] = $showButtons;
        $data['showBackupButtons'] = $showBackupButtons;
        $data['showOnedriveButtons'] = $showOnedriveButtons;

        $this->log("show buttons".json_encode($showButtons),"info");
        $this->log("show backup buttons".json_encode($showBackupButtons),"info");
        $this->log("show onedrive buttons".json_encode($showOnedriveButtons),"info");
        $this->log("allowEndUserTocontrolRestoreGS ".$data['allowEndUserTocontrolRestoreGS'],"info");		
		
	if($userDetails['body']->{'backup-enabled'} == 'true'){
	  if($userDetails['body']->{'backupPolicyElement'}){
		  $someArray = $userDetails['body']->{'backupPolicyElement'}->{'menuOptions'}->{'entry'};
		  for($x=0; $x < sizeof($someArray); $x++){          
			  if($someArray[$x]->{'key'} == 'restore'){
				$backupFlag = $someArray[$x]->{'value'};
			  }
		  }
		  $data['bkpRestore'] = $backupFlag;
	  }
	}


	if($userDetails['body']->{'onedriveBkpEnabled'} == 'true' || $userDetails['body']->{'exchangeBkpEnabled'} == 'true'){
	  if($userDetails['body']->{'officeBackupPolicyElement'}){
		  $someArray = $userDetails['body']->{'officeBackupPolicyElement'}->{'menuOptions'}->{'entry'};
		  for($x=0; $x < sizeof($someArray); $x++){          
			  if($someArray[$x]->{'key'} == 'restore'){
				$ODBFlag = $someArray[$x]->{'value'};
			  }
		  }
		  $data['ODBRestore'] = $ODBFlag;
	  }
	}

            if($this->session->get('userName') == $userDetails['body']->{'user-name'}){
                        $data['lastLoggedInTime'] = $this->session->get('lastLoggedInTime');
                    }
                    else{
                        $data['lastLoggedInTime'] = $userDetails['body']->{'lastLoggedInTime'};
        }

            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('users/profile', $data);
            View::renderTemplate('footer', $data);
        }else{
            Url::redirect('404');
        }

    }

    public function getAllUserDevices(){
	$this->verifyAndCleanItUp();
        if(!empty($_POST['userName'])){
            $this->valid->filter($_POST, array('userName' => 'trim|sanitize_string'));
            $result = $this->_model->getUserDevices(array('token' => $this->session->get('token'), 'userName' => $_POST['userName']));
            $assignedResult = $this->_model->getUserAssignedDevices(array('Accept' => 'application/json','token' => $this->session->get('token'), 'userName' => $_POST['userName']));
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    $assignDevices = [];
                    $blockedDevices = [];
                    if($result['body']->bluSyncPortalBackupElement->devices){
                        foreach($result['body']->bluSyncPortalBackupElement->devices as $value){
			    if($value->blocked == true){
                                    $isblocked = 'blocked';
                            }else{
                                    $isblocked = 'active';
                            }
                            $device = array(
                                'deviceName' => $value->deviceName,
				'userName' => $result['body']->bluSyncPortalBackupElement->userName,
                                'deviceId' => $value->deviceId,
                                'deviceUUID' => $value->deviceUUID,
                                'storageUsedByDevice' => $value->storageUsedByDevice,
                                'windowsDevice' => $value->windowsDevice,
                                'blocked' => $isblocked,
				'canAdminRestore' => $value->canAdminRestore,
                                'deviceType' => $value->deviceType,
                                //'icon' => $this->getOsIcon($value->deviceType),
                                'icon' => ((string)$value->deviceType == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->deviceType),
                                'background' => ($value->blocked == false) ? $this->getBackground($value->deviceType) : 'danger',
                                //'background' => ($value->windowsDevice == 'true') ? 'purple' : 'primary'
                            );
                            /*if($value->blocked != true){
                                $devices = array_merge(array($device), $devices);
                            }else{
                                $blockedDevices = array_merge(array($device), $blockedDevices);
                            }*/
			    $devices = array_merge(array($device), $devices);
                        }
                    }

                    if($assignedResult['body']->{'deviceElementList'}){
                        foreach($assignedResult['body']->{'deviceElementList'} as $value){
			    if($value->blocked == true){
                                    $isblocked = 'blocked';
                            }else{
                                    $isblocked = 'active';
                            }
                            $assignDevice = array(
                                'deviceName' => $value->deviceName,
				'userName' => base64_encode($value->userName),
                                'deviceId' => $value->deviceId,
                                'deviceUUID' => $value->deviceUUID,
                                'storageUsedByDevice' => $value->storageUsedByDevice,
                                'windowsDevice' => $value->windowsDevice,
                                'deviceType' => $value->deviceType,
                                'blocked' => $isblocked,
                                //'icon' => $this->getOsIcon($value->deviceType),
                                'icon' => ((string)$value->osType == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->osType),
				'background' => ($value->blocked == false) ? $this->getBackground($value->osType) : 'danger',   
                                //'background' => ($value->windowsDevice == 'true') ? 'purple' : 'primary'
                            );
                            $assignDevices = array_merge(array($assignDevice), $assignDevices);
                        }
                    }
                    $this->log("assignDevice : ".json_encode($assignDevices),"info");
                    $this->log("blockedDevice : ".json_encode($blockedDevices),"info");
                    $used = '';
                    $free = '';
                    $storage = $result['body']->bluSyncPortalBackupElement->storageUsed;
                    $limit = 25;
                    if(stripos($storage, 'MB') != false){
                        $storage = str_replace('MB', '', $storage);
                        $usedInMB = (double)$storage;
                        $used = round(($usedInMB/1024), 2);
                        while($limit < $used){
                            $limit = $limit + 25;
                        }
                        $free = $limit - $used;
                    }elseif(stripos($storage, 'GB') != false){
                        $storage = str_replace('GB', '', $storage);
                        $used = (double)$storage;
                        while($limit < $used){
                            $limit = $limit + 25;
                        }
                        $free = $limit - $used;
                    }
                    if((string)$result['header']->{'container'}['policyconfiguration'] != ""){
                    $response = array(
                        'result' => 'success',
                        'storage' => $storage,
                        'free' => $free,
                        'limit' => $limit,
                        'used' => $used,
                        'devices'  => $devices,
                        'assignDevices' => $assignDevices,
                        'blockedDevices' => $blockedDevices,
                        'policyconfiguration' => (string)$result['header']->{'container'}['policyconfiguration']
                    );
                    }
                    else {
                    $response = array(
                        'result' => 'success',
                        'storage' => $storage,
                        'free' => $free,
                        'limit' => $limit,
                        'used' => $used,
                        'devices'  => $devices,
                        'assignDevices' => $assignDevices,
                        'blockedDevices' => $blockedDevices
                    );    
                    }
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /**
     * Displays Settings page
     * @param string $username
     */
    public function settings($username = ''){
        //$username = !empty($username && $this->session->get('admin') == true) ? htmlentities($username) : $this->session->get('userName');
	$username = htmlentities($username);
        $this->auth->checkLoggedInUser($username);
        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $username);
        $backupResult = $this->_model->getAllPolicies(array('token'=>$this->session->get('token'), 'userEditProfile' => 'true'));
        $syncResult = $this->_model->getAllSyncPolicies(array('token'=>$this->session->get('token'), 'userEditProfile' => 'true'));
        $miniClouds = $this->_model->getAllMiniClouds(array('token' => $this->session->get('token'), 'userEditProfile' => 'true'));
        $odbPolicyResult1 = $this->_model->getAllOneDrivePolicies(array('token'=>$this->session->get('token'), 'userEditProfile' => 'true'));
        $mini = [];
	if(!empty($miniClouds['body']->{'mini-cloud'})){
		foreach($miniClouds['body']->{'mini-cloud'} as $key => $value){ 
		    if($value->{'owner'} == $this->session->get('userName')){
			$mini = array_merge(array($value), $mini);
		    }
		}
	}
	$backupResult1 = $this->_model->getAllBackupPolicyName(array('token'=>$this->session->get('token'), 'userEditProfile' => 'true'));
        $syncResult1 = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token'), 'userEditProfile' => 'true'));
	
        if($this->session->get('admin') == true){
		$headers = array(
		    'Content-Type'  => 'application/json',
		    'token'         => $this->session->get('token')
		);
		if($this->session->get('graphApiEnabled') == 'true'){
			$result = $this->_model->getOneDriveDetails($headers);
		}else{
			$result = $this->_model->getOdbDetails($headers);
		}
	}

        if(empty((array)$backupResult['body']->{'backupPolicyElementList'}) && $this->auth->checkCloudPermission('backup')){
            header('Location: '.Url::basePath('pms/policy/create'));
            exit;
        }

        if(empty((array)$syncResult['body']->{'syncPolicyElementList'}) && $this->auth->checkCloudPermission('sync')){
            header('Location: '.Url::basePath('pms/sync/policy/create'));
            exit;
        }

        $backupPolicies = [];
        foreach((array)$backupResult['body']->{'backupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }

        $syncPolicies = [];
        foreach((array)$syncResult['body']->{'syncPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $syncPolicies = array_merge(array($policy), $syncPolicies);
        }
	    $backupPolicies1 = [];
        foreach((array)$backupResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies1 = array_merge(array($policy), $backupPolicies1);
        }
        
        $syncPolicies1 = [];
        foreach((array)$syncResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $syncPolicies1 = array_merge(array($policy), $syncPolicies1);
        }
        
        $odbPolicies1 = [];
        foreach((array)$odbPolicyResult1['body']->{'officeBackupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $odbPolicies1 = array_merge(array($policy), $odbPolicies1);
        }
        natcasesort($backupPolicies1);
        natcasesort($syncPolicies1);
        if($userDetails['body']->{'response-code'} != 500){
	    $headers1 = array(
                    'Content-Type'  => 'application/json',
                    'token'         => $this->session->get('token')
            );
	    $cloudProperties = $this->_model->getCloudProperties($headers1);
	    $autoExpireUsers = $cloudProperties['body']->{'cloudPropertyElement'}->{'autoExpireUsers'};
            $data = array(
                'title' => $this->language->get('indexPageName'),
                'subPageName' => $this->language->get('profilePage'),
                'active' => 'users',
                'csrf_token' => $this->setCSRFToken(),
                'activateEdit' => !empty($username && ($this->session->get('admin') == true || $this->session->get('readOnlyAdmin') == true)) ? true : false,
                'userDetails' => $userDetails['body'],
                'miniClouds' => $miniClouds['body'],
                'mini' => $mini,
                'backupPolicies' => $backupPolicies,
                'syncPolicies' => $syncPolicies,
		'backupPolicies1' => $backupPolicies1,
                'syncPolicies1' => $syncPolicies1,
                'odbPolicies1' => $odbPolicies1,
                'loggedInUser' => $this->session->all(),
                'clientID'=> $result['body']->{'clientId'},
                'clientRedirectURI'=> $result['body']->{'clientRedirectURI'},
                'portalURL'=> $result['body']->{'portalURL'},
                'clientSecretKey'=> $result['body']->{'clientSecretKey'},
                'clientResourceURL'=> $result['body']->{'clientResourceURL'},
                'configId'=> $result['body']->{'configId'},
		'user_principal' => $result["body"]->{'accountId'},
                'userUnderOdbMigration' => $userDetails['body']->{'userUnderOdbMigration'},
		'autoExpireUsers'       => $autoExpireUsers
            );
		
	    if($this->session->get('graphApiEnabled') == 'true'){
                    $data['graphApi'] == 'true';
                    $data['tokenMapped'] = $result['header']->{'container'}['tokenMapped'];
            }else{
                $data['graphApi'] == 'false';
            }
            
            if($this->session->get('userName') == $userDetails['body']->{'user-name'}){
			$data['lastLoggedInTime'] = $this->session->get('lastLoggedInTime');
	    }else{
			$data['lastLoggedInTime'] = $userDetails['body']->{'lastLoggedInTime'};
	    }			    
		    
            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('users/settings', $data);
            View::renderTemplate('footer', $data);
        }else{
            Url::redirect('404');
        }
    }

    /**
     * Save UserDetails
     * @throws \Helpers\Exception
     */
    public function saveUserDetails(){
        $this->verifyAndCleanItUp();
        //$this->auth->checkLoggedInUser($_POST['user_name']);
        if(!empty($_POST)){
            $rules = array(
                'user_name'             => 'required',
                'recovery_key'          => 'required',
                'is_first_login'        => 'required',
                //'email_address'         => 'required',
                'account_status'        => 'required',
                'account_type'          => 'required',
                //'sync_access'           => 'required',
                'backup'                => 'required',
                'share_enabled'         => 'required'
            );
            $filters = array(
                'password_hash'         => 'trim|sanitize_string',
                'user_name'             => 'trim|sanitize_string',
                'recovery_key'          => 'trim|sanitize_string',
                'is_first_login'        => 'trim|sanitize_string',
                'email_address'         => 'trim|sanitize_string',
                'account_status'        => 'trim|sanitize_string',
                'account_type'          => 'trim|sanitize_string',
                'sync_access'           => 'trim|sanitize_string',
                'backup'                => 'trim|sanitize_string',
                'share_enabled'         => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);
            //When the user is using the application, we get Enabled or false and when the admin is using the application, we get true or false
            if($_POST['backup'] == 'Enabled' || $_POST['backup'] == 'true'){
                $_POST['backup'] = 'true';
            } else {
                $_POST['backup'] = 'false';
            }
            
            if($_POST['account_status'] == 'Active'){
                $account_status = 'true';
            } else {
                $account_status = 'false';
            }

            $_POST['displayName'] = trim($_POST['displayName']);
            $_POST['account_type'] = strtolower($_POST['account_type']);
            $_POST['account_type'] = str_replace(' ', '_', $_POST['account_type']);
            if($_POST['sync_access'] == 'End Point & Web Access'){
            $_POST['sync_access'] = 'true';
            }
	    $isSyncEnabled = 'false';
	    /*if($_POST['syncAccessType'] == 'Only Web Access' || $_POST['syncAccessType'] == 'WEBONLY'){
		$isSyncEnabled = 'true';
		$syncAccessType = 'WEBONLY';
	    }
	    if($_POST['syncAccessType'] == 'End Point & Web Access' || $_POST['syncAccessType'] == 'WEBANDENDPOINT'){
		$isSyncEnabled = 'true';
		$syncAccessType = 'WEBANDENDPOINT';
	    }
	    if($_POST['syncAccessType'] == 'Disabled' || $_POST['syncAccessType'] == 'DISABLED'){
		$isSyncEnabled = 'false';
		$syncAccessType = 'DISABLED';
	    }*/
	    if($_POST['syncAccessType'] == 'Only Web Access' || $_POST['syncAccessType'] == 'WEBONLY'){
		$syncAccessType = 'WEBONLY';
	    }
	    if($_POST['syncAccessType'] == 'End Point & Web Access' || $_POST['syncAccessType'] == 'WEBANDENDPOINT'){
		$syncAccessType = 'WEBANDENDPOINT';
	    }
	    if($_POST['account_type'] == 'admin'){
                    $admin = 'true';
                    $readonlyadmin = 'false';
            }elseif($_POST['account_type'] == 'delegated_administrator' || $_POST['account_type'] == 'read_only_admin'){
                    $admin = 'false';
                    $readonlyadmin = 'true';
            }else{
                    $admin = 'false';
                    $readonlyadmin = 'false';
            }
	    if(empty($_POST['onedriveBkpEnabled']) || $_POST['onedriveBkpEnabled'] != 'enabled'){
            	$_POST['onedriveBkpEnabled'] = 'false';
            }else{
            	$_POST['onedriveBkpEnabled'] = 'true';
            }
	    if(empty($_POST['exchangeBkpEnabled']) || $_POST['exchangeBkpEnabled'] != 'enabled'){
            	$_POST['exchangeBkpEnabled'] = 'false';
            }else{
            	$_POST['exchangeBkpEnabled'] = 'true';
            }
	    if($_POST['autoExpireType'] == 'DISABLED'){
                $_POST['noOfDaysForAutoBlock'] = '2000';
            }
	    if($_POST['autoAgingUsers'] != 'enabled'){
        	$_POST['autoExpireType'] = 'DISABLED';
	    }
	    if($_POST['autoExpireType'] == 'DISABLED'){
                $_POST['noOfDaysForAutoBlock'] = '2000';
            }
            if($validate === true){
                $xml = new \SimpleXMLElement('<?xml version="1.0" encoding="UTF-8" standalone="yes"?><user/>');
                $xml->{'is-active'}                     = $account_status;
		$xml->{'is-admin'}                      = $admin;
                $xml->{'is-readonly-admin'}             = $readonlyadmin;
                $xml->{'backup-enabled'}                = (!empty($_POST['backup'])) ? $_POST['backup'] : 'false';
                $xml->{'server-backup-enabled'}         = (!empty($_POST['serverBackup'])) ? $_POST['serverBackup'] : 'false';
                $xml->{'email-id'}                      = (!empty($_POST['email_address'])) ? trim($_POST['email_address']) : null;
                $xml->{'is-first-login'}                = (!empty($_POST['is_first_login'])) ? $_POST['is_first_login'] : 'false';
                $xml->{'last-modified-timestamp'}       = time();
                $xml->{'migrationtool-enabled'}         = (!empty($_POST['account_type'])) ? (($_POST['account_type'] == 'admin') ? 'true' : 'false') : 'false';
                if(!empty($_POST['password_hash'])){
                $xml->{'password-hash'}                 = $_POST['password_hash'];
                }
                $xml->{'aadLoginId'}                 	= $_POST['aadLoginId'];
                $xml->{'is-guest'}                 	= $_POST['is_guest'];
                if(!empty($_POST['local_user'])){
                $xml->{'localUser'}                 	= $_POST['local_user'];
                }
                $xml->{'pms-enabled'}                   = (!empty($_POST['account_type'])) ? (($_POST['account_type'] == 'admin') ? 'true' : 'false') : 'false';
                $xml->{'report-enabled'}                = (!empty($_POST['account_type'])) ? (($_POST['account_type'] == 'admin' || $_POST['account_type'] == 'delegated_administrator' || $_POST['account_type'] == 'read_only_admin') ? 'true' : 'false') : 'false';
                $xml->{'recovery-key'}                  = (!empty($_POST['recovery_key'])) ? $_POST['recovery_key'] : null;
		$xml->{'google-secret-key'}                  = (!empty($_POST['google_secret_key'])) ? $_POST['google_secret_key'] : null;
                $xml->{'share-enabled'}                 = (!empty($_POST['share_enabled'])) ? $_POST['share_enabled'] : 'false';
                $xml->{'support-enabled'}               = (!empty($_POST['account_type'])) ? (($_POST['account_type'] == 'admin' || $_POST['account_type'] == 'delegated_administrator' || $_POST['account_type'] == 'read_only_admin') ? 'true' : 'false') : 'false';
                //$xml->{'sync-enabled'}                = (!empty($_POST['sync_access'])) ? $_POST['sync_access'] : 'false';
		$xml->{'sync-enabled'}                  = !empty($_POST['sync']) ? $_POST['sync'] : 'false';
		$xml->{'syncAccessType'}                = $syncAccessType;
                $xml->{'onedriveBkpEnabled'}            = (!empty($_POST['onedriveBkpEnabled'])) ? $_POST['onedriveBkpEnabled'] : 'false';
		$xml->{'exchangeBkpEnabled'}            = (!empty($_POST['exchangeBkpEnabled'])) ? $_POST['exchangeBkpEnabled'] : 'false';
                $xml->{'odbPolicyName'}                 = (!empty($_POST['odbPolicyName'])) ? $_POST['odbPolicyName'] : null;
                $xml->{'user-id'}                       = (!empty($_POST['user_id'])) ? $_POST['user_id'] : null;
                $xml->{'user-name'}                     = (!empty($_POST['user_name'])) ? $_POST['user_name'] : null;
		$xml->{'noOfDaysForAutoBlock'}     	= $_POST['noOfDaysForAutoBlock'];
                $xml->{'autoExpireType'}  		= $_POST['autoExpireType'];
		$xml->{'user-consent'}                  = $_POST['consentGiven'];
		$xml->{'user-consent-time'}             = $_POST['consentGivenTime'];
                if(!empty($_POST['displayName'])){
                $xml->{'display-name'}                  = $_POST['displayName'];
                }
                if(!empty($_POST['location'])){
                $xml->{'location'}                      = $_POST['location'];
                }
                if(!empty($_POST['department'])){
                $xml->{'department'}                    = $_POST['department'];
                }
                if(!empty($_POST['backupTargetAssigned'])){
                $xml->{'backupTargetAssigned'}                 = ($_POST['backupTargetAssigned'] == 'Yes') ? 'true' : 'false';
                }
                $xml->{'backupTargetErrorCode'}                 = $_POST['backupTargetErrorCode'];
                //if($_POST['backup'] == 'true'){
                $xml->{'policy-name'}                   = (!empty($_POST['policyName'])) ? $_POST['policyName'] : null;
                //}
                $xml->{'sync-policy-name'}              = (!empty($_POST['syncPolicyName'])) ? $_POST['syncPolicyName'] : null;
                $xml->{'odb-loginId'}                   = (!empty($_POST['odb_login_Id'])) ? trim($_POST['odb_login_Id']) : '';
		        $xml->{'last-Logged-In-Time'}           = $_POST['lastLoginTime'];
		        $xml->{'user-name-lower-case'}           = $_POST['userNameLowerCase'];
                $xml->addChild('mini_clouds');
                if(!empty($_POST['miniCloudName'])){
                    $mini_clouds = (is_array($_POST['miniCloudName'])) ? $_POST['miniCloudName'] : explode(',', $_POST['miniCloudName']);
                    foreach($mini_clouds as $value){
                        $mini = $xml->mini_clouds->addChild('mini-cloud');
                        $mini->addChild('mini-cloud-name', htmlspecialchars($value));
                    }
                }
		        $xml->addChild('backupPoliciesAdmin');
                    if($_POST['account_type'] == 'delegated_administrator' || $_POST['account_type'] == 'read_only_admin'){
                    if(!empty($_POST['backupPoliciesAdmin'])){
                        $backupPoliciesAdmin = (is_array($_POST['backupPoliciesAdmin'])) ? $_POST['backupPoliciesAdmin'] : explode(',', $_POST['backupPoliciesAdmin']);
                        foreach($backupPoliciesAdmin as $value){
                            $xml->backupPoliciesAdmin->addChild('backupPolicyAdmin',htmlspecialchars($value));
                        }
                    }
                }
                $xml->addChild('syncPoliciesAdmin');
                 if(!empty($_POST['syncPoliciesAdmin'])){
                    $syncPoliciesAdmin = (is_array($_POST['syncPoliciesAdmin'])) ? $_POST['syncPoliciesAdmin'] : explode(',', $_POST['syncPoliciesAdmin']);
                    foreach($syncPoliciesAdmin as $value){
                        $xml->syncPoliciesAdmin->addChild('syncPolicyAdmin',htmlspecialchars($value));
                    }
                }
                $xml->addChild('odbPoliciesAdmin');
                     if($_POST['account_type'] == 'delegated_administrator' || $_POST['account_type'] == 'read_only_admin'){
                     if(!empty($_POST['odbPoliciesAdmin'])){
                         $odbPoliciesAdmin = (is_array($_POST['odbPoliciesAdmin'])) ? $_POST['odbPoliciesAdmin'] : explode(',', $_POST['odbPoliciesAdmin']);
                         foreach($odbPoliciesAdmin as $value){
                             $xml->odbPoliciesAdmin->addChild('odbPolicyAdmin',htmlspecialchars($value));
                         }
                     }
                }
                $userString = $xml->asXML();
                $userString = str_replace('mini_clouds', 'mini-clouds', $userString);
                $this->log(json_encode($_POST), "info");
                $this->log($userString, "info");

                $headers = array(
                    'Content-type' => 'application/xml',
                    'token' => $this->session->get('token')
                );
                $result = $this->_model->updateUserDetails($headers, $userString, base64_encode($this->session->get('userName')));

                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'message' => $this->language->get('userSavedSuccess'),
                            'data' => (string)$result['body']->{'is-active'}
                        );
                        echo json_encode($response);
                        exit;
                    case (201):
                        $response = array(
                            'result' => 'success',
                            'message' => $this->language->get('userSavedSuccess')
                        );
                        echo json_encode($response);
                        exit;
                    case (206):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Email is mandatory'
                        );
                        echo json_encode($result);
                        exit();
                    case (412):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('412')
                        );
                        echo json_encode($result);
                        exit();
		    case (417):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('417')
                        );
                        echo json_encode($result);
                        exit();
                    case (447):
                        $response = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('447')
                        );
                        echo json_encode($response);
                        exit;

                    case (442):
                        $response = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('442')
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (403):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('403')
                        );
                        echo json_encode($result);
                        exit();
                    case (428):
                         $result = array(
                             'result' => 'fail',
                             'msg' => $this->language->get('428')
                         );
                         echo json_encode($result);
                         exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result['status'],
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            $result = array(
                'result' => 'fail',
                'msg' => $this->language->get('noData')
            );
            echo json_encode($result);
        }
    }

    /**
     * Returns all the miniClouds
     */
    public function getAllMiniClouds(){
        $headers = array(
            'token' => $this->session->get('token')
        );
        $result = $this->_model->getAllMiniClouds($headers);
        if($result['status'] == 200){
            print_r($result['body']);
        }else{
            echo json_encode(array('result' => 'fail', 'msg' => 'Could not find any Mini Clouds'));
        }
    }

    /**
     * Uploads the profile picture
     */
    public function upload(){
        if (!empty($_FILES)) {
            list($type) = explode('/', mime_content_type($_FILES['file']['tmp_name']));
            if($type == 'image'){
                $targetPath = 'app/templates/default/uploads/profile';
                $nameMD5 = md5($this->session->get('userName'));
                $targetFile =  $targetPath.DS.$nameMD5;
                $ext = (explode(".", $_FILES['file']['name']));
                if(file_exists($targetFile.'.'.end($ext))) {
                    unlink($targetFile.'.'.end($ext));
                }
                if(move_uploaded_file($_FILES['file']['tmp_name'], $targetFile.'.'.end($ext))){
                    header('HTTP/1.1 200 uploaded');
                    header('Content-Type: application/json; charset=UTF-8');
                    die(json_encode(array('message' => 'success', 'code' => 200)));
                }else{
                    header('HTTP/1.1 500 Technical Issue');
                    header('Content-Type: application/json; charset=UTF-8');
                    die(json_encode(array('message' => 'ERROR in uploading, only ".jpg" files are allowed', 'code' => 500)));
                }
            }else{
                header('HTTP/1.1 500 Technical Issue');
                header('Content-Type: application/json; charset=UTF-8');
                die(json_encode(array('message' => 'ERROR in uploading, Invalid file type', 'code' => 500)));
            }
        }else{
            header('HTTP/1.1 404 File not found');
            header('Content-Type: application/json; charset=UTF-8');
            die(json_encode(array('message' => 'ERROR in uploading, only ".jpg" files are allowed', 'code' => 500)));
        }
    }

    /**
     * Below method accepts username param
     * and blocks the user
     * @throws \Helpers\Exception
     */
    public function block(){
	$this->verifyAndCleanItUp();
        //Auth::allowOnly('admin');
        if(empty($_POST['userName']) && empty($_POST['blockUser'])){
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
            exit;
        }
        if($_POST['userName'] != $this->session->get('userName')){
            $this->valid->filter($_POST, array('userName' => 'trim|sanitize_string'));
            $headers = array(
                'token' => $this->session->get('token'),
                'blocked' => $_POST['blockUser'],
                'userName' => $this->session->get('userName')
            );
            $result = $this->_model->blockUser($headers, $_POST['userName']);

            switch ($result['status']) {
                case (200):
                    if($_POST['blockUser'] == 'true'){
                        $msg = $this->language->get('userUnBlocked');
                    }else {
                        $msg = $this->language->get('userBlocked');
                    }
                    if($_POST['blockUser'] == 'false'){
                        $emailProps = array(
                            'actionOn' => base64_decode($_POST['userName']),
                            'action' => 'user-blocked',
                            'toAdmins' => true,
                            'actionBy' => $this->session->get('userName'),
                            'cloudName' => $this->session->get('cloudName'),
                        );
                        if(EMAIL_ONLY_ADMIN == false){
                        $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $_POST['userName']);
                        if(!empty((string)$userDetails['body']->{'email-id'})){
                            $emailProps['recipents'] = array(
                                array(
                                    'userName' => base64_decode($_POST['userName']),
                                    'email' => (string)$userDetails['body']->{'email-id'}
                                )
                            );
                        }
                    }
                    $this->sendMail($emailProps);
                    }
                    $response = array(
                        'result' => 'success',
                        'msg' => $msg,
                        'data' => (string)$result['body']->{'is-active'}
                    );
                    echo json_encode($response);
                    exit;
                case (201):
                    $response = array(
                        'result' => 'success',
                        'message' => $this->language->get('userBlocked')
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'message' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'cannot','msg' => $this->language->get('cannotBlock')));
        }
    }


    /**
     * Below method marks a user for delete
     * @throws \Helpers\Exception
     */
    public function delete(){
	$this->verifyAndCleanItUp();
        //Auth::allowOnly('admin');
        if(!empty($_POST['userName']) && !empty($_POST['blockUser'])){
            if($_POST['userName'] != $this->session->get('userName')){
                $this->valid->filter($_POST, array('userName' => 'trim|sanitize_string'));

                $headers = array(
                    'token' => $this->session->get('token'),
                    'userName' => $this->session->get('userName')
                );
                $result = $this->_model->deleteUser($headers, $_POST['userName']);

                switch ($result['status']) {
                    case (200):
                        /*$emailProps = array(
                            'actionOn' => $_POST['userName'],
                            'action' => 'user-delete',
                            'toAdmins' => true,
                            'actionBy' => $this->session->get('userName'),
                            'cloudName' => $this->session->get('cloudName'),
                        );
                        if(EMAIL_ONLY_ADMIN == false){
                            $userDetails = $this->_model->getUserDetails(array('token' => $this->session->get('token')), $_POST['userName']);
                            $emailProps['recipents'] = array(
                                array(
                                    'userName' => $_POST['userName'],
                                    'email' => !empty((string)$userDetails['body']->{'email-id'})? (string)$userDetails['body']->{'email-id'} : 'support@parablu.com'
                                )
                            );
                        }else{
                            $emailProps['recipents'] = array(
                                array(
                                    'userName' => $_POST['userName'],
                                    'email' => 'support@parablu.com'
                                )
                            );
                        }
                        $this->sendMail($emailProps);
                        */

                        $response = array(
                            'result' => 'success',
                            'message' => $this->language->get('userDeleted'),
                            'data' => (string)$result['body']->{'is-active'}
                        );
                        echo json_encode($response);
                        exit;
                    case (201):
                        $response = array(
                            'result' => 'success',
                            'message' => $this->language->get('userDeleted')
                        );
                        echo json_encode($response);
                        exit;
                    case (447):
                        $response = array(
                            'result' => 'fail',
                            'message' => $this->language->get('447')
                        );
                        echo json_encode($response);
                        exit;
                    case (448):
                        $response = array(
                            'result' => 'fail',
                            'message' => $this->language->get('448')
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (417):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('417')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                echo json_encode(array('result' => 'cannot','msg' => $this->language->get('cannotDelete')));
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /**
     * Renders users page
     */
    public function usersBulkBlockDelete(){
        Auth::allowOnly('readOnlyAdmin');
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'subTitle' => $this->language->get('usersBulkBlockDelete'),
            'crumb1' => $this->language->get('usersBulkBlockDelete'),
            'active' => 'users',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	$cloudProperties = $this->_model->getCloudProperties($headers);
        $data['muxedEnabled'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'muxedEnabled'};
	$data['softBlockEnabled'] = $cloudProperties['body']->{'cloudPropertyElement'}->{'softBlockEnabled'};

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('users/usersBulkBlockDelete', $data);
        View::renderTemplate('footer', $data);
    }

    /**
     * Renders users page
     */
    public function users(){
        Auth::allowOnly('readOnlyAdmin');
	if($this->session->get('isLdapEnabled') == 'true'){
		$text = 'This user is managed by AD group, this action is not allowed.';
	}	
	if($this->session->get('isAADEnabled') == 'true'){
		$text = 'This user is managed by AAD group, this action is not allowed.';
	}
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'subTitle' => $this->language->get('listOfUsers'),
            'active' => 'users',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
	    'type' => $text
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('users/users', $data);
        View::renderTemplate('footer', $data);
    }

    /**
     * Below method retrieves all the users
     */
    public function getAllUsers(){
        Auth::allowOnly('readOnlyAdmin');
        if(!empty($_POST)){
	    if($this->session->get('isLdapEnabled') == 'true'){
		$headers1 = array(
			    'Content-Type'      => 'application/json',
			    'token'          => $this->session->get('token')
			);

		$result1 = $this->_model->getAdCredentials($headers1);
		$adcS = [];
		if(!empty($result1['body']->{'adElementList'})){
			    foreach($result1['body']->{'adElementList'} as $value){
				if($value->{'adGroupName'} != ''){
					array_push($adcS, $value->{'adGroupName'});
				}
			    }
		}
		$this->log("groupssss : ".json_encode($adcS),"info");
		$this->log("groupssss count : ".count($adcS),"info");
		$count = count($adcS);
	    }
	    if($this->session->get('isAADEnabled') == 'true'){
		$headers1= array(
			    'Content-Type'  => 'application/json',
			    'token'         => $this->session->get('token'),
			    'Accept'        => 'application/json',
			    'Accept-Charset'=> 'utf-8',
			);
		$result1 = $this->_model->getAadDetails($headers1);
		$groups = [];
		if(!empty($result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'})){
			foreach( $result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'} as $key => $value ) {
				if($key != ''){
					array_push($groups, $key);
				}
			}
		}
		$count = count($groups);
	    }
            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'Accept'    => 'application/json',
                'Content-Type' => 'application/json',
            );
            if(is_array($_POST['userName'])){
                $_POST['userName'] = implode(',', $_POST['userName']);
            }

            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userName'] = $_POST['userName'];
                $result = $this->_model->searchForAUser($headers);
            }else{
                $result = $this->_model->getAllUsers($headers, $_POST['pageNumber']);
            }
            $this->log('Users Result'. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $users = array();
		    if(!empty($result['body']->{'data'}->{'users'})){
			    if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
				foreach($result['body']->{'data'}->{'users'} as $value){
					if($count > 0){
						$localUser = $value->{'localUser'};
					}else{
						$localUser = true;
					}
					$user = array(
					    'profilePic'       => Url::profilePic((string)$value->{'userName'}),
					    'userGroup'        => !empty((string)$value->{'user-group'}) ? (string)$value->{'user-group'} : '-',
					    'emailId'          => (string)$value->{'emailId'},
					    'isActive'         => $value->{'active'},
					    'localUser'        => $localUser,
					    //'localUser'         => $value->{'localUser'},
					    'userName'         => (string)$value->{'userName'},
					    'userNameForView' => base64_encode((string)$value->{'userName'}),
					    'displayName'         => (string)$value->{'displayName'},
					    'isAdmin'          => $value->{'admin'},
					    'timeinmillis'     => (int)($value->{'lastModifiedTimestamp'}),
					    'time'             => date('d-M-Y H:i:s',(int)($value->{'lastModifiedTimestamp'})/1000),
					    'isReadonlyAdmin' => $value->{'readOnlyAdmin'},
					    'userUnderOdbMigration' => $value->{'userUnderOdbMigration'},
					    'migrationStatus' => !empty($value->{'migrationStatus'}) ? $value->{'migrationStatus'} : '',
					    'guest' => $value->{'guest'}
					);
					if($value->{'guest'} == false){
						$users = array_merge(array($user), $users);
					}
				}
			    }else{
				    foreach($result['body']->{'data'}->{'users'} as $value){
					if($count > 0){
						$localUser = $value->{'localUser'};
					}else{
						$localUser = true;
					}
					$user = array(
					    'profilePic'       => Url::profilePic((string)$value->{'userName'}),
					    'userGroup'        => !empty((string)$value->{'user-group'}) ? (string)$value->{'user-group'} : '-',
					    'emailId'          => (string)$value->{'emailId'},
					    'isActive'         => $value->{'active'},
					    'localUser'        => $localUser,
					    //'localUser'         => $value->{'localUser'},
					    'userName'         => (string)$value->{'userName'},
					    'userNameForView' => base64_encode((string)$value->{'userName'}),
					    'displayName'         => (string)$value->{'displayName'},
					    'isAdmin'          => $value->{'admin'},
					    'timeinmillis'     => (int)($value->{'lastModifiedTimestamp'}),
					    'time'             => date('d-M-Y H:i:s',(int)($value->{'lastModifiedTimestamp'})/1000),
					    'isReadonlyAdmin' => $value->{'readOnlyAdmin'},
					    'userUnderOdbMigration' => $value->{'userUnderOdbMigration'},
					    'migrationStatus' => !empty($value->{'migrationStatus'}) ? $value->{'migrationStatus'} : '',
					    'guest' => $value->{'guest'}
					);
					if($value->{'guest'} == false){
						$users = array_merge(array($user), $users);
					}
				    }
		            }
		    }
		    if(empty($result['body']->{'data'})){
			$users = [];
		    }
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                        }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users),
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }
    
    public function getAllUsers1(){
        Auth::allowOnly('readOnlyAdmin');
        if(!empty($_POST)){
	if($this->session->get('isLdapEnabled') == 'true'){		
	    $headers1 = array(
			    'Content-Type'      => 'application/json',
			    'token'          => $this->session->get('token')
			);

		$result1 = $this->_model->getAdCredentials($headers1);
		$adcS = [];
		if(!empty($result1['body']->{'adElementList'})){
			    foreach($result1['body']->{'adElementList'} as $value){
				if($value->{'adGroupName'} != ''){
					array_push($adcS, $value->{'adGroupName'});
				}
			    }
		}
		$this->log("groupssss : ".json_encode($adcS),"info");
		$this->log("groupssss count : ".count($adcS),"info");
		$count = count($adcS);
	    }
	    if($this->session->get('isAADEnabled') == 'true'){
		$headers1= array(
			    'Content-Type'  => 'application/json',
			    'token'         => $this->session->get('token'),
			    'Accept'        => 'application/json',
			    'Accept-Charset'=> 'utf-8',
			);
		$result1 = $this->_model->getAadDetails($headers1);
		$groups = [];
		if(!empty($result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'})){
			foreach( $result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'} as $key => $value ) {
				if($key != ''){
					array_push($groups, $key);
				}
			}
		}
		$count = count($groups);
	    }
            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0,
                'Accept'    => 'application/json',
                'Content-Type' => 'application/json',
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userName'] = $_POST['userName'];
                $result = $this->_model->searchForAUser1($headers, $_POST['url']);
            }else{
                $result = $this->_model->getAllUsers1($headers, $_POST['url']);
            }
            $this->log('Users Result'. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $users = array();
		    if(!empty($result['body']->{'data'}->{'users'})){
			    if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
				foreach($result['body']->{'data'}->{'users'} as $value){
					if($count > 0){
						$localUser = $value->{'localUser'};
					}else{
						$localUser = true;
					}
					$user = array(
					    'profilePic'       => Url::profilePic((string)$value->{'userName'}),
					    'userGroup'        => !empty((string)$value->{'user-group'}) ? (string)$value->{'user-group'} : '-',
					    'emailId'          => (string)$value->{'emailId'},
					    'isActive'         => $value->{'active'},
					    'localUser'        => $localUser,
					    //'localUser'         => $value->{'localUser'},
					    'userName'         => (string)$value->{'userName'},
					    'userNameForView' => base64_encode((string)$value->{'userName'}),
					    'displayName'         => (string)$value->{'displayName'},
					    'isAdmin'          => $value->{'admin'},
					    'timeinmillis'     => (int)($value->{'lastModifiedTimestamp'}),
					    'time'             => date('d-M-Y H:i:s',(int)($value->{'lastModifiedTimestamp'})/1000),
					    'isReadonlyAdmin' => $value->{'readOnlyAdmin'},
					    'userUnderOdbMigration' => $value->{'userUnderOdbMigration'},
					    'migrationStatus' => !empty($value->{'migrationStatus'}) ? $value->{'migrationStatus'} : '',
					    'guest' => $value->{'guest'}
					);
					if($value->{'guest'} == false){
						$users = array_merge(array($user), $users);
					}
				}
			    }else{
				    foreach($result['body']->{'data'}->{'users'} as $value){
					if($count > 0){
						$localUser = $value->{'localUser'};
					}else{
						$localUser = true;
					}
					$user = array(
					    'profilePic'       => Url::profilePic((string)$value->{'userName'}),
					    'userGroup'        => !empty((string)$value->{'user-group'}) ? (string)$value->{'user-group'} : '-',
					    'emailId'          => (string)$value->{'emailId'},
					    'isActive'         => $value->{'active'},
					    'localUser'        => $localUser,
					    //'localUser'         => $value->{'localUser'},
					    'userName'         => (string)$value->{'userName'},
					    'userNameForView' => base64_encode((string)$value->{'userName'}),
					    'displayName'         => (string)$value->{'displayName'},
					    'isAdmin'          => $value->{'admin'},
					    'timeinmillis'     => (int)($value->{'lastModifiedTimestamp'}),
					    'time'             => date('d-M-Y H:i:s',(int)($value->{'lastModifiedTimestamp'})/1000),
					    'isReadonlyAdmin' => $value->{'readOnlyAdmin'},
					    'userUnderOdbMigration' => $value->{'userUnderOdbMigration'},
					    'migrationStatus' => !empty($value->{'migrationStatus'}) ? $value->{'migrationStatus'} : '',
					    'guest' => $value->{'guest'}
					);
					if($value->{'guest'} == false){
						$users = array_merge(array($user), $users);
					}
				    }
		            }
		    }
		    if(empty($result['body']->{'data'})){
			$users = [];
		    }
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                        }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users),
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
        }
    }

    /**
     * Below method retrieves all the users
     */
    public function getAllUserNames(){
        if(empty($_POST)){
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
            exit;
        }
        $headers = array(
            'Accept' => 'application/json',
            'token'     => $this->session->get('token')
        );
        $result = $this->_model->getAllNames($headers);
        switch ($result['status']) {
            case (200):
                $users = [];
                if(!empty($result['body']->{'stringElementList'})){
                    foreach($result['body']->{'stringElementList'} as $key => $value){
                        if($key < 10){
                            $userName = array('id' => $key, 'text' => $value->{'name'});
                            $users = array_merge(array($userName), $users);
                        }
                    }
                }

                $response = array(
                    'result' => 'success',
                    'users'  => array_reverse($users)
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'users'  => $result['body'],
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function deviceDetails(){
        if(!empty($_POST) && !empty($_POST['deviceUUID'])){

            $headers = array(
                'Content-Type' => 'application/json',
                'token'     => $this->session->get('token'),
                'deviceUUID' => $_POST['deviceUUID']
            );

            $result = $this->_model->getDeviceDetails($headers);
            switch ($result['status']) {
                case (200):
		    if($result['body']->{'BSDeviceInfoElement'}->{'windowsDevice'} == true && preg_match('/bit/',$result['body']->{'BSDeviceInfoElement'}->{'osVersion'})) {
			$version = $result['body']->{'BSDeviceInfoElement'}->{'osVersion'};
			$char = "(";
			$version = $result['body']->{'BSDeviceInfoElement'}->{'osVersion'};
                    	$str = explode($char, $version);
                    	$version = "(".$str[1];
			$result['body']->{'BSDeviceInfoElement'}->{'version'} = $version;
		    }
                    $result['body']->{'BSDeviceInfoElement'}->{'icon'} = $this->getOsIcon($result['body']->{'BSDeviceInfoElement'}->{'osType'});
                    $result['body']->{'BSDeviceInfoElement'}->{'os'} = $this->getOsType($result['body']->{'BSDeviceInfoElement'}->{'osType'});

                    $response = array(
                        'result' => 'success',
                        'deviceDetails'  => $result['body']->{'BSDeviceInfoElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /*public function changePassword(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST['password'])){

            $result = $this->_model->getUserData(array('token' => $this->session->get('token')), $this->session->get('userName'));
            $xml1   = new \SimpleXMLElement($result['body']);
            $oldpass = $xml1->{'password-hash'};
                    $this->log('passwordOld: '. $xml1->{'password-hash'}, 'info');
                   // $this->log('password123: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $xml    = new \SimpleXMLElement($result['body']);
                    $xml->{'password-hash'} = hash('sha512', $_POST['password']);
                    $newpass = $xml->{'password-hash'};
                    $this->log('passwordNew: '. $xml->{'password-hash'}, 'info');
                    $this->log('gggggg: '. strcmp($newpass,$oldpass), 'info');
                    $oldpassword_valuepost = hash('sha512', $_POST['oldpassword']);
                    $similarity1 = strcmp($oldpassword_valuepost,$oldpass);
                    $this->log('gggggg1: '. strcmp($oldpassword_valuepost,$oldpass), 'info');
                    $similarity = strcmp($newpass,$oldpass);
                    if($similarity1 != 0){
                        $response = array(
                            'result' => 'oldNotMatched'
                        );
                        echo json_encode($response);
                        exit;
                    }
                    if($similarity == 0 ){
                        
                        $response = array(
                            'result' => 'fail',
                            'msg'  => 'passwordnotchanged'
                        );
                        echo json_encode($response);
                        exit;
                    }
                    
                    else {
                    $userDetails    = $xml->asXML();
                    $userUpdateResult = $this->_model->updateUserDetails(
                        array('Content-type' => 'application/xml','token' => $this->session->get('token')),
                        $userDetails, $this->session->get('userName')
                    );
                    if($userUpdateResult['status'] == 200){
                        $response = array(
                            'result' => 'success',
                            'msg'  => $this->language->get('passwordChanged')
                        );
                        echo json_encode($response);
                        exit;
                    }else{
                        $response = array(
                            'result' => 'fail',
                            'msg'  => $this->language->get('default')
                        );
                        echo json_encode($response);
                        exit;
                    }
            }
            
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
        }
    }*/
    
    public function changePassword(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST['password'])){
            $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'userName' => $_POST['username1'],
                'reset-password-key'       => $_POST['recoverykey1'],
                'password'=> hash('sha512', $_POST['password']),
                'setpassword' => "true",
                //'token'=> $this->session->get('token')
            );
            $this->log('headers: '. json_encode($headers), 'info');
            $result1 = $this->_model->getUserData(array('token' => $this->session->get('token')), base64_encode($_POST['username1']));
            $xml1   = new \SimpleXMLElement($result1['body']);
            $oldpass = $xml1->{'password-hash'};
            $newpass = hash('sha512', $_POST['password']);
            $oldpassword_valuepost = hash('sha512', $_POST['oldpassword']);
            $this->log('oldpassword_valuepost: '. $oldpass, 'info');
                    $this->log('passwordOld: '. $oldpass, 'info');
                    $this->log('passwordNew: '. $newpass, 'info');
                    $similarity1 = strcmp($oldpassword_valuepost,$oldpass);
                    if($similarity1 != 0){
                        $this->log('Old password not matched: ', 'info');
                        $response = array(
                            'result' => 'oldNotMatched'
                        );
                        echo json_encode($response);
                        exit;
                    }
                    $similarity = strcmp($newpass,$oldpass);
                    if($similarity == 0 ){
                        $this->log('passwordOld and new are same: ', 'info');
                        $response = array(
                            'result' => 'oldNewSame',
                            'msg'  => 'passwordnotchanged'
                        );
                        echo json_encode($response);
                        exit;
                        
                    }
            $result = $this->_model->setpassword($headers);
            switch ($result['status']) {
                case (200):

                    $result = array(
                        'result' => 'success',
                        'msg' => $this->language->get('passwordChanged')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    public function resetPassword(){
         $this->log('inside resetpassword1', 'info');
        $this->verifyAndCleanItUp();
        if(!empty($_POST['password'])){
            $headers = array(
                'Content-type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'userName' => $_POST['username1'],
                'reset-password-key'       => $_POST['recoverykey1'],
                'password'=> hash('sha512', $_POST['password']),
                'setpassword' => "true",
                //'token'=> $this->session->get('token')
            );
            $this->log('headers: '. json_encode($headers), 'info');
            $this->log('inside resetpassword2', 'info');
            $result = $this->_model->setpassword($headers);
            $this->log('inside resetpassword3', 'info');
            switch ($result['status']) {
                case (200):

                    $result = array(
                        'result' => 'success',
                        'msg' => $this->language->get('passwordChanged')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }
    
    public function changePasswordForGuest(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST['passwordGuest'])){
            $result = $this->_model->getUserData(array('token' => $this->session->get('token')), $this->session->get('userName'));
            $xml1   = new \SimpleXMLElement($result['body']);
            $oldpass = $xml1->{'password-hash'};
                    $this->log('passwordOld: '. $xml1->{'password-hash'}, 'info');
                   // $this->log('password123: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $xml    = new \SimpleXMLElement($result['body']);
                    $xml->{'password-hash'} = hash('sha512', $_POST['passwordGuest']);
                    $newpass = $xml->{'password-hash'};
                    $this->log('passwordNew: '. $xml->{'password-hash'}, 'info');
                    $this->log('gggggg: '. strcmp($newpass,$oldpass), 'info');
                    $similarity = strcmp($newpass,$oldpass);
                    if($similarity == 0){
                        
                        $response = array(
                            'result' => 'fail',
                            'msg'  => 'passwordnotchanged'
                        );
                        echo json_encode($response);
                        exit;
                    }
                    else {
                    $userDetails    = $xml->asXML();
                    $userUpdateResult = $this->_model->updateUserDetails(
                        array('Content-type' => 'application/xml','token' => $this->session->get('token')),
                        $userDetails, $this->session->get('userName')
                    );
                    if($userUpdateResult['status'] == 200){
                        $response = array(
                            'result' => 'success',
                            'msg'  => $this->language->get('passwordChanged')
                        );
                        echo json_encode($response);
                        exit;
                    }else{
                        $response = array(
                            'result' => 'fail',
                            'msg'  => $this->language->get('default')
                        );
                        echo json_encode($response);
                        exit;
                    }
            }
            
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    public function sendMail($emailProps){

        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );

        return $this->_model->sendMail($headers, $emailProps);

    }

    /**
     * Renders createUser Page
     */
    public function createUser(){
        Auth::allowOnly('readOnlyAdmin');
        $backupResult = $this->_model->getAllPolicies(array('token'=>$this->session->get('token')));
        $syncResult = $this->_model->getAllSyncPolicies(array('token'=>$this->session->get('token')));
        $backupResult1 = $this->_model->getAllBackupPolicyName(array('token'=>$this->session->get('token')));
        $syncResult1 = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token')));
        $odbPolicyResult1 = $this->_model->getAllOneDrivePolicies(array('token'=>$this->session->get('token')));
        $headers = array(
            'Content-type' => 'application/xml',
            'Accept' => 'application/xml',
            'Accept-Charset' => 'utf-8',
            'token' => $this->session->get('token'),
            'cloudParams' => ''
        );
        $cloudLicense = $this->_model->getCloudLicense($headers);
        $xml = new \SimpleXMLElement($cloudLicense['body']);
        $miniClouds = $this->_model->getAllMiniClouds(array('token' => $this->session->get('token')));
        $mini = [];
        foreach($miniClouds['body']->{'mini-cloud'} as $key => $value){ 
//            if($value->{'owner'} == $this->session->get('userName')){
                $mini = array_merge(array($value), $mini);
//            }
        }

        if(empty((array)$backupResult['body']->{'backupPolicyElementList'}) && $this->auth->checkCloudPermission('backup')){
            header('Location: '.Url::basePath('pms/policy/create'));
            exit;
        }

        if(empty((array)$syncResult['body']->{'syncPolicyElementList'}) && $this->auth->checkCloudPermission('sync')){
            header('Location: '.Url::basePath('pms/sync/policy/create'));
            exit;
        }

        $backupPolicies = [];
        foreach((array)$backupResult['body']->{'backupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $backupPolicies = array_merge(array($policy), $backupPolicies);
        }

        $syncPolicies = [];
        foreach((array)$syncResult['body']->{'syncPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $syncPolicies = array_merge(array($policy), $syncPolicies);
        }
	
	    $backupPolicies1 = [];
        foreach((array)$backupResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies1 = array_merge(array($policy), $backupPolicies1);
        }
        
        $syncPolicies1 = [];
        foreach((array)$syncResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $syncPolicies1 = array_merge(array($policy), $syncPolicies1);
        }
        
        $odbPolicies1 = [];
        foreach((array)$odbPolicyResult1['body']->{'officeBackupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $odbPolicies1 = array_merge(array($policy), $odbPolicies1);
        }
        $this->log("odbPolicies1 : ".json_encode($odbPolicies1),"info");        
        natcasesort($backupPolicies1);
        natcasesort($syncPolicies1);
	$headers1 = array(
                    'Content-Type'  => 'application/json',
                    'token'         => $this->session->get('token')
        );
	$cloudProperties = $this->_model->getCloudProperties($headers1);
	$autoExpireUsers = $cloudProperties['body']->{'autoExpireUsers'};
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'subTitle' => $this->language->get('create'),
            'active' => 'users',
            'license' => $xml->{'license'},
            'csrf_token' => $this->setCSRFToken(),
            'miniClouds' => $miniClouds['body'],
            'mini' => $mini,
            'backupPolicies' => $backupPolicies,
            'syncPolicies' => $syncPolicies,
	    'syncPolicies1' => $syncPolicies1,
            'backupPolicies1' => $backupPolicies1,
            'odbPolicies1' => $odbPolicies1,
            'loggedInUser' => $this->session->all(),
	    'secret' => $this->createSecret(),
	    'autoExpireUsers' => $autoExpireUsers
        );	 

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('users/create', $data);
        View::renderTemplate('footer', $data);
    }
	
    public function getEncryptPassword($password){
         $cipher = 'aes-128-cbc';
         $key = md5('a9985ebcae81', $raw_output=true);
 	 $iv_length = openssl_cipher_iv_length($cipher);
 	 $iv = openssl_random_pseudo_bytes($iv_length);
 	 $ciphertext = openssl_encrypt($password, $cipher, $key, OPENSSL_RAW_DATA, $iv);
         $composed = $iv.$ciphertext;
         $composed_encoded = base64_encode($composed);
         return $composed_encoded;
    }

    public function saveNewUserDetails(){
        $this->verifyAndCleanItUp();
        //Auth::allowOnly('admin');
        if(!empty($_POST['username']) && !empty($_POST['email'])){
            if($_POST['account_type'] == 'delegated_administrator' || $_POST['account_type'] == 'read_only_admin'){
                $isAdmin = 'false';
                $isReadAdmin = 'true';
            }elseif($_POST['account_type'] == 'admin'){
                $isAdmin = 'true';
                $isReadAdmin = 'false';
            }else{
                $isAdmin = 'false';
                $isReadAdmin = 'false';
            }

            //$_POST['username'] = preg_replace('/\s+/', '', $_POST['username']);
	    if(empty($_POST['onedriveBkpEnabled']) || $_POST['onedriveBkpEnabled'] != 'enabled'){
            	$_POST['onedriveBkpEnabled'] = 'false';
            }else{
            	$_POST['onedriveBkpEnabled'] = 'true';
            }
	    if(empty($_POST['exchangeBkpEnabled']) || $_POST['exchangeBkpEnabled'] != 'enabled'){
            	$_POST['exchangeBkpEnabled'] = 'false';
            }else{
            	$_POST['exchangeBkpEnabled'] = 'true';
            }
	    
	    if($_POST['autoGeneratePassword'] == 'enabled'){
                $_POST['password'] = $_POST['final_pass'];
            }else{
                $_POST['password'] = $_POST['password'];
	    }
	    if($_POST['autoAgingUsers'] != 'enabled'){
        	$_POST['autoExpireType'] = 'DISABLED';
	    }
	    if($_POST['autoExpireType'] == 'DISABLED'){
                $_POST['noOfDaysForAutoBlock'] = '2000';
            }	    
	    $enc = $this->getEncryptPassword($_POST['password']);
	    $isSyncEnabled = 'false';
	    /*if($_POST['syncAccessType'] == 'WEBONLY'){
		$isSyncEnabled = 'true';
		$syncAccessType = 'WEBONLY';
	    }
	    if($_POST['syncAccessType'] == 'WEBANDENDPOINT'){
		$isSyncEnabled = 'true';
		$syncAccessType = 'WEBANDENDPOINT';
	    }
	    if($_POST['syncAccessType'] == 'DISABLED'){
		$isSyncEnabled = 'false';
		$syncAccessType = 'DISABLED';
	    }*/
	    if($_POST['syncAccessType'] == 'WEBONLY'){
		$syncAccessType = 'WEBONLY';
	    }
	    if($_POST['syncAccessType'] == 'WEBANDENDPOINT'){
		$syncAccessType = 'WEBANDENDPOINT';
	    }
            $values = array(
                'userName' => htmlspecialchars_decode($_POST['username'],ENT_QUOTES),
                'displayName' => $_POST['displayName'],
                'location' => $_POST['location'],
                'department' => $_POST['department'],
                'password' => hash('sha512', $_POST['password']),
                'emailId' => trim($_POST['email']),
                'isAdmin' => !empty($isAdmin) ? $isAdmin : 'false',
                'policyName' => (!empty($_POST['policyName'])) ? $_POST['policyName'] : null,
                'odb-loginId' => (!empty($_POST['odb_login_Id'])) ? trim($_POST['odb_login_Id']) : '',
                'syncPolicyName' => (!empty($_POST['syncPolicyName'])) ? $_POST['syncPolicyName'] : null,
                'odbPolicyName' => (!empty($_POST['odbPolicyName'])) ? $_POST['odbPolicyName'] : null,
                'readOnlyAdmin' => !empty($isReadAdmin) ? $isReadAdmin : 'false',
                //'isSyncEnabled' => !empty($_POST['sync_access']) ? $_POST['sync_access'] : 'false',
		'isSyncEnabled' => !empty($_POST['sync']) ? $_POST['sync'] : 'false',
                'syncAccessType' => $syncAccessType,
                'isBackupEnabled' => !empty($_POST['backup']) ? $_POST['backup'] : 'false',
                'onedriveBkpEnabled' => !empty($_POST['onedriveBkpEnabled']) ? $_POST['onedriveBkpEnabled'] : 'false',
		'exchangeBkpEnabled' => !empty($_POST['exchangeBkpEnabled']) ? $_POST['exchangeBkpEnabled'] : 'false',
                'isServerBackupEnabled' => !empty($_POST['serverBackup']) ? $_POST['serverBackup'] : 'false',
                'isShareEnabled' => !empty($_POST['share_enabled']) ? $_POST['share_enabled'] : 'false',
		'googleSecretKey' => $_POST['googleSecretKey'],
		'noOfDaysForAutoBlock' => $_POST['noOfDaysForAutoBlock'],
                'autoExpireType' => $_POST['autoExpireType']
            );
            $userDetails = $this->getUserXML($_POST['miniCloudName'], $values,($_POST['backupPoliciesAdmin']),($_POST['syncPoliciesAdmin']),$_POST['odbPoliciesAdmin']);
            $this->log('User Result: '.$userDetails, 'info');
            $headers = array(
                'Content-type' => 'application/xml',
                'Accept'       => 'application/xml',
                'Accept-Charset'=> 'utf-8',
                'token'=> $this->session->get('token'),
		'encPassword' => $enc
            );
	    $this->log('final_pass : '.$_POST['final_pass'], 'info');
            $result = $this->_model->createNewUser($headers, $this->session->get('userName'), $userDetails);
            $this->log('Result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $result = array(
                        'result' => 'success',
                        'msg' => 'User has been created Successfully'
                    );
                    echo json_encode($result);
                    exit();
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (409):
                    if($result['header']->{'container'}['deleted-user'] == 'true'){
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'This user has been marked for deletion. Please try adding the user again after some time, once the deletion operation is complete'
                        );
                    }else {
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('409')
                        );
                    }
                    echo json_encode($result);
                    exit();
                case (412):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('412')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (403):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('403')
                        );
                        echo json_encode($result);
                        exit();
                case (428):
                         $result = array(
                             'result' => 'fail',
                             'msg' => $this->language->get('428')
                         );
                         echo json_encode($result);
                         exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }


    /**
     * Below method retrieves all the users
     */
    public function searchUsers(){
        if(!empty($_GET)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_GET['skipValue']) ? $_GET['skipValue'] : 0,
		'Content-Type' => 'application/json',
          	'Accept' => 'application/json',
            );

            if(!empty($_GET['q']) && $_GET['q'] != 'all'){
                $headers['userName'] = $_GET['q'];
                $result = $this->_model->searchForAUser($headers);
            }else{
                $result = $this->_model->getAllUsers($headers, 1);
            }

            switch ($result['status']) {
                case (200):
                    $users = array();
                    $users = array_merge(array(array("userName" => "all", "profilePic" => Url::profilePic('default'))), $users);
                    foreach($result['body']->{'data'}->{'users'} as $value){
                        $user = array(
                            'profilePic'       => Url::profilePic((string)$value->{'userName'}),
                            'userName'         => (string)$value->{'userName'}
                        );
                        $users = array_merge(array($user), $users);
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }


    /**
     * Below method retrieves all the users
     */
    public function searchUserWithDevice(){
        if(!empty($_GET)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_GET['skipValue']) ? $_GET['skipValue'] : 0
            );

            $users = array();
            if($_GET['q'] == "all"){
                $users = array_merge(array(array("userName" => "all", "profilePic" => Url::profilePic('default'))), $users);
                $response = array(
                    'result' => 'success',
                    'users'  => array_reverse($users)
                );
                echo json_encode($response);
                exit;
            }

            $headers['userName'] = $_GET['q'];
            $result = $this->_model->searchUserWithDevice($headers);
            $this->log($result);
            switch ($result['status']) {
                case (200):
                    $users = array_merge(array(array("userName" => "all", "profilePic" => Url::profilePic('default'))), $users);
                    if($result['body']->{"searchUserElementList"}){
                        foreach($result['body']->{"searchUserElementList"} as $value){
                            $user = array(
                                'profilePic'       => Url::profilePic((string)$value->{'userName'}),
                                'userName'         => (string)$value->{'userName'},
                                'devices'          => (array)$value->{'deviceNameList'}
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }else{
                        $users = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }
	
    public function searchUserWithDeviceOwner(){
        if(!empty($_GET)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_GET['skipValue']) ? $_GET['skipValue'] : 0
            );

            $users = array();
            /*if($_GET['q'] == "all"){
                $users = array_merge(array(array("userName" => "all", "profilePic" => Url::profilePic('default'))), $users);
                $response = array(
                    'result' => 'success',
                    'users'  => array_reverse($users)
                );
                echo json_encode($response);
                exit;
            }*/

            $headers['userName'] = $_GET['q'];
            $result = $this->_model->searchUserWithDevice($headers);
            $this->log($result);
            switch ($result['status']) {
                case (200):
                    $users = [];
                    if($result['body']->{"searchUserElementList"}){
                        foreach($result['body']->{"searchUserElementList"} as $value){
                            $user = array(
                                'profilePic'       => Url::profilePic((string)$value->{'userName'}),
                                'userName'         => (string)$value->{'userName'},
                                'devices'          => (array)$value->{'deviceNameList'}
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }else{
                        $users = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }	

    /**
     * Below method retrieves all the UnBlocked users
     */
    public function getAllUnBlockedUsers(){
        if(!empty($_GET)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_GET['skipValue']) ? $_GET['skipValue'] : 0
            );

            if(!empty($_GET['q']) && $_GET['q'] != 'all'){
                $headers['userName'] = $_GET['q'];
                $result = $this->_model->searchForAUser($headers);
            }else{
                $result = $this->_model->getAllUsers($headers);
            }

            switch ($result['status']) {
                case (200):
                    $users = array();
                    foreach($result['body'] as $value){
                        if((string)$value->{'is-active'} == 'true' && (string)$value->{'user-name'} != $this->session->get('userName')){
                            $user = array(
                                'profilePic'       => Url::profilePic((string)$value->{'user-name'}),
                                'userName'         => (string)$value->{'user-name'}
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /**
     * Below method retrieves all the UnBlocked users
     */
    public function getAllUnBlockedUsersWithLoggedInUser(){
        if(!empty($_GET)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'skipValue' => !empty($_GET['skipValue']) ? $_GET['skipValue'] : 0
            );

            if(!empty($_GET['q']) && $_GET['q'] != 'all'){
                $headers['userName'] = $_GET['q'];
                $result = $this->_model->searchForAUser($headers);
            }else{
                $result = $this->_model->getAllUsers($headers, 1);
            }

            switch ($result['status']) {
                case (200):
                    $users = array();
                    foreach($result['body']->{'data'}->{'users'} as $value){
                        if((string)$value->{'active'} == true){
                            $user = array(
                                'profilePic'       => Url::profilePic((string)$value->{'userName'}),
                                'userName'         => (string)$value->{'userName'}
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /**
     * Below method retrieves all the Blocked users
     */
    public function getAllBlockedUsers(){
        if(!empty($_GET)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_GET['skipValue']) ? $_GET['skipValue'] : 0
            );

            if(!empty($_GET['q']) && $_GET['q'] != 'all'){
                $headers['userName'] = $_GET['q'];
                $result = $this->_model->searchForAUser($headers);
            }else{
                $result = $this->_model->getAllUsers($headers);
            }

            switch ($result['status']) {
                case (200):
                    $users = array();
                    foreach($result['body'] as $value){
                        if((string)$value->{'is-active'} == 'false' && (string)$value->{'user-name'} != $this->session->get('userName')){
                            $user = array(
                                'profilePic'       => Url::profilePic((string)$value->{'user-name'}),
                                'userName'         => (string)$value->{'user-name'}
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /**
     * Below method retrieves all the UnBlocked users
     */
    public function getAllUnBlockedUsersWithGroups(){
        if(empty($_GET)){
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
        }
        $headers = array(
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'token'     => $this->session->get('token'),
            'skipValue' => !empty($_GET['skipValue']) ? $_POST['skipValue'] : 0
        );
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['userName'] = $_GET['q'];
            $result = $this->_model->searchForAUserWithGroup($headers);
        }else{
            $result = $this->_model->getAllUsersWithGroup($headers);
        }

        switch ($result['status']) {
            case (200):
                $users = array();
                //$users = array_merge(array(array("userName" => "all", "profilePic" => Url::profilePic('default'))), $users);
                if(!empty($result['body']->{'stringElementList'})){
                    foreach($result['body']->{'stringElementList'} as $value){
                        $user = array(
                            'profilePic'       => Url::profilePic((string)$value->{'name'}),
                            'userName'         => (string)$value->{'name'},
                            'emailId'         => (!empty((string)$value->{'emailId'})) ? (string)$value->{'emailId'} : (string)$value->{'name'}
                        );
                        $users = array_merge(array($user), $users);

                    }
                }

                $response = array(
                    'result' => 'success',
                    'users'  => (!empty($users)) ? array_reverse($users) : $users
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    /**
     * Below method Blocks list of users
     */
    public function blockMultipleUsers(){
        if(!empty($_POST['users'])){
             $this->log('UUUUSSSSEEEERRRRRSSSSS'. $_POST['users'], 'info');
            $headers = array(
                'Content-Type' => 'application/json',
                'token'     => $this->session->get('token'),
                'active'    => $_POST['active'],
                'blockedBy'    => $this->session->get('userName'),
                );
            
            $this->log(json_encode($headers), "info");
            $this->log(json_encode($_POST['users']), "info");
            $result = $this->_model->blockMultipleUsers($headers,$_POST['users'] );
            $this->log('Type'. $_POST['active'], 'info');
            switch ($result['status']) {
                case (200):
                    if($_POST['active'] == 'true'){
                        $msg = $this->language->get('unBlockedMultipleUsers');
                    }else{
                        $msg = $this->language->get('blockedMultipleUsers');
                    }
                    $response = array(
                        'result' => 'success',
                        'msg' => $msg,
                        'users'  => $result
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }
    
    public function blockUsers(){
	    $this->log("------------------------------------","info");
        if(!empty($_POST['users'])){
            $headers = array(
                'Content-type' => 'application/json',
                'token'     => $this->session->get('token'),
		'oppType' => 'block'
            );
	    if($this->session->get('isLdapEnabled') == 'true'){
                $headers1 = array(
                	'Content-Type'   => 'application/json',
                        'token'          => $this->session->get('token')
                );

                $result1 = $this->_model->getAdCredentials($headers1);
                $adcS = [];
                if(!empty($result1['body']->{'adElementList'})){
                            foreach($result1['body']->{'adElementList'} as $value){
                                if($value->{'adGroupName'} != ''){
                                        array_push($adcS, $value->{'adGroupName'});
                                }
                            }
                }
                $this->log("groupssss : ".json_encode($adcS),"info");
                $this->log("groupssss count : ".count($adcS),"info");
                $count = count($adcS);
            }
            if($this->session->get('isAADEnabled') == 'true'){
                $headers1= array(
                            'Content-Type'  => 'application/json',
                            'token'         => $this->session->get('token'),
                            'Accept'        => 'application/json',
                            'Accept-Charset'=> 'utf-8',
                        );
                $result1 = $this->_model->getAadDetails($headers1);
                $groups = [];
                if(!empty($result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'})){
                        foreach( $result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'} as $key => $value ) {
                                if($key != ''){
                                        array_push($groups, $key);
                                }
                        }
                }
                $count = count($groups);
            }
            $this->log('Type________'. json_encode($data), 'info');
            $result = $this->_model->blockUsers($headers, $_POST['users']);
            $this->log('Type'. $result['body']->userElementList, 'info');
            switch ($result['status']) {
                case (200):
                    $this->log('UUUUUUUEEEEE'. json_encode($result['body']), 'info');
                    $policies = [];
		    foreach($result['body']->{'userElementList'} as $value){
			    if($value->{'localUser'} == true){
				$type = "Local";
			    }else{
			    	if($count > 0){
					$type = 'Migrated';
				}else{
					$type = 'Migrated1';
				}
			    }
			    if($type == 'Migrated' || (string)$value->{'status'} == 'BLOCKED' || (string)$value->{'status'} == 'DELETED' || (string)$value->{'status'} == 'INVALID' || (string)$value->{'status'} == 'CurrentUser' || (string)$value->{'status'} == 'User does not exist or invalid'){
			    $flag = 'disablee';
			    }else{
			    $flag = 'enablee';
			    }
			    if($type == 'Local'){
                                    $type = 'Local User';
                            }else{
                                if($count > 0){
                                	$type = 'Not a Local User. Please remove from in AD or AAD group or Disable the user from AD or AAD';
                                }else{
                                        $type = 'Not a Local User.';
                                }
                            }
                        $policy = array(

                            'userName' => (string)$value->{'userName'},
                            'emailId' => (string)$value->{'emailId'},
                            'isActive' => $value->{'active'},
                            'localUser' => $value->{'localUser'},
                            'type' => $type,
                            'time' =>!empty($value->{'lastModifiedTimestamp'})? date("M j, Y, g:i:s", (((int)$value->{'lastModifiedTimestamp'}) / 1000)) : '',
			    'status' => (string)$value->{'status'},
			    'flag' => $flag,

                            );
                        $policies = array_merge(array($policy), $policies);
                    }

                    $this->log('UUUUUUU'. json_encode($policies), 'info');
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('deletedMultipleUsers'),
                        'naveen'  => array_reverse($policies)
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'message' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;

                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /**
     * Below method Delete list of users
     */
    public function deleteMultipleUsers(){
        if(!empty($_POST['users'])){
            $headers = array(
                'Content-Type' => 'application/json',
                'token'     => $this->session->get('token'),
                'deletedBy'    => $this->session->get('userName'),
            );
            $this->log(json_encode($headers), "info");
            $this->log(json_encode($_POST['users']), "info");
            $result = $this->_model->deleteMultipleUsers($headers, $_POST['users']);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('deletedMultipleUsers'),
                        'users'  => $result
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'message' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }
    
    public function unblockUsers(){
        if(!empty($_POST['users'])){
            $headers = array(
                'Content-type' => 'application/json',
                'token'     => $this->session->get('token'),
		'oppType' => 'unblock'
            );
    /*        $data = array(
               'userNames' => implode(',', $_POST['users']),           
                          
       );*/
	    if($this->session->get('isLdapEnabled') == 'true'){
                $headers1 = array(
                	'Content-Type'   => 'application/json',
                        'token'          => $this->session->get('token')
                );

                $result1 = $this->_model->getAdCredentials($headers1);
                $adcS = [];
                if(!empty($result1['body']->{'adElementList'})){
                            foreach($result1['body']->{'adElementList'} as $value){
                                if($value->{'adGroupName'} != ''){
                                        array_push($adcS, $value->{'adGroupName'});
                                }
                            }
                }
                $this->log("groupssss : ".json_encode($adcS),"info");
                $this->log("groupssss count : ".count($adcS),"info");
                $count = count($adcS);
            }
            if($this->session->get('isAADEnabled') == 'true'){
                $headers1= array(
                            'Content-Type'  => 'application/json',
                            'token'         => $this->session->get('token'),
                            'Accept'        => 'application/json',
                            'Accept-Charset'=> 'utf-8',
                        );
                $result1 = $this->_model->getAadDetails($headers1);
                $groups = [];
                if(!empty($result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'})){
                        foreach( $result1['body']->{'AADCredentialsElementList'}[0]->{'groupConfig'} as $key => $value ) {
                                if($key != ''){
                                        array_push($groups, $key);
                                }
                        }
                }
                $count = count($groups);
            }
            $this->log('Type________'. json_encode($data), 'info');
            $result = $this->_model->unblockUsers($headers, $_POST['users']);
            $this->log('Type'. $result['body']->userElementList, 'info');
            switch ($result['status']) {
                case (200):
                    $this->log('UUUUUUUEEEEE'. json_encode($result['body']), 'info');
                    $policies = [];
		    foreach($result['body']->{'userElementList'} as $value){
			    if($value->{'localUser'} == true){
                                $type = "Local";
                            }else{
                            	if($count > 0){
					$type = 'Migrated';
				}else{
					$type = 'Migrated1';
				}
                            }
                            if($type == 'Migrated' || (string)$value->{'status'} == 'ACTIVE' || (string)$value->{'status'} == 'DELETED' || (string)$value->{'status'} == 'INVALID' || (string)$value->{'status'} == 'CurrentUser' || (string)$value->{'status'} == 'User does not exist or invalid'){
                            $flag = 'disablee';
                            }else{
                            $flag = 'enablee';
                            }
			    if($type == 'Local'){
                                    $type = 'Local User';
                            }else{
                                if($count > 0){
                                	$type = 'Not a Local User. Please remove from in AD or AAD group or Disable the user from AD or AAD';
                                }else{
                                        $type = 'Not a Local User.';
                                }
                            }
                        $policy = array(
                            'userName' => (string)$value->{'userName'},
                            'emailId' => (string)$value->{'emailId'},
                            'isActive' => $value->{'active'},
			    'localUser' => $value->{'localUser'},
			    'type' => $type,
                            'time' =>!empty($value->{'lastModifiedTimestamp'})? date("M j, Y, g:i:s", (((int)$value->{'lastModifiedTimestamp'}) / 1000)) : '',
                            'status' => (string)$value->{'status'},
                            'flag' => $flag,
                            );
                        $policies = array_merge(array($policy), $policies);
                    }
                    
                    $this->log('UUUUUUU'. json_encode($policies), 'info');
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('deletedMultipleUsers'),
                        'naveen'  => array_reverse($policies)
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'message' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
                
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    /**
     * Renders users page
     */
    public function createUserGroup(){
        //Auth::allowOnly('admin');
        $headers = array(
            'Content-type' => 'application/json',
            'Accept' => 'application/json',
            'token'     => $this->session->get('token')
        );
        $groupResult = $this->_model->getUserGroups($headers);
        $groups = !empty($groupResult['body']) ? json_decode($groupResult['body']) : '';

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'subTitle' => $this->language->get('manageUserGroup'),
            'active' => 'users',
            'csrf_token' => $this->setCSRFToken(),
            'groups' => $groups->stringElementList,
            'loggedInUser' => $this->session->all()
        );


        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('users/userGroup', $data);
        View::renderTemplate('footer', $data);
    }



    /**
     * Below method Delete list of users
     */
    public function deleteUserGroup(){
        if(!empty($_POST['groupName'])){
            $headers = array(
                'Content-type' => 'application/json',
                'Accept' => 'application/json',
                'token'     => $this->session->get('token'),
            );

            $result = $this->_model->deleteUserGroup($headers, $_POST['groupName']);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('deletedAGroup'),
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'message' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    function getUserXML($clouds,$users,$backups,$syncs,$odbackups){
        $doc = new DOMDocument();
        $doc->formatOutput = true;

        $b = $doc->createElement( "user" );
        $doc->appendChild( $b );

        $userName = $doc->createElement( "user-name" );
        $userName->appendChild( $doc->createTextNode( $users['userName'] ));
        $b->appendChild( $userName );
        
        if($users['displayName'] != ''){
        $displayName = $doc->createElement( "display-name" );
        $displayName->appendChild( $doc->createTextNode( $users['displayName'] ));
        $b->appendChild( $displayName );
        }
	    
	$googleSecretKey = $doc->createElement( "google-secret-key" );
        $googleSecretKey->appendChild( $doc->createTextNode( $users['googleSecretKey'] ));
        $b->appendChild( $googleSecretKey );
	    
	$noOfDaysForAutoBlock = $doc->createElement("noOfDaysForAutoBlock");
        $noOfDaysForAutoBlock->appendChild( $doc->createTextNode( $users['noOfDaysForAutoBlock'] ));
        $b->appendChild($noOfDaysForAutoBlock);

        $autoExpireType = $doc->createElement("autoExpireType");
        $autoExpireType->appendChild( $doc->createTextNode( $users['autoExpireType'] ));
        $b->appendChild($autoExpireType);

        if($users['location'] != ''){
        $location = $doc->createElement( "location" );
        $location->appendChild( $doc->createTextNode( $users['location'] ));
        $b->appendChild( $location );
        }

        if($users['department'] != ''){
        $department = $doc->createElement( "department" );
        $department->appendChild( $doc->createTextNode( $users['department'] ));
        $b->appendChild( $department );
        }

        if($users['isBackupEnabled'] == 'true'){
        $userName = $doc->createElement( "policy-name" );
        $userName->appendChild( $doc->createTextNode( $users['policyName'] ));
        $b->appendChild( $userName );
        }

        $userName = $doc->createElement( "sync-policy-name" );
        $userName->appendChild( $doc->createTextNode( $users['syncPolicyName'] ));
        $b->appendChild( $userName );
        
        $userName = $doc->createElement( "odbPolicyName" );
        $userName->appendChild( $doc->createTextNode( $users['odbPolicyName'] ));
        $b->appendChild( $userName );

        $password = $doc->createElement( "password-hash" );
        $password->appendChild( $doc->createTextNode( $users['password'] ));
        $b->appendChild( $password );

        $emailId = $doc->createElement( "email-id" );
        $emailId->appendChild( $doc->createTextNode( $users['emailId'] ));
        $b->appendChild( $emailId );
        
        $odbEmailId = $doc->createElement( "odb-loginId" );
        $odbEmailId->appendChild( $doc->createTextNode( $users['odb-loginId'] ));
        $b->appendChild( $odbEmailId );

        $admin = $doc->createElement( "is-admin" );
        $admin->appendChild($doc->createTextNode( $users['isAdmin'] ));
        $b->appendChild( $admin );

        $admin = $doc->createElement( "is-readonly-admin" );
        $admin->appendChild($doc->createTextNode( $users['readOnlyAdmin'] ));
        $b->appendChild( $admin );

        $sync = $doc->createElement( "sync-enabled" );
        $sync->appendChild($doc->createTextNode( $users['isSyncEnabled'] ));
        $b->appendChild( $sync );

        $syncAccessType = $doc->createElement( "syncAccessType" );
        $syncAccessType->appendChild($doc->createTextNode( $users['syncAccessType'] ));
        $b->appendChild( $syncAccessType );

        $backup = $doc->createElement( "backup-enabled" );
        $backup->appendChild($doc->createTextNode( $users['isBackupEnabled'] ));
        $b->appendChild( $backup );
        
        $odbBackup = $doc->createElement( "onedriveBkpEnabled" );
        $odbBackup->appendChild($doc->createTextNode( $users['onedriveBkpEnabled'] ));
        $b->appendChild( $odbBackup );
	    
	$exchangeBackup = $doc->createElement( "exchangeBkpEnabled" );
        $exchangeBackup->appendChild($doc->createTextNode( $users['exchangeBkpEnabled'] ));
        $b->appendChild( $exchangeBackup );

        $serverBackup = $doc->createElement( "server-backup-enabled" );
        $serverBackup->appendChild($doc->createTextNode( $users['isServerBackupEnabled'] ));
        $b->appendChild( $serverBackup );

        $share = $doc->createElement( "share-enabled" );
        $share->appendChild($doc->createTextNode( $users['isShareEnabled'] ));
        $b->appendChild( $share );

        $mcs = $doc->createElement("mini-clouds");
        $b->appendChild($mcs);

        if(!empty($clouds)){
            foreach ($clouds as $cloud) {
                $mc= $doc->createElement("mini-cloud");
                $mcs->appendChild($mc);
                $cloudName = $doc->createElement( "mini-cloud-name" );
                $cloudName->appendChild($doc->createTextNode( $cloud));
                $mc->appendChild($cloudName);
            }
        }
	$bpa = $doc->createElement("backupPoliciesAdmin");
        $b->appendChild($bpa);

        if(!empty($backups)){
            foreach ($backups as $backup) {
                $backupPolicyName = $doc->createElement("backupPolicyAdmin" );
                $backupPolicyName->appendChild($doc->createTextNode($backup));
                $bpa->appendChild($backupPolicyName);
            }
        }

        $spa = $doc->createElement("syncPoliciesAdmin");
        $b->appendChild($spa);

        if(!empty($syncs)){
            foreach ($syncs as $sync) {
                $syncPolicyName = $doc->createElement("syncPolicyAdmin" );
                $syncPolicyName->appendChild($doc->createTextNode($sync));
                $spa->appendChild($syncPolicyName);
            }
        }
        
        $odbpa = $doc->createElement("odbPoliciesAdmin");
         $b->appendChild($odbpa);
 
         if(!empty($odbackups)){
             foreach ($odbackups as $odbackup) {
                 $odbPolicyName = $doc->createElement("odbPolicyAdmin" );
                 $odbPolicyName->appendChild($doc->createTextNode($odbackup));
                 $odbpa->appendChild($odbPolicyName);
             }
         }
        return $doc->saveXML();
    }

    public function getOsType($deviceType){
        if((strpos($deviceType, 'Wind') === false )){
            if((strpos($deviceType, 'Lin') === false )){
                return 'MAC';
            }else{
                return 'Linux';
            }
        }else{
            return 'Windows';
        }
    }

public function getAllCcS(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
        $ccS = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        $result = $this->_model->getCloudCredentials($headers);
        $this->log($result);
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
                    foreach($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $value){
                        switch($value->cloudName){
                            case 'azureBlob':
                                $value->cloudNameInCaps = 'Azure Blob';
                                break;
                            case 'ibmCloud':
                                $value->cloudNameInCaps = 'IBM Cloud';
                                break;
                            case 'amazon':$value->cloudNameInCaps = 'Amazon s3 Services';
                                break;
                            case 'localStorage':
                                $value->cloudNameInCaps = 'Local Storage';
                break;
                            default:
                                $value->cloudNameInCaps = '';
                                break;
                        }

                        $ccS = array_merge(array($value), $ccS);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'ccS' => $ccS,
);
                echo json_encode($response);
                exit;
        case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
        case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function bulkCreate(){
        if(!empty($_POST['devices'])){
            $headers = array(
                'Content-Type' => 'application/json',
                'token'     => $this->session->get('token'),
            );
            
            $this->log('Type________'. $_POST['devices'], 'info');
            $result = $this->_model->bulkCreate($headers, $_POST['devices']);
            $this->log('Type_____userElementList'. json_encode($result['body']->userErrorReponseList), 'info');
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => "Users Created Successfully",
                    );
                    echo json_encode($response);
                    exit;
                case (201):
                        $response = array(
                            'result' => 'success',
                            'message' => $this->language->get('userSavedSuccess')
                        );
                        echo json_encode($response);
                        exit;
                case (400):
                    $users = array();
                    foreach($result['body']->userErrorReponseList as $value){
                        $user = array(
                            'userName'         => (string)$value->{'userName'},
                            'errorMessage' => (string)$value->{'errorMessage'}
                        );
                        $users = array_merge(array($user), $users);
                    }
                    $response = array(
                        'result' => 'Not_created',
                        'users'  => array_reverse($users),
                        'msg' => 'Unable to create users'
                    );
                    echo json_encode($response);
                    exit;
                case (206):
                    $users = array();
                    foreach($result['body']->userErrorReponseList as $value){
                        $user = array(
                            'userName'         => (string)$value->{'userName'},
                            'errorMessage' => (string)$value->{'errorMessage'}
                        );
                        $users = array_merge(array($user), $users);
                    }
                    if($result['header']->{'container'}['totalUsersCreated'] == 1){
                       $msg = 'Partially Created ,'. $result['header']->{'container'}['totalUsersCreated'].' user out of '.$result['header']->{'container'}['totalUsersCount']. ' users .';
                    }else{
                       $msg = 'Partially Created ,'. $result['header']->{'container'}['totalUsersCreated'].' users out of '.$result['header']->{'container'}['totalUsersCount']. ' users .'; 
                    }
                    
                    $response = array(
                        'result' => 'Not_created',
                        'users'  => array_reverse($users),
                        'msg' => $msg
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'message' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $result = array(
                        'result' => 'User_Limit_Exceeded',
                        'noOfPossibleUsers' => $result['header']->{'container'}['no-of-possible-users'],
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }

    public function getOsIcon($deviceType){
	if((strpos($deviceType, 'ONE') === false )){
        if((strpos($deviceType, 'Wind') === false )){
            if((strpos($deviceType, 'Lin') === false )){
                if(strpos($deviceType, 'Android') === false){
                    $type =  'apple';
                }else{
                    $type =  'android';
                }
            }else{
                $type =  'linux';
            }
        }else{
            $type =  'windows';
        }
    }else{
        $type =  'cloud';
    }
    return $type;
    }
    
    public function getBackground($deviceType){
        if((strpos($deviceType, 'OUTLOOK') === false )){
            if((strpos($deviceType, 'ONE') === false )){
                if((strpos($deviceType, 'Wind') === false )){
                    if((strpos($deviceType, 'Lin') === false )){
                        if(strpos($deviceType, 'Android') === false){
                            $type =  'primary';
                        }else{
                            $type =  'primary';
                        }
                    }else{
                        $type =  'primary';
                    }
                }else{
                    $type =  'purple';
                }
            }else{
                $type =  'skyBlue';
            }
        }else{
            $type =  'outlook';
        }
    return $type;
    }
    
    public function exportUsersToExcel(){
        $headers = array(
            'Content-Type' => 'application/json',
            'token'     => $this->session->get('token')
        );
        $data = array(
                'userName' => $_POST['userName']
        );
        $result = $this->_model->exportUserToExcel($headers, $data);
        switch ($result['status']) {
                case (200):
 
                    $response = array(
                        'result' => 'success'
                    );
                    echo json_encode($response);
                    exit;
                case (403):
 
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'No records found, Unable to create excel.'
                     );
                    echo json_encode($response);
                    exit;
 
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                     );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
     
    public function downloadUsersToExcel(){
        $filePath = AGENT_NOT_HEARD_PATH.USER_EXCEL_NAME;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.USER_EXCEL_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('users/'.$_GET['from'].'?result=404'));
            }
    }
    
    public function downloadBulkcreateusersSample(){
    	$filePath = OVERVIEW_REPORT_PATH.BULK_CREATE_USERS_SAMPLE_NAME;
    	$this->log("path -> ".$filePath,"info");
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BULK_CREATE_USERS_SAMPLE_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }
    
    public function downloadBlockUnblockDeleteusersSample(){
    	$filePath = OVERVIEW_REPORT_PATH.BULK_BLOCK_UNBLOCK_DELETE_USERS_SAMPLE;
    	$this->log("path -> ".$filePath,"info");
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BULK_BLOCK_UNBLOCK_DELETE_USERS_SAMPLE);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }
    
    /*muxed start*/
    public function muxedUsersList(){
            $headers = array(
                'Content-Type'      => 'application/json',
                'Accept'        => 'application/json',
                'token'             => $this->session->get('token')
            );

            $result = $this->_model->muxedUsersList($headers);
            $musers = [];

                    if($result['body']->{'userElementResponse'}->{'users'}){
                        foreach($result['body']->{'userElementResponse'}->{'users'} as $value){
                            array_push($musers,(string)$value->{'userName'});
                        }
                    }
            $this->log("muxedUsersList : ".json_encode($musers),"info");
            $this->log("muxedUsersList : ".json_encode($result['body']->{'userElementResponse'}->{'users'}),"info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'users'  => $musers
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (404):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "Not found"
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function startMuxing(){
        $this->log("Called startDataMigration ".json_encode($_POST['users']),"info");
        $_POST['users'] = implode(',', $_POST['users']);
        $headers = array(
            'Content-Type'  => 'application/json',
            'Accept'  => 'application/json',
            'token'         => $this->session->get('token'),
            'users' => $_POST['users'],
            'destOdbId' => $_POST['bucketName'],
        );
        $this->log("jjjjjjjjjjjjjjjj : ".json_encode($headers),"info");
        $result = $this->_model->startMuxing($headers);
                    switch ($result['status']) {
                        case (200):
                            $response = array(
                                'result' => 'success',
                                'response' => $result,
                                'msg'    => 'Storage repository successfully mapped.'
                            );
                            echo json_encode($response);
                            exit;
                        case (421):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('421')
                            );
                            echo json_encode($result);
                            exit();
                        case (500):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('500')
                            );
                            echo json_encode($result);
                            exit();
                        case (0):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('0')
                            );
                            echo json_encode($result);
                            exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'response' => $result,
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }
    }
    /*muxed end*/
    
    public function downloadDump(){
        $filePath = AGENT_NOT_HEARD_PATH.BULK_BLOCK_UNBLOCK_DELETE_FAIL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BULK_BLOCK_UNBLOCK_DELETE_FAIL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }
	
	public function getDeviceEndPoint(){
            $headers = array(
                    'token'         => $this->session->get('token'),
                    'Content-type'  => 'application/json',
            	    'Accept'        => 'application/json',
            );
            $result = $this->_model->getDeviceAll($headers,base64_encode($_POST['username']));
            $this->log("hhhhhhhhhh : ".json_encode($result),"info");
            $devices = array();
            switch ($result['status']) {
                case (200):
			foreach($result['body']->{'data'}->{"devices"} as $value){
                            $device = array(
                                'deviceName'         => (string)$value->{'deviceName'},
                                'deviceUUID'         => (string)$value->{'deviceUUID'},
                                'blocked'            => (string)$value->{'blocked'},
                                'osType'             => (string)$value->{'osType'},
				'decoupled'          => (string)$value->{'decoupled'}
                        );
                            if($device['blocked'] == false && $device['osType'] != 'ONEDRIVE' && $device['osType'] != 'OUTLOOK' && $device['decoupled'] == false){
                                    $devices = array_merge(array($device), $devices);
                            }
                        }
                    $response = array(
                            'result' => 'success',
                            'newone1'  => array_reverse($devices)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
			'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }
	
	public function getDeviceOutlook(){
            $headers = array(
                    'token'         => $this->session->get('token'),
                    'Content-type'  => 'application/json',
            	    'Accept'        => 'application/json',
            );
            $result = $this->_model->getDeviceAll($headers,base64_encode($_POST['username']));
            $this->log("hhhhhhhhhh : ".json_encode($result),"info");
            $devices = array();
            switch ($result['status']) {
                case (200):
			foreach($result['body']->{'data'}->{"devices"} as $value){
                            $device = array(
                                'deviceName'         => (string)$value->{'deviceName'},
                                'deviceUUID'         => (string)$value->{'deviceUUID'},
                                'blocked'            => (string)$value->{'blocked'},
                                'osType'             => (string)$value->{'osType'},
				'decoupled'          => (string)$value->{'decoupled'}
                        );
                            if($device['blocked'] == false && $device['osType'] == 'OUTLOOK' && $device['decoupled'] == false){
                                    $devices = array_merge(array($device), $devices);
                            }
                        }
                    $response = array(
                            'result' => 'success',
                            'newone1'  => array_reverse($devices)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
			'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }
	
	public function getDeviceOnedrive(){
            $headers = array(
                    'token'         => $this->session->get('token'),
                    'Content-type'  => 'application/json',
            	    'Accept'        => 'application/json',
            );
            $result = $this->_model->getDeviceAll($headers,base64_encode($_POST['username']));
            $this->log("hhhhhhhhhh : ".json_encode($result),"info");
            $devices = array();
            switch ($result['status']) {
                case (200):
			foreach($result['body']->{'data'}->{"devices"} as $value){
                            $device = array(
                                'deviceName'         => (string)$value->{'deviceName'},
                                'deviceUUID'         => (string)$value->{'deviceUUID'},
                                'blocked'            => (string)$value->{'blocked'},
                                'osType'             => (string)$value->{'osType'},
				'decoupled'          => (string)$value->{'decoupled'}
                        );
                            if($device['blocked'] == false && $device['osType'] == 'ONEDRIVE' && $device['decoupled'] == false){
                                    $devices = array_merge(array($device), $devices);
                            }
                        }
                    $response = array(
                            'result' => 'success',
                            'newone1'  => array_reverse($devices)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
			'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }
	
	public function searchUserWithDeviceForRestore(){
        if(!empty($_GET)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'skipValue' => !empty($_GET['skipValue']) ? $_GET['skipValue'] : 0
            );

            $users = array();
            if($_GET['q'] == "all"){
                $users = array_merge(array(array("userName" => "all", "profilePic" => Url::profilePic('default'))), $users);
                $response = array(
                    'result' => 'success',
                    'users'  => array_reverse($users)
                );
                echo json_encode($response);
                exit;
            }

            $headers['userName'] = $_GET['q'];
            $result = $this->_model->searchUserWithDevice($headers);
            $this->log($result);
            switch ($result['status']) {
                case (200):
                    //$users = array_merge(array(array("userName" => "all", "profilePic" => Url::profilePic('default'))), $users);
                    if($result['body']->{"searchUserElementList"}){
                        foreach($result['body']->{"searchUserElementList"} as $value){
                            $user = array(
                                'profilePic'       => Url::profilePic((string)$value->{'userName'}),
                                'userName'         => (string)$value->{'userName'},
                                'devices'          => (array)$value->{'deviceNameList'},
				'active'           => (string)$value->{'active'}
                            );
                            if($user['active'] != false){
				$users = array_merge(array($user), $users);
			    }
                        }
                    }else{
                        $users = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'users'  => array_reverse($users)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','msg' => $this->language->get('noData')));
        }
    }
	
    public function getSoftDeleteUsers(){
            $headers = array(
                'Content-Type'      => 'application/json',
                'Accept'        => 'application/json',
                'token'             => $this->session->get('token')
            );
            $pageNumber =1;
            $result = $this->_model->getSoftDeleteUsers($headers, $pageNumber);
            $users = array();
            if(!empty($result['body']->{'data'}->{'users'})){
                foreach($result['body']->{'data'}->{'users'} as $value){
                    $user = array(
                        'userName'         => (string)$value->{'userName'},
                        'emailId'          => (string)$value->{'emailId'},
                        );
                    $users = array_merge(array($user), $users);
                }
            }
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'users'    => $users
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (404):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "Not found"
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    /*----------------------------------------*/
//protected $_codeLength = 6;

    /**
     * Create new secret.
     * 16 characters, randomly chosen from the allowed base32 characters.
     *
     * @param int $secretLength
     * @return string
     */
    public function createSecret($secretLength = 16)
    {
        $validChars = $this->_getBase32LookupTable();
        unset($validChars[32]);

        $secret = '';
        for ($i = 0; $i < $secretLength; $i++) {
            $secret .= $validChars[array_rand($validChars)];
        }
        return $secret;
    }

    /**
     * Calculate the code, with given secret and point in time
     *
     * @param string $secret
     * @param int|null $timeSlice
     * @return string
     */
    public function getCode($secret, $timeSlice = null)
    {
        if ($timeSlice === null) {
            $timeSlice = floor(time() / 30);
        }

        $secretkey = $this->_base32Decode($secret);

        // Pack time into binary string
	$time = chr(0).chr(0).chr(0).chr(0).pack('N*', $timeSlice);
        // Hash it with users secret key
        $hm = hash_hmac('SHA1', $time, $secretkey, true);
        // Use last nipple of result as index/offset
        $offset = ord(substr($hm, -1)) & 0x0F;
        // grab 4 bytes of the result
        $hashpart = substr($hm, $offset, 4);

        // Unpak binary value
        $value = unpack('N', $hashpart);
        $value = $value[1];
        // Only 32 bits
        $value = $value & 0x7FFFFFFF;

        $modulo = pow(10, $this->_codeLength);
        return str_pad($value % $modulo, $this->_codeLength, '0', STR_PAD_LEFT);
    }
     /**
     * Get QR-Code URL for image, from google charts
     *
     * @param string $name
     * @param string $secret
     * @param string $title
     * @return string
     */
    public function getQRCodeGoogleUrl($name, $secret, $title = null) {
        $urlencoded = urlencode('otpauth://totp/'.$name.'?secret='.$secret.'');
    if(isset($title)) {
                $urlencoded .= urlencode('&issuer='.urlencode($title));
        }
        return 'https://chart.googleapis.com/chart?chs=200x200&chld=M|0&cht=qr&chl='.$urlencoded.'';
    }
     /**
     * Check if the code is correct. This will accept codes starting from $discrepancy*30sec ago to $discrepancy*30sec from now
     *
     * @param string $secret
     * @param string $code
     * @param int $discrepancy This is the allowed time drift in 30 second units (8 means 4 minutes before or after)
     * @param int|null $currentTimeSlice time slice if we want use other that time()
     * @return bool
     */
    public function verifyCode($secret, $code, $discrepancy = 1, $currentTimeSlice = null)
    {
        if ($currentTimeSlice === null) {
            $currentTimeSlice = floor(time() / 30);
        }

        for ($i = -$discrepancy; $i <= $discrepancy; $i++) {
            $calculatedCode = $this->getCode($secret, $currentTimeSlice + $i);
	    $this->log("CODE : ".json_encode($code),"info");
	    $this->log("getCODE : ".json_encode($calculatedCode),"info");
            if ($calculatedCode == $code ) {
		return true;
            }
        }

        return false;
    }

    /**
     * Set the code length, should be >=6
     *
     * @param int $length
     * @return GoogleAuthenticator
     */
    public function setCodeLength($length)
    {
        $this->_codeLength = $length;
        return $this;
    }
     /**
     * Helper class to decode base32
     *
     * @param $secret
     * @return bool|string
     */
    protected function _base32Decode($secret)
    {
        if (empty($secret)) return '';

        $base32chars = $this->_getBase32LookupTable();
        $base32charsFlipped = array_flip($base32chars);

        $paddingCharCount = substr_count($secret, $base32chars[32]);
        $allowedValues = array(6, 4, 3, 1, 0);
        if (!in_array($paddingCharCount, $allowedValues)) return false;
        for ($i = 0; $i < 4; $i++){
	if ($paddingCharCount == $allowedValues[$i] &&
                substr($secret, -($allowedValues[$i])) != str_repeat($base32chars[32], $allowedValues[$i])) return false;
        }
        $secret = str_replace('=','', $secret);
        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i = $i+8) {
            $x = "";
            if (!in_array($secret[$i], $base32chars)) return false;
            for ($j = 0; $j < 8; $j++) {
                $x .= str_pad(base_convert(@$base32charsFlipped[@$secret[$i + $j]], 10, 2), 5, '0', STR_PAD_LEFT);
            }
            $eightBits = str_split($x, 8);
            for ($z = 0; $z < count($eightBits); $z++) {
                $binaryString .= ( ($y = chr(base_convert($eightBits[$z], 2, 10))) || ord($y) == 48 ) ? $y:"";
            }
        }
        return $binaryString;
	}

    /**
     * Helper class to encode base32
     *
     * @param string $secret
     * @param bool $padding
     * @return string
     */
    protected function _base32Encode($secret, $padding = true)
    {
        if (empty($secret)) return '';

        $base32chars = $this->_getBase32LookupTable();

        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i++) {
	$binaryString .= str_pad(base_convert(ord($secret[$i]), 10, 2), 8, '0', STR_PAD_LEFT);
        }
        $fiveBitBinaryArray = str_split($binaryString, 5);
        $base32 = "";
        $i = 0;
        while ($i < count($fiveBitBinaryArray)) {
            $base32 .= $base32chars[base_convert(str_pad($fiveBitBinaryArray[$i], 5, '0'), 2, 10)];
            $i++;
        }
        if ($padding && ($x = strlen($binaryString) % 40) != 0) {
            if ($x == 8) $base32 .= str_repeat($base32chars[32], 6);
            elseif ($x == 16) $base32 .= str_repeat($base32chars[32], 4);
            elseif ($x == 24) $base32 .= str_repeat($base32chars[32], 3);
            elseif ($x == 32) $base32 .= $base32chars[32];
        }
        return $base32;
    }
     /**
     * Get array with all 32 characters for decoding from/encoding to base32
     *
     * @return array
     */
    protected function _getBase32LookupTable()
    {
        return array(
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', //  7
            'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', // 15
            'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', // 23
            'Y', 'Z', '2', '3', '4', '5', '6', '7', // 31
            '='  // padding char
        );
    }
    /*----------------------------------------*/

}
