<?php
use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
if($data['userDetails']->{'sync-enabled'} == 'true' || $data['userDetails']->{'sync-webAccess-enabled'} == 'true'){
    $data['userDetails']->{'sync-enabled'} = 'true';
}
?>
<?php
if(googleAuthenticator == true){
include_once('/var/www/portal/app/views/login/GoogleAuthenticator.php');
$ga = new GoogleAuthenticator();
$website = MFATITLE; //Your Website
$title = $data['userDetails']->{'user-name'};
$secret = $data['userDetails']->{'google-secret-key'};
$qrCodeUrl = $ga->getQRCodeGoogleUrl($title, $secret,$website);
}
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <?php }else{ ?>
                    <li><h3><?=$data['title']?></h3></li>
                <?php } ?>
                <li><?=$data['subPageName']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="currentPage d-none"><?='myaccount'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                <div class="col-lg-3">
                    <div class="sidebar">
                        <div class="side-menu">
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'd-none';}?>" ng-app="fileUpload" align="center">
                                    <br/>
                                    <img class="profileImg drop-box"
                                         ngf-select ngf-drop
                                         ng-model="file"
                                         ngf-drag-over-class="dragover"
                                         ngf-multiple="false"
                                         ngf-allow-dir="true"
                                         ngf-keep="false"
                                         ngf-src="file"
                                         ngf-pattern="'.jpg'"
                                         ngf-default-src="'<?=Url::profilePic($data['userDetails']->{'user-name'})?>'"
                                         accept="image/*" ngf-accept="'image/*'">
                                    <div ngf-no-file-drop><?=Language::show('drag_drop_not_supported', 'keywords');?></div>
                                </div>
                            <?php }else{ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'd-none';}?>" align="center">
                                    <br/>
                                    <img class="profileImg" src="<?=Url::profilePic($data['userDetails']->{'user-name'})?>" />
                                </div>
                            <?php } ?>
                            <br/>
                            <div align="center">
                                <ul class="nav wordwrap">
                                    <li><p><?=Language::show('name', 'keywords');?>: <span class="userName"><?=$data['userDetails']->{'user-name'};?></span></p></li>
                                    <li><p><?=Language::show('email', 'keywords');?>: <?=$data['userDetails']->{'email-id'};?></p></li>
                                    <li>
                                        <p>
                                            <?=Language::show('account_type', 'keywords');?>:
                                            <?php
                                            if((string)$data['userDetails']->{'is-admin'} == 'true'){
                                                echo 'Admin';
                                            }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true'){
                                                //echo 'Read Only Admin';
                                                echo 'Delegated Administrator';
                                            }else{
                                                echo 'User';
                                            }
                                            ?>
                                        </p>
                                    </li>
                                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-y H:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?>"><?=Language::show('last_modified_time', 'keywords');?>: <?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-y H:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?></p></li>
				                    <?php if($data['lastLoggedInTime']){ ?>
				                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['lastLoggedInTime']/1000))){echo date('d-M-y H:i:s', ((int)$data['lastLoggedInTime']/1000));}else{echo '-';}?>"><?=Language::show('last_loggedin_time', 'keywords');?>: <?php if(!empty(((int)$data['lastLoggedInTime']/1000))){echo date('d-M-y H:i:s', ((int)$data['lastLoggedInTime']/1000));}else{echo '-';}?></p></li>
				                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="panel">
                        <div class="panel-heading" style="border-bottom: 1px solid #f0f4f7; padding-bottom: 13px; padding-top: 15px;">
                            <span class="h4"><?=Language::show('profileDisplay', 'user');?></span>
                            <ul class="list list-inline <?php if(!isMobile()) { ?> float-right <?php } ?>">
                                <?php if($data['userDetails']->{'localUser'} == 'true'){ ?>
                                <?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){?>
                                <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                     <li><a class="btn btn-default btn-small change" data-toggle="modal" data-target="#changePassword"><i class="fa fa-key"></i> <?=Language::show('change_password', 'keywords');?></a></li>
                                 <?php } else {?>
                                     <?php if($data['enableChangePasswordAdmin'] == 'true'){ ?>
                                         <li><a class="btn btn-default btn-small reset" data-toggle="modal" data-target="#changePassword"><i class="fa fa-key"></i> <?=Language::show('Reset Password', 'keywords');?></a></li>
                                 <?php } ?>
                                 <?php } ?> 
                                 <?php } else { ?>
                                     <?php if($data['enableChangePasswordUser'] == 'true'){ ?>
                                         <li><a class="btn btn-default btn-small change" data-toggle="modal" data-target="#changePassword"><i class="fa fa-key"></i> <?=Language::show('change_password', 'keywords');?></a></li>
                                 <?php } ?>
                                 <?php } ?>
                                 <?php } ?>    
                                <li><a class="btn btn-default btn-small" href="<?=Url::basePath('user/settings/'.base64_encode($data['userDetails']->{'user-name'}))?>"><i class="fa fa-edit"></i> <?=Language::show('edit_profile', 'keywords');?></a></li>
                                <?php if($data['loggedInUser']['admin'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                    <span class="userStatusCollector d-none"><?php if($data['userDetails']->{'is-active'} == 'true'){echo true;}?></span>
                                    <li ng-show="userStatus">
                                        <a class="btn btn-default btn-small d-none"
                                           ng-bootbox-confirm="<?=Language::show('blockConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="blockUserProfile('<?=urlencode($data['userDetails']->{'user-name'});?>', 'true')"
                                           ng-bootbox-confirm-action-cancel=""
                                           href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('Block Profile', 'keywords');?></a>
                                    </li>
                                    <li ng-hide="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('unBlockConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="unBlockUserProfile('<?=urlencode($data['userDetails']->{'user-name'});?>', 'true')"
                                           ng-bootbox-confirm-action-cancel=""
                                           href="javascript:;"><i class="fa fa-user-plus"></i> <?=Language::show('UnBlock Profile', 'keywords');?></a>
                                    </li>
                                    <li ng-hide="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('deleteConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="deleteUserProfile('<?=urlencode($data['userDetails']->{'user-name'});?>', 'true')"
                                           ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('Delete Profile', 'keywords');?></a>
                                    </li>
                                <?php } ?>
				<?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'} && googleAuthenticator == true){ ?>
					<a class="btn btn-default btn-small" data-toggle="modal" data-target="#myQR"><i class="fa fa-qrcode"></i> <?=Language::show('My QR Code', 'keywords');?></a>
				<?php } ?>
                            </ul>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="col-lg-8">
                                        <h4>Access Details</h4>
                                        <ul class="list-group">
					<?php if(DISABLE_BLUSYNC == false){ ?>
                                            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                                                <li class="list-group-item"><?php if(BLUDRIVE_MODE == false){ ?><?=Language::show('sync', 'keywords');?> <?php } else { ?> <?=Language::show('BluDrive', 'keywords');?> <?php } ?>: <?php if($data['userDetails']->{'sync-enabled'} =='true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
                                            <?php } ?>
					<?php } ?>
					<?php if(DISABLE_BLUVAULT == false){ ?>
                                            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                                                <li class="list-group-item"><?=Language::show('backup', 'keywords');?>: <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
                                            <?php } ?>
					<?php } ?>
					<?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
						<li class="list-group-item"><?=Language::show('OneDrive Backup', 'keywords');?>: <?php if($data['userDetails']->{'onedriveBkpEnabled'} == 'true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
					<?php } ?>
					<?php if(Auth::checkCloudPermission('exchange') == true){ ?>
						<li class="list-group-item"><?=Language::show('Exchange Backup', 'keywords');?>: <?php if($data['userDetails']->{'exchangeBkpEnabled'} == 'true'){ echo '<label class="badge badge-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="badge badge-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
					<?php } ?>
                                        </ul>
                                    </div>
                                    <div class="col-lg-4 d-none">
                                        <h4>Storage Details</h4>
                                        <canvas id="storage" width="245" height="150" data-used="{{ userUsed }}" data-free="{{ userFree }}"></canvas>
                                        <span class="help-block text-center" style="color:black !important;">{{ userStorage }} GB* Used, out of {{ userLimit }} GB</span>
                                    </div>
                                </div>
                            </div>
                            <div class="modal fade" id="changePassword" tabindex="-1">
                                <div class="modal-dialog">
                                  <!-- Modal content-->
                                  <div class="modal-content">
                                    <?php if($data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                        <?= Form::open(array(
                                                'ng-submit' => 'resetPassword()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                            )); ?>
                                    <?php } else { ?>
                                        <?= Form::open(array(
                                                'ng-submit' => 'changePassword()',
                                                'method' => 'post',
                                                'id' => 'changePasswordForm',
                                                'csrf' => $data['csrf_token'],
                                                'autocomplete' => 'off',
                                                'data-parsley-validate' => true
                                            )); ?>
                                    <?php } ?>
                                    <div class="modal-header">
					<h4 class="modal-title" id="myModalLabel">Change Password</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" class="form-control d-none" name="username1" id="username1" value="<?=$data['userDetails']->{'user-name'}?>">
                                        <input type="text" class="form-control d-none" name="recoverykey1" id="recoverykey1" value="<?=$data['userDetails']->{'recovery-key'}?>">
					<input type="text" class="form-control d-none" name="googleSecretKey1" id="googleSecretKey1" value="<?=$data['userDetails']->{'google-secret-key'}?>">
                                        <div class="form-group <?php if($data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ echo 'd-none'; }?>">
                                        	<label for="password">Enter Old Password</label>
                                                <input type="password" class="form-control" name="oldpassword" id="oldpassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('old', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">     
                                         </div>
                                         <div class="form-group">
                                                    <label for="password">Enter New Password</label>
                                                    <?php if(complexPassword == true) { ?>
                                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                    <?php } else { ?>
                                                    <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('new', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off" data-parsley-required data-parsley-minlength="6">
                                                    <?php } ?>
                                                    
                                         </div>
                                         <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the New Password" data-parsley-equalto="#password" data-parsley-trigger="change" data-parsley-required>
                                         </div>
					 <?php if(enableRecaptcha == true){ ?>
						<div class="row">
						    <div class="col-lg-6">
							<!--<div class="g-recaptcha" data-sitekey="<?php echo RECAPTCHA_SITE_KEY;?>"></div>-->
							<div class="g-recaptcha" data-sitekey="6LdjbN0UAAAAAJJHP5ZaYSd4hBZSbwQ5eQ8xVcio"></div>
						    </div>
						</div>
                        		 <?php } ?>
                                    </div>
                                    <div class="modal-footer">
                                      <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords');?></button>
                                      <button type="submit" id="changePasswordBtn" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>                  
                                    </div>
                                    <?= Form::close(); ?>
                                  </div>
                                  
                                </div>
                            </div>
<?php if(DISABLE_BLUVAULT == false){ ?>
                            <?php //if(($data['userDetails']->{'backup-enabled'} == 'true' || $data['userDetails']->{'onedriveBkpEnabled'} == 'true') && $data['userDetails']->{'is-guest'} == 'false'){ ?>
                                <div class="row userDevices" style="display: none;">
                                    <div class="col-lg-12">
                                        <h4><?=Language::show('myDevices', 'user');?></h4><span id="final"></span>
                                    </div>

              	<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true) { ?>
                                    <div ng-if="value.storageUsedByDevice != null" ng-repeat="value in userDevices track by $index" class="col-lg-4 userDevicemydevice{{$index}}" id="userDevicemydevice{{$index}}" block-ui="myBlockUImydevice{{$index}}">
                                <?php } else { ?>
                                    <div <?php if($data['userDetails']->{'is-readonly-admin'} != 'true' && $data['userDetails']->{'is-admin'} != 'true'){ ?> <?php } ?> ng-if="value.storageUsedByDevice != null && value.blocked == 'active'" ng-repeat="value in userDevices track by $index" class="col-lg-4 userDevicemydevice{{$index}}" id="userDevicemydevice{{$index}}" block-ui="myBlockUImydevice{{$index}}">
                                <?php } ?>
                                        <div class="panel panel-default no-box-shadow widget-{{ value.background }}">
                                            <div class="devicebackground">
                                                <i class="fa fa-{{ value.icon }}"></i>
                                            </div>
                                            <div class="panel-heading widget-header">
                                                <a title="{{ value.deviceDisplayName }}">{{ value.deviceDisplayName | limitTo:limit}}{{value.deviceDisplayName.length > limit ? '...' : ''}}</a>
                                                <a class="dropdown-toggle pull-right toolTip" data-toggle="dropdown" data-placement="right" title="Details" href="javascript:;"><i class="fa fa-bars"></i></a>
                                                <ul class="dropdown-menu">
<!--exp new start-->
<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
    <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
            <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
    <?php }else{ ?>
            <?php if($data['showButtons'] == 'true'){?>
		<?php if($data['allowEndUserTocontrolRestoreGS'] == 'true'){ ?>
                	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
			<li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                	<li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } else { ?>
			<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
			<li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
			<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
            <?php } ?>
            <?php if($data['showBackupButtons'] == 'true'){?>
		<?php if($data['allowEndUserTocontrolRestoreBP'] == 'true'){ ?>
                	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } else { ?>
			<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                	<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
            <?php } ?>
            <?php if($data['showOnedriveButtons'] == 'true'){?>
		<?php if($data['allowEndUserTocontrolRestoreBP'] == 'true'){ ?>
                	<li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                	<li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } else { ?>
			<li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                	<li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                	<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
            <?php } ?>
    <?php } ?>
<?php }else{ ?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
            <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
<?php } ?>
<!--exp new end-->							
<!--exp start-->
<!--							
<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
    <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>        
<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
<?php }else { ?>
<?php if($data['canAdminRestore'] == true){?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
<?php if(($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true') || ($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'false' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true')){ ?>
                        <li <?php if($data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true'){ ?>ng-show="value.canAdminRestore == true" <?php } ?> ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
<?php } ?>
<?php } ?>
<?php } ?>
<?php } ?>
<?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
<?php } else { ?>
<?php if($data['canAdminRestore'] == true){?>
<?php if(($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true') || ($data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'false' && $data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true')){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
                        <li <?php if($data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true' && $data['userDetails']->{'backupPolicyElement'}->{'allowEndUserTocontrolRestore'} == 'true'){ ?> ng-show="value.canAdminRestore == true" <?php } ?>  ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
<?php } ?>
        <?php } ?>
        <?php } ?>
        <?php if($data['userDetails']->{'officeBackupPolicyElement'}->{'canAdminRestore'} == 'true' || $data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                <?php } ?>
<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
							<?php } ?>
        <?php if($data['ODBRestore'] == 'true'){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
        <?php } ?>
        <?php } ?>
    <?php //} ?>
<?php }else{ ?>
        <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
                <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
        <?php } ?>
<?php if($data['bkpRestore'] == 'true'){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
        <?php } ?>
        <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                <li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
        <?php } ?>
							<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                <li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
        <?php } ?>
        <?php if($data['ODBRestore'] == 'true'){ ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
                <?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
                        <li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
        <?php } ?>

<?php } ?>-->
<!--exp end-->
                                                    <li><a href="<?=Url::basePath('user/backupHistory/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{value.deviceName}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>
						    <?php if($data['userDetails']->{'is-active'} == 'true' && ($data['userDetails']->{'backup-enabled'} == 'true' || $data['userDetails']->{'onedriveBkpEnabled'} == 'true' || $data['userDetails']->{'exchangeBkpEnabled'} == 'true')){?>
                                                    	<!--<li><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>-->
							<?php if($data['showBackupSettingsForBackupDevice'] == 'true'){?>
                                                        	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
							<?php } ?>
							<li ng-if="value.icon == 'cloud'"><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
							<li ng-if="value.icon == 'envelope'"><a href="<?=Url::basePath('user/device/policyInfo/'.base64_encode($data['userDetails']->{'user-name'}).'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
						    <?php } ?>
                                                </ul>
                                                <a class="pull-right eye" ng-click="viewDeviceDetails($index, value.deviceUUID,'mydevice',value.deviceType)" href="javascript:;"><i class="fa fa-eye"></i></a>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i ng-click="viewDeviceDetails($index, value.deviceUUID,'mydevice',value.deviceType)" class="clickAble fa fa-{{ value.icon }}"></i>
                                                <a style="font-size: 18px;margin-top: -10px; margin-right: 13px;" class="pull-right" ng-cloak>{{ value.storageUsedByDevice }}*</a>
                                                <div class="row expandDetailsmydevice{{$index}} col-lg-12" style="font-size: 10px; color: #FFFFFF; display: none;">
                                                    <?php if(!isMobile()){ ?>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <?php }else{ ?>
                                                    <div class="col-lg-12" style="padding: 30px 10px 10px 35px;">
                                                    <?php } ?>
                                                        <p>Last Successful Backup:
                                                            <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup == null" ng-cloak>Not completed yet</b>
                                                            <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup != null" ng-cloak>{{deviceDetails.lastSuccessBackup}}</b>
                                                        </p>
							<p>Next Scheduled Backup:
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup != null" ng-cloak>{{deviceDetails.nextScheduledBackup}}</b>
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup == null" ng-cloak>-</b>
                                                        </p>
							<p>Policy Refresh Frequency:
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh != null" ng-cloak>{{deviceDetails.nextPolicyRefresh}} hours</b>
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh == null">-</b>
							</p>
<?php if($data['showLatestBkpInfo'] == true){?>
                                                            <p>Total Size of Restorable Data(Latest Version): <b class="pull-right" ng-cloak>{{deviceDetails.totalSizeOfDataInCurrentBackupLatestVersion}}</b></p>
                                                        <?php } ?>
                                                    <?php if(!isMobile()){ ?></div>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;"><?php } ?>
                                                        <p ng-if="deviceDetails.osType != 'ONEDRIVE'">Operating System: <b class="pull-right" ng-cloak>{{deviceDetails.osTypeDisplay.replace("(unknown)", "");}} {{deviceDetails.version}}</b></p>
                                                        <p ng-if="deviceDetails.osType != 'ONEDRIVE'">End Point Agent Version: <b class="pull-right" ng-cloak>{{deviceDetails.productVersion}}</b></p>
							<p>Storage Media:
                                                                <b class="pull-right" ng-if="deviceDetails.storageMedia != null" ng-cloak>{{deviceDetails.storageMedia}}</b>
                                                                <b class="pull-right" ng-if="deviceDetails.storageMedia == null">-</b>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="h4 loading text-center">Loading ...</div>
<hr>
			<?php } ?>
<?php //} ?>
<!--new blockedDevices -->
<!--<div class="row blockedDevices" style="display: none;">
<div class="col-lg-12">
                                        <h4><?=Language::show('Blocked Devices', 'user');?></h4>
</div>
<div ng-if="value.storageUsedByDevice != null" ng-repeat="value in blockedDevices track by $index" class="col-lg-4 userDeviceblockeddevice{{$index}}" id="userDeviceblocked{{$index}}" block-ui="myBlockUIblockeddevice{{$index}}">
                                        <div class="panel panel-default no-box-shadow widget-{{ value.background }}">
                                            <div class="background">
                                                <i class="fa fa-{{ value.icon }}"></i>
                                            </div>
                                            <div class="panel-heading widget-header">
                 <a title="{{ value.deviceName }}">{{ value.deviceName | limitTo:limit}}{{value.deviceName.length > limit ? '...' : ''}}</a>
<a class="dropdown-toggle pull-right toolTip" data-toggle="dropdown" data-placement="right" title="Details" href="javascript:;"><i class="fa fa-bars"></i></a>
                                                <ul class="dropdown-menu">
<?php if($data['canAdminRestore'] == true){?>
<?php if($data['canAdminRestoreBackupPolicy'] == 'true'){?>
<li class="fileListBtnblockeddevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
<?php } ?>
<?php } ?>
<li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID)">Restore</a></li>
<li><a href="<?=Url::basePath('user/backupHistory/'.$data['userDetails']->{'user-name'}.'/{{ value.deviceUUID }}/{{value.deviceName}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>
<li ng-if="policyconfiguration != 'false'"><a href="<?=Url::basePath('user/device/policyInfo/'.$data['userDetails']->{'user-name'}.'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
                                                </ul>
   <a class="pull-right eye" ng-click="viewDeviceDetails($index, value.deviceUUID,'blockeddevice')" href="javascript:;"><i class="fa fa-eye"></i></a>
                                            </div>
                                            <div class="panel-body widget widget-body">
                      <i ng-click="viewDeviceDetails($index, value.deviceUUID)" class="clickAble fa fa-{{ value.icon }}"></i>
          <a style="font-size: 18px;margin-top: -10px; margin-right: 13px;" class="pull-right" ng-cloak>{{ value.storageUsedByDevice }}*</a>
              <div class="row expandDetailsblockeddevice{{$index}} col-lg-12" style="font-size: 10px; color: #FFFFFF; display: none;">
                                                    <?php if(!isMobile()){ ?>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <?php }else{ ?>
                                                    <div class="col-lg-12" style="padding: 30px 10px 10px 35px;">
                                                    <?php } ?>
<p>Last Successful Backup:
<b class="pull-right" ng-if="deviceDetails.lastSuccessBackup == null" ng-cloak>Not completed yet</b>
                     <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup != null" ng-cloak>{{deviceDetails.lastSuccessBackup}}</b>
                                                        </p>
                          <p>Next Scheduled Backup: <b class="pull-right" ng-cloak>{{deviceDetails.nextScheduledBackup}}</b></p>
                                 <p>Policy Refresh Frequency: <b class="pull-right" ng-cloak>{{deviceDetails.nextPolicyRefresh}} hours</b></p>
                                                       <?php if($data['showLatestBkpInfo'] == true){?>
<p>Total Size of Restorable Data(Latest Version): <b class="pull-right" ng-cloak>{{deviceDetails.totalSizeOfDataInCurrentBackupLatestVersion}}</b></p>
                                                        <?php } ?>
                                                    <?php if(!isMobile()){ ?></div>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;"><?php } ?>
                                                    <p ng-if="deviceDetails.osType != 'ONEDRIVE'">Operating System: <b class="pull-right" ng-cloak>{{deviceDetails.osType.replace("(unknown)", "");}} {{deviceDetails.version}}</b></p>
                                                    <p ng-if="deviceDetails.osType != 'ONEDRIVE'">End Point Agent Version: <b class="pull-right" ng-cloak>{{deviceDetails.productVersion}}</b></p>
                                                    <p>Storage Media: <b class="pull-right" ng-cloak>{{deviceDetails.storageMedia}}</b></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>-->
<!--new blocked end-->
<!--new assignDevices -->
<?php //if($data['loggedInUser']['admin'] == true) { ?>
<div class="row assignDevices" style="display: none;">
<div class="col-lg-12">
                                        <h4><?=Language::show('Devices assigned to me', 'user');?></h4>
<p><span class="label label-danger"> </span>  Blocked Devices</p>
<!--<span class="label label-warning"> </span>  Assigned Devices</p>-->
                                    </div>
<div ng-if="value.storageUsedByDevice != null" ng-repeat="value in assignDevices track by $index" class="col-lg-4 userDeviceassigndevice{{$index}}" id="userDeviceassigndevice{{$index}}" block-ui="myBlockUIassigndevice{{$index}}">
                                        <div class="panel panel-default no-box-shadow widget-{{ value.background }}">
                                            <div class="devicebackground">
                                                <i class="fa fa-{{ value.icon }}"></i>
                                            </div>
                                            <div class="panel-heading widget-header">
                 <a title="{{ value.deviceDisplayName }}">{{ value.deviceDisplayName | limitTo:limit}}{{value.deviceDisplayName.length > limit ? '...' : ''}}</a>
<a class="dropdown-toggle pull-right toolTip" data-toggle="dropdown" data-placement="right" title="Details" href="javascript:;"><i class="fa fa-bars"></i></a>
                                                <ul class="dropdown-menu">
<!--exp start-->
<!--<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
    <?php if($data['canAdminRestore'] == true || $data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
    <?php //if($data['userDetails']->{'officeBackupPolicyElement'}->{'canAdminRestore'} == true){?>
        <?php if($data['userDetails']->{'backupPolicyElement'}->{'canAdminRestore'} == 'true' || $data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
            		<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
		<?php } ?>
	<?php if($data['bkpRestore'] == 'true'){ ?>	
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
            		<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
	<?php } ?>							
        <?php } ?>
        <?php if($data['userDetails']->{'officeBackupPolicyElement'}->{'canAdminRestore'} == 'true' || $data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
            		<li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
		<?php } ?>
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
            		<li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
		<?php } ?>
	<?php if($data['ODBRestore'] == 'true'){ ?>							
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
            		<li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
            		<li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
	<?php } ?>							
        <?php } ?>
    <?php } ?>
<?php }else{ ?>
	<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
        	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
	<?php } ?>
	<?php if($data['bkpRestore'] == 'true'){ ?>							
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'backup-enabled'} == 'true'){?>
        		<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
	<?php } ?>
	<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
        	<li ng-if="value.icon == 'cloud'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
	<?php } ?>
	<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
        	<li ng-if="value.icon == 'envelope'" class="fileListBtnmydevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
	<?php } ?>
	<?php if($data['ODBRestore'] == 'true'){ ?>	
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'onedriveBkpEnabled'} == 'true'){?>
        		<li ng-if="value.icon == 'cloud'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
		<?php if($data['userDetails']->{'is-active'} == 'true' && $data['userDetails']->{'exchangeBkpEnabled'} == 'true'){?>
        		<li ng-if="value.icon == 'envelope'"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
		<?php } ?>
	<?php } ?>							

<?php } ?>-->
<!--exp end-->
<!--exp new start-->
<?php if($data['loggedInUser']['admin'] == true || $data['loggedInUser']['readOnlyAdmin'] == true){ ?>
    <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
            <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
    <?php }else{ ?>
            <?php if($data['showButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreGS'] == 'true'){ ?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } else { ?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
            <?php } ?>
            <?php if($data['showBackupButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreBP'] == 'true'){ ?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } else { ?>
                        <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
            <?php } ?>
            <?php if($data['showOnedriveButtons'] == 'true'){?>
                <?php if($data['allowEndUserTocontrolRestoreBP'] == 'true'){ ?>
                	<li ng-if="value.icon == 'cloud'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" ng-show="value.canAdminRestore == true" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li ng-show="value.canAdminRestore == true"><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } else { ?>
                        <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
                        <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
                        <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
                <?php } ?>
            <?php } ?>
    <?php } ?>
<?php }else{ ?>
            <li ng-if="value.icon != 'cloud' && value.icon != 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;" ><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'cloud'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('files_list', 'keywords');?></a></li>
            <li ng-if="value.icon == 'envelope'" class="fileListBtnassigndevice{{$index}}"><a ng-click="viewDeviceDetailsFileList(value.deviceUUID, value.deviceType, value.icon, value.userName, value.blocked)" href="javascript:;"><?=Language::show('List Emails', 'keywords');?></a></li>
            <li><a ng-click="sendMeTo('<?=Url::basePath("backup/restore")?>/'+value.deviceUUID+'/'+value.deviceType+'/'+value.icon+'/'+value.deviceName+'/<?=base64_encode($data['userDetails']->{'user-name'})?>/'+value.blocked)" href="javascript:;">Restore</a></li>
<?php } ?>
<!--exp new end-->							
<li><a href="<?=Url::basePath('user/backupHistory/{{ value.userName }}/{{ value.deviceUUID }}/{{value.deviceName}}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>
<?php if($data['userDetails']->{'is-active'} == 'true' && ($data['userDetails']->{'backup-enabled'} == 'true' || $data['userDetails']->{'onedriveBkpEnabled'} == 'true' || $data['userDetails']->{'exchangeBkpEnabled'} == 'true')){?>
	<!--<li><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>-->
        <?php if($data['showBackupSettingsForBackupDevice'] == 'true'){?>
        	<li ng-if="value.icon != 'cloud' && value.icon != 'envelope'"><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
        <?php } ?>
        	<li ng-if="value.icon == 'cloud'"><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
        	<li ng-if="value.icon == 'envelope'"><a href="<?=Url::basePath('user/device/policyInfo/{{ value.userName }}/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>							
<?php } ?>
                                                </ul>
   <a class="pull-right eye" ng-click="viewDeviceDetails($index, value.deviceUUID,'assigndevice', value.deviceType)" href="javascript:;"><i class="fa fa-eye"></i></a>
                                            </div>
                                            <div class="panel-body widget widget-body">
                      <i ng-click="viewDeviceDetails($index, value.deviceUUID,'assigndevice', value.deviceType)" class="clickAble fa fa-{{ value.icon }}"></i>
          <a style="font-size: 18px;margin-top: -10px; margin-right: 13px;" class="pull-right" ng-cloak>{{ value.storageUsedByDevice }}*</a>
              <div class="row expandDetailsassigndevice{{$index}} col-lg-12" style="font-size: 10px; color: #FFFFFF; display: none;">
<?php if(!isMobile()){ ?>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <?php }else{ ?>
                                                    <div class="col-lg-12" style="padding: 30px 10px 10px 35px;">
                                                    <?php } ?>
                                                        <p>Last Successful Backup:
                               					<b class="pull-right" ng-if="deviceDetails.lastSuccessBackup == null" ng-cloak>Not completed yet</b>
                     						<b class="pull-right" ng-if="deviceDetails.lastSuccessBackup != null" ng-cloak>{{deviceDetails.lastSuccessBackup}}</b>
                                                        </p>
                          				<p>Next Scheduled Backup:
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup != null" ng-cloak>{{deviceDetails.nextScheduledBackup}}</b>
                                                            <b class="pull-right" ng-if="deviceDetails.nextScheduledBackup == null" ng-cloak>-</b>
                                                        </p>
                                 			<p>Policy Refresh Frequency:
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh != null" ng-cloak>{{deviceDetails.nextPolicyRefresh}} hours</b>
                                                                <b class="pull-right" ng-if="deviceDetails.nextPolicyRefresh == null">-</b>
							</p>
                                                       <?php if($data['showLatestBkpInfo'] == true){?>
							<p>Total Size of Restorable Data(Latest Version): <b class="pull-right" ng-cloak>{{deviceDetails.totalSizeOfDataInCurrentBackupLatestVersion}}</b></p>
                                                        <?php } ?>
                                                    <?php if(!isMobile()){ ?></div>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;"><?php } ?>
<p ng-if="deviceDetails.osType != 'ONEDRIVE'">Operating System: <b class="pull-right" ng-cloak>{{deviceDetails.osTypeDisplay.replace("(unknown)", "");}} {{deviceDetails.version}}</b></p>
<p ng-if="deviceDetails.osType != 'ONEDRIVE'">End Point Agent Version: <b class="pull-right" ng-cloak>{{deviceDetails.productVersion}}</b></p>
						    <p>Storage Media:
                                                                <b class="pull-right" ng-if="deviceDetails.storageMedia != null" ng-cloak>{{deviceDetails.storageMedia}}</b>
                                                                <b class="pull-right" ng-if="deviceDetails.storageMedia == null">-</b>
                                                    </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
</div>
</div>
<?php //} ?>
<!--new assign end-->
<?php if(DISABLE_BLUVAULT == false){ ?>
		<?php if($data['loggedInUser']['admin'] == true) { ?>
                        <div class="panel-footer">
                            <span class="help-block" style="color:black !important;">Note:- * size includes the sizes of earlier file versions</span>
</div>
		<?php } ?>
<?php } ?>
                    </div>
                </div>
            </div>
<!--modal--><?php if($data['popup'] == 'visible') { ?>
            <div class="modal fade" id="changePasswordForFirstlogin" role="dialog" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content">
      <?=
                        Form::open(array(
                            'ng-submit' => 'changePasswordForFirstlogin()',
                            'method' => 'post',
                            'id' => 'changePasswordForFirstlogin',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                    ?>
        <div class="modal-header">

          <h4 class="modal-title">Change Password</h4>
        </div>
        <div class="modal-body">

                        <div class="form-group">
                            <label for="passwordGuest">Password</label>
<?php if(complexPassword == true) { ?>
                                <input type="password" class="form-control" name="password" id="passwordFirstLogin" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                                                <?php } else { ?>
                                <input type="password" class="form-control" name="password" id="passwordFirstLogin" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
                                <?php } ?>
                        </div>
<div class="form-group">
                            <label for="rePasswordGuest">Re Type Password</label>
                            <input type="password" class="form-control" name="rePassword" id="rePasswordFirstLogin" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#passwordFirstLogin" data-parsley-trigger="change">
			</div>
<?php if(googleAuthenticator == true){ ?>
<center><div id="img">
                                <img src='<?php echo $qrCodeUrl; ?>' />
				</div></center>
<?php } ?>
        </div>
	<div class="modal-footer">
<?php if(googleAuthenticator == true){ ?>
	  <p style="float: left;">Note: This user account has been enabled for multi-factor authentication.  Please use an authenticator app on your smartphone to scan this QR code and generate a one-time key.</p>
<?php } else { ?>
	<p style="float: left;">Note: Please change password to proceed further.</p>
<?php } ?>
          <!--<a class="btn btn-default" type="button" href="<?=URL::basePath('logout')?>">Cancel</a>-->
	  <?php if(googleAuthenticator == true){ ?>
		<a id="changePasswordBtnGuest" ng-bootbox-confirm="<h4>You may use Microsoft or Google Authenticator to set up Multi-Factor Authentication (MFA) using the QR code displayed here on this screen.  If you have not done so yet, please click Cancel and set up MFA first.</h4>"
                                       ng-bootbox-confirm-action="changePasswordForFirstlogin()"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-primary"> <?=Language::show('save', 'keywords');?></a>
	  <?php } else { ?>
          	<button type="submit" id="changePasswordBtnGuest" class="btn btn-primary"><?=Language::show('save', 'keywords');?></button>
	  <?php } ?>
        </div>
        <?=
                        Form::close();
                    ?>
      </div>

    </div>
  </div>
  <?php } ?>
	    <!--modal-->
<?php if(googleAuthenticator == true){ ?>
<!--modal qr code starts-->
  <div class="modal fade" id="myQR" role="dialog" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
          	<h4 class="modal-title">My QR Code</h4>
        </div>
        <div class="modal-body">
		<center>
			<div id="img">
				<img src='<?php echo $qrCodeUrl; ?>' />
                        </div>
		</center>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
        </div>
      </div>
    </div>
  </div>
<!--modal my qr code ends-->
<?php } ?>
			
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>	    
<script type="text/javascript">
   <?php if($data['popup'] == 'visible') { ?>
$('#changePasswordForFirstlogin').modal('show');
    <?php } ?>
</script>	    
