<?php

use \Core\View;
use \Helpers\Url;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="">
                    <div class="">
                        <ul id="connectorTabs" class="nav nav-tabs" role="tablist">
                            <li role="presentation"><a href="#googleDrive" id="home-tab" role="tab" aria-controls="home" aria-expanded="true">Google Drive</a></li>
<!--                            <li role="presentation"><a href="#ODC" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">One Drive for Consumer</a></li>-->
                            <li role="presentation" class="active"><a href="#ODB" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">One Drive Business</a></li>
                        </ul>
                        <div id="connectorTabsContent" class="tab-content">
                            <div role="tabpanel" class="tab-pane fade in" id="googleDrive" aria-labelledby="home-tab">
                                <div class="panel">
                                    <div class="panel-heading"><h4>Google Drive Connection Settings</h4></div>
                                    <div class="panel-body">
                                        <form class="googleConfiguration" ng-submit="saveGoogleConfiguration()" data-parsley-validate>
                                            <input type="text" class="hide" hidden value="<?=$data["configId"]?>" name="configId" />
                                            <div class="form-group col-lg-6">
                                                <label for="clientId">Client ID</label>
                                                <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter your Client Id" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created a google app.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientSecret">Client Secret</label>
                                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter your Secret Key" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created a google app.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientRedirectURI">Client Redirect URI</label>
                                                <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="<?=$data["clientRedirectURI"]?>" placeholder="Enter your Redirect Uri" required autocomplete="off" readonly>
                                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientResourceURL">Client Resource URL</label>
                                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=$data["clientResourceURL"]?>" placeholder="Enter your client Resource URL" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com</span>
                                            </div>
                                            <div class="form-group col-lg-12">
                                                <label for="portalURL">Portal URL</label>
                                                <input type="text" class="form-control" name="portalURL" id="portalURL" value="<?=$data["portalURL"]?>" placeholder="Enter your Portal URL" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                                <br/><br/>
                                                <button type="submit" class="btn btn-success pull-right">Save</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div role="tabpanel" class="tab-pane fade in" id="ODC" aria-labelledby="home-tab">
                                <div class="panel">
                                    <div class="panel-heading"><h4>One Drive consumer Connection Settings</h4></div>
                                    <div class="panel-body">
                                        <form class="odcConfiguration" ng-submit="saveOdcConfiguration()" data-parsley-validate>
                                            <div class="form-group col-lg-6">
                                                <label for="ClientId">Client ID</label>
                                                <input type="text" class="form-control" name="ClientId" id="ClientId" value="<?=ODFC_CLIENT_ID?>" placeholder="Enter your Client Id" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created an one drive Consumer app.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientSecret">Client Secret</label>
                                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=ODFC_SECRET_KEY?>" placeholder="Enter your Secret Key" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created a one drive Consumer app.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientRedirectURI">Client Redirect URI</label>
                                                <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="<?=ODFC_REDIRECT_URI?>" placeholder="Enter your Redirect Uri" required autocomplete="off" readonly>
                                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientResourceURL">Client Resource URL</label>
                                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=ODFC_RESOURCE_URI?>" placeholder="Enter your client Resource URL" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your share point app URL)</span>
                                            </div>
                                            <div class="form-group col-lg-12">
                                                <label for="portalURL">Portal URL</label>
                                                <input type="text" class="form-control" name="portalURL" id="portalURL" value="<?=\Helpers\Url::basePath();?>" placeholder="Enter your Portal URL" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                                <br/><br/>
                                                <button type="submit" class="btn btn-success pull-right">Save</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div role="tabpanel" class="tab-pane active fade in" id="ODB" aria-labelledby="home-tab">
                                <div class="panel">
                                    <div class="panel-heading"><h4>One Drive For Business Connection Settings</h4></div>
                                    <div class="panel-body">
                                        <form class="odbConfiguration" ng-submit="saveOdbConfiguration()" data-parsley-validate>
                                            <input type="text" class="hide" hidden value="<?=$data["configId"]?>" name="configId" />
                                            <div class="form-group col-lg-6">
                                                <label for="ClientId">Client ID</label>
                                                <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter your Client Id" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created a One Drive Business app.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientSecret">Client Secret</label>
                                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter your Secret Key" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created a One Drive Business app.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientRedirectURI">Client Redirect URI</label>
                                                <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="<?=$data["clientRedirectURI"]?>" placeholder="Enter your Redirect Uri" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientResourceURL">Client Resource URL</label>
                                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=$data["clientResourceURL"]?>" placeholder="Enter your client Resource URL" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your share point app URL)</span>
                                            </div>
                                            <div class="form-group col-lg-12">
                                                <label for="portalURL">Portal URL</label>
                                                <input type="text" class="form-control" name="portalURL" id="portalURL" value="<?=$data["portalURL"]?>" placeholder="Enter your Portal URL" required autocomplete="off">
                                                <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                                <br/><br/>
                                                <button type="submit" class="btn btn-success pull-right">Save</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                    <?php if($data['userDetails']->{'backup-enabled'} == "true" || $data['userDetails']->{'sync-enabled'} == "true"){?>
                                        <?php if($data['userDetails']->{'externalstorage-authorized'}=="true") { ?>
                                            <div class="panel">
                                                <div class="panel-heading"><h4>Select Storage Space</h4></div>
                                                <div class="panel-body">
                                                    <div class="form-group col-lg-12">
                                                        <div class="well well-lg">
                                                            <p>
                                                                <a href="javascript:;" class="btn btn-default"><i class="fa fa-database"></i> Local Storage</a>
                                                                - Your cloud does not support this feature
                                                            </p>
                                                            <p>
                                                                <a href="javascript:;" class="btn btn-default"><i class="fa fa-cloud"></i> Parablu Hosted Storage</a>
                                                                - Parablu Cloud Storage is your default selected storage space. Please select other storage space.
                                                            </p>
                                                            <?php
                                                            $GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
                                                            ?>
                                                            <p>
                                                                <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                                                - Google Drive Storage space
                                                            </p>
                                                            <?php
                                                            $MODCUrl = ODFC_REDIRECT_URI."?client_id=".ODFC_CLIENT_ID."&response_type=code&redirect_uri=".\Helpers\Url::basePath(ODFC_RESOURCE_URI.'/')."&state=".$data['loggedInUser']['userName'];
                                                            ?>
                                                            <p>
                                                                <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODCUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive</a>
                                                                - Microsoft OneDrive Consumer Storage Space
                                                            </p>
                                                            <?php
                                                            $params = "?resource=".ODFB_RESOURCE_URI."&client_id=".ODFB_CLIENT_ID."&response_type=code&redirect_uri=".ODFB_REDIRECT_URI."&state=".$data['loggedInUser']['userName'];
                                                            $MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                            ?>
                                                            <p>
                                                                <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                                - Microsoft OneDrive for business Storage Space
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
