<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('devices')?>"><h3><?=$data['title']?></h3></a></li>
                <li><span>Manage devices in bulk</span></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php //View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="DeviceController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('Block Multiple Devices', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="form-group d-none">
                        <label for="blockDevices"><?=Language::show('devices', 'keywords');?></label><br/>
                        <!--<select class="blockDevices" name="blockDevices[]" style="width: 100%;" id="blockDevices" multiple="multiple" required></select>-->
                        <input type="text" data-role="tagsinput" value="" class=" form-control blockDevices" name="blockDevices[]" id="blockDevices" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('deviceId', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <a ng-click="blockMultipleDevices(true)" class="block btn btn-danger" disabled><i class="fa fa-lock"></i> Block</a>
                        <a href="javascript:;" class="btn btn-default" ngf-select="readUserNamesFromExcel($files)" <?php if(isMobile()){ ?> disabled <?php } ?>><i class="share-icon fa fa-upload"> Import Device ID's from Excel</i></a>
                        <a class="btn btn-default" href="<?=Url::basePath('devices')?>" <?php if(isMobile()){ ?>style="margin-top: 5px;" <?php }?>><i class="fa fa-times"></i> Cancel</a>
                    </div>
                    <a href="" ng-click="downloadSample('common')" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
                    </br>
                    <?php if(isMobile()){ ?>
                        <span class="help-line text-muted">Note:- Bulk Import feature is available from your workstation.</span>
                    <?php } ?>
                    <div class="row">
                            <div class="col-lg-12">
                                
                            </div>
                    </div>
                    <div class="form-group d-none">
                                <label for="userNames"><?=Language::show('userId', 'keywords');?></label><br/>
                                <input type="text" data-role="tagsinput" value="" class="form-control" name="userNames[]" id="userNames" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userId', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="row blockdevices" style="display: none;">
                
                    <div class="panel-heading">
                        <h3>
                            Block Devices -
                            <a id="blockDump" ng-click="downloadSample('downloadDump')" class="btn btn-success btn-small pull-right" style="display:none;">Download List</a>
                            <span id="blockStatement" style="color: #f55753;font-size: 0.7em !important;"></span>
                        </h3>
                    </div>
                    <div class="panel-body blockDevicesPanel col-lg-12" style="display:none;">
                        <table class="table table-bordered table-responsive">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" class="select-all checkbox" name="select-all" checked/>
                                    </th>
                                    <th><?=Language::show('username', 'keywords')?></th>
                                    <th><?=Language::show('deviceName', 'keywords')?></th>
                                    <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in deviceList track by $index">
                                    <td ng-class="{disablee:'invalid'}[value.flag]">
                                        <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.deviceUUID }}" ng-checked="value.status == 'ACTIVE' || value.status == 'DECOUPLED'" ng-disabled="value.status == 'BLOCKED'|| value.status == 'DELETED'|| value.status == 'INVALID' || value.status == 'User or Device does not exist or invalid'"/>
                                    </td>
                                    <td ng-class="{disablee:'invalid'}[value.flag]" ng-cloak>{{ value.userName }}</td>
                                    <td ng-class="{disablee:'invalid'}[value.flag]" ng-cloak>{{ value.deviceName }}</td>
                                    <!--<td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{ value.emailId }}</td>
                                    <td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{value.time}}</td>-->
                                    <td class="text-center" ng-class="{disablee:'invalid'}[value.flag]" ng-cloak>
                                        <h5><label class="badge badge-success" ng-if="value.status == 'ACTIVE'"><?=Language::show('active', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'BLOCKED' || value.isBlocked == 'Yes'"><?=Language::show('blocked', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'DECOUPLED'"><?=Language::show('decoupled', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'DELETED'"><?=Language::show('deleted', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'INVALID' || value.status == 'User or Device does not exist or invalid'"><?=Language::show('Device not found', 'keywords')?></label></h5>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                
            </div>
                </div>
            </div>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('UnBlock Multiple Devices', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="form-group d-none">
                        <!--<label for="unBlockDevices"><?=Language::show('devices', 'keywords');?></label><br/>-->
                        <!--<select class="unBlockDevices" name="unBlockDevices[]" style="width: 100%;" id="unBlockDevices" multiple="multiple" required></select>-->
                        <input type="text" data-role="tagsinput" value="" class=" form-control unBlockDevices" name="unBlockDevices[]" id="unBlockDevices" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('deviceId', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <a ng-click="blockMultipleDevices(false)" class="unBlock btn btn-success" disabled><i class="fa fa-unlock"></i> UnBlock</a>
                        <a ng-click="deleteMultipleDevices()" class="deleteBTN btn btn-danger" disabled><i class="fa fa-trash"></i> Delete</a>
                        <a href="javascript:;" class="btn btn-default" ngf-select="readUserNamesFromExcel1($files)" <?php if(isMobile()){ ?>style="margin-top: 5px;" <?php }?> <?php if(isMobile()){ ?> disabled <?php } ?>><i class="share-icon fa fa-upload"> Import Device ID's from Excel</i></a>
                        <a class="btn btn-default" href="<?=Url::basePath('devices')?>" <?php if(isMobile()){ ?>style="margin-top: 5px;" <?php }?>><i class="fa fa-times"></i> Cancel</a>
                    </div>
                    <a href="" ng-click="downloadSample('common')" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
                    </br>
                    <?php if(isMobile()){ ?>
                        <span class="help-line text-muted">Note:- Bulk Import feature is available from your workstation.</span>
                    <?php } ?>
                    <div class="row">
                            <div class="col-lg-12">
                                
                            </div>
                    </div>
                    <div class="row unblockdeletedevices col-lg-12" style="display: none;">
                
                    <div class="panel-heading">
                        <h3>
                            Unblock/Delete Devices -
                            <!--<span id="selected_users" style="color: #f55753;font-size: 0.9em;"></span>
                            <a ng-click="startMigrating()" class="btn btn-success btn-small pull-right">Start Migrating Users</a>
                            <button id="selected" class="btn button-default">GetSelected</button>-->
                            <a id="unblockDump" ng-click="downloadSample('downloadDump')" class="btn btn-success btn-small pull-right" style="display:none;">Download List</a>
                            <span id="unblockStatement" style="color: #f55753;font-size: 0.7em !important;"></span>
                        </h3>
                    </div>
                    <div class="panel-body unblockDevicesPanel col-lg-12" style="display:none;">
                        <table class="table table-bordered table-responsive">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" class="select-all checkbox" name="select-all" checked/>
                                    </th>
                                    <th><?=Language::show('username', 'keywords')?></th>
                                    <th><?=Language::show('deviceName', 'keywords')?></th>
                                    <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in unblockList track by $index">
                                    <td ng-class="{disablee:'invalid'}[value.flag]">
                                        <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.deviceUUID }}" ng-checked="value.status == 'BLOCKED' " ng-disabled="value.status == 'ACTIVE' || value.status == 'DELETED' || value.status == 'DECOUPLED'|| value.status == 'INVALID' || value.status == 'User or Device does not exist or invalid' || value.status == 'Device Assigned'"/>
                                    </td>
                                    <td ng-class="{disablee:'invalid'}[value.flag]" ng-cloak>{{ value.userName }}</td>
                                    <td ng-class="{disablee:'invalid'}[value.flag]" ng-cloak>{{ value.deviceName }}</td>
                                    <!--<td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{ value.emailId }}</td>
                                    <td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{value.time}}</td>-->
                                    <td class="text-center" ng-class="{disablee:'invalid'}[value.flag]" ng-cloak>
                                        <h5><label class="badge badge-success" ng-if="value.status == 'ACTIVE'"><?=Language::show('active', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'BLOCKED'"><?=Language::show('blocked', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'DECOUPLED'"><?=Language::show('decoupled', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'DELETED'"><?=Language::show('deleted', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'INVALID' || value.status == 'User or Device does not exist or invalid'"><?=Language::show('Device not found', 'keywords')?></label></h5>
                                        <h5><label class="badge badge-danger" ng-if="value.status == 'Device Assigned'"><?=Language::show('Device Assigned', 'keywords')?></label></h5>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                
            </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/DeviceController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    /*$('.blockDevices').select2({
        ajax: {
            url: "<?=DIR?>"+"device/getAllUnBlockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceUUID, text: o.deviceName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Device'
    });

    $('.unBlockDevices').select2({
        ajax: {
            url: "<?=DIR?>"+"device/getAllBlockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceUUID, text: o.deviceName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }*/
</script>
<script>
    $(function(){

        //button select all or cancel
        $("#select-all").click(function () {
            var all = $("input.select-all")[0];
            all.checked = !all.checked;
            var checked = all.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
        });

        //button select invert
        $("#select-invert").click(function () {
            $("input.select-item").each(function (index,item) {
                item.checked = !item.checked;
            });
            checkSelected();
        });

        //button get selected info
        $("#selected").click(function () {
            var items=[];
            $("input.select-item:checked:checked").each(function (index,item) {
                items[index] = item.value;
            });
            if (items.length < 1) {
                //document.getElementById("selected_users").innerHTML = "";
            }else {
                var values = items.join();
                console.log("items"+items);
                console.log(values);
                //var html = $("<div></div>");
                //document.getElementById("selected_users").innerHTML = arr;
                //html.html("selected:"+values);
                //html.appendTo("body");
            }
        });

        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
        });

        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            console.log(checked);
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        }
    });
</script>
<style>
    .invalid{
        background-color: gainsboro !important;
        cursor:not-allowed !important;
    }
</style>
