<?php

use Helpers\Assets;
use Helpers\Url;
use Helpers\Hooks;
use Core\Language;
use Helpers\Form;
//initialise hooks
$hooks = Hooks::get();
?>

<div class="container">
    <div class="row">
        <div class="col-lg-6 col-lg-offset-3" align="center" style="margin-top: -25px;">
            <?php
            Assets::img(array(
                Url::templatePath() . 'images/logo_new.png',
            ));
            ?>
            <br/><a>The Cloud you can trust</a>
        </div>
    </div>
    <br/><br/><br/>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default no-box-shadow" style="padding: 10px;">
                <div class="panel-heading text-center">
                    <a><b class="h3"><?=$data['title'];?></b> - <?=$data['indexPage_message']?></a>
                </div>
                <div class="panel-body">
                    <div class="row col-lg-12">
                        <div class="alert alert-danger alert-dismissible fade in hide" role="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                            <strong>Error!!!</strong> <span class="resultMessage"></span>
                        </div>
                    </div>
                    <form id="cloudCreateForm" data-parsley-validate>
                        <br/>
                        <div class="form-group">
                            <label for="cloudName"><?=Language::show('cloudNameLabel', 'amazon');?></label>
                            <input type="text" name="cloudName" class="form-control cloudName" data-parsley-trigger="keyup" data-parsley-cloudName placeholder="Enter a Cloud Name" required data-parsley-remote data-parsley-remote-validator='checkCloudName' data-parsley-remote-options='{ "type": "POST" }' data-parsley-remote-message="Selected cloud name has already been taken" data-parsley-pattern="/^[0-9a-zA-Z_-\s]+$/" data-parsley-pattern-message="Cloud Name should only contain letters, numbers and characters such as '-', '_'" data-parsley-minlength="3" data-parsley-maxlength="40" />
                            <span class="help-block"><?=Language::show('cloudNameHelp', 'amazon');?></span>
                        </div>
                        <div class="form-group">
                            <label for="email"><?=Language::show('emailAddress', 'amazon');?></label>
                            <input type="email" class="form-control email" name="email" id="email" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('emailAddress', 'keywords');?>" required autocomplete="off">
                            <span class="help-block"><?=Language::show('emailAddressHelp', 'amazon');?></span>
                        </div>
                        <button type="submit" id="create" class="create btn btn-primary pull-right"><?=Language::show('Create', 'keywords');?></button>
                    </form>
                    <form id="userCreateForm" class="hide" data-parsley-validate>
                        <br/>
                        <div class="form-group">
                            <label for="userName">User Name <span style="color: red;">*</span></label>
                            <div class="row">
                                <div class="col-lg-12">
                                    <input type="text" name="userName" class="form-control" data-parsley-trigger="keyup" data-parsley-pattern="/^[a-zA-Z\s]+$/" data-parsley-pattern-message="Username should only contain letters" placeholder="Enter your user name" required />
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="password">Enter your Password <span style="color: red;">*</span></label>
                            <div class="row">
                                <div class="col-lg-12">
                                    <input type="password" name="password" class="form-control password" data-parsley-checkPassword data-parsley-trigger="keyup" placeholder="Enter a password" required />
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rePassword">Re-Enter your Password <span style="color: red;">*</span></label>
                            <div class="row">
                                <div class="col-lg-12">
                                    <input type="password" name="rePassword" class="form-control" data-parsley-trigger="keyup" placeholder="Re Enter your password" data-parsley-equalto=".password" required />
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="saveUser btn btn-primary pull-right"><?=Language::show('Save User', 'keywords');?></button>
                    </form>
                    <div id="creationSuccess" class="text-center h4 hide">
                        <p>Congratulations.  Your ParaBlu Cloud is configured and you are good to go.</p>

                        <p>Before accessing the cloud we would like you to go through the settings and if required you can change and update the same. <a href="<?=DIR?>">Click here to go through the settings.</a></p>

                        <p>To access the cloud, <a href="<?=DIR?>">click here</a></p>

                        <p>Getting Started Guide can be accessed here.</p>

                        Support Desk Link: <a href="https://support.parablu.com">https://support.parablu.com</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript Plugins
================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<?php

/**
 * Core Javascript Files will be loaded for everypage
 */

Assets::js(array(
    Url::templatePath() . 'js/plugins/jquery-1.9.1.js',
    Url::templatePath() . 'js/plugins/jquery-2.1.4.min.js',
    Url::templatePath() . 'js/plugins/jquery-ui.js',
    Url::templatePath() . 'js/plugins/parsley.min.js',
    Url::templatePath() . 'js/plugins/bootstrap.min.js',
    Url::templatePath() . 'js/plugins/nprogress.js',
    Url::templatePath() . 'js/plugins/ie10-viewport-bug-workaround.js',
    Url::templatePath() . 'js/plugins/parsley.remote.min.js',
));

/**
 * Core Javascript Files will be loaded for only selected pages
 */

Assets::js(array(
    Url::templatePath() . 'js/login-scripts.js?'.VERSIONS_NUMBER
));

//hook for plugging in javascript
$hooks->run('js');

//hook for plugging in code into the footer
$hooks->run('footer');
?>

<script type="text/javascript">
    window.ParsleyValidator
        .addValidator('checkPassword', function (value) {
            var re = /^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#.$%^&*])[a-zA-Z0-9!@#.$%^&*]{6,}$/;
            return re.test(value);
        }, 32)
        .addMessage('en', 'checkPassword', 'Password should contain at-least one uppercase letter, one number, one special character and should be 6 characters long');
</script>

<script type="text/javascript">
    var html = $('.create').html();
    $('.cloudName').on('keyup', function(){
        if ( $(this).parsley().isValid() ) {
            $('.create').attr('disabled','disabled');
            $('.create').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        }
    });
    $('.cloudName').parsley()
        .addAsyncValidator('checkCloudName', function (xhr) {
            $('.create').removeAttr('disabled');
            $('.create').html(html);
            if(xhr.status == 200){
                $('.loadingImg').addClass("hide");
                return true;
            }else{
                $('.loadingImg').addClass("hide");
                return false;
            }
        }, '<?=DIR?>checkCloudName');
</script>
<script>

    $('#cloudCreateForm').on('submit', function(e){
        e.preventDefault();
        if ( $(this).parsley().isValid() && $(".cloudName").hasClass("parsley-error") == false ) {
            $.post("<?=DIR?>amazon/create", $(this).serialize(), function(data){
                $('.create').removeAttr('disabled');
                $('.create').html(html);
                var jData = jQuery.parseJSON(data);
                if(jData.result == 'success') {
                    $('#cloudCreateForm').addClass("hide");
                    $('#userCreateForm').removeClass("hide");
                    $('.introMessage').html("User Creation, &nbsp;");
                }else{
                    $('.alert').removeClass('hide');
                    $('.resultMessage').html(jData.message);
                    $('.fromSubmitLoading').addClass("hide");
                }
            });
        }
    });

    $('#userCreateForm').on('submit', function(e){
        e.preventDefault();
        var html = $('.saveUser').html();
        $('.saveUser').prop('disabled', 'disabled');
        $('.saveUser').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var cloudName = $('.cloudName').val();
        var email = $('.email').val();
        var formData = $(this).serialize() + "&email=" + email;
        if ( $(this).parsley().isValid() ) {
            $.post("<?=DIR?>amazon/saveUser", formData, function(data){
                $('.saveUser').removeAttr('disabled');
                $('.saveUser').html(html);
                var jData = jQuery.parseJSON(data);
                console.log(jData);
                if(jData.result == 'success') {
                    $('#cloudCreateForm').addClass("hide");
                    $('#userCreateForm').addClass("hide");
                    $('#creationSuccess').removeClass("hide");
                    $('.introMessage').empty();
                }else{
                    $('.alert').removeClass('hide');
                    $('.resultMessage').html(jData.message);
                    $('.fromSubmitLoading').addClass("hide");
                }
            });
        }
    });

</script>

<!-- FOR EVERY PAGE THE BELOW CODE SHOULD BE ADDED -->
<script>
    NProgress.start();
    var interval = setInterval(function() { NProgress.inc(); }, 1000);
    $(window).load(function () {
        clearInterval(interval);
        NProgress.done();
    });
    $(window).unload(function () {
        NProgress.start();
    });
    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    })
</script>

</body>
</html>