<?php

    use Helpers\Assets;
    use Helpers\Url;
    use Helpers\Hooks;

    //initialise hooks
    $hooks = Hooks::get();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="<?=Url::templatePath()?>images/favicon.ico">
    <?php
        $hooks->run('meta');
    ?>
    <title><?php echo $data['title'].' - '.SITETITLE; ?></title>

    <!-- CSS -->
    <?php
        Assets::css(array(
            /* Core CSS */
	    Url::templatePath() . 'css/plugins/font-awesome_latest.min.css',	
	    Url::templatePath() . 'css/plugins/bootstrap.css',
            Url::templatePath() . 'css/plugins/jquery-ui.css',
            Url::templatePath() . 'css/plugins/nprogress.css',
            Url::templatePath() . 'css/plugins/switchery.min.css',

            /* Custom styles for this template */
            Url::templatePath() . 'css/style.css?'.VERSIONS_NUMBER,
            Url::templatePath() . 'css/plugins/search.css?'.VERSIONS_NUMBER,
        ));

        $hooks->run('css');
    ?>

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
        <script src="<?php echo Url::templatePath(); ?>/js/plugins/html5shiv.min.js"></script>
        <script src="<?php echo Url::templatePath(); ?>/js/plugins/respond.min.js"></script>
    <![endif]-->
</head>

<body>

<?php
    $hooks->run('afterBody');
    function isMobile() {
    return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
}
?>
