<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Pms;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class PmsController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('pms');
        $this->_model = new Pms();
        //$this->verifyAndCleanItUp();
    }
	
    public function validateData($value){
        if(preg_match('/([{}<>;:=]+)(*)/',$value)){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($response);
                        exit;
                }
    }

    public function pms(){
        Auth::allowOnly('readOnlyAdmin');
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'pms',
            //'onedriveBkpEnabled' => $onedriveBkpEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	$data['activeTabB'] = '';
	$data['activeTabS'] = '';
	$data['activeTabO'] = '';

	if(Auth::checkCloudPermission('backup') == true){
        	$data['activeTabB'] = 'active';
	}else if(Auth::checkCloudPermission('backup') == false){
        	if(Auth::checkCloudPermission('sync') == true){
                	$data['activeTabS'] = 'active';
        	}else{
                	$data['activeTabO'] = 'active';
        	}
	}

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/pms', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function getGlobalExclusions(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
	    $globalResult = $this->_model->getGlobalExclusion($headers);
            switch ($globalResult['status']) {
                case (200):
                    $ff = [];
                    $oo = [];
		    $exchange = [];
                    $combined = [];
                    foreach($globalResult['body']->{'globalExcludedFoldersElement'}->{'globalExcludedFoldersList'}->{'win'} as $key){
                        $ff = array_merge(array($key), $ff);
                    }
                    foreach($globalResult['body']->{'globalExcludedFoldersElement'}->{'globalExcludedFoldersList'}->{'mac'} as $key){
                        $oo = array_merge(array($key), $oo);
                    }
		    foreach($globalResult['body']->{'globalExcludedFoldersElement'}->{'globalExcludedFoldersList'}->{'exchange'} as $key){
                        $exchange = array_merge(array($key), $exchange);
                    }
                    $response = array(
                            'result' => 'success',
                            'filters' => $ff,
                            'globalmac' => $oo,
			    'exchange' => $exchange
                            );
                    echo json_encode($response);
                                        exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
                echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function schedules(){
        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('schedules'),
            'active' => 'pms',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/schedule/view', $data);
        View::renderTemplate('footer', $data);
    }

    public function getSchedules(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getSchedules($headers);
            switch ($result['status']) {
                case (200):
                    $schedules = [];

                    if($result['body']->{'scheduleElementList'}){
                        foreach($result['body']->{'scheduleElementList'} as $value){
                            $schedule = array(
                                'time' => (string)$value->{'time'},
                                'timeZone' => (string)$value->{'timeZone'},
                                'scheduleName' => (string)$value->{'scheduleName'},
                                'daysArray' => (array)$value->{'dayArray'},
                                'backupType' => (string)$value->{'backupType'},
                                'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                            );
                            $schedules = array_merge(array($schedule), $schedules);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'schedules' => $schedules
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getSchedule(){
	    $this->log("---------->".json_encode($_POST['scheduleNames']),"info");
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
                'schedules' => implode(',', $_POST['scheduleNames'])
            );
            $result = $this->_model->getSchedule($headers);
            switch ($result['status']) {
                case (200):
                    $schedules = [];

                    if($result['body']->{'scheduleElementList'}){
                        foreach($result['body']->{'scheduleElementList'} as $value){
                            $schedule = array(
                                'time' => (string)$value->{'time'},
                                'timeZone' => (string)$value->{'timeZone'},
                                'scheduleName' => (string)$value->{'scheduleName'},
                                'daysArray' => (array)$value->{'dayArray'},
                                'backupType' => (string)$value->{'backupType'},
                                'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                            );
                            $schedules = array_merge(array($schedule), $schedules);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'schedules' => $schedules
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function getParticularSchedule(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $this->log("SCHEDULENAME : ".$_POST['scheduleName'],"info");
            $result = $this->_model->getParticularSchedule($headers, $_POST['scheduleName']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'schedules' => (array)$result['body']->{'scheduleElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function createSchedule(){
        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('schedule'),
            'crumb2' => $this->language->get('create'),
            'active' => 'pms',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/schedule/create', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveSchedule(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'scheduleName'       => 'required',
                'scheduleStartTime'  => 'required',
                'days'               => 'required'
            );
            $filters = array(
                'scheduleName'       => 'trim|sanitize_string',
                'scheduleStartTime'  => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'scheduleName' => $_POST['scheduleName'],
                    'time' => $_POST['scheduleStartTime'],
                    'timeZone' => $_POST['scheduleTimeZone'],
                    'backupType' => $_POST['backupType'],
                    'dayArray' => $_POST['days']
                );
                $result = $this->_model->saveSchedule($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('scheduleSaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4061')
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function saveScheduleEdit(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'scheduleName'       => 'required',
                'scheduleStartTime'  => 'required',
                'days'               => 'required'
            );
            $filters = array(
                'scheduleName'       => 'trim|sanitize_string',
                'scheduleStartTime'  => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);
            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );
                $data = array(
                    'scheduleName' => $_POST['scheduleName'],
                    'time' => $_POST['scheduleStartTime'],
                    'timeZone' => $_POST['scheduleTimeZone'],
                    'backupType' => $_POST['backupType'],
                    'dayArray' => $_POST['days']
                );
                $result = $this->_model->saveScheduleEdit($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('scheduleSaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4061')
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function deleteSchedule(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'scheduleName' => $_POST['scheduleName']
            );
            $this->log("SCHEDULENAME : ".$_POST['scheduleName'],"info");
            $result = $this->_model->deleteSchedule($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'deleted successfully'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (412):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "Cannot delete schedule, already mapped to policy."
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getDaysString($numString){
        $numString = str_replace('1', Language::show('Sunday', 'keywords'), $numString);
        $numString = str_replace('2', Language::show('Monday', 'keywords'), $numString);
        $numString = str_replace('3', Language::show('Tuesday', 'keywords'), $numString);
        $numString = str_replace('4', Language::show('Wednesday', 'keywords'), $numString);
        $numString = str_replace('5', Language::show('Thursday', 'keywords'), $numString);
        $numString = str_replace('6', Language::show('Friday', 'keywords'), $numString);
        return str_replace('7', Language::show('Saturday', 'keywords'), $numString);
    }

    public function filters(){
        Auth::allowOnly('readOnlyAdmin');
        $filters = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $filtersResult = $this->_model->getCannedFilters($headers);
        $fil1 = [];
        foreach((array)$filtersResult['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($fil1);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('filters'),
            'active' => 'pms',
            'fil1' => $fil1,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/filter/view', $data);
        View::renderTemplate('footer', $data);
    }

    public function createFilter(){
        Auth::allowOnly('readOnlyAdmin');
        $filters = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $filtersResult = $this->_model->getCannedFilters($headers);
        $fil1 = [];
        foreach((array)$filtersResult['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }
        natcasesort($fil1);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('filters'),
            'crumb2' => $this->language->get('create'),
            'active' => 'pms',
            'fil1' => $fil1,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/filter/create', $data);
        View::renderTemplate('footer', $data);
    }
    
    //specially for policy create edit clone 
    public function getAllFilters(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getFilters($headers);
            switch ($result['status']) {
                case (200):
                    $filters = [];
                    $IncFilters = [];
                    $ExcFilters = [];

                    if($result['body']->{'inclusionFilterElementList'}){
                        foreach($result['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
                    $this->log("INCLUSION0000000000 : ".json_encode($IncFilters),"info");
                    $this->log("EXCLUSION1111111111 : ".json_encode($ExcFilters),"info");
                    $response = array(
                        'result' => 'success',
    //                    'filters' => $filters
                        'IncFilters' => $IncFilters,
                        'ExcFilters' => $ExcFilters 
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                    )
            );
        }
    }

    public function getFilters(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getFilters($headers);
            switch ($result['status']) {
                case (200):
                    $filters = [];

                    if($result['body']->{'inclusionFilterElementList'}){
                        foreach($result['body']->{'inclusionFilterElementList'} as $value){
                            $filter = array(
                                'filters' => (string)$value->{'filters'},
                                'filterName' => (string)$value->{'filterName'},
                                'filterType' => (string)$value->{'filterType'},
                                'filterArray' => (array)explode(',', (string)$value->{'filters'})
                            );
                            $filters = array_merge(array($filter), $filters);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'filters' => $filters
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function getFilterTemplate(){
$this->log("inside getfilterone11111".json_encode($_POST['filterName']),"info");
        //Auth::allowOnly('admin');
//        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'filters' => implode(',', $_POST['filterName'])
            );
$this->log("jjjjjjjjjjjjjjjjj : ".json_encode($headers),"info");
            $result = $this->_model->getFilterTemplate($headers);
            $this->log("jjjjjjjjjjjjjjjjj : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
                    $filters = [];
$endpointDisabledUiPreferences = [];
$items = array();
                    if($result['body']->{'filterTemplateElementList'}){
                        foreach($result['body']->{'filterTemplateElementList'} as $value){
//array_push($endpointUiPreferences,(string)$value->{'filters'});
 $items[] = (string)$value->{'extensionName'};
 $filter = array(
                                'filters' => (string)$value->{'extensionName'},
                                'filterName' => (string)$value->{'filterName'},
                                'filterType' => !empty($value->{'filterType'}) ? (string)$value->{'filterType'}: '',
                                /*'osType' => (string)$value->{'osType'},
				'filterArray' => (array)explode(',', (string)$value->{'filters'})*/
                                );
                            $filters = array_merge(array($filter), $filters);
}
                    }
$this->log("ggggggggggggg : ".json_encode($items),"info");
                    $response = array(
                        'result' => 'success',
//                        'filters' => (array)$result['body']->{'inclusionFilterElementList'}
                        'filters' => $filters,
'tags' => $items
                    );
                    echo json_encode($response);
                    exit;
                    case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                        );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

/*        }else{
            echo json_encode(array(
'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                    )
            );
        }*/
    }
    
    public function getFilterOne(){
        $this->log("inside getfilterone","info");
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'filters' => implode(',', $_POST['filterName'])
            );
            $this->log("jjjjjjjjjjjjjjjjj : ".json_encode($headers),"info");
            $result = $this->_model->getFilterOne($headers);
            $this->log("jjjjjjjjjjjjjjjjj : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
                    $filters = [];

                    if($result['body']->{'inclusionFilterElementList'}){
                        foreach($result['body']->{'inclusionFilterElementList'} as $value){
                            $filter = array(
                                'filters' => (string)$value->{'filters'},
                                'filterName' => (string)$value->{'filterName'},
                                'filterType' => (string)$value->{'filterType'},
//                                'osType' => (string)$value->{'osType'},
                                'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
                            $filters = array_merge(array($filter), $filters);
                        }
                    }

                    $response = array(
                        'result' => 'success',
//                        'filters' => (array)$result['body']->{'inclusionFilterElementList'}
                        'filters' => $filters
                    );
                    echo json_encode($response);
                    exit;
                    case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                    )
            );
        }
    }

    public function getFilter(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getFilter($headers, $_POST['filterName']);
            switch ($result['status']) {
                case (200):
                    $filters = [];

                    /*if($result['body']->{'inclusionFilterElementList'}){
                        foreach($result['body']->{'inclusionFilterElementList'} as $value){
                            $filter = array(
                                'filters' => (string)$value->{'filters'},
                                'filterName' => (string)$value->{'filterName'},
                                'filterType' => (string)$value->{'filterType'},
                                'filterArray' => (array)explode(',', (string)$value->{'filters'})
                            );
                            $filters = array_merge(array($filter), $filters);
                        }
		    }*/

                    $response = array(
                        'result' => 'success',
                        'filters' => (array)$result['body']->{'inclusionFilterElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function saveFilter(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'filterName'       => 'required'
            );
            $filters = array(
                'filterName'       => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'filterName' => $_POST['filterName'],
                    'filterType' => $_POST['filterType'],
                    //'filters' => implode(',', $_POST['filters'])
                    'filters' => $_POST['filtersNew']
                );
                $this->log('Data: '. json_encode($data), 'info');
                $result = $this->_model->saveFilter($headers, json_encode($data));
                $this->log('result: '. json_encode($result), 'info');
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('filterSaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4062')
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function saveFilterEdit(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'filterName'       => 'required'
            );
            $filters = array(
                'filterName'       => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'filterName' => $_POST['filterName'],
                    'filterType' => $_POST['filterType'],
                    //'filters' => implode(',', $_POST['filters'])
                    'filters' => $_POST['filtersNew']
                );
                $this->log('Data: '. json_encode($data), 'info');
                $result = $this->_model->saveFilterEdit($headers, json_encode($data));
                $this->log('result: '. json_encode($result), 'info');
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('filterSaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4062')
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function deleteFilter(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'filterName' => $_POST['filterName']
            );
            $this->log("filterName : ".$_POST['filterName'],"info");
            $result = $this->_model->deleteFilter($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'deleted successfully'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (412):
                    $result = array(
                        'result' => 'fail',
                        'msg' => "Cannot delete filter, already mapped to policy."
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function polices(){
        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => (Auth::checkCloudPermission('serverBackup') == "true") ? $this->language->get('sPolices') : $this->language->get('bPolices'),
            'active' => 'pms',
            'deactivateEdit' => $this->session->get('readOnlyAdmin') == true ? true : false,
            'deactivateEdit' => $this->session->get('readOnlyAdmin') == true ? true : false,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	if($this->session->get('isSQLBkpEnabled') == 'true'){
        	$data['isSQLBkpEnabled'] = 'true';
        }else{
        	$data['isSQLBkpEnabled'] = 'false';
	}
        $data['V'] = true;
        $data['ECD'] = true;
	$headers = array(
                'Content-Type'         => 'application/json',
                'token'         => $this->session->get('token')
            );
        $cloudProperties = $this->_model->getCloudProperties($headers);
        if($this->session->get('readOnlyAdmin')){            
            $policyEdit = $cloudProperties['body']->{'cloudPropertyElement'}->{'policyEdit'};
            if($policyEdit == true){
                $data['V'] = true;
                $data['ECD'] = true;
            }else{
                $data['V'] = true;
                $data['ECD'] = false;
            }
        }
	$searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$data['searchEnabled'] = $searchEnabled;
	$canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$data['canAdminRestoreAll'] = $canAdminRestoreAll;
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $data['canAdminDelete'] = $canAdminDelete;
	$showUserConsentFieldInPolicies = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserConsentFieldInPolicies'};
	$data['showUserConsentFieldInPolicies'] = $showUserConsentFieldInPolicies;
	$overridePolicySettings = $cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'};
	$data['overridePolicySettings']  = $overridePolicySettings;
	if($this->session->get('readOnlyAdminUser') == 'Yes'){
        	$data['readOnlyAdminUser'] = 'Yes';
	}else{
        	$data['readOnlyAdminUser'] = 'No';
	}
	$noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
	$data['noOfDevicesAllowed'] = $noOfDevicesAllowed;
	$passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
	$data['passwordChangeEnforce'] = $passwordChangeEnforce;
	$canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
	$data['canUserChangePassword'] =  $canUserChangePassword;
	$canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
	$data['canAdminChangeUserPassword'] = $canAdminChangeUserPassword;
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/policy/view', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function oneDrivePolices(){
        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Office 365 Policies',
            'active' => 'pms',
            'deactivateEdit' => $this->session->get('readOnlyAdmin') == true ? true : false,
            'deactivateEdit' => $this->session->get('readOnlyAdmin') == true ? true : false,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $data['V'] = true;
        $data['ECD'] = true;
	$headers = array(
                'Content-Type'         => 'application/json',
                'token'         => $this->session->get('token')
            );
        $cloudProperties = $this->_model->getCloudProperties($headers);
        if($this->session->get('readOnlyAdmin')){            
            $policyEdit = $cloudProperties['body']->{'cloudPropertyElement'}->{'policyEdit'};
            if($policyEdit == true){
                $data['V'] = true;
                $data['ECD'] = true;
            }else{
                $data['V'] = true;
                $data['ECD'] = false;
            }
        }
	    
	if($this->session->get('one_drive_backup_enabled') == "true"){
        	$data['onedriveBackupEnabled'] = 'true';
        }else{
                $data['onedriveBackupEnabled'] = 'false';
        }
        if($this->session->get('exchange_backup_enabled') == "true"){
                $data['exchangeBackupEnabled'] = 'true';
        }else{
                $data['exchangeBackupEnabled'] = 'false';
        }
	if($this->session->get('oneDriveArchivingEnabled') == "true"){
                $data['oneDriveArchivingEnabled'] = 'true';
        }else{
                $data['oneDriveArchivingEnabled'] = 'false';
        }
	if($this->session->get('mailArchivingEnabled') == "true"){
                $data['mailArchivingEnabled'] = 'true';
        }else{
                $data['mailArchivingEnabled'] = 'false';
        }
	$searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$data['searchEnabled'] = $searchEnabled;	 
	$canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$data['canAdminRestoreAll'] = $canAdminRestoreAll;
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $data['canAdminDelete'] = $canAdminDelete;
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/oneDrivePolicy/view', $data);
        View::renderTemplate('footer', $data);
    }
    
    /*public function getOneDrivePolicies(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true'
            );
            $result = $this->_model->getAllOneDrivePolicies($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];

                    foreach($result['body']->{'ODBBackupPolicyElementList'} as $value){
                        $policy = array(
                            'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                            'cpuUtilization' => (string)$value->{'cpuUtilization'},
                            'memoryUtilization' => (string)$value->{'memoryUtilization'},
                            'crawlLimit' => (string)$value->{'crawlLimit'},
                            'description' => (string)$value->{'description'},
                            'mappedUserCount' => (int)$value->{'mappedUserCount'},
                            'dcmEnabled' => (string)$value->{'dcmEnabled'},
                            'destination' => (string)$value->{'destination'},
                            //'filterInclusionName' => (string)$value->{'filterInclusionName'},
                            'filterInclusionName' => (array)$value->{'filterInclusionName'},
                            'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                            'lmts' => (string)$value->{'lmts'},
                            'maxFileSize' => (string)$value->{'maxFileSize'},
                            'maxVersions' => $value->{'maxVersions'},
                            'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                            'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                            'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                            'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                            'osType' => (string)$value->{'osType'},
                            'compressionEnabled' => (string)$value->{'compressionEnabled'},
                            'pftEnabled' => (string)$value->{'pftEnabled'},
                            'pftSize' => (string)$value->{'pftSize'},
                            'policyRefresh' => (string)$value->{'policyRefresh'},
                            'dedup' => (string)$value->{'dedup'},
                            'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                            'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                            'policygroupName' => (string)$value->{'policygroupName'},
                            'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                            'scheduleNames' => (array)$value->{'scheduleNames'},
                            'blocked' => $value->{'blocked'},
                            'userSizeAllowed' => (string)$value->{'userSizeAllowed'}
                        );
                        $policy['maxVersionsForSort'] = $policy['maxVersions'];
                        if($policy['maxVersions'] == '-1'){
                            $policy['maxVersionsForSort'] = '10000000';
                        }
                        $policies = array_merge(array($policy), $policies);
                    }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }*/
    public function getOneDrivePolicies(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true'
            );
            $result = $this->_model->getAllOneDrivePolicies($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
foreach($result['body']->{'officeBackupPolicyElementList'} as $value){
//                    foreach($result['body']->{'ODBBackupPolicyElementList'} as $value){
                        $policy = array(
                            'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                            'cpuUtilization' => (string)$value->{'cpuUtilization'},
                            'memoryUtilization' => (string)$value->{'memoryUtilization'},
                            'crawlLimit' => (string)$value->{'crawlLimit'},
                            'description' => (string)$value->{'description'},
                            'mappedUserCount' => (int)$value->{'mappedUserCount'},
                            'dcmEnabled' => (string)$value->{'dcmEnabled'},
                            'destination' => (string)$value->{'destination'},
                            //'filterInclusionName' => (string)$value->{'filterInclusionName'},
                            'filterInclusionName' => (array)$value->{'filterInclusionName'},
                            'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                            'lmts' => (string)$value->{'lmts'},
			    'maxFileSize' => (string)$value->{'maxFileSize'},
			    'maxVersions' => $value->{'odMaxVersions'},
//                            'maxVersions' => $value->{'maxVersions'},
                            'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                            'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                            'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                            'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                            'osType' => (string)$value->{'osType'},
                            'compressionEnabled' => (string)$value->{'compressionEnabled'},
                            'pftEnabled' => (string)$value->{'pftEnabled'},
                            'pftSize' => (string)$value->{'pftSize'},
                            'policyRefresh' => (string)$value->{'policyRefresh'},
                            'dedup' => (string)$value->{'dedup'},
                            'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                            'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                            'policygroupName' => (string)$value->{'policygroupName'},
                            'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                            'scheduleNames' => (array)$value->{'scheduleNames'},
                            'blocked' => $value->{'blocked'},
                            'userSizeAllowed' => (string)$value->{'userSizeAllowed'}
                        );
                        $policy['maxVersionsForSort'] = $policy['maxVersions'];
                        if($policy['maxVersions'] == '-1'){
                            $policy['maxVersionsForSort'] = '10000000';
                        }
                        $policies = array_merge(array($policy), $policies);
                    }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getPolicies(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true'
            );
            $result = $this->_model->getAllPolicies($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];

                    foreach($result['body']->{'backupPolicyElementList'} as $value){
                        $policy = array(
                            'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                            'cpuUtilization' => (string)$value->{'cpuUtilization'},
                            'memoryUtilization' => (string)$value->{'memoryUtilization'},
                            'crawlLimit' => (string)$value->{'crawlLimit'},
                            'description' => (string)$value->{'description'},
                            'mappedUserCount' => (int)$value->{'mappedUserCount'},
                            'dcmEnabled' => (string)$value->{'dcmEnabled'},
                            'destination' => (string)$value->{'destination'},
                            //'filterInclusionName' => $value->{'inclusionFilterElement'}->{'filterName'},
                            'filterInclusionName' => (array)$value->{'filterInclusionName'},
                            'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                            'lmts' => (string)$value->{'lmts'},
                            'maxFileSize' => (string)$value->{'maxFileSize'},
                            'maxVersions' => $value->{'maxVersions'},
                            'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                            'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                            'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                            'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                            'osType' => (string)$value->{'osType'},
                            'compressionEnabled' => (string)$value->{'compressionEnabled'},
                            'pftEnabled' => (string)$value->{'pftEnabled'},
                            'pftSize' => (string)$value->{'pftSize'},
                            'policyRefresh' => (string)$value->{'policyRefresh'},
                            'dedup' => (string)$value->{'dedup'},
                            'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                            'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                            'policygroupName' => (string)$value->{'policygroupName'},
                            'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                            'scheduleNames' => (array)$value->{'scheduleNames'},
                            'blocked' => $value->{'blocked'},
                            'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                            'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
                        );
                        $policy['maxVersionsForSort'] = $policy['maxVersions'];
                        if($policy['maxVersions'] == '-1'){
                            $policy['maxVersionsForSort'] = '10000000';
                        }
                        $policies = array_merge(array($policy), $policies);
                    }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function createOneDrivePolicy(){
        Auth::allowOnly('readOnlyAdmin');
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $cons = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $controllerResult = $this->_model->getBlukryptSettings($headers);
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }


        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }


        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                 if((string)$value->{'productType'} != 'blusync'){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }
        }
        
        if($controllerResult['body']->{'MSAppBluKryptElementList'}){
            foreach($controllerResult['body']->{'MSAppBluKryptElementList'} as $key => $value){
                $con = array(
                    'host' => (string)$value->{'host'}
                );
                $cons = array_merge(array($con), $cons);
                
            }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
        $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Office 365 Policy',
            'crumb2' => $this->language->get('create'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'sch1' => $sch1,
            'fil1' => $fil1,
            'filCanned' => $filCanned,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
	    'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'cons' => $cons,
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
            'canAdminRestoreAll' => $canAdminRestoreAll,
	    'canAdminDelete' => $canAdminDelete,
            'searchEnabled' => $searchEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	
	if($this->session->get('one_drive_backup_enabled') == "true"){
        	$data['onedriveBackupEnabled'] = 'true';
        }else{
                $data['onedriveBackupEnabled'] = 'false';
        }
        if($this->session->get('exchange_backup_enabled') == "true"){
                $data['exchangeBackupEnabled'] = 'true';
        }else{
                $data['exchangeBackupEnabled'] = 'false';
        }
	if($this->session->get('oneDriveArchivingEnabled') == "true"){
                $data['oneDriveArchivingEnabled'] = 'true';
        }else{
                $data['oneDriveArchivingEnabled'] = 'false';
        }
	if($this->session->get('mailArchivingEnabled') == "true"){
                $data['mailArchivingEnabled'] = 'true';
        }else{
                $data['mailArchivingEnabled'] = 'false';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        if(Auth::checkCloudPermission('serverBackup')){
            View::render('pms/serverPolicy/create', $data);
        }else{
            View::render('pms/oneDrivePolicy/create', $data);
        }
        View::renderTemplate('footer', $data);
    }

    public function createPolicy(){
        Auth::allowOnly('readOnlyAdmin');
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$overridePolicySettings = $cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'};
	$showUserConsentFieldInPolicies = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserConsentFieldInPolicies'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
	    $sch1 = array_merge(array($sc), $sch1);
	    $this->log("------------> ".$sc,"info");
        }
	$this->log("------------> ".json_encode($sch1),"info");

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                 if((string)$value->{'productType'} != 'blusync'){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
        $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => (Auth::checkCloudPermission('serverBackup') == true) ? $this->language->get('sPolicy') : $this->language->get('bPolicy'),
            'crumb2' => $this->language->get('create'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'sch1' => $sch1,
            'fil1' => $fil1,
            'filCanned' => $filCanned,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
            'canAdminRestoreAll' => $canAdminRestoreAll,
	    'canAdminDelete' => $canAdminDelete,
            'searchEnabled' => $searchEnabled,
	    'overridePolicySettings' => $overridePolicySettings,
	    'showUserConsentFieldInPolicies' => $showUserConsentFieldInPolicies,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('isSQLBkpEnabled') == 'true'){
        	$data['isSQLBkpEnabled'] = 'true';
        }else{
        	$data['isSQLBkpEnabled'] = 'false';
	}

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        if(Auth::checkCloudPermission('serverBackup')){
            View::render('pms/serverPolicy/create', $data);
        }else{
            View::render('pms/policy/create', $data);
        }
        View::renderTemplate('footer', $data);
    }

    public function savePolicy(){
        //Auth::allowOnly('admin');
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
	if($this->session->get('isSQLBkpEnabled') == 'true'){
		if(empty($_POST['sqlbkpEnabled']) || $_POST['sqlbkpEnabled'] != 'enabled'){
		    	$_POST['sqlbkpEnabled'] = 'false';
		}else{
		    	$_POST['sqlbkpEnabled'] = 'true';
		}
	}else{
		$_POST['sqlbkpEnabled'] = 'false';
	}
        if(empty($_POST['maxVersions']) || $_POST['maxVersions'] == 'UNLIMITED'){
            $_POST['maxVersions'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSize']) || $_POST['maxPermissibleFileSize'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSize'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimit']) || $_POST['perUserBackupStorageLimit'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimit'] = "102400";
        }
        if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
        if(empty($_POST['noOfDaysToKeepDeviceNotHeard']) || $_POST['noOfDaysToKeepDeviceNotHeard'] == 'UNLIMITED'){
            $_POST['noOfDaysToKeepDeviceNotHeard'] = "-1";
        }
        if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;
        }
        if(empty($_POST['noOfDaysToKeepDeletedFiles']) || $_POST['noOfDaysToKeepDeletedFiles'] == 'UNLIMITED'){
             $_POST['noOfDaysToKeepDeletedFiles'] = "-1";
         }
        if(!empty($_POST)){
            $rules = array(
                'defaultFolders'            => 'required',
                'filesCrawlLimit'           => 'required',
                'incrementalFileTransfer'   => 'required',
                'machineMaxThreshold'       => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'perUserBackupStorageLimit' => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
                'defaultFolders'            => 'trim|sanitize_string',
                'filesCrawlLimit'           => 'trim|sanitize_string',
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'machineMaxThreshold'       => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'perUserBackupStorageLimit' => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

                //if($validate == true){
                if(true){
                    $headers = array(
                        'Content-Type'         => 'application/json',
                        'token'         => $this->session->get('token')
                    );

                $_POST['defaultFolders'] = explode(',^,',$_POST['defaultFolders']);
                foreach($_POST['defaultFolders'] as $value){
                    $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                    $value = str_replace('%E2%81%A9%2F', "/", $value);
                    $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                }
                if($_POST['defaultExclusionFolders'] != ''){  
                $_POST['defaultExclusionFolders'] = explode(',^,',$_POST['defaultExclusionFolders']);
                foreach($_POST['defaultExclusionFolders'] as $value){
                        $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                        $value = str_replace('%E2%81%A9%2F', "/", $value);
                        $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                    }
                }else{
                    $_POST['defaultExclusionFolders'] = [];
                }
                
                if($_POST['exceptionsToExclusions'] != ''){  
                $_POST['exceptionsToExclusions'] = explode(',^,',$_POST['exceptionsToExclusions']);
                foreach($_POST['exceptionsToExclusions'] as $value){
                        $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                        $value = str_replace('%E2%81%A9%2F', "/", $value);
                        $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                    }
                }else{
                    $_POST['exceptionsToExclusions'] = [];
		}
		if(!empty($_POST['pgList'])){
			$_POST['pgList'] = explode(',',$_POST['pgList']);
		}else{
			$_POST['pgList'] = [];
		}

                $privacyGatewayMappingElement = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['Blukryptipaddress']) ? $_POST['Blukryptipaddress'] : $list
                );

                $endpointUiPreferences = [];
                $endpointDisabledUiPreferences = [];
                    if(isset($_POST['exitt']) && $_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'EXIT');
		    }
		    if(isset($_POST['disallowAdminRestores']) && $_POST['disallowAdminRestores']=='true'){
                        array_push($endpointUiPreferences,'DISALLOW_ADMIN_RESTORES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'DISALLOW_ADMIN_RESTORES');
                    }
                    if(isset($_POST['decouple']) && $_POST['decouple']=='true'){
                        array_push($endpointUiPreferences,'DECOUPLE');
                    }else{
                        array_push($endpointDisabledUiPreferences,'DECOUPLE');
                    }
                    if(isset($_POST['support']) && $_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT'); 
                    }else{
                        array_push($endpointDisabledUiPreferences,'SUPPORT');
                    }
                    if(isset($_POST['initiatebackup']) && $_POST['initiatebackup']=='true'){
                        array_push($endpointUiPreferences,'INTIATE_BACKUP');
                    }else{
                        array_push($endpointDisabledUiPreferences,'INTIATE_BACKUP');
                    }
                    if(isset($_POST['restore']) && $_POST['restore']=='true'){
                        array_push($endpointUiPreferences,'RESTORE');
                    }else{
                        array_push($endpointDisabledUiPreferences,'RESTORE');
                    }
                    if(isset($_POST['stopbackup']) && $_POST['stopbackup']=='true'){
                        array_push($endpointUiPreferences,'STOP_BACKUP');
                    }else{
                        array_push($endpointDisabledUiPreferences,'STOP_BACKUP');
                    }
                    if(isset($_POST['bkpsettings']) && $_POST['bkpsettings']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_SETTINGS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_SETTINGS');
                    }
                    if(isset($_POST['bkpfiles']) && $_POST['bkpfiles']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_FILES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_FILES');
                    }
                    if(isset($_POST['refbkppolicy']) && $_POST['refbkppolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_BACKUP_POLICY');
                    }else{
                        array_push($endpointDisabledUiPreferences,'REFRESH_BACKUP_POLICY');
                    }
		    if(isset($_POST['blockNotifications']) && $_POST['blockNotifications']=='true'){
                        array_push($endpointUiPreferences,'BLOCK_NOTIFICATIONS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BLOCK_NOTIFICATIONS');
                    }
                    if(isset($_POST['pauseBackup']) && $_POST['pauseBackup']=='true'){
                        array_push($endpointUiPreferences,'PAUSE_BACKUP');
                    }else{
                        array_push($endpointDisabledUiPreferences,'PAUSE_BACKUP');
                    }
                    if(isset($_POST['about']) && $_POST['about']=='true'){
                        array_push($endpointUiPreferences,'ABOUT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'ABOUT');
                    }
                    if(isset($_POST['updateAgent']) && $_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'UPDATE_AGENT');
                    }
                    if(isset($_POST['systrayIcon']) && $_POST['systrayIcon']=='true'){
                        array_push($endpointUiPreferences,'SYSTRAYICON');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYSTRAYICON');
		    }		    

   		    if(strpos($_POST['policyRefresh'], ':') == false) {
			$_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
		    }
	            if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                        $_POST['nwFromClientToPGMB'] = 10000.0000;
                    }else{
			    if($_POST['networkThrottlingUnit'] == "kbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
			    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
			    }
			    elseif($_POST['networkThrottlingUnit'] == "gbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
			    }                    
                    }
                $_POST['policyName'] = trim($_POST['policyName']);

                $arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
                    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }
                if(sizeof($_POST['deviceDeleted']) > 0){
                    $_POST['deviceDeleted'] = implode(",", $_POST['deviceDeleted']);
                    $_POST['deviceDeleted'] = rtrim($_POST['deviceDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDeleted' => $_POST['deviceDeleted']));
                }
                if(sizeof($_POST['deviceBlocked']) > 0){
                    $_POST['deviceBlocked'] = implode(",", $_POST['deviceBlocked']);
                    $_POST['deviceBlocked'] = rtrim($_POST['deviceBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('deviceBlocked' => $_POST['deviceBlocked']));
                }
                if(sizeof($_POST['deviceDecoupled']) > 0){
                    $_POST['deviceDecoupled'] = implode(",", $_POST['deviceDecoupled']);
                    $_POST['deviceDecoupled'] = rtrim($_POST['deviceDecoupled'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDecoupled' => $_POST['deviceDecoupled']));
                }
                if(sizeof($_POST['deviceLimitReached']) > 0){
                    $_POST['deviceLimitReached'] = implode(",", $_POST['deviceLimitReached']);
                    $_POST['deviceLimitReached'] = rtrim($_POST['deviceLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('deviceLimitReached' => $_POST['deviceLimitReached']));
                }
                if(sizeof($_POST['weeklyBkpreport']) > 0){
                    $_POST['weeklyBkpreport'] = implode(",", $_POST['weeklyBkpreport']);
                    $_POST['weeklyBkpreport'] = rtrim($_POST['weeklyBkpreport'], ", \t\n");
                    $arr = array_merge($arr, array('weeklyBkpreport' => $_POST['weeklyBkpreport']));
                }
                if(sizeof($_POST['firstBkpCompleted']) > 0){
                    $_POST['firstBkpCompleted'] = implode(",", $_POST['firstBkpCompleted']);
                    $_POST['firstBkpCompleted'] = rtrim($_POST['firstBkpCompleted'], ", \t\n");
                    $arr = array_merge($arr, array('firstBkpCompleted' => $_POST['firstBkpCompleted']));
                }
                if(sizeof($_POST['restoreInitiated']) > 0){
                    $_POST['restoreInitiated'] = implode(",", $_POST['restoreInitiated']);
                    $_POST['restoreInitiated'] = rtrim($_POST['restoreInitiated'], ", \t\n");
                    $arr = array_merge($arr, array('restoreInitiated' => $_POST['restoreInitiated']));
                }
                if(sizeof($_POST['storageLimitReached']) > 0){
                    $_POST['storageLimitReached'] = implode(",", $_POST['storageLimitReached']);
                    $_POST['storageLimitReached'] = rtrim($_POST['storageLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('storageLimitReached' => $_POST['storageLimitReached']));
                }
                
                $menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download'],
		    "restore" => $_POST['portalRestore']
                );
                
                if(isset($_POST['switchAllowedDomains']) && $_POST['switchAllowedDomains'] == 'on'){
                    $_POST['switchAllowedDomains'] = 'true';
                }else{
                    $_POST['switchAllowedDomains'] = 'false';
		}

		if(isset($_POST['switchAgentPassword']) && $_POST['switchAgentPassword'] == 'on'){
                    $_POST['switchAgentPassword'] = 'true';
                }else{
                    $_POST['switchAgentPassword'] = 'false';
                }
			
		if(isset($_POST['preScanCommandEnabled']) && $_POST['preScanCommandEnabled'] == 'on'){
                    $_POST['preScanCommandEnabled'] = 'true';
                }else{
                    $_POST['preScanCommandEnabled'] = 'false';
                }

		if(isset($_POST['preBackupCommandEnabled']) && $_POST['preBackupCommandEnabled'] == 'on'){
                    $_POST['preBackupCommandEnabled'] = 'true';
                }else{
                    $_POST['preBackupCommandEnabled'] = 'false';
                }

		if(isset($_POST['postBackupCommandEnabled']) && $_POST['postBackupCommandEnabled'] == 'on'){
                    $_POST['postBackupCommandEnabled'] = 'true';
                }else{
                    $_POST['postBackupCommandEnabled'] = 'false';
                }

		if(empty($_POST['continueOnPreScan']) || $_POST['continueOnPreScan'] != 'enabled'){
            		$_POST['continueOnPreScan'] = 'false';
        	}else{
            		$_POST['continueOnPreScan'] = 'true';
        	}

		if(empty($_POST['continueOnPreBkp']) || $_POST['continueOnPreBkp'] != 'enabled'){
			$_POST['continueOnPreBkp'] = 'false';
		}else{
			$_POST['continueOnPreBkp'] = 'true';
		}

		if(empty($_POST['continueOnPostBkp']) || $_POST['continueOnPostBkp'] != 'enabled'){
			$_POST['continueOnPostBkp'] = 'false';
		}else{
			$_POST['continueOnPostBkp'] = 'true';
		}
		if(empty($_POST['highSecureShareEnabled']) || $_POST['highSecureShareEnabled'] != 'enabled'){
            		$_POST['highSecureShareEnabled'] = 'false';
        	}else{
            		$_POST['highSecureShareEnabled'] = 'true';
        	}
		if(isset($_POST['controllerSL']) && $_POST['controllerSL'] == 'true'){
                    $_POST['showShareLink'] = 'true';
                }else{
                    $_POST['showShareLink'] = 'false';
                }
		if(isset($_POST['controllerCP']) && $_POST['controllerCP'] == 'true'){
                    $_POST['complexPasswordRequired'] = 'true';
                }else{
                    $_POST['complexPasswordRequired'] = 'false';
                }
		if(isset($_POST['controllerAD']) && $_POST['controllerAD'] == 'true'){
                    $_POST['preventDownloadEnabled'] = 'true';
                }else{
                    $_POST['preventDownloadEnabled'] = 'false';
                }
		if(isset($_POST['controllerED']) && $_POST['controllerED'] == 'true'){
                    $_POST['expiredDate'] = 'true';
                }else{
                    $_POST['expiredDate'] = 'false';
                }
		if(isset($_POST['controllerMFA']) && $_POST['controllerMFA'] == 'true'){
                    $_POST['googleAuth'] = 'true';
                }else{
                    $_POST['googleAuth'] = 'false';
                }
		if(empty($_POST['shareDomainsEnabled']) || $_POST['shareDomainsEnabled'] != 'enabled'){
                        $_POST['shareDomainsEnabled'] = 'false';
                }else{
                        $_POST['shareDomainsEnabled'] = 'true';
                }
		$_POST['shareDomainIncExclusions'] = preg_replace('/\s/', '', $_POST['shareDomainIncExclusions']);
		if(isset($_POST['switchlogUnaccessedFiles']) && $_POST['switchlogUnaccessedFiles'] == 'on'){
                    $_POST['logUnaccessedFiles'] = 'true';
                }else{
                    $_POST['logUnaccessedFiles'] = 'false';
                }
		if(isset($_POST['applyFilterToExceptionsToExclusion']) && $_POST['applyFilterToExceptionsToExclusion'] == 'true'){
                    $applyFilterToExceptionsToExclusion = 'true';
                }else{
                    $applyFilterToExceptionsToExclusion = 'false';
                }
                $data = array(
                    "backupSystemFilesEnabled"      => $_POST['systemFolders'],
                    "legalHoldEnabled"              => $_POST['legalHold'],
		    "sqlbkpEnabled"                 => $_POST['sqlbkpEnabled'],
                    "shareEnabled"                  => $_POST['Share'],
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPassword"               => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['complexPasswordRequired'],
                    "allowDownload"                 => ($_POST['highSecureShareEnabled'] == "true") ? false : $_POST['preventDownloadEnabled'],
                    "shareExpireDateEnable"         => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['expiredDate'],
		    "googleAuth"         	    => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['googleAuth'],
                    "maxFileSizeForBkpBatch"        => $_POST['maxFileSizeForBkpBatch'],
                    "clientDedup"                   => $_POST['clientDedup'],
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   => $_POST['description'],
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "dcmEnabled"                    => !empty($_POST['dcmEnabled']) ? ($_POST['dcmEnabled'] == 'true') ? true : false : false,
                    "destination"                   => !empty($_POST['backupDestination']) ? $_POST['backupDestination'] : '',
                    "backupFolderPaths"             => !empty($_POST['defaultFolders']) ? $_POST['defaultFolders'] : '',
                    "maxVersions"                   => !empty($_POST['maxVersions']) ? $_POST['maxVersions'] : '',
                    "maxFileSize"                   => !empty($_POST['maxPermissibleFileSize']) ? $_POST['maxPermissibleFileSize'] : '',
                    "osType"                        => !empty($_POST['osTyped']) ? $_POST['osTyped'] : '',
                    "pftEnabled"                    => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
                    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
                    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
                    "fullBackupEnabled"             => !empty($_POST['fullBackupEnabled']) ? $_POST['fullBackupEnabled'] : false,
                    "fullBackupStartDate"           => !empty($_POST['fullBackupStartDate']) ? strtotime($_POST['fullBackupStartDate']) : '',
                    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
                    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
                    "nwFromClientToPG"              => $_POST['nwFromClientToPGMB'],
		    "nwFromClientToPGMB"            => $_POST['nwFromClientToPGMB'],
                    "filterInclusionName"           => !empty($_POST['filters']) ? $_POST['filters'] : [],
                    "searchFilterInclusionName"     => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : [],
                    'vssEnabled'                    => !empty($_POST['vssEnabled']) ? $_POST['vssEnabled'] : '',
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "scheduleNames"                 => !empty($_POST['schedules']) ? $_POST['schedules'] : '',
                    "userSizeAllowed"               => !empty($_POST['perUserBackupStorageLimit']) ? $_POST['perUserBackupStorageLimit'] : '',
                    "memoryUtilization"             => !empty($_POST['memoryUtilization']) ? $_POST['memoryUtilization'] : '',
                    "cpuUtilization"                => !empty($_POST['cpuUtilization']) ? $_POST['cpuUtilization'] : '',
                    "fullBackupSchedule"            => !empty($_POST['fullBackupPeriod']) ? $_POST['fullBackupPeriod'] : '',
                    "compressionEnabled"            => !empty($_POST['compEnabled']) ? $_POST['compEnabled'] : false,
                    "privacyGatewayMappingElement"  => $privacyGatewayMappingElement,
                    "endpointUiPreferences"         => $endpointUiPreferences,
                    "endpointDisabledUiPreferences" => $endpointDisabledUiPreferences,
                    "menuOptions"                   => $menuOptions,
                    "calloutScripts"                => $this->getAllScripts($this->serializeTheString($_POST['preBackupScripts']), $this->serializeTheString($_POST['postBackupScripts']), $this->serializeTheString($_POST['preRestoreScripts']), $this->serializeTheString($_POST['postRestoreScripts'])),
                    "crawlLimit"                    => !empty($_POST['filesCrawlLimit']) ? $_POST['filesCrawlLimit'] : 500,
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "canUserChangePassword" 	    => !empty($_POST['canUserChangePassword']) ? $_POST['canUserChangePassword'] : 'false',
                    "canAdminChangeUserPassword"    => !empty($_POST['canAdminChangeUserPassword']) ? $_POST['canAdminChangeUserPassword'] : 'false',
                    "downloadAgent"                 => !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "canBackupHiddenFiles"          => !empty($_POST['canBackupHiddenFiles']) ? $_POST['canBackupHiddenFiles'] : 'false',
                    "searchAlgoForPg"               => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    "cpuThrottling"                 => $_POST['cpuThrottling'],
                    "daysToWaitForNextBackup"       => !empty($_POST['daysToWaitForNextBackup']) ? $_POST['daysToWaitForNextBackup'] : 0,
                    'noOfDevicesAllowed'            => $_POST['noOfDevicesAllowed'],
                    "endpointDomainCheck"      	    => $_POST['switchAllowedDomains'],
                    "allowedDomains"                => $_POST['allowedDomains'],
                    "webBasedLogin"                 => !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
                    "canAdminRestore"               => !empty($_POST['canAdminRestore']) ? $_POST['canAdminRestore'] : 'true',
		    "canAdminDelete"                => !empty($_POST['canAdminDelete']) ? $_POST['canAdminDelete'] : 'true',
                    'contentIndexEnabled'           => $_POST['contentIndexEnabled'],
                    "noOfDaysToKeepDeviceNotHeard"  => !empty($_POST['noOfDaysToKeepDeviceNotHeard']) ? $_POST['noOfDaysToKeepDeviceNotHeard'] : '',
                    "noOfDaysToKeepDeletedFiles"    => $_POST['noOfDaysToKeepDeletedFiles'],
		    "filterType" 		    => $_POST['filtersType'],
		    "searchFilterType" 		    => $_POST['searchFilterType'],
		    "preScanCommand"        	    => $_POST['preScanCommand'],
		    "preBackupCommand"      	    => $_POST['preBackupCommand'],
		    "postBackupCommand"     	    => $_POST['postBackupCommand'],
		    "continueOnPreScan"      	    => $_POST['continueOnPreScan'],
		    "continueOnPreBkp"      	    => $_POST['continueOnPreBkp'],
		    "continueOnPostBkp"      	    => $_POST['continueOnPostBkp'],
		    "preScanCommandEnabled"         => $_POST['preScanCommandEnabled'],
		    "preBackupCommandEnabled"       => $_POST['preBackupCommandEnabled'],
		    "postBackupCommandEnabled"      => $_POST['postBackupCommandEnabled'],
		    "switchAgentPassword"      	    => $_POST['switchAgentPassword'],
                    "agentPassword"           	    => $_POST['agentPassword'],
		    "shareDomainType"		    => !empty($_POST['shareDomainType']) ? $_POST['shareDomainType']: 'Share only with these Email domains',
                    "shareDomainIncExclusions"      => explode (",", $_POST['shareDomainIncExclusions']),
		    "allowEndUserTocontrolRestore"  => !empty($_POST['allowEndUserTocontrolRestore']) ? $_POST['allowEndUserTocontrolRestore'] : 'true',
		    "showShareLink"   		    => $_POST['showShareLink'],
		    "userConsentEnabled"   	    => !empty($_POST['userConsentEnabled']) ? $_POST['userConsentEnabled'] : 'false',
                    "userConsentDisplayText"   	    => $_POST['userConsentDisplayText'],
		    "numberOfThreadsAllowedForBackup"   => $_POST['numberOfThreadsAllowedForBackup'],
		    "shareDomainsEnabled"           => $_POST['shareDomainsEnabled'],
		    "logUnaccessedFiles"            => $_POST['logUnaccessedFiles'],
		    "applyFilterToExceptionsToExclusion" => $applyFilterToExceptionsToExclusion
                );
                //if($_POST['defaultExclusionFolders'] != ''){
                $data = array_merge($data, array('excludedFolderpaths'=>$_POST['defaultExclusionFolders']));
                $data = array_merge($data, array('exceptionsToExclusions'=>$_POST['exceptionsToExclusions']));
                //}
                if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->savePolicy($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4063')
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function savePolicyEdit(){
        //Auth::allowOnly('admin');
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
	if($this->session->get('isSQLBkpEnabled') == 'true'){
		if(empty($_POST['sqlbkpEnabled']) || $_POST['sqlbkpEnabled'] != 'enabled'){
		    	$_POST['sqlbkpEnabled'] = 'false';
		}else{
		    	$_POST['sqlbkpEnabled'] = 'true';
		}
	}else{
		$_POST['sqlbkpEnabled'] = 'false';
	}
        if(empty($_POST['maxVersions']) || $_POST['maxVersions'] == 'UNLIMITED'){
            $_POST['maxVersions'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSize']) || $_POST['maxPermissibleFileSize'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSize'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimit']) || $_POST['perUserBackupStorageLimit'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimit'] = "102400";
        }
        if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
        if(empty($_POST['noOfDaysToKeepDeviceNotHeard']) || $_POST['noOfDaysToKeepDeviceNotHeard'] == 'UNLIMITED'){
            $_POST['noOfDaysToKeepDeviceNotHeard'] = "-1";
        }
        if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;
        }
        if(empty($_POST['noOfDaysToKeepDeletedFiles']) || $_POST['noOfDaysToKeepDeletedFiles'] == 'UNLIMITED'){
             $_POST['noOfDaysToKeepDeletedFiles'] = "-1";
         }
        if(!empty($_POST)){
            $rules = array(
                'defaultFolders'            => 'required',
                'filesCrawlLimit'           => 'required',
                'incrementalFileTransfer'   => 'required',
                'machineMaxThreshold'       => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'perUserBackupStorageLimit' => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
                'defaultFolders'            => 'trim|sanitize_string',
                'filesCrawlLimit'           => 'trim|sanitize_string',
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'machineMaxThreshold'       => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'perUserBackupStorageLimit' => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

                //if($validate == true){
                if(true){
                    $headers = array(
                        'Content-Type'         => 'application/json',
                        'token'         => $this->session->get('token')
                    );

                $_POST['defaultFolders'] = explode(',^,',$_POST['defaultFolders']);
                foreach($_POST['defaultFolders'] as $value){
                     $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                     $value = str_replace('%E2%81%A9%2F', "/", $value);
                     $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                 }
                if($_POST['defaultExclusionFolders'] != ''){  
                $_POST['defaultExclusionFolders'] = explode(',^,',$_POST['defaultExclusionFolders']);
                foreach($_POST['defaultExclusionFolders'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['defaultExclusionFolders'] = [];
                }
                
                if($_POST['exceptionsToExclusions'] != ''){  
                $_POST['exceptionsToExclusions'] = explode(',^,',$_POST['exceptionsToExclusions']);
                foreach($_POST['exceptionsToExclusions'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['exceptionsToExclusions'] = [];
                }
                if(!empty($_POST['pgList'])){
                        $_POST['pgList'] = explode(',',$_POST['pgList']);
                }else{
                        $_POST['pgList'] = [];
                }

                $privacyGatewayMappingElement = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['Blukryptipaddress']) ? $_POST['Blukryptipaddress'] : $list
                );

                $endpointUiPreferences = [];
                $endpointDisabledUiPreferences = [];
                    if(isset($_POST['exitt']) && $_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'EXIT');
		    }
		    if(isset($_POST['disallowAdminRestores']) && $_POST['disallowAdminRestores']=='true'){
                        array_push($endpointUiPreferences,'DISALLOW_ADMIN_RESTORES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'DISALLOW_ADMIN_RESTORES');
                    }
                    if(isset($_POST['decouple']) && $_POST['decouple']=='true'){
                        array_push($endpointUiPreferences,'DECOUPLE');
                    }else{
                        array_push($endpointDisabledUiPreferences,'DECOUPLE');
                    }
                    if(isset($_POST['support']) && $_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT'); 
                    }else{
                        array_push($endpointDisabledUiPreferences,'SUPPORT');
                    }
                    if(isset($_POST['initiatebackup']) && $_POST['initiatebackup']=='true'){
                        array_push($endpointUiPreferences,'INTIATE_BACKUP');
                    }else{
                        array_push($endpointDisabledUiPreferences,'INTIATE_BACKUP');
                    }
                    if(isset($_POST['restore']) && $_POST['restore']=='true'){
                        array_push($endpointUiPreferences,'RESTORE');
                    }else{
                        array_push($endpointDisabledUiPreferences,'RESTORE');
                    }
                    if(isset($_POST['stopbackup']) && $_POST['stopbackup']=='true'){
                        array_push($endpointUiPreferences,'STOP_BACKUP');
                    }else{
                        array_push($endpointDisabledUiPreferences,'STOP_BACKUP');
                    }
                    if(isset($_POST['bkpsettings']) && $_POST['bkpsettings']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_SETTINGS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_SETTINGS');
                    }
                    if(isset($_POST['bkpfiles']) && $_POST['bkpfiles']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_FILES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_FILES');
                    }
                    if(isset($_POST['refbkppolicy']) && $_POST['refbkppolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_BACKUP_POLICY');
                    }else{
                        array_push($endpointDisabledUiPreferences,'REFRESH_BACKUP_POLICY');
                    }
		    if(isset($_POST['blockNotifications']) && $_POST['blockNotifications']=='true'){
                        array_push($endpointUiPreferences,'BLOCK_NOTIFICATIONS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BLOCK_NOTIFICATIONS');
                    }
                    if(isset($_POST['pauseBackup']) && $_POST['pauseBackup']=='true'){
                        array_push($endpointUiPreferences,'PAUSE_BACKUP');
                    }else{
                        array_push($endpointDisabledUiPreferences,'PAUSE_BACKUP');
                    }
                    if(isset($_POST['about']) && $_POST['about']=='true'){
                        array_push($endpointUiPreferences,'ABOUT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'ABOUT');
                    }
                    if(isset($_POST['updateAgent']) && $_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'UPDATE_AGENT');
                    }
                    if(isset($_POST['systrayIcon']) && $_POST['systrayIcon']=='true'){
                        array_push($endpointUiPreferences,'SYSTRAYICON');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SYSTRAYICON');
		    }		    

                    if(strpos($_POST['policyRefresh'], ':') == false) {
                    	$_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                    }

	            if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                   $_POST['nwFromClientToPGMB'] = 10000.0000;
                }
                else{
                    if($_POST['networkThrottlingUnit'] == "kbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
                    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
                    }
                    elseif($_POST['networkThrottlingUnit'] == "gbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
                    }
                    //$_POST['nwFromClientToPGMB'] = number_format($_POST['nwFromClientToPGMB'], 2);
                }
                $_POST['policyName'] = trim($_POST['policyName']);
                
                $arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
                    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }
                if(sizeof($_POST['deviceDeleted']) > 0){
                    $_POST['deviceDeleted'] = implode(",", $_POST['deviceDeleted']);
                    $_POST['deviceDeleted'] = rtrim($_POST['deviceDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDeleted' => $_POST['deviceDeleted']));
                }
                if(sizeof($_POST['deviceBlocked']) > 0){
                    $_POST['deviceBlocked'] = implode(",", $_POST['deviceBlocked']);
                    $_POST['deviceBlocked'] = rtrim($_POST['deviceBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('deviceBlocked' => $_POST['deviceBlocked']));
                }
                if(sizeof($_POST['deviceDecoupled']) > 0){
                    $_POST['deviceDecoupled'] = implode(",", $_POST['deviceDecoupled']);
                    $_POST['deviceDecoupled'] = rtrim($_POST['deviceDecoupled'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDecoupled' => $_POST['deviceDecoupled']));
                }
                if(sizeof($_POST['deviceLimitReached']) > 0){
                    $_POST['deviceLimitReached'] = implode(",", $_POST['deviceLimitReached']);
                    $_POST['deviceLimitReached'] = rtrim($_POST['deviceLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('deviceLimitReached' => $_POST['deviceLimitReached']));
                }
                if(sizeof($_POST['weeklyBkpreport']) > 0){
                    $_POST['weeklyBkpreport'] = implode(",", $_POST['weeklyBkpreport']);
                    $_POST['weeklyBkpreport'] = rtrim($_POST['weeklyBkpreport'], ", \t\n");
                    $arr = array_merge($arr, array('weeklyBkpreport' => $_POST['weeklyBkpreport']));
                }
                if(sizeof($_POST['firstBkpCompleted']) > 0){
                    $_POST['firstBkpCompleted'] = implode(",", $_POST['firstBkpCompleted']);
                    $_POST['firstBkpCompleted'] = rtrim($_POST['firstBkpCompleted'], ", \t\n");
                    $arr = array_merge($arr, array('firstBkpCompleted' => $_POST['firstBkpCompleted']));
                }
                if(sizeof($_POST['restoreInitiated']) > 0){
                    $_POST['restoreInitiated'] = implode(",", $_POST['restoreInitiated']);
                    $_POST['restoreInitiated'] = rtrim($_POST['restoreInitiated'], ", \t\n");
                    $arr = array_merge($arr, array('restoreInitiated' => $_POST['restoreInitiated']));
                }
                if(sizeof($_POST['storageLimitReached']) > 0){
                    $_POST['storageLimitReached'] = implode(",", $_POST['storageLimitReached']);
                    $_POST['storageLimitReached'] = rtrim($_POST['storageLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('storageLimitReached' => $_POST['storageLimitReached']));
                }
                
                $menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download'],
		    "restore" => $_POST['portalRestore']
                );
                
                if(isset($_POST['switchAllowedDomains']) && $_POST['switchAllowedDomains'] == 'on'){
                    $_POST['switchAllowedDomains'] = 'true';
                }else{
                    $_POST['switchAllowedDomains'] = 'false';
                }
		if(isset($_POST['switchAgentPassword']) && $_POST['switchAgentPassword'] == 'on'){
                    $_POST['switchAgentPassword'] = 'true';
                }else{
                    $_POST['switchAgentPassword'] = 'false';
                }
                if(isset($_POST['preScanCommandEnabled']) && $_POST['preScanCommandEnabled'] == 'on'){
                    $_POST['preScanCommandEnabled'] = 'true';
                }else{
                    $_POST['preScanCommandEnabled'] = 'false';
                }
                if(isset($_POST['preBackupCommandEnabled']) && $_POST['preBackupCommandEnabled'] == 'on'){
                    $_POST['preBackupCommandEnabled'] = 'true';
                }else{
                    $_POST['preBackupCommandEnabled'] = 'false';
                }
                if(isset($_POST['postBackupCommandEnabled']) && $_POST['postBackupCommandEnabled'] == 'on'){
                    $_POST['postBackupCommandEnabled'] = 'true';
                }else{
                    $_POST['postBackupCommandEnabled'] = 'false';
                }
                if(empty($_POST['continueOnPreScan']) || $_POST['continueOnPreScan'] != 'enabled'){
                        $_POST['continueOnPreScan'] = 'false';
                }else{
                        $_POST['continueOnPreScan'] = 'true';
                }
                if(empty($_POST['continueOnPreBkp']) || $_POST['continueOnPreBkp'] != 'enabled'){
                        $_POST['continueOnPreBkp'] = 'false';
                }else{
                        $_POST['continueOnPreBkp'] = 'true';
                }
		if(empty($_POST['continueOnPostBkp']) || $_POST['continueOnPostBkp'] != 'enabled'){
                        $_POST['continueOnPostBkp'] = 'false';
                }else{
                        $_POST['continueOnPostBkp'] = 'true';
                }
                if(empty($_POST['highSecureShareEnabled']) || $_POST['highSecureShareEnabled'] != 'enabled'){
                        $_POST['highSecureShareEnabled'] = 'false';
                }else{
                        $_POST['highSecureShareEnabled'] = 'true';
                }
                if(isset($_POST['controllerSL']) && $_POST['controllerSL'] == 'true'){
                    $_POST['showShareLink'] = 'true';
                }else{
                    $_POST['showShareLink'] = 'false';
                }
                if(isset($_POST['controllerCP']) && $_POST['controllerCP'] == 'true'){
                    $_POST['complexPasswordRequired'] = 'true';
                }else{
                    $_POST['complexPasswordRequired'] = 'false';
                }
                if(isset($_POST['controllerAD']) && $_POST['controllerAD'] == 'true'){
                    $_POST['preventDownloadEnabled'] = 'true';
                }else{
                    $_POST['preventDownloadEnabled'] = 'false';
                }
                if(isset($_POST['controllerED']) && $_POST['controllerED'] == 'true'){
                    $_POST['expiredDate'] = 'true';
                }else{
                    $_POST['expiredDate'] = 'false';
                }
                if(isset($_POST['controllerMFA']) && $_POST['controllerMFA'] == 'true'){
                    $_POST['googleAuth'] = 'true';
                }else{
                    $_POST['googleAuth'] = 'false';
                }
		if(empty($_POST['shareDomainsEnabled']) || $_POST['shareDomainsEnabled'] != 'enabled'){
                        $_POST['shareDomainsEnabled'] = 'false';
                }else{
                        $_POST['shareDomainsEnabled'] = 'true';
                }
                $_POST['shareDomainIncExclusions'] = preg_replace('/\s/', '', $_POST['shareDomainIncExclusions']);
                if(isset($_POST['switchlogUnaccessedFiles']) && $_POST['switchlogUnaccessedFiles'] == 'on'){
                    $_POST['logUnaccessedFiles'] = 'true';
                }else{
                    $_POST['logUnaccessedFiles'] = 'false';
                }
                if(isset($_POST['applyFilterToExceptionsToExclusion']) && $_POST['applyFilterToExceptionsToExclusion'] == 'true'){
                    $applyFilterToExceptionsToExclusion = 'true';
                }else{
                    $applyFilterToExceptionsToExclusion = 'false';
                }
                $data = array(
                    "backupSystemFilesEnabled"      => $_POST['systemFolders'],
                    "legalHoldEnabled"              => $_POST['legalHold'],
		    "sqlbkpEnabled"                 => $_POST['sqlbkpEnabled'],
                    "shareEnabled"                  => $_POST['Share'],
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPassword"               => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['complexPasswordRequired'],
                    "allowDownload"                 => ($_POST['highSecureShareEnabled'] == "true") ? false : $_POST['preventDownloadEnabled'],
                    "shareExpireDateEnable"         => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['expiredDate'],
		    "googleAuth"         	    => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['googleAuth'],
                    "maxFileSizeForBkpBatch"        => $_POST['maxFileSizeForBkpBatch'],
                    "clientDedup"                   => $_POST['clientDedup'],
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   => $_POST['description'],
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "dcmEnabled"                    => !empty($_POST['dcmEnabled']) ? ($_POST['dcmEnabled'] == 'true') ? true : false : false,
                    "destination"                   => !empty($_POST['backupDestination']) ? $_POST['backupDestination'] : '',
                    "backupFolderPaths"             => !empty($_POST['defaultFolders']) ? $_POST['defaultFolders'] : '',
                    "maxVersions"                   => !empty($_POST['maxVersions']) ? $_POST['maxVersions'] : '',
                    "maxFileSize"                   => !empty($_POST['maxPermissibleFileSize']) ? $_POST['maxPermissibleFileSize'] : '',
                    "osType"                        => !empty($_POST['osTyped']) ? $_POST['osTyped'] : '',
                    "pftEnabled"                    => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
                    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
                    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
                    "fullBackupEnabled"             => !empty($_POST['fullBackupEnabled']) ? $_POST['fullBackupEnabled'] : false,
                    "fullBackupStartDate"           => !empty($_POST['fullBackupStartDate']) ? strtotime($_POST['fullBackupStartDate']) : '',
                    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
                    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
                    "nwFromClientToPG"              => $_POST['nwFromClientToPGMB'],
		    "nwFromClientToPGMB"            => $_POST['nwFromClientToPGMB'],
                    "filterInclusionName"           => !empty($_POST['filters']) ? $_POST['filters'] : [],
                    "searchFilterInclusionName"     => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : [],
                    'vssEnabled'                    => !empty($_POST['vssEnabled']) ? $_POST['vssEnabled'] : '',
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "scheduleNames"                 => !empty($_POST['schedules']) ? $_POST['schedules'] : '',
                    "userSizeAllowed"               => !empty($_POST['perUserBackupStorageLimit']) ? $_POST['perUserBackupStorageLimit'] : '',
                    "memoryUtilization"             => !empty($_POST['memoryUtilization']) ? $_POST['memoryUtilization'] : '',
                    "cpuUtilization"                => !empty($_POST['cpuUtilization']) ? $_POST['cpuUtilization'] : '',
                    "fullBackupSchedule"            => !empty($_POST['fullBackupPeriod']) ? $_POST['fullBackupPeriod'] : '',
                    "compressionEnabled"            => !empty($_POST['compEnabled']) ? $_POST['compEnabled'] : false,
                    "privacyGatewayMappingElement"  => $privacyGatewayMappingElement,
                    "endpointUiPreferences"         => $endpointUiPreferences,
                    "endpointDisabledUiPreferences" => $endpointDisabledUiPreferences,
                    "menuOptions"                   => $menuOptions,
                    "calloutScripts"                => $this->getAllScripts($this->serializeTheString($_POST['preBackupScripts']), $this->serializeTheString($_POST['postBackupScripts']), $this->serializeTheString($_POST['preRestoreScripts']), $this->serializeTheString($_POST['postRestoreScripts'])),
                    "crawlLimit"                    => !empty($_POST['filesCrawlLimit']) ? $_POST['filesCrawlLimit'] : 500,
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "canUserChangePassword"         => !empty($_POST['canUserChangePassword']) ? $_POST['canUserChangePassword'] : 'false',
                    "canAdminChangeUserPassword"    => !empty($_POST['canAdminChangeUserPassword']) ? $_POST['canAdminChangeUserPassword'] : 'false',
                    "canBackupHiddenFiles"          => !empty($_POST['canBackupHiddenFiles']) ? $_POST['canBackupHiddenFiles'] : 'false',
                    "downloadAgent"                 => !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "searchAlgoForPg"               => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    "cpuThrottling"                 => $_POST['cpuThrottling'],
                    "daysToWaitForNextBackup"       => !empty($_POST['daysToWaitForNextBackup']) ? $_POST['daysToWaitForNextBackup'] : 0,
                    'noOfDevicesAllowed'            => $_POST['noOfDevicesAllowed'],
                    "endpointDomainCheck"           => $_POST['switchAllowedDomains'],
                    "allowedDomains"                => $_POST['allowedDomains'],
                    "webBasedLogin"                 => !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
                    "canAdminRestore"               => !empty($_POST['canAdminRestore']) ? $_POST['canAdminRestore'] : 'true',
                    "canAdminDelete"                => !empty($_POST['canAdminDelete']) ? $_POST['canAdminDelete'] : 'true',
                    'contentIndexEnabled'           => $_POST['contentIndexEnabled'],
                    "noOfDaysToKeepDeviceNotHeard"  => !empty($_POST['noOfDaysToKeepDeviceNotHeard']) ? $_POST['noOfDaysToKeepDeviceNotHeard'] : '',
                    "noOfDaysToKeepDeletedFiles"    => $_POST['noOfDaysToKeepDeletedFiles'],
                    "filterType"                    =>  $_POST['filtersType'],
		    "searchFilterType" 		    => $_POST['searchFilterType'],
		    "preScanCommand"        	    => $_POST['preScanCommand'],
		    "preBackupCommand"      	    => $_POST['preBackupCommand'],
		    "postBackupCommand"     	    => $_POST['postBackupCommand'],
		    "continueOnPreScan"      	    => $_POST['continueOnPreScan'],
		    "continueOnPreBkp"      	    => $_POST['continueOnPreBkp'],
		    "continueOnPostBkp"      	    => $_POST['continueOnPostBkp'],
		    "preScanCommandEnabled"         => $_POST['preScanCommandEnabled'],
		    "preBackupCommandEnabled"       => $_POST['preBackupCommandEnabled'],
		    "postBackupCommandEnabled"      => $_POST['postBackupCommandEnabled'],
		    "switchAgentPassword"      	    => $_POST['switchAgentPassword'],
		    "agentPassword"           	    => $_POST['agentPassword'],
		    "shareDomainType"               => !empty($_POST['shareDomainType']) ? $_POST['shareDomainType']: 'Share only with these Email domains',
                    "shareDomainIncExclusions"      => explode (",", $_POST['shareDomainIncExclusions']),
                    "allowEndUserTocontrolRestore"  => !empty($_POST['allowEndUserTocontrolRestore']) ? $_POST['allowEndUserTocontrolRestore'] : 'true',
                    "showShareLink"                 => $_POST['showShareLink'],
                    "userConsentEnabled"            => !empty($_POST['userConsentEnabled']) ? $_POST['userConsentEnabled'] : 'false',
                    "userConsentDisplayText"        => $_POST['userConsentDisplayText'],
                    "numberOfThreadsAllowedForBackup"   => $_POST['numberOfThreadsAllowedForBackup'],
                    "shareDomainsEnabled"           => $_POST['shareDomainsEnabled'],
                    "logUnaccessedFiles"            => $_POST['logUnaccessedFiles'],
                    "applyFilterToExceptionsToExclusion" => $applyFilterToExceptionsToExclusion
                );
                //if($_POST['defaultExclusionFolders'] != ''){
                $data = array_merge($data, array('excludedFolderpaths'=>$_POST['defaultExclusionFolders']));
                $data = array_merge($data, array('exceptionsToExclusions'=>$_POST['exceptionsToExclusions']));
                //}
                if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->savePolicyEdit($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4063')
                        );
                        echo json_encode($result);
                        exit();
		    case (400):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Bad Input'
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    /*public function saveOneDrivePolicy(){
        //Auth::allowOnly('admin');
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
        if(empty($_POST['maxVersions']) || $_POST['maxVersions'] == 'UNLIMITED'){
            $_POST['maxVersions'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSize']) || $_POST['maxPermissibleFileSize'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSize'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimit']) || $_POST['perUserBackupStorageLimit'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimit'] = "102400";
        }
        if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
        if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;

        }
        if(!empty($_POST)){
            $rules = array(
                'defaultFolders'            => 'required',
                'filesCrawlLimit'           => 'required',
                'incrementalFileTransfer'   => 'required',
                'machineMaxThreshold'       => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'perUserBackupStorageLimit' => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
                'defaultFolders'            => 'trim|sanitize_string',
                'filesCrawlLimit'           => 'trim|sanitize_string',
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'machineMaxThreshold'       => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'perUserBackupStorageLimit' => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

                //if($validate == true){
                if(true){
                    $headers = array(
                        'Content-Type'         => 'application/json',
                        'token'         => $this->session->get('token')
                    );

                $_POST['defaultFolders'] = explode(',^,',$_POST['defaultFolders']);
                foreach($_POST['defaultFolders'] as $value){
                     $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                     $value = str_replace('%E2%81%A9%2F', "/", $value);
                     $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                 }
                if($_POST['defaultExclusionFolders'] != ''){  
                $_POST['defaultExclusionFolders'] = explode(',^,',$_POST['defaultExclusionFolders']);
                foreach($_POST['defaultExclusionFolders'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['defaultExclusionFolders'] = [];
                }
                $_POST['pgList'] = explode(',',$_POST['pgList']);

                $privacyGatewayMappingElement = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['Blukryptipaddress']) ? $_POST['Blukryptipaddress'] : $list
                );

                $endpointUiPreferences = [];
                    if($_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }
                    if($_POST['decouple']=='true'){
                        array_push($endpointUiPreferences,'DECOUPLE');
                    }
                    if($_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT'); 
                    }
                    if($_POST['initiatebackup']=='true'){
                        array_push($endpointUiPreferences,'INTIATE_BACKUP');
                    }
                    if($_POST['restore']=='true'){
                        array_push($endpointUiPreferences,'RESTORE');
                    }
                    if($_POST['stopbackup']=='true'){
                        array_push($endpointUiPreferences,'STOP_BACKUP');
                    }
                    if($_POST['bkpsettings']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_SETTINGS');
                    }
                    if($_POST['bkpfiles']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_FILES');
                    }
                    if($_POST['refbkppolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_BACKUP_POLICY');
                    }
		            if($_POST['blockNotifications']=='true'){
                        array_push($endpointUiPreferences,'BLOCK_NOTIFICATIONS');
                    }
                    if($_POST['pauseBackup']=='true'){
                        array_push($endpointUiPreferences,'PAUSE_BACKUP');
                    }
                    if($_POST['about']=='true'){
                        array_push($endpointUiPreferences,'ABOUT');
                    }
                    if($_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }
                    if($_POST['systrayIcon']=='true'){
                        array_push($endpointUiPreferences,'SYSTRAYICON');
                    }

                if (strpos($_POST['policyRefresh'], ':') == false) {
                    $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                }

	            if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                   $_POST['nwFromClientToPGMB'] = 10000.0000;
                }
                else{
                    if($_POST['networkThrottlingUnit'] == "kbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
                    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
                    }
                    elseif($_POST['networkThrottlingUnit'] == "gbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
                    }
                    //$_POST['nwFromClientToPGMB'] = number_format($_POST['nwFromClientToPGMB'], 2);
                }
                $_POST['policyName'] = trim($_POST['policyName']);

                $arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
                    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }
                if(sizeof($_POST['deviceDeleted']) > 0){
                    $_POST['deviceDeleted'] = implode(",", $_POST['deviceDeleted']);
                    $_POST['deviceDeleted'] = rtrim($_POST['deviceDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDeleted' => $_POST['deviceDeleted']));
                }
                if(sizeof($_POST['deviceBlocked']) > 0){
                    $_POST['deviceBlocked'] = implode(",", $_POST['deviceBlocked']);
                    $_POST['deviceBlocked'] = rtrim($_POST['deviceBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('deviceBlocked' => $_POST['deviceBlocked']));
                }
                if(sizeof($_POST['deviceDecoupled']) > 0){
                    $_POST['deviceDecoupled'] = implode(",", $_POST['deviceDecoupled']);
                    $_POST['deviceDecoupled'] = rtrim($_POST['deviceDecoupled'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDecoupled' => $_POST['deviceDecoupled']));
                }
                if(sizeof($_POST['deviceLimitReached']) > 0){
                    $_POST['deviceLimitReached'] = implode(",", $_POST['deviceLimitReached']);
                    $_POST['deviceLimitReached'] = rtrim($_POST['deviceLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('deviceLimitReached' => $_POST['deviceLimitReached']));
                }
                if(sizeof($_POST['weeklyBkpreport']) > 0){
                    $_POST['weeklyBkpreport'] = implode(",", $_POST['weeklyBkpreport']);
                    $_POST['weeklyBkpreport'] = rtrim($_POST['weeklyBkpreport'], ", \t\n");
                    $arr = array_merge($arr, array('weeklyBkpreport' => $_POST['weeklyBkpreport']));
                }
                if(sizeof($_POST['firstBkpCompleted']) > 0){
                    $_POST['firstBkpCompleted'] = implode(",", $_POST['firstBkpCompleted']);
                    $_POST['firstBkpCompleted'] = rtrim($_POST['firstBkpCompleted'], ", \t\n");
                    $arr = array_merge($arr, array('firstBkpCompleted' => $_POST['firstBkpCompleted']));
                }
                if(sizeof($_POST['restoreInitiated']) > 0){
                    $_POST['restoreInitiated'] = implode(",", $_POST['restoreInitiated']);
                    $_POST['restoreInitiated'] = rtrim($_POST['restoreInitiated'], ", \t\n");
                    $arr = array_merge($arr, array('restoreInitiated' => $_POST['restoreInitiated']));
                }
                if(sizeof($_POST['storageLimitReached']) > 0){
                    $_POST['storageLimitReached'] = implode(",", $_POST['storageLimitReached']);
                    $_POST['storageLimitReached'] = rtrim($_POST['storageLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('storageLimitReached' => $_POST['storageLimitReached']));
                }
                
                $menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download']
                );

                $data = array(
                    "backupSystemFilesEnabled"      => $_POST['systemFolders'],
                    "legalHoldEnabled"              => $_POST['legalHold'],
                    "shareEnabled"                  => $_POST['Share'],
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPassword"               => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['complexPasswordRequired'],
                    "allowDownload"                 => ($_POST['highSecureShareEnabled'] == "true") ? false : $_POST['preventDownloadEnabled'],
                    "shareExpireDateEnable"         => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['expiredDate'],
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   => $_POST['description'],
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "dcmEnabled"                    => !empty($_POST['dcmEnabled']) ? ($_POST['dcmEnabled'] == 'true') ? true : false : false,
                    "destination"                   => !empty($_POST['backupDestination']) ? $_POST['backupDestination'] : '',
                    "backupFolderPaths"             => !empty($_POST['defaultFolders']) ? $_POST['defaultFolders'] : '',
                    "maxVersions"                   => !empty($_POST['maxVersions']) ? $_POST['maxVersions'] : '',
                    "maxFileSize"                   => !empty($_POST['maxPermissibleFileSize']) ? $_POST['maxPermissibleFileSize'] : '',
                    "osType"                        => !empty($_POST['osTyped']) ? $_POST['osTyped'] : '',
                    "officeProductType"                        => !empty($_POST['officeProductType']) ? $_POST['officeProductType'] : '',
                    "pftEnabled"                    => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
                    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
                    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
                    "fullBackupEnabled"             => !empty($_POST['fullBackupEnabled']) ? $_POST['fullBackupEnabled'] : false,
                    "fullBackupStartDate"           => !empty($_POST['fullBackupStartDate']) ? strtotime($_POST['fullBackupStartDate']) : '',
                    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
                    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
                    "nwFromClientToPG"              => $_POST['nwFromClientToPGMB'],
		            "nwFromClientToPGMB"            => $_POST['nwFromClientToPGMB'],
                    "filterInclusionName"           => !empty($_POST['filters']) ? $_POST['filters'] : '',
                    "searchFilterInclusionName"           => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : '',
                    'vssEnabled'                    => !empty($_POST['vssEnabled']) ? $_POST['vssEnabled'] : '',
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "scheduleNames"                 => !empty($_POST['schedules']) ? $_POST['schedules'] : '',
                    "userSizeAllowed"               => !empty($_POST['perUserBackupStorageLimit']) ? $_POST['perUserBackupStorageLimit'] : '',
                    "memoryUtilization"             => !empty($_POST['memoryUtilization']) ? $_POST['memoryUtilization'] : '',
                    "cpuUtilization"                => !empty($_POST['cpuUtilization']) ? $_POST['cpuUtilization'] : '',
                    "fullBackupSchedule"            => !empty($_POST['fullBackupPeriod']) ? $_POST['fullBackupPeriod'] : '',
                    "compressionEnabled"            => !empty($_POST['compEnabled']) ? $_POST['compEnabled'] : false,
                    "privacyGatewayMappingElement"  => $privacyGatewayMappingElement,
                    "endpointUiPreferences"         => $endpointUiPreferences,
                    "menuOptions"                   => $menuOptions,
                    "calloutScripts"                => $this->getAllScripts($this->serializeTheString($_POST['preBackupScripts']), $this->serializeTheString($_POST['postBackupScripts']), $this->serializeTheString($_POST['preRestoreScripts']), $this->serializeTheString($_POST['postRestoreScripts'])),
                    "crawlLimit"                    => !empty($_POST['filesCrawlLimit']) ? $_POST['filesCrawlLimit'] : 500,
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "canUserChangePassword" => $_POST['canUserChangePassword'],
                    "canAdminChangeUserPassword" => $_POST['canAdminChangeUserPassword'],
                    "downloadAgent"                  => !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "canBackupHiddenFiles"                  => !empty($_POST['canBackupHiddenFiles']) ? $_POST['canBackupHiddenFiles'] : 'false',
                    "searchAlgoForPg"               => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    "cpuThrottling"                 => $_POST['cpuThrottling'],
                    "daysToWaitForNextBackup"                 => $_POST['daysToWaitForNextBackup'],
                    "msAppBluKrypt"                 => $_POST['msAppBluKrypt'],
                    "webBasedLogin"                  => !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
                    'contentIndexEnabled'            => $_POST['contentIndexEnabled'],
                );
                //if($_POST['defaultExclusionFolders'] != ''){
                $data = array_merge($data, array('excludedFolderpaths'=>$_POST['defaultExclusionFolders']));
                //}
                if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->saveOneDrivePolicy($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4063')
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function saveOneDrivePolicyEdit(){
        //Auth::allowOnly('admin');
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
        if(empty($_POST['maxVersions']) || $_POST['maxVersions'] == 'UNLIMITED'){
            $_POST['maxVersions'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSize']) || $_POST['maxPermissibleFileSize'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSize'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimit']) || $_POST['perUserBackupStorageLimit'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimit'] = "102400";
        }
        if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
        if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;

        }
        if(!empty($_POST)){
            $rules = array(
                'defaultFolders'            => 'required',
                'filesCrawlLimit'           => 'required',
                'incrementalFileTransfer'   => 'required',
                'machineMaxThreshold'       => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'perUserBackupStorageLimit' => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
                'defaultFolders'            => 'trim|sanitize_string',
                'filesCrawlLimit'           => 'trim|sanitize_string',
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'machineMaxThreshold'       => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'perUserBackupStorageLimit' => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

                //if($validate == true){
                if(true){
                    $headers = array(
                        'Content-Type'         => 'application/json',
                        'token'         => $this->session->get('token')
                    );

                $_POST['defaultFolders'] = explode(',^,',$_POST['defaultFolders']);
                foreach($_POST['defaultFolders'] as $value){
                     $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                     $value = str_replace('%E2%81%A9%2F', "/", $value);
                     $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                 }
                if($_POST['defaultExclusionFolders'] != ''){  
                $_POST['defaultExclusionFolders'] = explode(',^,',$_POST['defaultExclusionFolders']);
                foreach($_POST['defaultExclusionFolders'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['defaultExclusionFolders'] = [];
                }
                $_POST['pgList'] = explode(',',$_POST['pgList']);

                $privacyGatewayMappingElement = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['Blukryptipaddress']) ? $_POST['Blukryptipaddress'] : $list
                );

                $endpointUiPreferences = [];
                    if($_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }
                    if($_POST['decouple']=='true'){
                        array_push($endpointUiPreferences,'DECOUPLE');
                    }
                    if($_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT'); 
                    }
                    if($_POST['initiatebackup']=='true'){
                        array_push($endpointUiPreferences,'INTIATE_BACKUP');
                    }
                    if($_POST['restore']=='true'){
                        array_push($endpointUiPreferences,'RESTORE');
                    }
                    if($_POST['stopbackup']=='true'){
                        array_push($endpointUiPreferences,'STOP_BACKUP');
                    }
                    if($_POST['bkpsettings']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_SETTINGS');
                    }
                    if($_POST['bkpfiles']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_FILES');
                    }
                    if($_POST['refbkppolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_BACKUP_POLICY');
                    }
		            if($_POST['blockNotifications']=='true'){
                        array_push($endpointUiPreferences,'BLOCK_NOTIFICATIONS');
                    }
                    if($_POST['pauseBackup']=='true'){
                        array_push($endpointUiPreferences,'PAUSE_BACKUP');
                    }
                    if($_POST['about']=='true'){
                        array_push($endpointUiPreferences,'ABOUT');
                    }
                    if($_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }
                    if($_POST['systrayIcon']=='true'){
                        array_push($endpointUiPreferences,'SYSTRAYICON');
                    }

                if (strpos($_POST['policyRefresh'], ':') == false) {
                    $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                }

	            if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                   $_POST['nwFromClientToPGMB'] = 10000.0000;
                }
                else{
                    if($_POST['networkThrottlingUnit'] == "kbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
                    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
                    }
                    elseif($_POST['networkThrottlingUnit'] == "gbps"){
                        $_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
                    }
                    //$_POST['nwFromClientToPGMB'] = number_format($_POST['nwFromClientToPGMB'], 2);
                }
                $_POST['policyName'] = trim($_POST['policyName']);
                
                $arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
                    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }
                if(sizeof($_POST['deviceDeleted']) > 0){
                    $_POST['deviceDeleted'] = implode(",", $_POST['deviceDeleted']);
                    $_POST['deviceDeleted'] = rtrim($_POST['deviceDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDeleted' => $_POST['deviceDeleted']));
                }
                if(sizeof($_POST['deviceBlocked']) > 0){
                    $_POST['deviceBlocked'] = implode(",", $_POST['deviceBlocked']);
                    $_POST['deviceBlocked'] = rtrim($_POST['deviceBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('deviceBlocked' => $_POST['deviceBlocked']));
                }
                if(sizeof($_POST['deviceDecoupled']) > 0){
                    $_POST['deviceDecoupled'] = implode(",", $_POST['deviceDecoupled']);
                    $_POST['deviceDecoupled'] = rtrim($_POST['deviceDecoupled'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDecoupled' => $_POST['deviceDecoupled']));
                }
                if(sizeof($_POST['deviceLimitReached']) > 0){
                    $_POST['deviceLimitReached'] = implode(",", $_POST['deviceLimitReached']);
                    $_POST['deviceLimitReached'] = rtrim($_POST['deviceLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('deviceLimitReached' => $_POST['deviceLimitReached']));
                }
                if(sizeof($_POST['weeklyBkpreport']) > 0){
                    $_POST['weeklyBkpreport'] = implode(",", $_POST['weeklyBkpreport']);
                    $_POST['weeklyBkpreport'] = rtrim($_POST['weeklyBkpreport'], ", \t\n");
                    $arr = array_merge($arr, array('weeklyBkpreport' => $_POST['weeklyBkpreport']));
                }
                if(sizeof($_POST['firstBkpCompleted']) > 0){
                    $_POST['firstBkpCompleted'] = implode(",", $_POST['firstBkpCompleted']);
                    $_POST['firstBkpCompleted'] = rtrim($_POST['firstBkpCompleted'], ", \t\n");
                    $arr = array_merge($arr, array('firstBkpCompleted' => $_POST['firstBkpCompleted']));
                }
                if(sizeof($_POST['restoreInitiated']) > 0){
                    $_POST['restoreInitiated'] = implode(",", $_POST['restoreInitiated']);
                    $_POST['restoreInitiated'] = rtrim($_POST['restoreInitiated'], ", \t\n");
                    $arr = array_merge($arr, array('restoreInitiated' => $_POST['restoreInitiated']));
                }
                if(sizeof($_POST['storageLimitReached']) > 0){
                    $_POST['storageLimitReached'] = implode(",", $_POST['storageLimitReached']);
                    $_POST['storageLimitReached'] = rtrim($_POST['storageLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('storageLimitReached' => $_POST['storageLimitReached']));
                }
                
                $menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download']
                );

                $data = array(
                    "backupSystemFilesEnabled"      => $_POST['systemFolders'],
                    "legalHoldEnabled"              => $_POST['legalHold'],
                    "shareEnabled"                  => $_POST['Share'],
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPassword"               => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['complexPasswordRequired'],
                    "allowDownload"                 => ($_POST['highSecureShareEnabled'] == "true") ? false : $_POST['preventDownloadEnabled'],
                    "shareExpireDateEnable"         => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['expiredDate'],
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   => $_POST['description'],
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "dcmEnabled"                    => !empty($_POST['dcmEnabled']) ? ($_POST['dcmEnabled'] == 'true') ? true : false : false,
                    "destination"                   => !empty($_POST['backupDestination']) ? $_POST['backupDestination'] : '',
                    "backupFolderPaths"             => !empty($_POST['defaultFolders']) ? $_POST['defaultFolders'] : '',
                    "maxVersions"                   => !empty($_POST['maxVersions']) ? $_POST['maxVersions'] : '',
                    "maxFileSize"                   => !empty($_POST['maxPermissibleFileSize']) ? $_POST['maxPermissibleFileSize'] : '',
                    "osType"                        => !empty($_POST['osTyped']) ? $_POST['osTyped'] : '',
                    "officeProductType"                        => !empty($_POST['officeProductType']) ? $_POST['officeProductType'] : '',
                    "pftEnabled"                    => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
                    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
                    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
                    "fullBackupEnabled"             => !empty($_POST['fullBackupEnabled']) ? $_POST['fullBackupEnabled'] : false,
                    "fullBackupStartDate"           => !empty($_POST['fullBackupStartDate']) ? strtotime($_POST['fullBackupStartDate']) : '',
                    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
                    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
                    "nwFromClientToPG"              => $_POST['nwFromClientToPGMB'],
		            "nwFromClientToPGMB"            => $_POST['nwFromClientToPGMB'],
                    "filterInclusionName"           => !empty($_POST['filters']) ? $_POST['filters'] : '',
                    "searchFilterInclusionName"           => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : '',
                    'vssEnabled'                    => !empty($_POST['vssEnabled']) ? $_POST['vssEnabled'] : '',
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "scheduleNames"                 => !empty($_POST['schedules']) ? $_POST['schedules'] : '',
                    "userSizeAllowed"               => !empty($_POST['perUserBackupStorageLimit']) ? $_POST['perUserBackupStorageLimit'] : '',
                    "memoryUtilization"             => !empty($_POST['memoryUtilization']) ? $_POST['memoryUtilization'] : '',
                    "cpuUtilization"                => !empty($_POST['cpuUtilization']) ? $_POST['cpuUtilization'] : '',
                    "fullBackupSchedule"            => !empty($_POST['fullBackupPeriod']) ? $_POST['fullBackupPeriod'] : '',
                    "compressionEnabled"            => !empty($_POST['compEnabled']) ? $_POST['compEnabled'] : false,
                    "privacyGatewayMappingElement"  => $privacyGatewayMappingElement,
                    "endpointUiPreferences"         => $endpointUiPreferences,
                    "menuOptions"                   => $menuOptions,
                    "calloutScripts"                => $this->getAllScripts($this->serializeTheString($_POST['preBackupScripts']), $this->serializeTheString($_POST['postBackupScripts']), $this->serializeTheString($_POST['preRestoreScripts']), $this->serializeTheString($_POST['postRestoreScripts'])),
                    "crawlLimit"                    => !empty($_POST['filesCrawlLimit']) ? $_POST['filesCrawlLimit'] : 500,
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "canUserChangePassword" => $_POST['canUserChangePassword'],
                    "canAdminChangeUserPassword" => $_POST['canAdminChangeUserPassword'],
                    "canBackupHiddenFiles"                  => !empty($_POST['canBackupHiddenFiles']) ? $_POST['canBackupHiddenFiles'] : 'false',
                    "downloadAgent"                  => !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "searchAlgoForPg"               => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    "cpuThrottling"                 => $_POST['cpuThrottling'],
                    "daysToWaitForNextBackup"                 => $_POST['daysToWaitForNextBackup'],
                    "msAppBluKrypt"                 => $_POST['msAppBluKrypt'],
                    "webBasedLogin"                  => !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
                    'contentIndexEnabled'            => $_POST['contentIndexEnabled'],
                );
                //if($_POST['defaultExclusionFolders'] != ''){
                $data = array_merge($data, array('excludedFolderpaths'=>$_POST['defaultExclusionFolders']));
                //}
                if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->saveOneDrivePolicyEdit($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4063')
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }*/
    
    public function saveOneDrivePolicy(){
        Auth::allowOnly('admin');
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
        if(empty($_POST['maxVersionsOdb']) || $_POST['maxVersionsOdb'] == 'UNLIMITED'){
            $_POST['maxVersionsOdb'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSizeOdb']) || $_POST['maxPermissibleFileSizeOdb'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSizeOdb'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimitOdb']) || $_POST['perUserBackupStorageLimitOdb'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimitOdb'] = "102400";
        }
        if(empty($_POST['maxVersionsMail']) || $_POST['maxVersionsMail'] == 'UNLIMITED'){
            $_POST['maxVersionsMail'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSizeMail']) || $_POST['maxPermissibleFileSizeMail'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSizeMail'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimitMail']) || $_POST['perUserBackupStorageLimitMail'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimitMail'] = "102400";
        }
        if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
	if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;
	}
	if(empty($_POST['purgeDeletedFilesOlderThan']) || $_POST['purgeDeletedFilesOlderThan'] == 'UNLIMITED'){
            $_POST['purgeDeletedFilesOlderThan'] = "-1";
        }
	if(empty($_POST['purgeDeletedMailsOlderThan']) || $_POST['purgeDeletedMailsOlderThan'] == 'UNLIMITED'){
            $_POST['purgeDeletedMailsOlderThan'] = "-1";
        }
	if(empty($_POST['deletedMailsOlderThan']) || $_POST['deletedMailsOlderThan'] == 'UNLIMITED'){
            $_POST['deletedMailsOlderThan'] = "-1";
        }
        if(!empty($_POST)){
            $rules = array(
                'defaultFolders'            => 'required',
                'filesCrawlLimit'           => 'required',
                'incrementalFileTransfer'   => 'required',
                'machineMaxThreshold'       => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'perUserBackupStorageLimit' => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
		'defaultFolders'            => 'trim|sanitize_string',
                'filesCrawlLimit'           => 'trim|sanitize_string',
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'machineMaxThreshold'       => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'perUserBackupStorageLimit' => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

                //if($validate == true){
                if(true){
                    $headers = array(
                        'Content-Type'         => 'application/json',
                        'token'         => $this->session->get('token')
                    );

                $_POST['defaultFoldersOdb'] = explode(',^,',$_POST['defaultFoldersOdb']);
		foreach($_POST['defaultFoldersOdb'] as $value){
                     $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                     $value = str_replace('%E2%81%A9%2F', "/", $value);
                     $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                 }
                if($_POST['defaultExclusionFoldersOdb'] != ''){
                $_POST['defaultExclusionFoldersOdb'] = explode(',^,',$_POST['defaultExclusionFoldersOdb']);
                foreach($_POST['defaultExclusionFoldersOdb'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['defaultExclusionFoldersOdb'] = [];
                }

		$_POST['defaultFoldersMail'] = explode(',^,',$_POST['defaultFoldersMail']);
		foreach($_POST['defaultFoldersMail'] as $value){
                     $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                     $value = str_replace('%E2%81%A9%2F', "/", $value);
                     $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                 }
                if($_POST['defaultExclusionFoldersMail'] != ''){
                $_POST['defaultExclusionFoldersMail'] = explode(',^,',$_POST['defaultExclusionFoldersMail']);
                foreach($_POST['defaultExclusionFoldersMail'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['defaultExclusionFoldersMail'] = [];
                }
                $_POST['pgList'] = explode(',',$_POST['pgList']);
                $privacyGatewayMappingElementOdb = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['BlukryptipaddressOdb']) ? $_POST['BlukryptipaddressOdb'] : $list
            	);
                $privacyGatewayMappingElementMail = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['BlukryptipaddressMail']) ? $_POST['BlukryptipaddressMail'] : $list
            	);

		$endpointUiPreferences = [];
                    $endpointDisabledUiPreferences = [];
		    if($_POST['bkpfiles']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_FILES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_FILES');
                    }
		    if($_POST['bkpsettings']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_SETTINGS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_SETTINGS');
                    }
		    if($_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT'); 
                    }else{
                        array_push($endpointDisabledUiPreferences,'SUPPORT');
                    }		    
		    if($_POST['restore']=='true'){
                        array_push($endpointUiPreferences,'RESTORE');
                    }else{
                        array_push($endpointDisabledUiPreferences,'RESTORE');
                    }
		    if($_POST['refbkppolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_BACKUP_POLICY');
                    }else{
                        array_push($endpointDisabledUiPreferences,'REFRESH_BACKUP_POLICY');
                    }
		    if($_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'UPDATE_AGENT');
                    }
                    if($_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'EXIT');
                    }
                    if (strpos($_POST['policyRefresh'], ':') == false) {
                    	$_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                    }
                    if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                   	$_POST['nwFromClientToPGMB'] = 10000.0000;
                    }else{
			    if($_POST['networkThrottlingUnit'] == "kbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
			    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
			    }
			    elseif($_POST['networkThrottlingUnit'] == "gbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
			    }
                    }
                $_POST['policyName'] = trim($_POST['policyName']);

                $arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
		    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }
                if(sizeof($_POST['deviceDeleted']) > 0){
                    $_POST['deviceDeleted'] = implode(",", $_POST['deviceDeleted']);
                    $_POST['deviceDeleted'] = rtrim($_POST['deviceDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDeleted' => $_POST['deviceDeleted']));
                }
                if(sizeof($_POST['deviceBlocked']) > 0){
                    $_POST['deviceBlocked'] = implode(",", $_POST['deviceBlocked']);
                    $_POST['deviceBlocked'] = rtrim($_POST['deviceBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('deviceBlocked' => $_POST['deviceBlocked']));
                }
                if(sizeof($_POST['deviceDecoupled']) > 0){
                    $_POST['deviceDecoupled'] = implode(",", $_POST['deviceDecoupled']);
                    $_POST['deviceDecoupled'] = rtrim($_POST['deviceDecoupled'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDecoupled' => $_POST['deviceDecoupled']));
                }
                if(sizeof($_POST['deviceLimitReached']) > 0){
                    $_POST['deviceLimitReached'] = implode(",", $_POST['deviceLimitReached']);
                    $_POST['deviceLimitReached'] = rtrim($_POST['deviceLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('deviceLimitReached' => $_POST['deviceLimitReached']));
                }
                if(sizeof($_POST['weeklyBkpreport']) > 0){
		    $_POST['weeklyBkpreport'] = implode(",", $_POST['weeklyBkpreport']);
                    $_POST['weeklyBkpreport'] = rtrim($_POST['weeklyBkpreport'], ", \t\n");
                    $arr = array_merge($arr, array('weeklyBkpreport' => $_POST['weeklyBkpreport']));
                }
                if(sizeof($_POST['firstBkpCompleted']) > 0){
                    $_POST['firstBkpCompleted'] = implode(",", $_POST['firstBkpCompleted']);
                    $_POST['firstBkpCompleted'] = rtrim($_POST['firstBkpCompleted'], ", \t\n");
                    $arr = array_merge($arr, array('firstBkpCompleted' => $_POST['firstBkpCompleted']));
                }
                if(sizeof($_POST['restoreInitiated']) > 0){
                    $_POST['restoreInitiated'] = implode(",", $_POST['restoreInitiated']);
                    $_POST['restoreInitiated'] = rtrim($_POST['restoreInitiated'], ", \t\n");
                    $arr = array_merge($arr, array('restoreInitiated' => $_POST['restoreInitiated']));
                }
                if(sizeof($_POST['storageLimitReached']) > 0){
                    $_POST['storageLimitReached'] = implode(",", $_POST['storageLimitReached']);
                    $_POST['storageLimitReached'] = rtrim($_POST['storageLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('storageLimitReached' => $_POST['storageLimitReached']));
                }

                $menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download'],
		    "restore" => $_POST['portalRestore']
	    	);

		if($_POST['switchAllowedDomains'] == 'on'){
                    $_POST['switchAllowedDomains'] = 'true';
                }else{
                    $_POST['switchAllowedDomains'] = 'false';
                }
		if(empty($_POST['highSecureShareEnabled']) || $_POST['highSecureShareEnabled'] != 'enabled'){
            		$_POST['highSecureShareEnabled'] = 'false';
        	}else{
            		$_POST['highSecureShareEnabled'] = 'true';
        	}
		if($_POST['controllerCP'] == 'true'){
                    $_POST['complexPasswordRequired'] = 'true';
                }else{
                    $_POST['complexPasswordRequired'] = 'false';
                }
		if($_POST['controllerAD'] == 'true'){
                    $_POST['preventDownloadEnabled'] = 'true';
                }else{
                    $_POST['preventDownloadEnabled'] = 'false';
                }
		if($_POST['controllerED'] == 'true'){
                    $_POST['expiredDate'] = 'true';
                }else{
                    $_POST['expiredDate'] = 'false';
                }
		if($_POST['controllerMFA'] == 'true'){
                    $_POST['googleAuth'] = 'true';
                }else{
                    $_POST['googleAuth'] = 'false';
                }
		$arrFil = array();
                if(!empty($_POST['from'])){
			if(is_array($_POST['from'])){
				$_POST['from'] = implode(",", $_POST['from']);
			}
                	$_POST['from'] = rtrim($_POST['from'], ", \t\n");
                	$arrFil = array_merge($arrFil, array('from' => $_POST['from']));
                }else{
                        $arrFil = array_merge($arrFil, array('from' => ''));
                }
		if(!empty($_POST['to'])){
			if(is_array($_POST['to'])){
				$_POST['to'] = implode(",", $_POST['to']);
			}
			$_POST['to'] = rtrim($_POST['to'], ", \t\n");
			$arrFil = array_merge($arrFil, array('to' => $_POST['to']));
                }else{
                        $arrFil = array_merge($arrFil, array('to' => ''));
                }
                if(!empty($_POST['subject'])){
			if(is_array($_POST['subject'])){
				$_POST['subject'] = implode(",", $_POST['subject']);
			}
			$_POST['subject'] = rtrim($_POST['subject'], ", \t\n");
			$arrFil = array_merge($arrFil, array('subject' => $_POST['subject']));
                }else{
                        $arrFil = array_merge($arrFil, array('subject' => ''));
                }
		$createLinkEnabled = false;
		if(empty($_POST['createLinkEnabled']) || $_POST['createLinkEnabled'] != 'enabled'){
            		$createLinkEnabled = 'false';
        	}else{
            		$createLinkEnabled = 'true';
        	}
		$createMailLinkEnabled = false;
                if($_POST['createMailLinkEnabled']=='true'){
                        $createMailLinkEnabled = true;
                }
                $data = array(
                    "backupSystemFilesEnabled"      => $_POST['systemFolders'],
                    "legalHoldEnabled"              => $_POST['legalHold'],
                    "shareEnabled"                  => $_POST['Share'],
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPassword"               => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['complexPasswordRequired'],
		    "allowDownload"                 => ($_POST['highSecureShareEnabled'] == "true") ? false : $_POST['preventDownloadEnabled'],
                    "shareExpireDateEnable"         => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['expiredDate'],
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   => $_POST['description'],
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "destination"                   => !empty($_POST['backupDestination']) ? $_POST['backupDestination'] : '',
                    "odBackupFolderPaths"           => !empty($_POST['defaultFoldersOdb']) ? $_POST['defaultFoldersOdb'] : '',
		    "mailBackupFolderPaths"         => !empty($_POST['defaultFoldersMail']) ? $_POST['defaultFoldersMail'] : '',
                    "odMaxVersions"                 => !empty($_POST['maxVersionsOdb']) ? $_POST['maxVersionsOdb'] : '',
                    "odMaxFileSize"                 => !empty($_POST['maxPermissibleFileSizeOdb']) ? $_POST['maxPermissibleFileSizeOdb'] : '',
                    "odUserSizeAllowed"             => !empty($_POST['perUserBackupStorageLimitOdb']) ? $_POST['perUserBackupStorageLimitOdb'] : '',
                    "mailMaxVersions"               => !empty($_POST['maxVersionsMail']) ? $_POST['maxVersionsMail'] : '',
                    "mailMaxFileSize"               => !empty($_POST['maxPermissibleFileSizeMail']) ? $_POST['maxPermissibleFileSizeMail'] : '',
                    "mailUserSizeAllowed"           => !empty($_POST['perUserBackupStorageLimitMail']) ? $_POST['perUserBackupStorageLimitMail'] : '',
                    "osType"                        => !empty($_POST['osTyped']) ? $_POST['osTyped'] : '',
                    "odFilterInclusionName"         => !empty($_POST['filtersOdb']) ? $_POST['filtersOdb'] : [],
		    "mailFilterInclusionName"       => !empty($_POST['filtersMail']) ? $_POST['filtersMail'] : [],
		    "searchFilterInclusionName"     => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : [],
                    'vssEnabled'                    => !empty($_POST['vssEnabled']) ? $_POST['vssEnabled'] : '',
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "odScheduleNames"               => !empty($_POST['schedulesOdb']) ? $_POST['schedulesOdb'] : '',
                    "mailScheduleNames"             => !empty($_POST['schedulesMail']) ? $_POST['schedulesMail'] : '',
                    "fullBackupSchedule"            => !empty($_POST['fullBackupPeriod']) ? $_POST['fullBackupPeriod'] : '',
                    "odPrivacyGatewayMappingElement"  => $privacyGatewayMappingElementOdb,
		    "mailPrivacyGatewayMappingElement" => $privacyGatewayMappingElementMail,
                    "endpointUiPreferences"         => $endpointUiPreferences,
                    "endpointDisabledUiPreferences" => $endpointDisabledUiPreferences,
                    "menuOptions"                   => $menuOptions,
                    "calloutScripts"                => $this->getAllScripts($this->serializeTheString($_POST['preBackupScripts']), $this->serializeTheString($_POST['postBackupScripts']), $this->serializeTheString($_POST['preRestoreScripts']), $this->serializeTheString($_POST['postRestoreScripts'])),
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "downloadAgent"                 => !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "canBackupHiddenFiles"          => !empty($_POST['canBackupHiddenFiles']) ? $_POST['canBackupHiddenFiles'] : 'false',
                    "searchAlgoForPg"               => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    "cpuThrottling"                 => $_POST['cpuThrottling'],
                    "daysToWaitForNextBackup"       => $_POST['daysToWaitForNextBackup'],
                    "odMsAppBluKrypt"               => $_POST['msAppBluKryptOdb'],
                    "mailMsAppBluKrypt"             => $_POST['msAppBluKryptMail'],
                    "webBasedLogin"                 => !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
		    'contentIndexEnabled'           => $_POST['contentIndexEnabled'],
		    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
		    "isPftEnabled"                  => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
		    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
		    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
		    "nwFromClientToPG"              => $_POST['nwFromClientToPGMB'],
		    "nwFromClientToPGMB"            => $_POST['nwFromClientToPGMB'],
		    "fullBackupEnabled"             => !empty($_POST['fullBackupEnabled']) ? $_POST['fullBackupEnabled'] : false,
		    "fullBackupStartDate"           => !empty($_POST['fullBackupStartDate']) ? strtotime($_POST['fullBackupStartDate']) : '',
		    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
		    "canUserChangePassword" => $_POST['canUserChangePassword'],
		    "canAdminChangeUserPassword" => $_POST['canAdminChangeUserPassword'],
		    "canAdminRestore"               => !empty($_POST['canAdminRestore']) ? $_POST['canAdminRestore'] : 'true',
		    "canAdminDelete"                => !empty($_POST['canAdminDelete']) ? $_POST['canAdminDelete'] : 'true',
		    "endpointDomainCheck"      	    => $_POST['switchAllowedDomains'],
		    "allowedDomains"                => $_POST['allowedDomains'],
		    "purgeDeletedFilesOlderThan"    => $_POST['purgeDeletedFilesOlderThan'],
		    "purgeDeletedMailsOlderThan"    => $_POST['purgeDeletedMailsOlderThan'],
		    "deletedMailsOlderThan"         => $_POST['deletedMailsOlderThan'],
		    "inPlaceMailArchiveEnabled"     => $_POST['isInPlaceMailArchiveEnabled'],
		    "contactsEnabled"    	    => $_POST['isContactsEnabled'],
		    "tasksEnabled"    		    => $_POST['isTasksEnabled'],
		    "odFilterType"  		    => $_POST['odFilterType'],
		    "mailFilterType" 		    => $_POST['mailFilterType'],
		    "searchFilterType" 		    => $_POST['searchFilterType'],
		    "noOfDevicesAllowed"            => $_POST['noOfDevicesAllowed'],
		    "threshholdLimit"               => $_POST['threshholdLimit'],
		    "purgeFilesOlderThan"           => $_POST['purgeFilesOlderThan'],
		    "purgeFilesSizeGTThan"          => $_POST['purgeFilesSizeGTThan'],
		    "createLinkEnabled" 	    => $createLinkEnabled,
		    "createMailLinkEnabled"	    => $createMailLinkEnabled
                );
		//if($_POST['defaultExclusionFolders'] != ''){
		$data = array_merge($data, array('excludedOdFolderpaths'=>$_POST['defaultExclusionFoldersOdb']));
                $data = array_merge($data, array('excludedMailFolderpaths'=>$_POST['defaultExclusionFoldersMail']));
                //}
                if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
		$data = array_merge($data, array('outlookFilters'=>$arrFil));
                $this->log('Policy Details: '. json_encode($data), 'info');
		$result = $this->_model->saveOneDrivePolicy($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
			$response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4063')
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
);
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
}
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveOneDrivePolicyEdit(){
        Auth::allowOnly('admin');
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
        if(empty($_POST['maxVersionsOdb']) || $_POST['maxVersionsOdb'] == 'UNLIMITED'){
            $_POST['maxVersionsOdb'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSizeOdb']) || $_POST['maxPermissibleFileSizeOdb'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSizeOdb'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimitOdb']) || $_POST['perUserBackupStorageLimitOdb'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimitOdb'] = "102400";
        }
        if(empty($_POST['maxVersionsMail']) || $_POST['maxVersionsMail'] == 'UNLIMITED'){
            $_POST['maxVersionsMail'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSizeMail']) || $_POST['maxPermissibleFileSizeMail'] == 'UNLIMITED'){
            $_POST['maxPermissibleFileSizeMail'] = "1048576";
        }
        if(empty($_POST['perUserBackupStorageLimitMail']) || $_POST['perUserBackupStorageLimitMail'] == 'UNLIMITED'){
            $_POST['perUserBackupStorageLimitMail'] = "102400";
        }
        if(empty($_POST['nwFromClientToPG']) || $_POST['nwFromClientToPG'] == 'UNLIMITED'){
            $_POST['nwFromClientToPG'] = "10000";
        }
	if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'UNLIMITED'){
            $_POST['machineMaxThreshold'] = 100;
        }
        if(!empty($_POST)){
            $rules = array(
                'defaultFolders'            => 'required',
                'filesCrawlLimit'           => 'required',
                'incrementalFileTransfer'   => 'required',
                'machineMaxThreshold'       => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'perUserBackupStorageLimit' => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                //'filters'                   => 'required'
            );
            $filters = array(
		'defaultFolders'            => 'trim|sanitize_string',
                'filesCrawlLimit'           => 'trim|sanitize_string',
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'machineMaxThreshold'       => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'perUserBackupStorageLimit' => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                //'filters'                   => 'trim|sanitize_string'
            );
            //$filteredData = $this->valid->filter($_POST, $filters);
            //$validate = $this->valid->validate($filteredData, $rules);

                //if($validate == true){
                if(true){
                    $headers = array(
                        'Content-Type'         => 'application/json',
                        'token'         => $this->session->get('token')
                    );

                $_POST['defaultFoldersOdb'] = explode(',^,',$_POST['defaultFoldersOdb']);
		foreach($_POST['defaultFoldersOdb'] as $value){
                     $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                     $value = str_replace('%E2%81%A9%2F', "/", $value);
                     $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                 }
                if($_POST['defaultExclusionFoldersOdb'] != ''){
                $_POST['defaultExclusionFoldersOdb'] = explode(',^,',$_POST['defaultExclusionFoldersOdb']);
                foreach($_POST['defaultExclusionFoldersOdb'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['defaultExclusionFoldersOdb'] = [];
                }

		$_POST['defaultFoldersMail'] = explode(',^,',$_POST['defaultFoldersMail']);
		foreach($_POST['defaultFoldersMail'] as $value){
                     $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                     $value = str_replace('%E2%81%A9%2F', "/", $value);
                     $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                 }
                if($_POST['defaultExclusionFoldersMail'] != ''){
                $_POST['defaultExclusionFoldersMail'] = explode(',^,',$_POST['defaultExclusionFoldersMail']);
                foreach($_POST['defaultExclusionFoldersMail'] as $value){
                         $value = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $value);
                         $value = str_replace('%E2%81%A9%2F', "/", $value);
                         $this->log("kkkkkkkkkkkk : ".urldecode($value),"info");
                     }
                }else{
                    $_POST['defaultExclusionFoldersMail'] = [];
                }
                $_POST['pgList'] = explode(',',$_POST['pgList']);

                $privacyGatewayMappingElementOdb = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['BlukryptipaddressOdb']) ? $_POST['BlukryptipaddressOdb'] : $list
            	);
                $privacyGatewayMappingElementMail = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['BlukryptipaddressMail']) ? $_POST['BlukryptipaddressMail'] : $list
            	);
		$endpointUiPreferences = [];
                    $endpointDisabledUiPreferences = [];
		    if($_POST['bkpfiles']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_FILES');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_FILES');
                    }
		    if($_POST['bkpsettings']=='true'){
                        array_push($endpointUiPreferences,'BACKUP_SETTINGS');
                    }else{
                        array_push($endpointDisabledUiPreferences,'BACKUP_SETTINGS');
                    }
		    if($_POST['support']=='true'){
                        array_push($endpointUiPreferences,'SUPPORT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'SUPPORT');
                    }		    
		    if($_POST['restore']=='true'){
                        array_push($endpointUiPreferences,'RESTORE');
                    }else{
                        array_push($endpointDisabledUiPreferences,'RESTORE');
                    }
		    if($_POST['refbkppolicy']=='true'){
                        array_push($endpointUiPreferences,'REFRESH_BACKUP_POLICY');
                    }else{
                        array_push($endpointDisabledUiPreferences,'REFRESH_BACKUP_POLICY');
                    }
		    if($_POST['updateAgent']=='true'){
                        array_push($endpointUiPreferences,'UPDATE_AGENT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'UPDATE_AGENT');
                    }
                    if($_POST['exitt']=='true'){
                        array_push($endpointUiPreferences,'EXIT');
                    }else{
                        array_push($endpointDisabledUiPreferences,'EXIT');
                    }
                    if(strpos($_POST['policyRefresh'], ':') == false) {
                    	$_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                    }
                    if(empty($_POST['nwFromClientToPGMB']) || $_POST['nwFromClientToPGMB'] == 'UNLIMITED'){
                   	$_POST['nwFromClientToPGMB'] = 10000.0000;
                    } else{
			    if($_POST['networkThrottlingUnit'] == "kbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']/1024, 4);
			    }elseif($_POST['networkThrottlingUnit'] == "mbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB'], 4);
			    }
			    elseif($_POST['networkThrottlingUnit'] == "gbps"){
				$_POST['nwFromClientToPGMB'] = round($_POST['nwFromClientToPGMB']*1024, 4);
			    }
                    }
                $_POST['policyName'] = trim($_POST['policyName']);

                $arr = array();
                if(sizeof($_POST['createUser']) > 0){
                    $_POST['createUser'] = implode(",", $_POST['createUser']);
                    $_POST['createUser'] = rtrim($_POST['createUser'], ", \t\n");
                    $arr = array_merge($arr, array('createUser' => $_POST['createUser']));
                }
                if(sizeof($_POST['userDeleted']) > 0){
                    $_POST['userDeleted'] = implode(",", $_POST['userDeleted']);
                    $_POST['userDeleted'] = rtrim($_POST['userDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('userDeleted' => $_POST['userDeleted']));
                }
                if(sizeof($_POST['userBlocked']) > 0){
		    $_POST['userBlocked'] = implode(",", $_POST['userBlocked']);
                    $_POST['userBlocked'] = rtrim($_POST['userBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('userBlocked' => $_POST['userBlocked']));
                }
                if(sizeof($_POST['userLimitReached']) > 0){
                    $_POST['userLimitReached'] = implode(",", $_POST['userLimitReached']);
                    $_POST['userLimitReached'] = rtrim($_POST['userLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('userLimitReached' => $_POST['userLimitReached']));
                }
                if(sizeof($_POST['deviceDeleted']) > 0){
                    $_POST['deviceDeleted'] = implode(",", $_POST['deviceDeleted']);
                    $_POST['deviceDeleted'] = rtrim($_POST['deviceDeleted'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDeleted' => $_POST['deviceDeleted']));
                }
                if(sizeof($_POST['deviceBlocked']) > 0){
                    $_POST['deviceBlocked'] = implode(",", $_POST['deviceBlocked']);
                    $_POST['deviceBlocked'] = rtrim($_POST['deviceBlocked'], ", \t\n");
                    $arr = array_merge($arr, array('deviceBlocked' => $_POST['deviceBlocked']));
                }
                if(sizeof($_POST['deviceDecoupled']) > 0){
                    $_POST['deviceDecoupled'] = implode(",", $_POST['deviceDecoupled']);
                    $_POST['deviceDecoupled'] = rtrim($_POST['deviceDecoupled'], ", \t\n");
                    $arr = array_merge($arr, array('deviceDecoupled' => $_POST['deviceDecoupled']));
                }
                if(sizeof($_POST['deviceLimitReached']) > 0){
                    $_POST['deviceLimitReached'] = implode(",", $_POST['deviceLimitReached']);
                    $_POST['deviceLimitReached'] = rtrim($_POST['deviceLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('deviceLimitReached' => $_POST['deviceLimitReached']));
                }
                if(sizeof($_POST['weeklyBkpreport']) > 0){
		    $_POST['weeklyBkpreport'] = implode(",", $_POST['weeklyBkpreport']);
                    $_POST['weeklyBkpreport'] = rtrim($_POST['weeklyBkpreport'], ", \t\n");
                    $arr = array_merge($arr, array('weeklyBkpreport' => $_POST['weeklyBkpreport']));
                }
                if(sizeof($_POST['firstBkpCompleted']) > 0){
                    $_POST['firstBkpCompleted'] = implode(",", $_POST['firstBkpCompleted']);
                    $_POST['firstBkpCompleted'] = rtrim($_POST['firstBkpCompleted'], ", \t\n");
                    $arr = array_merge($arr, array('firstBkpCompleted' => $_POST['firstBkpCompleted']));
                }
                if(sizeof($_POST['restoreInitiated']) > 0){
                    $_POST['restoreInitiated'] = implode(",", $_POST['restoreInitiated']);
                    $_POST['restoreInitiated'] = rtrim($_POST['restoreInitiated'], ", \t\n");
                    $arr = array_merge($arr, array('restoreInitiated' => $_POST['restoreInitiated']));
                }
                if(sizeof($_POST['storageLimitReached']) > 0){
                    $_POST['storageLimitReached'] = implode(",", $_POST['storageLimitReached']);
                    $_POST['storageLimitReached'] = rtrim($_POST['storageLimitReached'], ", \t\n");
                    $arr = array_merge($arr, array('storageLimitReached' => $_POST['storageLimitReached']));
		}
		if(empty($_POST['purgeDeletedFilesOlderThan']) || $_POST['purgeDeletedFilesOlderThan'] == 'UNLIMITED'){
            		$_POST['purgeDeletedFilesOlderThan'] = "-1";
        	}
		if(empty($_POST['purgeDeletedMailsOlderThan']) || $_POST['purgeDeletedMailsOlderThan'] == 'UNLIMITED'){
            		$_POST['purgeDeletedMailsOlderThan'] = "-1";
        	}
		if(empty($_POST['deletedMailsOlderThan']) || $_POST['deletedMailsOlderThan'] == 'UNLIMITED'){
            		$_POST['deletedMailsOlderThan'] = "-1";
        	}
                $menuOptions = array(
                    "open" => $_POST['Open'],
                    "view" => $_POST['View'],
                    "versions" => $_POST['Versions'],
                    "share" => $_POST['Share'],
                    "download" => $_POST['Download'],
		    "restore" => $_POST['portalRestore']
	    	);
		if($_POST['switchAllowedDomains'] == 'on'){
                    $_POST['switchAllowedDomains'] = 'true';
                }else{
                    $_POST['switchAllowedDomains'] = 'false';
                }			
		if(empty($_POST['highSecureShareEnabled']) || $_POST['highSecureShareEnabled'] != 'enabled'){
            		$_POST['highSecureShareEnabled'] = 'false';
        	}else{
            		$_POST['highSecureShareEnabled'] = 'true';
        	}
		if($_POST['controllerCP'] == 'true'){
                    $_POST['complexPasswordRequired'] = 'true';
                }else{
                    $_POST['complexPasswordRequired'] = 'false';
                }
		if($_POST['controllerAD'] == 'true'){
                    $_POST['preventDownloadEnabled'] = 'true';
                }else{
                    $_POST['preventDownloadEnabled'] = 'false';
                }
		if($_POST['controllerED'] == 'true'){
                    $_POST['expiredDate'] = 'true';
                }else{
                    $_POST['expiredDate'] = 'false';
                }
		if($_POST['controllerMFA'] == 'true'){
                    $_POST['googleAuth'] = 'true';
                }else{
                    $_POST['googleAuth'] = 'false';
                }
		$arrFil = array();
                if(!empty($_POST['from'])){
			if(is_array($_POST['from'])){
				$_POST['from'] = implode(",", $_POST['from']);
			}
                	$_POST['from'] = rtrim($_POST['from'], ", \t\n");
                	$arrFil = array_merge($arrFil, array('from' => $_POST['from']));
                }else{
                        $arrFil = array_merge($arrFil, array('from' => ''));
                }
		if(!empty($_POST['to'])){
			if(is_array($_POST['to'])){
				$_POST['to'] = implode(",", $_POST['to']);
			}
			$_POST['to'] = rtrim($_POST['to'], ", \t\n");
			$arrFil = array_merge($arrFil, array('to' => $_POST['to']));
                }else{
                        $arrFil = array_merge($arrFil, array('to' => ''));
                }
                if(!empty($_POST['subject'])){
			if(is_array($_POST['subject'])){
				$_POST['subject'] = implode(",", $_POST['subject']);
			}
			$_POST['subject'] = rtrim($_POST['subject'], ", \t\n");
			$arrFil = array_merge($arrFil, array('subject' => $_POST['subject']));
                }else{
                        $arrFil = array_merge($arrFil, array('subject' => ''));
                }
		$createLinkEnabled = false;
		if(empty($_POST['createLinkEnabled']) || $_POST['createLinkEnabled'] != 'enabled'){
            		$createLinkEnabled = 'false';
        	}else{
            		$createLinkEnabled = 'true';
        	}
		$createMailLinkEnabled = false;
                if($_POST['createMailLinkEnabled']=='true'){
                        $createMailLinkEnabled = true;
                }
                $data = array(
                    "backupSystemFilesEnabled"      => $_POST['systemFolders'],
                    "legalHoldEnabled"              => $_POST['legalHold'],
                    "shareEnabled"                  => $_POST['Share'],
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPassword"               => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['complexPasswordRequired'],
		    "allowDownload"                 => ($_POST['highSecureShareEnabled'] == "true") ? false : $_POST['preventDownloadEnabled'],
                    "shareExpireDateEnable"         => ($_POST['highSecureShareEnabled'] == "true") ? true : $_POST['expiredDate'],
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "description"                   => $_POST['description'],
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "destination"                   => !empty($_POST['backupDestination']) ? $_POST['backupDestination'] : '',
                    "odBackupFolderPaths"           => !empty($_POST['defaultFoldersOdb']) ? $_POST['defaultFoldersOdb'] : '',
		    "mailBackupFolderPaths"         => !empty($_POST['defaultFoldersMail']) ? $_POST['defaultFoldersMail'] : '',
                    "odMaxVersions"                 => !empty($_POST['maxVersionsOdb']) ? $_POST['maxVersionsOdb'] : '',
                    "odMaxFileSize"                 => !empty($_POST['maxPermissibleFileSizeOdb']) ? $_POST['maxPermissibleFileSizeOdb'] : '',
                    "odUserSizeAllowed"             => !empty($_POST['perUserBackupStorageLimitOdb']) ? $_POST['perUserBackupStorageLimitOdb'] : '',
                    "mailMaxVersions"               => !empty($_POST['maxVersionsMail']) ? $_POST['maxVersionsMail'] : '',
                    "mailMaxFileSize"               => !empty($_POST['maxPermissibleFileSizeMail']) ? $_POST['maxPermissibleFileSizeMail'] : '',
                    "mailUserSizeAllowed"           => !empty($_POST['perUserBackupStorageLimitMail']) ? $_POST['perUserBackupStorageLimitMail'] : '',
                    "osType"                        => !empty($_POST['osTyped']) ? $_POST['osTyped'] : '',
                    "odFilterInclusionName"         => !empty($_POST['filtersOdb']) ? $_POST['filtersOdb'] : [],
		    "mailFilterInclusionName"       => !empty($_POST['filtersMail']) ? $_POST['filtersMail'] : [],
		    "searchFilterInclusionName"     => !empty($_POST['searchfilters']) ? $_POST['searchfilters'] : [],
                    'vssEnabled'                    => !empty($_POST['vssEnabled']) ? $_POST['vssEnabled'] : '',
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "odScheduleNames"               => !empty($_POST['schedulesOdb']) ? $_POST['schedulesOdb'] : '',
                    "mailScheduleNames"             => !empty($_POST['schedulesMail']) ? $_POST['schedulesMail'] : '',
                    "fullBackupSchedule"            => !empty($_POST['fullBackupPeriod']) ? $_POST['fullBackupPeriod'] : '',
                    "odPrivacyGatewayMappingElement"  => $privacyGatewayMappingElementOdb,
		    "mailPrivacyGatewayMappingElement" => $privacyGatewayMappingElementMail,
                    "endpointUiPreferences"         => $endpointUiPreferences,
                    "endpointDisabledUiPreferences" => $endpointDisabledUiPreferences,
                    "menuOptions"                   => $menuOptions,
                    "calloutScripts"                => $this->getAllScripts($this->serializeTheString($_POST['preBackupScripts']), $this->serializeTheString($_POST['postBackupScripts']), $this->serializeTheString($_POST['preRestoreScripts']), $this->serializeTheString($_POST['postRestoreScripts'])),
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
                    "downloadAgent"                 => !empty($_POST['downloadAgent']) ? $_POST['downloadAgent'] : 'false',
                    "canBackupHiddenFiles"          => !empty($_POST['canBackupHiddenFiles']) ? $_POST['canBackupHiddenFiles'] : 'false',
                    "searchAlgoForPg"               => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                    "cpuThrottling"                 => $_POST['cpuThrottling'],
                    "daysToWaitForNextBackup"       => $_POST['daysToWaitForNextBackup'],
                    "odMsAppBluKrypt"               => $_POST['msAppBluKryptOdb'],
                    "mailMsAppBluKrypt"             => $_POST['msAppBluKryptMail'],
                    "webBasedLogin"                 => !empty($_POST['webBasedLogin']) ? $_POST['webBasedLogin'] : 'true',
		    'contentIndexEnabled'           => $_POST['contentIndexEnabled'],
		    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
		    "isPftEnabled"                  => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
		    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
		    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
		    "nwFromClientToPG"              => $_POST['nwFromClientToPGMB'],
		    "nwFromClientToPGMB"            => $_POST['nwFromClientToPGMB'],
		    "fullBackupEnabled"             => !empty($_POST['fullBackupEnabled']) ? $_POST['fullBackupEnabled'] : false,
		    "fullBackupStartDate"           => !empty($_POST['fullBackupStartDate']) ? strtotime($_POST['fullBackupStartDate']) : '',
		    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
		    "canUserChangePassword" 	    => $_POST['canUserChangePassword'],
		    "canAdminChangeUserPassword"    => $_POST['canAdminChangeUserPassword'],
		    "canAdminRestore"               => !empty($_POST['canAdminRestore']) ? $_POST['canAdminRestore'] : 'true',
		    "canAdminDelete"                => !empty($_POST['canAdminDelete']) ? $_POST['canAdminDelete'] : 'true',
		    "endpointDomainCheck"      	    => $_POST['switchAllowedDomains'],
		    "allowedDomains"                => $_POST['allowedDomains'],
		    "purgeDeletedFilesOlderThan"    => $_POST['purgeDeletedFilesOlderThan'],
		    "purgeDeletedMailsOlderThan"    => $_POST['purgeDeletedMailsOlderThan'],
		    "deletedMailsOlderThan"    	    => $_POST['deletedMailsOlderThan'],
		    "inPlaceMailArchiveEnabled"     => $_POST['isInPlaceMailArchiveEnabled'],
		    "contactsEnabled"    	    => $_POST['isContactsEnabled'],
		    "tasksEnabled"    		    => $_POST['isTasksEnabled'],
		    "odFilterType"  		    => $_POST['odFilterType'],
		    "mailFilterType" 		    => $_POST['mailFilterType'],
		    "searchFilterType" 		    => $_POST['searchFilterType'],
		    "noOfDevicesAllowed"            => $_POST['noOfDevicesAllowed'],
		    "threshholdLimit"               => $_POST['threshholdLimit'],
		    "purgeFilesOlderThan"           => $_POST['purgeFilesOlderThan'],
		    "purgeFilesSizeGTThan"          => $_POST['purgeFilesSizeGTThan'],
		    "createLinkEnabled" 	    => $createLinkEnabled,
		    "createMailLinkEnabled"	    => $createMailLinkEnabled
                );
                //if($_POST['defaultExclusionFolders'] != ''){
		$data = array_merge($data, array('excludedOdFolderpaths'=>$_POST['defaultExclusionFoldersOdb']));
		$data = array_merge($data, array('excludedMailFolderpaths'=>$_POST['defaultExclusionFoldersMail']));
                //}
                if(sizeof($arr) >0){
                   $data = array_merge($data, array('emailsRestriction'=>$arr));
                }
		$data = array_merge($data, array('outlookFilters'=>$arrFil));
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->saveOneDrivePolicyEdit($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        if($this->session->get('policyName') == $_POST['policyName']){
                            $isDownloadAgent = $_POST['downloadAgent'];
                            $this->session->put('isDownloadAgent',$isDownloadAgent);
                        }
			$response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4063')
                        );
                        echo json_encode($result);
                        exit();
                    case (331):
                        $result = array(
                            'result' => 'fail',
                            'msg' => 'Policy with same name exists and is blocked'
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
);
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
}
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function serializeTheString($oneBigStrings){
        if(!empty($oneBigStrings)){
            $strings = explode('^', $oneBigStrings);
            $array = array();
            foreach($strings as $string){
                list($scriptName, $scriptArgs, $backupType) = explode('|', $string);
                $scriptArray = array(
                    'scriptName' => $scriptName,
                    'backupType' => $backupType,
                    'scriptArgs' => explode(',', $scriptArgs)
                );
                $array = array_merge(array($scriptArray), $array);
            }
            return $array;
        }else{
            return null;
        }
    }

    public function getAllScripts($preBackup, $postBackup, $preRestore, $postRestore){
        $data = [];
        if(!empty($preBackup)){
            foreach($preBackup as $value){
                if($value['backupType'] == 'f'){
                    $preOne = $value['scriptName'].'|preBackupF|'.implode(',',$value['scriptArgs']);
                }else{
                    $preOne = $value['scriptName'].'|preBackupI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($preOne), $data);
            }
        }
        if(!empty($postBackup)){
            foreach($postBackup as $value){
                if($value['backupType'] == 'f'){
                    $postOne = $value['scriptName'].'|postBackupF|'.implode(',',$value['scriptArgs']);
                }else{
                    $postOne = $value['scriptName'].'|postBackupI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($postOne), $data);
            }
        }
        if(!empty($preRestore)){
            foreach($preRestore as $value){
                if($value['backupType'] == 'f'){
                    $preOne = $value['scriptName'].'|preRestoreF|'.implode(',',$value['scriptArgs']);
                }else{
                    $preOne = $value['scriptName'].'|preRestoreI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($preOne), $data);
            }
        }
        if(!empty($postRestore)){
            foreach($postRestore as $value){
                if($value['backupType'] == 'f'){
                    $postOne = $value['scriptName'].'|postRestoreF|'.implode(',',$value['scriptArgs']);
                }else{
                    $postOne = $value['scriptName'].'|postRestoreI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($postOne), $data);
            }
        }
        return $data;
    }
    
    public function clonePolicy($policyName){
        Auth::allowOnly('readOnlyAdmin');
        $this->session->put('selectedPolicyName', $policyName);
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$overridePolicySettings = $cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'};
	$showUserConsentFieldInPolicies = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserConsentFieldInPolicies'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
                    
        $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => (Auth::checkCloudPermission('serverBackup') == true) ? $this->language->get('sPolicy') : $this->language->get('bPolicy'),
            'crumb2' => $this->language->get('edit'),
            'active' => 'pms',
            'schedules' => array_reverse($schedules),
            'filters' => array_reverse($filters),
            'sch1' => $sch1,
            'fil1' => $fil1,
            'filCanned' => $filCanned,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
            'pgs' => $pgs,
            'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'ccS' => array_reverse($ccS),
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
            'canAdminRestoreAll' => $canAdminRestoreAll,
	    'canAdminDelete' => $canAdminDelete,
            'searchEnabled' => $searchEnabled,
	    'overridePolicySettings' => $overridePolicySettings,
	    'showUserConsentFieldInPolicies' => $showUserConsentFieldInPolicies,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('isSQLBkpEnabled') == 'true'){
        	$data['isSQLBkpEnabled'] = 'true';
        }else{
        	$data['isSQLBkpEnabled'] = 'false';
	}

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        if(Auth::checkCloudPermission('serverBackup')){
            View::render('pms/serverPolicy/clone', $data);
        }else{
            View::render('pms/policy/clone', $data);
        }
        View::renderTemplate('footer', $data);
    }
    
    public function cloneOneDrivePolicy($policyName){
        Auth::allowOnly('readOnlyAdmin');
        $this->session->put('selectedOneDrivePolicyName', $policyName);
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $cons = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $controllerResult = $this->_model->getBlukryptSettings($headers);
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
	$canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }
        
        if($controllerResult['body']->{'MSAppBluKryptElementList'}){
            foreach($controllerResult['body']->{'MSAppBluKryptElementList'} as $key => $value){
                $con = array(
                    'host' => (string)$value->{'host'}
                );
                $cons = array_merge(array($con), $cons);
                
            }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
        $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Office 365 Policy',
            'crumb2' => $this->language->get('edit'),
            'active' => 'pms',
            'schedules' => array_reverse($schedules),
            'filters' => array_reverse($filters),
            'sch1' => $sch1,
            'fil1' => $fil1,
            'filCanned' => $filCanned,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
	    'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'pgs' => $pgs,
            'cons' => $cons,
            'ccS' => array_reverse($ccS),
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
	    'canAdminRestoreAll' => $canAdminRestoreAll,
	    'canAdminDelete' => $canAdminDelete,
            'searchEnabled' => $searchEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('one_drive_backup_enabled') == "true"){
        	$data['onedriveBackupEnabled'] = 'true';
        }else{
                $data['onedriveBackupEnabled'] = 'false';
        }
        if($this->session->get('exchange_backup_enabled') == "true"){
                $data['exchangeBackupEnabled'] = 'true';
        }else{
                $data['exchangeBackupEnabled'] = 'false';
        }
	if($this->session->get('oneDriveArchivingEnabled') == "true"){
                $data['oneDriveArchivingEnabled'] = 'true';
        }else{
                $data['oneDriveArchivingEnabled'] = 'false';
        }
	if($this->session->get('mailArchivingEnabled') == "true"){
                $data['mailArchivingEnabled'] = 'true';
        }else{
                $data['mailArchivingEnabled'] = 'false';
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        if(Auth::checkCloudPermission('serverBackup')){
            View::render('pms/serverPolicy/clone', $data);
        }else{
            View::render('pms/oneDrivePolicy/clone', $data);
        }
        View::renderTemplate('footer', $data);
    }

    public function editPolicy($policyName){
        Auth::allowOnly('readOnlyAdmin');
        $this->session->put('selectedPolicyName', $policyName);
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$overridePolicySettings = $cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'};
	$showUserConsentFieldInPolicies = $cloudProperties['body']->{'cloudPropertyElement'}->{'showUserConsentFieldInPolicies'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                  if((string)$value->{'productType'} != 'blusync'){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
            }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
        $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => (Auth::checkCloudPermission('serverBackup') == true) ? $this->language->get('sPolicy') : $this->language->get('bPolicy'),
            'crumb2' => $this->language->get('edit'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'sch1' => $sch1,
            'fil1' => $fil1,
            'filCanned' => $filCanned,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
            'canAdminRestoreAll' => $canAdminRestoreAll,
	    'canAdminDelete' => $canAdminDelete,
            'searchEnabled' => $searchEnabled,
	    'overridePolicySettings' => $overridePolicySettings,
	    'showUserConsentFieldInPolicies' => $showUserConsentFieldInPolicies,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('isSQLBkpEnabled') == 'true'){
        	$data['isSQLBkpEnabled'] = 'true';
        }else{
        	$data['isSQLBkpEnabled'] = 'false';
	}

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        if(Auth::checkCloudPermission('serverBackup')){
            View::render('pms/serverPolicy/edit', $data);
        }else{
            View::render('pms/policy/edit', $data);
        }
        View::renderTemplate('footer', $data);
    }
    
    public function editOneDrivePolicy($policyName){
        Auth::allowOnly('readOnlyAdmin');
         $this->session->put('selectedOneDrivePolicyName', $policyName);
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $cons = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $filtersResultCanned = $this->_model->getCannedFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $controllerResult = $this->_model->getBlukryptSettings($headers);
        $canUserChangePassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canUserChangePassword'};
        $canAdminChangeUserPassword = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminChangeUserPassword'};
	$canAdminRestoreAll = $cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'};
	$canAdminDelete = $cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'};
        $passwordChangeEnforce = $cloudProperties['body']->{'cloudPropertyElement'}->{'passwordChangeEnforce'};
        $searchEnabled = $cloudProperties['body']->{'cloudPropertyElement'}->{'searchEnabled'};
	$noOfDevicesAllowed = $cloudProperties['body']->{'cloudPropertyElement'}->{'noOfDevicesAllowed'};

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }
        
        $sch1 = [];
        foreach((array)$schedulesResult['body']->{'scheduleElementList'} as $value){
            $sc = (string)$value->{'scheduleName'};
            $sch1 = array_merge(array($sc), $sch1);
        }

        $fil1 = [];
        foreach((array)$filtersResult['body']->{'inclusionFilterElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $fil1 = array_merge(array($fi), $fil1);
        }

        natcasesort($sch1);
        natcasesort($fil1);

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                  if((string)$value->{'productType'} != 'blusync'){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
            }
        }
        
        if($controllerResult['body']->{'MSAppBluKryptElementList'}){
            foreach($controllerResult['body']->{'MSAppBluKryptElementList'} as $key => $value){
                $con = array(
                    'host' => (string)$value->{'host'}
                );
                $cons = array_merge(array($con), $cons);
                
            }
        }
        
        $IncFilters = [];
        $ExcFilters = [];
            if($filtersResult['body']->{'inclusionFilterElementList'}){
                        foreach($filtersResult['body']->{'inclusionFilterElementList'} as $value){
                            if((string)$value->{'filterType'} == "inclusion"){
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                                $IncFilters = array_merge(array($filter), $IncFilters);
                            }else{
                                $filter = array(
                                    'filters' => (string)$value->{'filters'},
                                    'filterName' => (string)$value->{'filterName'},
                                    'filterType' => (string)$value->{'filterType'},
                                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                                );
//                            $filters = array_merge(array($filter), $filters);
                            $ExcFilters = array_merge(array($filter), $ExcFilters);
                            }
                        }
                    }
        $filCanned = [];
        foreach((array)$filtersResultCanned['body']->{'filterTemplateElementList'} as $value){
            $fi = (string)$value->{'filterName'};
            $filCanned = array_merge(array($fi), $filCanned);
        }

        natcasesort($filCanned);                    

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Office 365 Policy',
            'crumb2' => $this->language->get('edit'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'sch1' => $sch1,
            'fil1' => $fil1,
            'filCanned' => $filCanned,
            'IncFilters' => $IncFilters,
            'ExcFilters' => $ExcFilters,
	    'noOfDevicesAllowed' => $noOfDevicesAllowed,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'cons' => $cons,
            'passwordChangeEnforce' => $passwordChangeEnforce,
            'canUserChangePassword' =>  $canUserChangePassword,
            'canAdminChangeUserPassword' => $canAdminChangeUserPassword,
	    'canAdminRestoreAll' => $canAdminRestoreAll,
	    'canAdminDelete' => $canAdminDelete,
            'searchEnabled' => $searchEnabled,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
	    
	if($this->session->get('one_drive_backup_enabled') == "true"){
        	$data['onedriveBackupEnabled'] = 'true';
        }else{
                $data['onedriveBackupEnabled'] = 'false';
        }
        if($this->session->get('exchange_backup_enabled') == "true"){
                $data['exchangeBackupEnabled'] = 'true';
        }else{
                $data['exchangeBackupEnabled'] = 'false';
        }
	if($this->session->get('oneDriveArchivingEnabled') == "true"){
                $data['oneDriveArchivingEnabled'] = 'true';
        }else{
                $data['oneDriveArchivingEnabled'] = 'false';
        }
	if($this->session->get('mailArchivingEnabled') == "true"){
                $data['mailArchivingEnabled'] = 'true';
        }else{
                $data['mailArchivingEnabled'] = 'false';
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        if(Auth::checkCloudPermission('serverBackup')){
            View::render('pms/serverPolicy/edit', $data);
        }else{
            View::render('pms/oneDrivePolicy/edit', $data);
        }
        View::renderTemplate('footer', $data);
    }

    public function getPolicy(){
        //Auth::allowOnly('admin');
        $policyName = !empty($this->session->get('selectedPolicyName')) ? $this->session->get('selectedPolicyName') : $this->session->get('policyName');
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getPolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'backupPolicyElement'};
                    $nwFromClientToPGMB = round($result['body']->{'backupPolicyElement'}->{'nwFromClientToPGMB'}, 4);
                    $unit = "mbps";
                    if($nwFromClientToPGMB < 1){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB*1024, 0);
                        $unit = "kbps";
                    }
                    elseif($nwFromClientToPGMB > 1024 && $nwFromClientToPGMB == 10000){
                        $nwFromClientToPGMB = "UNLIMITED";
                        $unit = "mbps";
                    }
                    elseif($nwFromClientToPGMB > 1024){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB/1024, 0);
                        $unit = "gbps";
                    }
                    else{
                        $nwFromClientToPGMB = round($nwFromClientToPGMB, 0);
                    }
		    if(!empty($value->{'shareDomainIncExclusions'})){
                        $value->{'shareDomainIncExclusions'} = implode (",", $value->{'shareDomainIncExclusions'});
                    }
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
			'sqlbkpEnabled' => $value->{'sqlbkpEnabled'},
                        'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => !empty($value->{'excludedFolderpaths'}) ? (array)$value->{'excludedFolderpaths'} : [],
                        'exceptionsToExclusions' => !empty($value->{'exceptionsToExclusions'}) ? (array)$value->{'exceptionsToExclusions'} : [],
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'description' => !empty($value->{'description'}) ? (string)$value->{'description'} : '',
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'clientDedup' => (string)$value->{'clientDedup'},
                        'maxFileSizeForBkpBatch' => (string)$value->{'maxFileSizeForBkpBatch'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
			'nwFromClientToPGMB'    => $nwFromClientToPGMB,
                        'unit'                  => $unit,
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (array)$value->{'filterInclusionName'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
//                        'lmts' => !empty($value->{'lmts'}) ? (string)$value->{'lmts'} : '',
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (boolean)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (boolean)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (boolean)$value->{'highSecureShareEnabled'},
			'googleAuth' => (boolean)$value->{'googleAuth'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
                        'emailsRestriction' => (array)$value->{'emailsRestriction'},
                        'canBackupHiddenFiles' => (boolean)$value->{'canBackupHiddenFiles'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                        //'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'endpointUiPreferences' => (array)$value->{'endpointUiPreferences'},
                        'endpointDisabledUiPreferences' => (array)$value->{'endpointDisabledUiPreferences'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'cpuThrottling' => $value->{'cpuThrottling'},
                        'daysToWaitForNextBackup' => !empty($value->{'daysToWaitForNextBackup'}) ? (string)$value->{'daysToWaitForNextBackup'} : 0,
                        'noOfDevicesAllowed' => !empty($value->{'noOfDevicesAllowed'}) ? $value->{'noOfDevicesAllowed'} : 0,
                        'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
                        'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
			'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
                        'noOfDaysToKeepDeviceNotHeard' => (string)$value->{'noOfDaysToKeepDeviceNotHeard'},
                        'noOfDaysToKeepDeletedFiles' => (string)$value->{'noOfDaysToKeepDeletedFiles'},
			'allowedDomains' => !empty($value->{'allowedDomains'}) ? $value->{'allowedDomains'} : '',
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'filterType' => (string)$value->{'filterType'},
			'searchFilterType' => (string)$value->{'searchFilterType'},
			'preScanCommand' => !empty($value->{'preScanCommand'}) ? (string)$value->{'preScanCommand'} : '',
                        'preBackupCommand' => !empty($value->{'preBackupCommand'}) ? (string)$value->{'preBackupCommand'} : '',
                        'postBackupCommand' => !empty($value->{'postBackupCommand'}) ? (string)$value->{'postBackupCommand'} : '',
                        'continueOnPreScan' => !empty($value->{'continueOnPreScan'}) ? (boolean)$value->{'continueOnPreScan'} : false,
                        'continueOnPreBkp' => !empty($value->{'continueOnPreBkp'}) ? (boolean)$value->{'continueOnPreBkp'} : false,
                        'continueOnPostBkp' => !empty($value->{'continueOnPostBkp'}) ? (boolean)$value->{'continueOnPostBkp'} : false,
			'preScanCommandEnabled' => (boolean)$value->{'preScanCommandEnabled'},
			'preBackupCommandEnabled' => (boolean)$value->{'preBackupCommandEnabled'},
			'postBackupCommandEnabled' => (boolean)$value->{'postBackupCommandEnabled'},
			'agentPassword' => !empty($value->{'agentPassword'}) ? $value->{'agentPassword'} : '',
                        'switchAgentPassword' => !empty($value->{'switchAgentPassword'}) ? (boolean)$value->{'switchAgentPassword'} : false,
                        'shareDomainType' => !empty($value->{'shareDomainType'}) ? $value->{'shareDomainType'} : 'Share only with these Email domains',
                        'shareDomainIncExclusions' => !empty($value->{'shareDomainIncExclusions'}) ? $value->{'shareDomainIncExclusions'} : '',
                        'allowEndUserTocontrolRestore' => !empty($value->{'allowEndUserTocontrolRestore'}) ? (boolean)$value->{'allowEndUserTocontrolRestore'} : false,

			'showShareLink'   => (boolean)$value->{'showShareLink'},
			'userConsentEnabled' => !empty($value->{'userConsentEnabled'}) ? (boolean)$value->{'userConsentEnabled'} : false,
                        'userConsentDisplayText' => !empty($value->{'userConsentDisplayText'}) ? $value->{'userConsentDisplayText'} : '',
			'numberOfThreadsAllowedForBackup' => $value->{'numberOfThreadsAllowedForBackup'},
			'shareDomainsEnabled' => !empty($value->{'shareDomainsEnabled'}) ? (boolean)$value->{'shareDomainsEnabled'} : false,
			'logUnaccessedFiles' => (boolean)$value->{'logUnaccessedFiles'},
			'applyFilterToExceptionsToExclusion' => !empty($value->{'applyFilterToExceptionsToExclusion'}) ? (boolean)$value->{'applyFilterToExceptionsToExclusion'} : false
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    /*public function getOneDrivePolicy(){
        //Auth::allowOnly('admin');
        $policyName = !empty($this->session->get('selectedOneDrivePolicyName')) ? $this->session->get('selectedOneDrivePolicyName') : $this->session->get('selectedOneDrivePolicyName');
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getOneDrivePolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'ODBBackupPolicyElement'};
                    $nwFromClientToPGMB = round($result['body']->{'ODBBackupPolicyElement'}->{'nwFromClientToPGMB'}, 4);
                    $unit = "mbps";
                    if($nwFromClientToPGMB < 1){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB*1024, 0);
                        $unit = "kbps";
                    }
                    elseif($nwFromClientToPGMB > 1024 && $nwFromClientToPGMB == 10000){
                        $nwFromClientToPGMB = "UNLIMITED";
                        $unit = "mbps";
                    }
                    elseif($nwFromClientToPGMB > 1024){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB/1024, 0);
                        $unit = "gbps";
                    }
                    else{
                        $nwFromClientToPGMB = round($nwFromClientToPGMB, 0);
                    }
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                        'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => (array)$value->{'excludedFolderpaths'},
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'description' => (string)$value->{'description'},
                        'officeProductType' => (string)$value->{'officeProductType'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
			            'nwFromClientToPGMB'    => $nwFromClientToPGMB,
                        'unit'                  => $unit,
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (array)$value->{'filterInclusionName'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'lmts' => (string)$value->{'lmts'},
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (boolean)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (boolean)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (boolean)$value->{'highSecureShareEnabled'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
                        'emailsRestriction' => (array)$value->{'emailsRestriction'},
                        'canBackupHiddenFiles' => (boolean)$value->{'canBackupHiddenFiles'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                         'canUserChangePassword' => $value->{'canUserChangePassword'},
                         'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'endpointUiPreferences' => (array)$value->{'endpointUiPreferences'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'cpuThrottling' => $value->{'cpuThrottling'},
                        'msAppBluKrypt' => (string)$value->{'msAppBluKrypt'},
                        'daysToWaitForNextBackup' => (string)$value->{'daysToWaitForNextBackup'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }*/
    
    public function getOneDrivePolicy(){
        //Auth::allowOnly('admin');
        $policyName = !empty($this->session->get('selectedOneDrivePolicyName')) ? $this->session->get('selectedOneDrivePolicyName') : $this->session->get('selectedOneDrivePolicyName');
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getOneDrivePolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'officeBackupPolicyElement'};
                    $nwFromClientToPGMB = round($result['body']->{'officeBackupPolicyElement'}->{'nwFromClientToPGMB'}, 4);
                    $unit = "mbps";
                    if($nwFromClientToPGMB < 1){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB*1024, 0);
                        $unit = "kbps";
                    }
                    elseif($nwFromClientToPGMB > 1024 && $nwFromClientToPGMB == 10000){
                        $nwFromClientToPGMB = "UNLIMITED";
                        $unit = "mbps";
                    }
                    elseif($nwFromClientToPGMB > 1024){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB/1024, 0);
                        $unit = "gbps";
                    }
                    else{
                        $nwFromClientToPGMB = round($nwFromClientToPGMB, 0);
                    }
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                        'backupFolderPathsOdb' => (array)$value->{'odBackupFolderPaths'},
                        'userExcludedFolderpathsOdb' => (array)$value->{'excludedOdFolderpaths'},
			'backupFolderPathsMail' => (array)$value->{'mailBackupFolderPaths'},
                        'userExcludedFolderpathsMail' => (array)$value->{'excludedMailFolderpaths'},
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'description' => (string)$value->{'description'},
                        'officeProductType' => (string)$value->{'officeProductType'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
			'nwFromClientToPGMB'    => $nwFromClientToPGMB,
                        'unit'                  => $unit,
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionNameOdb' => (array)$value->{'odFilterInclusionName'},
			'filterInclusionNameMail' => (array)$value->{'mailFilterInclusionName'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'lmts' => (string)$value->{'lmts'},
                        'maxVersionsOdb' => (string)$value->{'odMaxVersions'},
			'maxFileSizeOdb' => (string)$value->{'odMaxFileSize'},
			'userSizeAllowedOdb' => (string)$value->{'odUserSizeAllowed'},
			'maxVersionsMail' => (string)$value->{'mailMaxVersions'},
			'maxFileSizeMail' => (string)$value->{'mailMaxFileSize'},
			'userSizeAllowedMail' => (string)$value->{'mailUserSizeAllowed'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (boolean)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (boolean)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (boolean)$value->{'highSecureShareEnabled'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElementOdb' => (array)$value->{'odPrivacyGatewayMappingElement'},
			'privacyGatewayMappingElementMail' => (array)$value->{'mailPrivacyGatewayMappingElement'},
                        'scheduleNamesOdb' => (array)$value->{'odScheduleNames'},
			'scheduleNamesMail' => (array)$value->{'mailScheduleNames'},
                        'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
                        'emailsRestriction' => (array)$value->{'emailsRestriction'},
			'outlookFilters' => (array)$value->{'outlookFilters'},
                        'canBackupHiddenFiles' => (boolean)$value->{'canBackupHiddenFiles'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                         'canUserChangePassword' => $value->{'canUserChangePassword'},
                         'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'endpointUiPreferences' => (array)$value->{'endpointUiPreferences'},
			'endpointDisabledUiPreferences' => (array)$value->{'endpointDisabledUiPreferences'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'cpuThrottling' => $value->{'cpuThrottling'},
                        'msAppBluKryptOdb' => (string)$value->{'odMsAppBluKrypt'},
			'msAppBluKryptMail' => (string)$value->{'mailMsAppBluKrypt'},
                        'daysToWaitForNextBackup' => (string)$value->{'daysToWaitForNextBackup'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
			'purgeDeletedFilesOlderThan' => $value->{'purgeDeletedFilesOlderThan'},
			'purgeDeletedMailsOlderThan' => $value->{'purgeDeletedMailsOlderThan'},
			'deletedMailsOlderThan' => $value->{'deletedMailsOlderThan'},
			'allowedDomains' => $value->{'allowedDomains'},
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
			'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
			'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
			'isInPlaceMailArchiveEnabled' => (boolean)$value->{'inPlaceMailArchiveEnabled'},
			'isContactsEnabled' => (boolean)$value->{'contactsEnabled'},
			'isTasksEnabled' => (boolean)$value->{'tasksEnabled'},
			'odFilterType'  =>      (string)$value->{'odFilterType'},
                        'mailFilterType' => (string)$value->{'mailFilterType'},
			'searchFilterType' => (string)$value->{'searchFilterType'},
			'noOfDevicesAllowed' => $value->{'noOfDevicesAllowed'},
			'threshholdLimit' => $value->{'threshholdLimit'},
			'purgeFilesOlderThan' => $value->{'purgeFilesOlderThan'},
			'purgeFilesSizeGTThan' => $value->{'purgeFilesSizeGTThan'},
			'createLinkEnabled' => (boolean)$value->{'createLinkEnabled'},
			'createMailLinkEnabled' => (boolean)$value->{'createMailLinkEnabled'}
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function viewPolicy(){
        //Auth::allowOnly('admin');
        $policyName = $_POST['policyName'];
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getPolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $value = $result['body']->{'backupPolicyElement'};
                    $nwFromClientToPGMB = round($result['body']->{'backupPolicyElement'}->{'nwFromClientToPGMB'}, 4);
                    $unit = "mbps";
                    if($nwFromClientToPGMB < 1){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB*1024, 0);
                        $unit = "kbps";
                    }
                    elseif($nwFromClientToPGMB > 1024 && $nwFromClientToPGMB == 10000){
                        $nwFromClientToPGMB = "UNLIMITED";
                        $unit = "mbps";
                    }
                    elseif($nwFromClientToPGMB > 1024){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB/1024, 0);
                        $unit = "gbps";
                    }
                    else{
                        $nwFromClientToPGMB = round($nwFromClientToPGMB, 0);
                    }
		    if(!empty($value->{'shareDomainIncExclusions'})){
                        $value->{'shareDomainIncExclusions'} = implode (",", $value->{'shareDomainIncExclusions'});
                    }
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                        'sqlbkpEnabled' => $value->{'sqlbkpEnabled'},
                        'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => !empty($value->{'excludedFolderpaths'}) ? (array)$value->{'excludedFolderpaths'} : [],
                        'exceptionsToExclusions' => !empty($value->{'exceptionsToExclusions'}) ? (array)$value->{'exceptionsToExclusions'} : [],
                        'description' => !empty($value->{'description'}) ? (string)$value->{'description'} : '',
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'clientDedup' => (string)$value->{'clientDedup'},
                        'maxFileSizeForBkpBatch' => (string)$value->{'maxFileSizeForBkpBatch'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                        'nwFromClientToPGMB'    => $nwFromClientToPGMB,
                        'unit'                  => $unit,
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (array)$value->{'filterInclusionName'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        //'lmts' => (string)$value->{'lmts'},
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (boolean)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (boolean)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (boolean)$value->{'highSecureShareEnabled'},
                        'googleAuth' => (boolean)$value->{'googleAuth'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
			'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
//                        'cloudCredentialName' => (string)$value->{'cloudCredentialName'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
                        'emailsRestriction' => (array)$value->{'emailsRestriction'},
                        'canBackupHiddenFiles' => (boolean)$value->{'canBackupHiddenFiles'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
//                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'endpointUiPreferences' => (array)$value->{'endpointUiPreferences'},
                        'endpointDisabledUiPreferences' => (array)$value->{'endpointDisabledUiPreferences'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'cpuThrottling' => $value->{'cpuThrottling'},
                        'daysToWaitForNextBackup' => !empty($value->{'daysToWaitForNextBackup'}) ? (string)$value->{'daysToWaitForNextBackup'} : 0,
                        'noOfDevicesAllowed' => !empty($value->{'noOfDevicesAllowed'}) ? $value->{'noOfDevicesAllowed'} : 0,
                        'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
                        'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
                        'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
			'noOfDaysToKeepDeviceNotHeard' => (string)$value->{'noOfDaysToKeepDeviceNotHeard'},
                        'noOfDaysToKeepDeletedFiles' => (string)$value->{'noOfDaysToKeepDeletedFiles'},
                        'allowedDomains' => !empty($value->{'allowedDomains'}) ? $value->{'allowedDomains'} : '',
                        'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
                        'filterType' => (string)$value->{'filterType'},
                        'searchFilterType' => (string)$value->{'searchFilterType'},
                        'preScanCommand' => !empty($value->{'preScanCommand'}) ? (string)$value->{'preScanCommand'} : '',
                        'preBackupCommand' => !empty($value->{'preBackupCommand'}) ? (string)$value->{'preBackupCommand'} : '',
                        'postBackupCommand' => !empty($value->{'postBackupCommand'}) ? (string)$value->{'postBackupCommand'} : '',
                        'continueOnPreScan' => !empty($value->{'continueOnPreScan'}) ? (boolean)$value->{'continueOnPreScan'} : false,
                        'continueOnPreBkp' => !empty($value->{'continueOnPreBkp'}) ? (boolean)$value->{'continueOnPreBkp'} : false,
                        'continueOnPostBkp' => !empty($value->{'continueOnPostBkp'}) ? (boolean)$value->{'continueOnPostBkp'} : false,
                        'preScanCommandEnabled' => (boolean)$value->{'preScanCommandEnabled'},
                        'preBackupCommandEnabled' => (boolean)$value->{'preBackupCommandEnabled'},
                        'postBackupCommandEnabled' => (boolean)$value->{'postBackupCommandEnabled'},
                        'agentPassword' => !empty($value->{'agentPassword'}) ? $value->{'agentPassword'} : '',
                        'switchAgentPassword' => !empty($value->{'switchAgentPassword'}) ? (boolean)$value->{'switchAgentPassword'} : false,
                        'shareDomainType' => !empty($value->{'shareDomainType'}) ? $value->{'shareDomainType'} : 'Share only with these Email domains',
                        'shareDomainIncExclusions' => !empty($value->{'shareDomainIncExclusions'}) ? $value->{'shareDomainIncExclusions'} : '',
                        'allowEndUserTocontrolRestore' => !empty($value->{'allowEndUserTocontrolRestore'}) ? (boolean)$value->{'allowEndUserTocontrolRestore'} : false,
                        'showShareLink'   => (boolean)$value->{'showShareLink'},
			'userConsentEnabled' => !empty($value->{'userConsentEnabled'}) ? (boolean)$value->{'userConsentEnabled'} : false,
                        'userConsentDisplayText' => !empty($value->{'userConsentDisplayText'}) ? $value->{'userConsentDisplayText'} : '',
                        'numberOfThreadsAllowedForBackup' => $value->{'numberOfThreadsAllowedForBackup'},
                        'shareDomainsEnabled' => !empty($value->{'shareDomainsEnabled'}) ? (boolean)$value->{'shareDomainsEnabled'} : false,
                        'active' => (boolean)$value->{'active'},
                        'logUnaccessedFiles' => (boolean)$value->{'logUnaccessedFiles'},
                        'applyFilterToExceptionsToExclusion' => !empty($value->{'applyFilterToExceptionsToExclusion'}) ? (boolean)$value->{'applyFilterToExceptionsToExclusion'} : false
                    );
                    $this->log("PFTTTTTT : ".json_encode($policy['highSecureShareEnabled']),"info");
                    $response = array(
                        'result' => 'success',
                        'policy' => $policy,
                    );
                    echo json_encode($response);
                    exit();
                case (421):
                    $msg = $this->language->get('421');
                    exit();
                case (500):
                    $msg = $this->language->get('500');
                    exit();
                case (0):
                    $msg = $this->language->get('0');
                    exit();
                default:
                    $msg = $this->language->get('default');
                    exit();
            }
            $result = array(
                        'result' => 'fail',
                        'msg' => $msg
                    );
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function viewOneDrivePolicy(){
        //Auth::allowOnly('admin');
        $policyName = $_POST['policyName'];
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getOneDrivePolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $value = $result['body']->{'officeBackupPolicyElement'};
                    $nwFromClientToPGMB = round($result['body']->{'officeBackupPolicyElement'}->{'nwFromClientToPGMB'}, 4);
                    $unit = "mbps";
                    if($nwFromClientToPGMB < 1){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB*1024, 0);
                        $unit = "kbps";
                    }
                    elseif($nwFromClientToPGMB > 1024 && $nwFromClientToPGMB == 10000){
                        $nwFromClientToPGMB = "UNLIMITED";
                        $unit = "mbps";
                    }
                    elseif($nwFromClientToPGMB > 1024){
                        $nwFromClientToPGMB = round($nwFromClientToPGMB/1024, 0);
                        $unit = "gbps";
                    }
                    else{
                        $nwFromClientToPGMB = round($nwFromClientToPGMB, 0);
                    }
		    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                        'backupFolderPathsOdb' => (array)$value->{'odBackupFolderPaths'},
                        'userExcludedFolderpathsOdb' => (array)$value->{'excludedOdFolderpaths'},
			'backupFolderPathsMail' => (array)$value->{'mailBackupFolderPaths'},
                        'userExcludedFolderpathsMail' => (array)$value->{'excludedMailFolderpaths'},
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'description' => (string)$value->{'description'},
                        'officeProductType' => (string)$value->{'officeProductType'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
			'nwFromClientToPGMB'    => $nwFromClientToPGMB,
                        'unit'                  => $unit,
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionNameOdb' => (array)$value->{'odFilterInclusionName'},
			'filterInclusionNameMail' => (array)$value->{'mailFilterInclusionName'},
                        'searchFilterInclusionName' => (array)$value->{'searchFilterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'lmts' => (string)$value->{'lmts'},
                        'maxVersionsOdb' => (string)$value->{'odMaxVersions'},
			'maxFileSizeOdb' => (string)$value->{'odMaxFileSize'},
			'userSizeAllowedOdb' => (string)$value->{'odUserSizeAllowed'},
			'maxVersionsMail' => (string)$value->{'mailMaxVersions'},
			'maxFileSizeMail' => (string)$value->{'mailMaxFileSize'},
			'userSizeAllowedMail' => (string)$value->{'mailUserSizeAllowed'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (boolean)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (boolean)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (boolean)$value->{'highSecureShareEnabled'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElementOdb' => (array)$value->{'odPrivacyGatewayMappingElement'},
			'privacyGatewayMappingElementMail' => (array)$value->{'mailPrivacyGatewayMappingElement'},
                        'scheduleNamesOdb' => (array)$value->{'odScheduleNames'},
			'scheduleNamesMail' => (array)$value->{'mailScheduleNames'},
                        'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
                        'emailsRestriction' => (array)$value->{'emailsRestriction'},
			'outlookFilters' => (array)$value->{'outlookFilters'},
                        'canBackupHiddenFiles' => (boolean)$value->{'canBackupHiddenFiles'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'endpointUiPreferences' => (array)$value->{'endpointUiPreferences'},
			'endpointDisabledUiPreferences' => (array)$value->{'endpointDisabledUiPreferences'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'cpuThrottling' => $value->{'cpuThrottling'},
                        'msAppBluKryptOdb' => (string)$value->{'odMsAppBluKrypt'},
			'msAppBluKryptMail' => (string)$value->{'mailMsAppBluKrypt'},
                        'daysToWaitForNextBackup' => (string)$value->{'daysToWaitForNextBackup'},
                        'contentIndexEnabled' => (boolean)$value->{'contentIndexEnabled'},
			'purgeDeletedFilesOlderThan' => $value->{'purgeDeletedFilesOlderThan'},
			'purgeDeletedMailsOlderThan' => $value->{'purgeDeletedMailsOlderThan'},
			'deletedMailsOlderThan' => $value->{'deletedMailsOlderThan'},
			'allowedDomains' => $value->{'allowedDomains'},
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
			'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
			'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
			'isInPlaceMailArchiveEnabled' => (boolean)$value->{'inPlaceMailArchiveEnabled'},
			'isContactsEnabled' => (boolean)$value->{'contactsEnabled'},
			'isTasksEnabled' => (boolean)$value->{'tasksEnabled'},
			'odFilterType'  =>      (string)$value->{'odFilterType'},
                        'mailFilterType' => (string)$value->{'mailFilterType'},
		        'searchFilterType' => (string)$value->{'searchFilterType'},
			'active' => (boolean)$value->{'active'},
			'noOfDevicesAllowed' => $value->{'noOfDevicesAllowed'},
			'threshholdLimit' => $value->{'threshholdLimit'},
			'purgeFilesOlderThan' => $value->{'purgeFilesOlderThan'},
			'purgeFilesSizeGTThan' => $value->{'purgeFilesSizeGTThan'},
			'createLinkEnabled' => (boolean)$value->{'createLinkEnabled'},
			'createMailLinkEnabled' => (boolean)$value->{'createMailLinkEnabled'},
                    );		    
                    $response = array(
                        'result' => 'success',
                        'policy' => $policy,
                    );
                    echo json_encode($response);
                    exit();
                case (421):
                    $msg = $this->language->get('421');
                    exit();
                case (500):
                    $msg = $this->language->get('500');
                    exit();
                case (0):
                    $msg = $this->language->get('0');
                    exit();
                default:
                    $msg = $this->language->get('default');
                    exit();
            }
            $result = array(
                        'result' => 'fail',
                        'msg' => $msg
                    );
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function singleOneDrivePolicyMapping(){
        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => 'Office 365 Policy Mapping',
            'crumb2' => $this->language->get('change_user_policy'),
            'active' => 'pms',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/oneDrivePolicyMapping/single', $data);
        View::renderTemplate('footer', $data);
    }


    public function getOneDrivePolicyMappingDetails(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $_POST['skipValue'] = ($_POST['skipValue'] != 0 ) ? $_POST['skipValue'] : 0;
            $headers = array(
                'token' => $this->session->get('token'),
                'skipValue' => !empty($_POST['skipValue']) ? (int)$_POST['skipValue'] : 0,
                'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userNames'] = $_POST['userName'];
                $result = $this->_model->searchOneDrivePolicyMapping($headers);
            }else{
                $result = $this->_model->getOneDrivePolicyMappingDetails($headers);
                $this->log("kkkkkkkkkkkkkkk : getOneDrivePolicyMappingDetails endddddddddd","info");
            }
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                            'result' => 'success',
                            'policies' => $result['body']->{'data'}->{'existingPolicies'},
                        'users' => $result['body']->{'data'}->{'userBackupPolicyMappingElements'},
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                $response = array(
                        'result' => 'fail',
			'response' => $result,
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
                    $response = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($response);
                    exit();
            }

        }else{
            echo json_encode(array(
			'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getOneDrivePolicyMappingDetailsNavigate(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $_POST['skipValue'] = ($_POST['skipValue'] != 0 ) ? $_POST['skipValue'] : 0;
            $headers = array(
                'token' => $this->session->get('token'),
                'skipValue' => !empty($_POST['skipValue']) ? (int)$_POST['skipValue'] : 0,
                'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userNames'] = $_POST['userName'];
                $result = $this->_model->searchOneDrivePolicyMapping($headers);
            }else{
                $result = $this->_model->getOneDrivePolicyMappingDetailsNavigate($headers, $_POST['url']);
                $this->log("kkkkkkkkkkkkkkk : getOneDrivePolicyMappingDetails endddddddddd","info");
            }
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
		}
                    $response = array(
                            'result' => 'success',
                            'policies' => $result['body']->{'data'}->{'existingPolicies'},
                        'users' => $result['body']->{'data'}->{'userBackupPolicyMappingElements'},
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                $response = array(
                        'result' => 'fail',
			'response' => $result,
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
                    $response = array(
                        'result' => 'fail',
			'code' => $result,
                        'msg' => $this->language->get('default')
                    );
echo json_encode($response);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function saveSingleOneDrivePolicyMapping(){
        $this->log("inside saveSingleOneDrivePolicyMapping","info");
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'userName'          => html_entity_decode($_POST['userName'], ENT_QUOTES | ENT_HTML5),
                'newPolicyName'     => $_POST['newPolicyName'],
                'existingPolicyName'=> $_POST['oldPolicyName']
            );
            $result = $this->_model->saveSingleOneDrivePolicyMapping($headers, urldecode($_POST['userName']));
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                         );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                    case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function blockPolicy(){
        //Auth::allowOnly('admin');
            $headers = array(
                'token' => $this->session->get('token'),
                'policyType' => 'backupPolicy',
                'policyName' => $_POST['policyName']
            );
            $result = $this->_model->blockPolicy($headers);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('policyBlocked')
                    );
                    echo json_encode($response);
                    exit;
                case (333):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('alreadyMapped')
                    );
                    echo json_encode($response);
                    exit;
		case (444):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('alreadyMappedDelegatedAdmin')
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
		case (445):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'This policy is set as default policy for user migration.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    
    public function blockOdbPolicy(){
        //Auth::allowOnly('admin');
            $headers = array(
                'token' => $this->session->get('token'),
                'policyType' => 'o365'
            );
            $result = $this->_model->blockOdbPolicy($headers, $_POST['policyName']);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('policyBlocked')
                    );
                    echo json_encode($response);
                    exit;
                case (333):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('alreadyMapped')
                    );
                    echo json_encode($response);
                    exit;
		case (444):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('alreadyMappedDelegatedAdmin')
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;
		case (445):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'This policy is set as default policy for user migration.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                    case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    
    /*public function getUserPolicy(){
        ////Auth::allowOnly('admin');
        $policyName = $this->session->get('policyName');
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getPolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'backupPolicyElement'};
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                        'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => (array)$value->{'excludedFolderpaths'},
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'description' => (string)$value->{'description'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (string)$value->{'filterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'lmts' => (string)$value->{'lmts'},
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (string)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (string)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
                        'daysToWaitForNextBackup' => (string)$value->{'daysToWaitForNextBackup'},			
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }*/
    
    public function getUserPolicy(){
            //Auth::allowOnly('admin');
            $this->log('result--------------->1', 'info');
            $policyName = $this->session->get('odbPolicyName');
            if(Auth::checkCloudPermission('backup') == true && Auth::checkCloudPermission('office365') == false){
            $policyName = $this->session->get('policyName');
            }elseif(Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('office365') == true) {
            $policyName = $this->session->get('odbPolicyName');
            }else{
            $policyName = $this->session->get('policyName');
            }
//        $policyName = $this->session->get('policyName');
            if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
        );
            $this->log('result--------------->2'.json_encode($policyName), 'info');
            if(Auth::checkCloudPermission('backup') == true && Auth::checkCloudPermission('office365') == false){
                    $result = $this->_model->getPolicy($headers, $policyName);
            }elseif(Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('office365') == true) {
                $result = $this->_model->getOneDrivePolicy($headers, $policyName);
            }else{
                $result = $this->_model->getPolicy($headers, $policyName);
            }

            $this->log('result--------------->'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                if(Auth::checkCloudPermission('backup') == true && Auth::checkCloudPermission('office365') == false){
                $value = $result['body']->{'backupPolicyElement'};
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
			'sqlbkpEnabled' => $value->{'sqlbkpEnabled'},
			'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => !empty($value->{'excludedFolderpaths'}) ? (array)$value->{'excludedFolderpaths'} : [],
                        'exceptionsToExclusions' => !empty($value->{'exceptionsToExclusions'}) ? (array)$value->{'exceptionsToExclusions'} : [],
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'description' => !empty($value->{'description'}) ? (string)$value->{'description'} : '',
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (array)$value->{'filterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
//                        'lmts' => (string)$value->{'lmts'},
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (string)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (string)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
			'googleAuth' => (boolean)$value->{'googleAuth'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
			'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
//                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
			'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
                        'daysToWaitForNextBackup' => !empty($value->{'daysToWaitForNextBackup'}) ? (string)$value->{'daysToWaitForNextBackup'} : '',
			'allowedDomains' => !empty($value->{'allowedDomains'}) ? $value->{'allowedDomains'} : '',
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'filterType' => (string)$value->{'filterType'},
			'showShareLink' => (boolean)$value->{'showShareLink'},
			'shareDomainsEnabled' => !empty($value->{'shareDomainsEnabled'}) ? (boolean)$value->{'shareDomainsEnabled'} : false,
			'logUnaccessedFiles' => (boolean)$value->{'logUnaccessedFiles'},
                    );
            }elseif(Auth::checkCloudPermission('backup') == false && Auth::checkCloudPermission('office365') == true) {
                $value = $result['body']->{'ODBBackupPolicyElement'};
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                        'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => (array)$value->{'excludedFolderpaths'},
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'description' => (string)$value->{'description'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (array)$value->{'filterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
//                        'lmts' => (string)$value->{'lmts'},
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (string)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (string)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
//                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
			'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
                        'daysToWaitForNextBackup' => !empty($value->{'daysToWaitForNextBackup'}) ? (string)$value->{'daysToWaitForNextBackup'} : '',
			'allowedDomains' => $value->{'allowedDomains'},
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'filterType' => (string)$value->{'filterType'},
                    );
            }else{
                $value = $result['body']->{'backupPolicyElement'};
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
			'sqlbkpEnabled' => $value->{'sqlbkpEnabled'},
                        'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => (array)$value->{'excludedFolderpaths'},
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'description' => (string)$value->{'description'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (array)$value->{'filterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
//                        'lmts' => (string)$value->{'lmts'},
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (string)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (string)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
			'googleAuth' => (boolean)$value->{'googleAuth'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                        'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
			'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
//                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
			'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
                        'daysToWaitForNextBackup' => !empty($value->{'daysToWaitForNextBackup'}) ? (string)$value->{'daysToWaitForNextBackup'} : '',
			'allowedDomains' => $value->{'allowedDomains'},
			'endpointDomainCheck' => (boolean)$value->{'endpointDomainCheck'},
			'filterType' => (string)$value->{'filterType'},
			'showShareLink' => (boolean)$value->{'showShareLink'},
			'shareDomainsEnabled' => (boolean)$value->{'shareDomainsEnabled'},
			'logUnaccessedFiles' => (boolean)$value->{'logUnaccessedFiles'},
                    );
                }

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function singlePolicyMapping(){
        Auth::allowOnly('readOnlyAdmin');
        $backupResult1 = $this->_model->getAllBackupPolicyName(array('token'=>$this->session->get('token')));

        $backupPolicies1 = [];
	if(!empty($backupResult1['body']->{'stringList'})){
	foreach((array)$backupResult1['body']->{'stringList'} as $value){
                $policy = $value;
                $backupPolicies1 = array_merge(array($policy), $backupPolicies1);
	}
	}
            natcasesort($backupPolicies1);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy_mapping'),
            'crumb2' => $this->language->get('change_user_policy'),
            'active' => 'pms',
            'backupPolicies1' => $backupPolicies1,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/policyMapping/single', $data);
        View::renderTemplate('footer', $data);
    }

    public function getPolicyMappingDetails(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $_POST['skipValue'] = ($_POST['skipValue'] != 0 ) ? $_POST['skipValue'] : 0;
            $headers = array(
                    'token' => $this->session->get('token'),
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? (int)$_POST['skipValue'] : 0
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userNames'] = $_POST['userName'];
                $result = $this->_model->searchPolicyMapping($headers);
            }else{
                $result = $this->_model->getPolicyMappingDetails($headers);
            }
            switch ($result['status']) {
                case (200):
if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'policies' => $result['body']->{'data'}->{'existingPolicies'},
                        'users' => $result['body']->{'data'}->{'userBackupPolicyMappingElements'},
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;

                case (421):
$response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
$response = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($response);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

public function getPolicyMappingDetailsNavigate(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userNames'] = $_POST['userName'];
                $result = $this->_model->searchPolicyMapping($headers);
            }else{
                $result = $this->_model->getPolicyMappingDetailsNavigate($headers, $_POST['url']);
}
            switch ($result['status']) {
                case (200):
		if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'policies' => $result['body']->{'data'}->{'existingPolicies'},
                        'users' => $result['body']->{'data'}->{'userBackupPolicyMappingElements'},
                        'metadata' => $metadata
                );
                    echo json_encode($response);
                    exit;

                case (421):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
			'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
                    $response = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($response);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function saveSinglePolicyMapping(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'userName'          => html_entity_decode($_POST['userName'], ENT_QUOTES | ENT_HTML5),
                'newPolicyName'     => $_POST['newPolicyName'],
                'existingPolicyName'=> $_POST['oldPolicyName']
            );
            $result = $this->_model->saveSinglePolicyMapping($headers, urldecode($_POST['userName']));
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function multiplePolicyMapping(){
        Auth::allowOnly('readOnlyAdmin');
        $result = $this->_model->getAllPolicies(array('token'=>$this->session->get('token')));
        $backupResult1 = $this->_model->getAllBackupPolicyName(array('token'=>$this->session->get('token')));

        if(!empty((array)$result['body']->{'backupPolicyElementList'})){
            $policies = [];
            foreach((array)$result['body']->{'backupPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $policies = array_merge(array($policy), $policies);
            }
            
            $backupPolicies1 = [];
	    if(!empty($backupResult1['body']->{'stringList'})){
	    foreach((array)$backupResult1['body']->{'stringList'} as $value){
                $policy = $value;
                $backupPolicies1 = array_merge(array($policy), $backupPolicies1);
	    }
	    }
            natcasesort($backupPolicies1);
            $data = array(
                'title' => $this->language->get('indexPageName'),
                'crumb1' => $this->language->get('policy_mapping'),
                'crumb2' => (Auth::checkCloudPermission('serverBackup')) ? $this->language->get('assign_policy') : $this->language->get('assign_policy_for_users_in_bulk'),
                'active' => 'pms',
                'csrf_token' => $this->setCSRFToken(),
                'policies' => $policies,
                'backupPolicies1' => $backupPolicies1,
                'loggedInUser' => $this->session->all()
            );

            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('pms/policyMapping/multiple', $data);
            View::renderTemplate('footer', $data);
        }else{
            header('Location: '.Url::basePath('pms/policy/create'));
        }
    }

    public function saveMultiplePolicyMapping(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
	    /*$array_ext = explode(',', $_POST['userNames']);
	    foreach($array_ext as $value){
        	$this->validateData($value);
	    }*/
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'userNames'          => urldecode($_POST['userNames']),
                'policyName'     => $_POST['policyName']
            );
            $result = $this->_model->saveMultiplePolicyMapping($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (409):
                    $result = array(
                        'result' => 'fail_withexcel',
                        'msg' => $this->language->get('409')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function multipleOneDrivePolicyMapping(){
        Auth::allowOnly('readOnlyAdmin');
        $odbPolicyResult1 = $this->_model->getAllOneDrivePolicies(array('token'=>$this->session->get('token')));
        if(!empty((array)$odbPolicyResult1['body']->{'officeBackupPolicyElementList'})){
        $odbPolicies1 = [];
        foreach((array)$odbPolicyResult1['body']->{'officeBackupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $odbPolicies1 = array_merge(array($policy), $odbPolicies1);
        }
            natcasesort($odbPolicies1);
            
            $data = array(
                'title' => $this->language->get('indexPageName'),
                'crumb1' => $this->language->get('Office 365 Policy Mapping'),
                'crumb2' => (Auth::checkCloudPermission('serverBackup')) ? $this->language->get('assign_policy') : $this->language->get('assign_policy_for_users_in_bulk'),
                'active' => 'pms',
                'csrf_token' => $this->setCSRFToken(),
                'odbPolicies1' => $odbPolicies1,
                'loggedInUser' => $this->session->all()
            );

            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('pms/oneDrivePolicyMapping/multiple', $data);
            View::renderTemplate('footer', $data);
        }else{
            header('Location: '.Url::basePath('pms/oneDrivePolicy/create'));
        }
    }
    
    public function saveMultipleOneDrivePolicyMapping(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'userNames'          => urldecode($_POST['userNames']),
                'policyName'     => $_POST['policyName']
            );
            $result = $this->_model->saveMultipleOneDrivePolicyMapping($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function paracloudblukrypt(){
        Auth::allowOnly('readOnlyAdmin');

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('paracloudblukrypt'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/machine/paracloudblukrypt', $data);
        View::renderTemplate('footer', $data);
    }

    public function getBluvault(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' =>  'application/json',
                'token' =>  $this->session->get('token'),
            );
            $result = $this->_model->getBluvaults($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'bluvaults' => $result['body']->{'bluVaultMappingElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveBluvault(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            if($this->checkForBluVaultInstallation($_POST['bluvault']) == false){
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('bluVaultNotInstalled')
                );
                echo json_encode($result);
                exit();
            }
            $headers = array(
                'Content-Type'      => 'application/json',
                'token' =>  $this->session->get('token')
            );
            /*$componentsProperties = array(
                "devAllowPerCollection" => $_POST["devAllowPerCollection"],
                "chunkTotalBuckets" => $_POST["chunkTotalBucketsParacloud"],
                "keyForLoad" => $_POST["keyForLoad"],
                "paracloudUrl" => $_POST["paracloudUrlParacloud"],
                "noOfMonthsOldRecordToDeleteForSyncOverview" => $_POST["noOfMonthsOldRecordToDeleteForSyncOverview"],
                "impUsersPolicyNames" => $_POST["impUsersPolicyNames"],
                "bkpColQueryRequired" => $_POST["bkpColQueryRequired"],
                "chunkColQueryRequired" => $_POST["chunkColQueryRequired"],
                "showAddADAttributeEnabled" => $_POST["showAddADAttributeEnabled"],
                /*"devicesPerUser" => $_POST["devicesPerUser"],
                "paracloudDownloadPath" => $_POST["paracloudDownloadPath"],
                "updateParacloudScriptName" => $_POST["updateParacloudScriptName"],
                "azureStorageAccountName" => $_POST["azureStorageAccountName"],
                "azureStorageAccountKey" => $_POST["azureStorageAccountKey"],
                "superUserName" => $_POST["superUserName"],
                "restoreurl" => $_POST["restoreurl"],
                "devcertprivkeypath" => $_POST["devcertprivkeypath"],
                "azureGateway" => $_POST["azureGateway"]
            );*/
            $data = array(
                'bluVaultName' => $_POST['bluvault'],
                //'componentsProperties' => $componentsProperties
            );
            $this->log("sent data : ".json_encode($data),"info");
            $result = $this->_model->saveBluvault($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function editSaveBluvault(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token' =>  $this->session->get('token')
            );
            /*$componentsProperties = array(
                "devAllowPerCollection" => $_POST["devAllowPerCollection"],
                "chunkTotalBuckets" => $_POST["chunkTotalBucketsParacloud"],
                "keyForLoad" => $_POST["keyForLoad"],
                "paracloudUrl" => $_POST["paracloudUrlParacloud"],
                "noOfMonthsOldRecordToDeleteForSyncOverview" => $_POST["noOfMonthsOldRecordToDeleteForSyncOverview"],
                "impUsersPolicyNames" => $_POST["impUsersPolicyNames"],
                "bkpColQueryRequired" => $_POST["bkpColQueryRequired"],
                "chunkColQueryRequired" => $_POST["chunkColQueryRequired"],
                "showAddADAttributeEnabled" => $_POST["showAddADAttributeEnabled"],
                /*"devicesPerUser" => $_POST["devicesPerUser"],
                "paracloudDownloadPath" => $_POST["paracloudDownloadPath"],
                "updateParacloudScriptName" => $_POST["updateParacloudScriptName"],
                "azureStorageAccountName" => $_POST["azureStorageAccountName"],
                "azureStorageAccountKey" => $_POST["azureStorageAccountKey"],
                "superUserName" => $_POST["superUserName"],
                "restoreurl" => $_POST["restoreurl"],
                "devcertprivkeypath" => $_POST["devcertprivkeypath"],
                "azureGateway" => $_POST["azureGateway"]
            );*/
            $data = array(
                'bluVaultName' => $_POST['bluvault'],
                //'componentsProperties' => $componentsProperties
            );
            $this->log("sent data : ".json_encode($data),"info");
            $result = $this->_model->saveBluvault($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function confirmSaveBluvault(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token' =>  $this->session->get('token')
            );
            /*$componentsProperties = array(
                "devAllowPerCollection" => $_POST["devAllowPerCollection"],
                "chunkTotalBuckets" => $_POST["chunkTotalBucketsParacloud"],
                "keyForLoad" => $_POST["keyForLoad"],
                "paracloudUrl" => $_POST["paracloudUrlParacloud"],
                "noOfMonthsOldRecordToDeleteForSyncOverview" => $_POST["noOfMonthsOldRecordToDeleteForSyncOverview"],
                "impUsersPolicyNames" => $_POST["impUsersPolicyNames"],
                "bkpColQueryRequired" => $_POST["bkpColQueryRequired"],
                "chunkColQueryRequired" => $_POST["chunkColQueryRequired"],
                "showAddADAttributeEnabled" => $_POST["showAddADAttributeEnabled"],
                /*"devicesPerUser" => $_POST["devicesPerUser"],
                "paracloudDownloadPath" => $_POST["paracloudDownloadPath"],
                "updateParacloudScriptName" => $_POST["updateParacloudScriptName"],
                "azureStorageAccountName" => $_POST["azureStorageAccountName"],
                "azureStorageAccountKey" => $_POST["azureStorageAccountKey"],
                "superUserName" => $_POST["superUserName"],
                "restoreurl" => $_POST["restoreurl"],
                "devcertprivkeypath" => $_POST["devcertprivkeypath"],
                "azureGateway" => $_POST["azureGateway"]
            );*/
            $data = array(
                'bluVaultName' => $_POST['bluvault'],
                //'componentsProperties' => $componentsProperties
            );
            $this->log("sent data : ".json_encode($data),"info");
            $result = $this->_model->saveBluvault($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function deleteBluvault(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             =>  $this->session->get('token'),
                'id'       => $_POST['bluvaultId'],
                'bluVaultName'       => $_POST['bluVaultName']
                
            );
            $this->log("HEADERS : ".json_encode($headers),"info");
            $result = $this->_model->deleteBluvault($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function blukrypt(){
        Auth::allowOnly('readOnlyAdmin');

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('blukrypt'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/machine/blukrypt', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAllBlukrypts(){
        if(!empty($_POST)){

            $headers = array(
                'Content-Type'      => 'application/json',
                'token' =>  $this->session->get('token')
            );
            $result = $this->_model->getAllBlukrypts($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result'    => 'success',
                        'blukrypts' => $result['body']->{'privacyGatewayElementList'},
                        'msg'       => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function saveBlukrypt(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            if($this->checkForBluVaultInstallation($_POST['blukrypt']) == false){
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('bluKryptNotInstalled')
                );
                echo json_encode($result);
                exit();
            }
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             =>  $this->session->get('token'),
            );

            /*$componentsProperties = array(
                "ftpHost" => $_POST["ftpHost"],
                "syncUploadPath" => $_POST["syncUploadPath"],
                "ftpUser" => $_POST["ftpUser"],
                "ftpPwd" => $_POST["ftpPwd"],
                "odbFrequencyCallValue" => $_POST["odbFrequencyCallValue"],
                "proxyUserName" => $_POST["proxyUserName"],
                "proxyPort" => $_POST["proxyPort"],
                "proxyHost" => $_POST["proxyHost"],
                "proxyPassword" => $_POST["proxyPassword"],
                "chunkUpdateMaxRetry" => $_POST["chunkUpdateMaxRetry"],
                "noOfJobThreads" => $_POST["noOfJobThreads"],
                "deleteBkpTblWhenChnkNotFound" => $_POST["deleteBkpTblWhenChnkNotFound"],
                "updateGatewayWhenChunkNotFound" => $_POST["updateGatewayWhenChunkNotFound"],
                "chunkTotalBuckets" => $_POST["chunkTotalBucketsBlukrypt"],
                "odbRetryFolderVal" => $_POST["odbRetryFolderVal"],
                "odbUserAgentVal" => $_POST["odbUserAgentVal"],
                "gatewayName" => $_POST["gatewayName"],
                "localdbhost" => $_POST["localdbhost"],
                "paracloudUrl" => $_POST["paracloudUrlBlukrypt"],
                "queryLimit" => $_POST["queryLimit"],
                "encryptionEnabled" => $_POST["encryptionEnabled"],
                "syncFtpEnabled" => $_POST["syncFtpEnabled"],
                "localStorageEnabled" => $_POST["localStorageEnabled"],
                "chunkColQueryRequired" => $_POST["chunkColQueryRequiredBlukrypt"],
                "bkpColQueryRequired" => $_POST["bkpColQueryRequiredBlukrypt"],
                "pgOverloadLimit" => $_POST["pgOverloadLimit"],
                "pgOverLoadInactivityPeriod" => $_POST["pgOverLoadInactivityPeriod"],
                "resoreQueryLimit" => $_POST["resoreQueryLimit"],
                "noOfThreads" => $_POST["noOfThreads"],
                "stopJobsEnabled" => $_POST["stopJobsEnabled"],

                );*/

            $data = array(
                'gatewayName'          => $_POST['blukrypt'],
                'type'      => $_POST['blukryptType'],
                'productType'      => $_POST['productType'],
                'active' => $_POST['active'],
                //'componentsProperties' => $componentsProperties
            );

            
            $this->log("sent data : ".json_encode($data),"info");
            $result = $this->_model->saveBlukrypt($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (406):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('406')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function editSaveBlukrypt(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             =>  $this->session->get('token'),
            );

            /*$componentsProperties = array(
                "ftpHost" => $_POST["ftpHost"],
                "syncUploadPath" => $_POST["syncUploadPath"],
                "ftpUser" => $_POST["ftpUser"],
                "ftpPwd" => $_POST["ftpPwd"],
                "odbFrequencyCallValue" => $_POST["odbFrequencyCallValue"],
                "proxyUserName" => $_POST["proxyUserName"],
                "proxyPort" => $_POST["proxyPort"],
                "proxyHost" => $_POST["proxyHost"],
                "proxyPassword" => $_POST["proxyPassword"],
                "chunkUpdateMaxRetry" => $_POST["chunkUpdateMaxRetry"],
                "noOfJobThreads" => $_POST["noOfJobThreads"],
                "deleteBkpTblWhenChnkNotFound" => $_POST["deleteBkpTblWhenChnkNotFound"],
                "updateGatewayWhenChunkNotFound" => $_POST["updateGatewayWhenChunkNotFound"],
                "chunkTotalBuckets" => $_POST["chunkTotalBucketsBlukrypt"],
                "odbRetryFolderVal" => $_POST["odbRetryFolderVal"],
                "odbUserAgentVal" => $_POST["odbUserAgentVal"],
                "gatewayName" => $_POST["gatewayName"],
                "localdbhost" => $_POST["localdbhost"],
                "paracloudUrl" => $_POST["paracloudUrlBlukrypt"],
                "queryLimit" => $_POST["queryLimit"],
                "encryptionEnabled" => $_POST["encryptionEnabled"],
                "syncFtpEnabled" => $_POST["syncFtpEnabled"],
                "localStorageEnabled" => $_POST["localStorageEnabled"],
                "chunkColQueryRequired" => $_POST["chunkColQueryRequiredBlukrypt"],
                "bkpColQueryRequired" => $_POST["bkpColQueryRequiredBlukrypt"],
                "pgOverloadLimit" => $_POST["pgOverloadLimit"],
                "pgOverLoadInactivityPeriod" => $_POST["pgOverLoadInactivityPeriod"],
                "resoreQueryLimit" => $_POST["resoreQueryLimit"],
                "noOfThreads" => $_POST["noOfThreads"],
                "stopJobsEnabled" => $_POST["stopJobsEnabled"],

                );*/

            $data = array(
                'gatewayName'          => $_POST['blukrypt'],
                'type'      => $_POST['blukryptType'],
                'productType'      => $_POST['productType'],
                'active' => $_POST['active'],
                //'componentsProperties' => $componentsProperties
            );

            
            $this->log("sent data : ".json_encode($data),"info");
            $result = $this->_model->saveBlukrypt($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (406):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('406')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function confirmSaveBlukrypt(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             =>  $this->session->get('token'),
            );
            /*$componentsProperties = array(
                "ftpHost" => $_POST["ftpHost"],
                "syncUploadPath" => $_POST["syncUploadPath"],
                "ftpUser" => $_POST["ftpUser"],
                "ftpPwd" => $_POST["ftpPwd"],
                "odbFrequencyCallValue" => $_POST["odbFrequencyCallValue"],
                "proxyUserName" => $_POST["proxyUserName"],
                "proxyPort" => $_POST["proxyPort"],
                "proxyHost" => $_POST["proxyHost"],
                "proxyPassword" => $_POST["proxyPassword"],
                "chunkUpdateMaxRetry" => $_POST["chunkUpdateMaxRetry"],
                "noOfJobThreads" => $_POST["noOfJobThreads"],
                "deleteBkpTblWhenChnkNotFound" => $_POST["deleteBkpTblWhenChnkNotFound"],
                "updateGatewayWhenChunkNotFound" => $_POST["updateGatewayWhenChunkNotFound"],
                "chunkTotalBuckets" => $_POST["chunkTotalBucketsBlukrypt"],
                "odbRetryFolderVal" => $_POST["odbRetryFolderVal"],
                "odbUserAgentVal" => $_POST["odbUserAgentVal"],
                "gatewayName" => $_POST["gatewayName"],
                "localdbhost" => $_POST["localdbhost"],
                "paracloudUrl" => $_POST["paracloudUrlBlukrypt"],
                "queryLimit" => $_POST["queryLimit"],
                "encryptionEnabled" => $_POST["encryptionEnabled"],
                "syncFtpEnabled" => $_POST["syncFtpEnabled"],
                "localStorageEnabled" => $_POST["localStorageEnabled"],
                "chunkColQueryRequired" => $_POST["chunkColQueryRequiredBlukrypt"],
                "bkpColQueryRequired" => $_POST["bkpColQueryRequiredBlukrypt"],
                "pgOverloadLimit" => $_POST["pgOverloadLimit"],
                "pgOverLoadInactivityPeriod" => $_POST["pgOverLoadInactivityPeriod"],
                "resoreQueryLimit" => $_POST["resoreQueryLimit"],
                "noOfThreads" => $_POST["noOfThreads"],
                "stopJobsEnabled" => $_POST["stopJobsEnabled"],
                );*/

            $data = array(
                'gatewayName'          => $_POST['blukrypt'],
                'type'      => $_POST['blukryptType'],
                'productType'      => $_POST['productType'],
                'active' => $_POST['active'],
                //'componentsProperties' => $componentsProperties
            );

            $result = $this->_model->saveBlukrypt($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (406):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('406')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function removeBlukrypt(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token' =>  $this->session->get('token'),
                'gatewayName'      => $_POST['bluKrypt']
            );
            $this->log("HEADERS : ".json_encode($headers),"info");
            $result = $this->_model->deleteBluKrypt($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;
                case (406):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('406')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function networkThrottling(){
        //Auth::allowOnly('admin');
        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );
        $result = $this->_model->getPgLists($headers);
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('networkThrottling'),
            'listNetworkThrottling' => $this->language->get('listNetworkThrottling'),
            'active' => 'pms',
            'pgList' => $result['body']->{'privacyGatewayElementList'},
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/networkThrottling/view', $data);
        View::renderTemplate('footer', $data);
    }

    public function networkThrottlingSet($type, $pg){
        //Auth::allowOnly('admin');
        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token')
        );
        $result = $this->_model->getPgLists($headers);
        if($this->checkIfExists($pg, $result['body']->{'privacyGatewayElementList'})){
            $exists = true;
        }else{
            $exists = false;
        }
        $nTResult = $this->_model->getNTList($headers, $pg);
        $c2p = [];
        $p2a = [];
        if(!empty($nTResult['body']->{'networkThrottlingElementList'})){
            foreach($nTResult['body']->{'networkThrottlingElementList'} as $value){
                $newItem = array(
                    'id' => $value->{'id'},
                    'networkThrottlingName' => $value->{'networkThrottlingName'},
                    'privacyGatewayName' => $value->{'privacyGatewayName'},
                    'startTime' => $value->{'startTime'},
                    'endTime' => $value->{'endTime'},
                    'uploadSpeed' => $value->{'uploadSpeed'},
                    'downloadSpeed' => $value->{'downloadSpeed'},
                    'throttleType' => $value->{'throttleType'},
                );
                if($value->{'throttleType'} == 'c2p'){
                    $c2p = array_merge(array($newItem), $c2p);
                }elseif($value->{'throttleType'} == 'p2a'){
                    $p2a = array_merge(array($newItem), $p2a);
                }
            }
        }

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('networkThrottling'),
            'listNetworkThrottling' => $this->language->get('listNetworkThrottling'),
            'active' => 'pms',
            'pgList' => $result['body']->{'privacyGatewayElementList'},
            'selectedPG' => $pg,
            'type' => $type,
            'c2p' => $c2p,
            'p2a' => $p2a,
            'exists' => $exists,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/networkThrottling/set', $data);
        View::renderTemplate('footer', $data);
    }

    public function saveThrottlingLimit(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'              => 'application/json',
                'token'                     => $this->session->get('token')
            );
            $data = array(
                'privacyGatewayName'        => $_POST['pgName'],
                'throttleType'              => $_POST['type'],
                'startTime'                 => $_POST['startTime'],
                'endTime'                   => $_POST['endTime'],
                'uploadSpeed'               => $_POST['uploadSpeed']
            );
            $result = $this->_model->saveThrottlingLimit($headers, json_encode($data));
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function removeThrottlingLimit(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'              => 'application/json',
                'token'                     => $this->session->get('token'),
                'throttle-id'                     => $_POST['id']
            );
            $result = $this->_model->removeThrottlingLimit($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }

    public function serverSinglePolicyMapping(){
        //Auth::allowOnly('admin');

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('Server'),
            'crumb2' => $this->language->get('Single Policy Mapping'),
            'active' => 'pms',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/serverPolicyMapping/single', $data);
        View::renderTemplate('footer', $data);
    }

    public function serverMultiplePolicyMapping(){
        //Auth::allowOnly('admin');

        $result = $this->_model->getAllPolicies(array('token'=>$this->session->get('token')));

        if(!empty((array)$result['body']->{'backupPolicyElementList'})){
            $policies = [];
            foreach((array)$result['body']->{'backupPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $policies = array_merge(array($policy), $policies);
            }

            $data = array(
                'title' => $this->language->get('indexPageName'),
                'crumb1' => $this->language->get('Server'),
                'crumb2' => $this->language->get('Multiple Policy Mapping'),
                'active' => 'pms',
                'csrf_token' => $this->setCSRFToken(),
                'loggedInUser' => $this->session->all(),
                'policies' => $policies,
            );

            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('pms/serverPolicyMapping/multiple', $data);
            View::renderTemplate('footer', $data);
        }else{
            header('Location: /pms/policy/create');
        }
    }

    public function getServerPolicyMappingList(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $_POST['skipValue'] = ($_POST['skipValue'] != 0 ) ? $_POST['skipValue']+1 : $_POST['skipValue'];
            $headers = array(
                'token' => $this->session->get('token'),
                'skipValue' => !empty($_POST['skipValue']) ? (int)$_POST['skipValue'] : 0
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['deviceNames'] = $_POST['userName'];
                $result = $this->_model->searchPolicyMapping($headers);
            }else{
                $result = $this->_model->getServerPolicyMappingList($headers);
            }
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'policies' => $result['body']->{'editDeviceBackupPolicyMappingElement'}->{'existingPolicies'},
                        'users' => $result['body']->{'editDeviceBackupPolicyMappingElement'}->{'deviceBackupPolicyMappingElements'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
                    $response = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($response);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function saveServerPolicyMapping(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'devices'           => $_POST['deviceUUID'],
                'policyName'        => $_POST['newPolicyName']
            );
            $this->log('Headers'. json_encode($headers), 'info');
            $result = $this->_model->saveServerPolicyMapping($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    /**
     * Below Method Renders Encryption settings page
     */
    public function cloudCredentials(){

        //Auth::allowOnly('admin');
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('cloudCredentials'),
            'active' => 'settings',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/ccS/cloudCredentials', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAllCcS(){
        //Auth::allowOnly('admin');
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
        $ccS = [];
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token')
        );
        $result = $this->_model->getCloudCredentials($headers);
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
                    foreach($result['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $value){
                        switch($value->cloudName){
                            case 'azureBlob':
                                $value->cloudNameInCaps = 'Azure Blob';
                                break;
                            case 'ibmCloud':
                                $value->cloudNameInCaps = 'IBM Cloud';
                                break;
                            case 'amazon':
                                $value->cloudNameInCaps = 'Amazon s3 Services';
                                break;
                            default:
                                $value->cloudNameInCaps = '';
                                break;
                        }

                        $ccS = array_merge(array($value), $ccS);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'ccS' => $ccS,
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function saveCloudCredentials(){
        //Auth::allowOnly('admin');
        if(!empty($_POST['cloudType'])){
            $data = array(
                'cloudName' => $_POST['cloudType'],
                'identity' => ($_POST['cloudType'] == "localStorage") ? "local" : $_POST['identity'],
                'credential' => $_POST['accessKey'],
                'containerName' => !empty($_POST['containerName']) ? $_POST['containerName'] : '',
                'endPointUrl' => (($_POST['cloudType'] == "localStorage") ? $_POST['localStorage'] : !empty($_POST['epaUrl'])) ? $_POST['epaUrl'] : ''
            );
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'          => $this->session->get('token')
            );
            $result = $this->_model->saveCloudCredentials($headers, $data);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('savedCloudCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function removeCloudCredentials(){
        //Auth::allowOnly('admin');
        if(!empty($_POST['identity'])){
            $headers = array(
                'Content-Type'      => 'application/json',
                'identity'          => $_POST['identity'],
                'token'             => $this->session->get('token')
            );
            $result = $this->_model->removeCloudCredentials($headers);
            $this->log("headers: ". json_encode($headers), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg'    => $this->language->get('removeCloudCredentials')
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getEPADetails(){
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'          => $this->session->get('token'),
            'productType' => 'service'
        );

        $result = $this->_model->getEPADetails($headers);
		$macDetails = [];
        $winDetails = [];
        if($result['body']->{'productElementList'}){
            foreach($result['body']->{'productElementList'} as $value){
                if($value->{'productMinorGroup'} == 'mac'){
                    $macDetails = array(
                                        'productMinorGroup' => !empty($value->{'productMinorGroup'}) ? (string)$value->{'productMinorGroup'} : '',
                                        'productVersion' => !empty($value->{'productVersion'}) ? (string)$value->{'productVersion'} : '',
                                        'updateAgent' => $value->{'updateAgent'},
                                        'downloadAgent' => $value->{'downloadAgent'}
                                    );
                    }
    
                if($value->{'productMinorGroup'} == 'service'){
                    $winDetails = array(
                                        'productMinorGroup' => !empty($value->{'productMinorGroup'}) ? (string)$value->{'productMinorGroup'} : '',
                                        'productVersion' => !empty($value->{'productVersion'}) ? (string)$value->{'productVersion'} : '',
                                        'updateAgent' => $value->{'updateAgent'},
                                        'downloadAgent' => $value->{'downloadAgent'} 
                                    );
                    }
            }
        }

		switch ($result['status']) {
            case (200):
                $response = array(
                    'result' => 'success',
                    'macDetails'    => $macDetails,
                    'winDetails' => $winDetails
                );
                echo json_encode($response);
                exit;
            case (204):
                $result = array(
                    'result' => 'fail',
                    'msg' => 'No Agents available for download'
                );
                echo json_encode($result);    
                exit();
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);    
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function checkForBluVaultInstallation($bluvault){
        if (strpos($bluvault,'localhost') !== false) {
            return true;
        }else{
            $result = $this->_model->checkForBluVaultInstallation($bluvault);
            return ($result['status'] != 500 && $result['status'] != 0);
        }
    }

    public function checkForBluKryptInstallation($bluKrypt){
        if (strpos($bluKrypt,'localhost') !== false) {
            return true;
        }else{
            $result = $this->_model->checkForBluKryptInstallation($bluKrypt);
            return ($result['status'] != 500 && $result['status'] != 0);
        }
    }
    
    public function downloadDump(){
        $filePath = AGENT_NOT_HEARD_PATH.BULK_POLICY_FAIL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BULK_POLICY_FAIL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }

    public function downloadSample(){
        $filePath = OVERVIEW_REPORT_PATH.BULK_BLOCK_UNBLOCK_DELETE_USERS_SAMPLE;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.'bulkPolicyMapping.xlsx');
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }
    
    public function saveScheduleEditMail(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'scheduleName'       => 'required',
                'scheduleStartTime'  => 'required',
                'days'               => 'required'
            );
            $filters = array(
                'scheduleName'       => 'trim|sanitize_string',
                'scheduleStartTime'  => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'scheduleName' => $_POST['scheduleNameMail'],
                    'time' => $_POST['scheduleStartTimeMail'],
                    'timeZone' => $_POST['scheduleTimeZoneMail'],
                    'backupType' => $_POST['backupTypeMail'],
                    'dayArray' => $_POST['daysMail']
                );

                $result = $this->_model->saveScheduleEdit($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('scheduleSaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4061')
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }



    public function saveScheduleOdb(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'scheduleName'       => 'required',
                'scheduleStartTime'  => 'required',
                'days'               => 'required'
            );
            $filters = array(
                'scheduleName'       => 'trim|sanitize_string',
                'scheduleStartTime'  => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'scheduleName' => $_POST['scheduleName'],
                    'time' => $_POST['scheduleStartTime'],
                    'timeZone' => $_POST['scheduleTimeZone'],
                    'backupType' => $_POST['backupType'],
                    'dayArray' => $_POST['days']
                );

                $result = $this->_model->saveSchedule($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
		    $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('scheduleSaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4061')
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
		        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }


public function saveScheduleMail(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'scheduleName'       => 'required',
                'scheduleStartTime'  => 'required',
                'days'               => 'required'
            );
            $filters = array(
                'scheduleName'       => 'trim|sanitize_string',
                'scheduleStartTime'  => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'scheduleName' => $_POST['scheduleNameMail'],
                    'time' => $_POST['scheduleStartTimeMail'],
                    'timeZone' => $_POST['scheduleTimeZoneMail'],
                    'backupType' => $_POST['backupTypeMail'],
                    'dayArray' => $_POST['daysMail']
                );

                $result = $this->_model->saveSchedule($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
		    $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('scheduleSaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4061')
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
		        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
}

public function saveFilterOdb(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'filterName'       => 'required'
            );
            $filters = array(
                'filterName'       => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'filterName' => $_POST['filterName'],
                    'filterType' => $_POST['filterType'],
                    //'filters' => implode(',', $_POST['filters'])
                    'filters' => $_POST['filtersNew']
                );
                $this->log('Data: '. json_encode($data), 'info');
                $result = $this->_model->saveFilter($headers, json_encode($data));
                $this->log('result: '. json_encode($result), 'info');
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('filterSaved')
);
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4062')
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

public function saveFilterMail(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'filterName'       => 'required'
            );
            $filters = array(
                'filterName'       => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'filterName' => $_POST['filterNameMail'],
                    'filterType' => $_POST['filterTypeMail'],
                    //'filters' => implode(',', $_POST['filters'])
                    'filters' => $_POST['filtersNew']
                );
                $this->log('Data: '. json_encode($data), 'info');
                $result = $this->_model->saveFilter($headers, json_encode($data));
                $this->log('result: '. json_encode($result), 'info');
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('filterSaved')
);
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4062')
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

public function saveFilterEditOdb(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'filterName'       => 'required'
            );
            $filters = array(
                'filterName'       => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'filterName' => $_POST['filterName'],
                    'filterType' => $_POST['filterType'],
                    //'filters' => implode(',', $_POST['filters'])
                    'filters' => $_POST['filtersNew']
                );
                $this->log('Data: '. json_encode($data), 'info');
                $result = $this->_model->saveFilterEdit($headers, json_encode($data));
                $this->log('result: '. json_encode($result), 'info');
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('filterSaved')
);
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4062')
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }


public function saveFilterEditMail(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){

            $rules = array(
                'filterName'       => 'required'
            );
            $filters = array(
                'filterName'       => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $data = array(
                    'filterName' => $_POST['filterNameMail'],
                    'filterType' => $_POST['filterTypeMail'],
                    //'filters' => implode(',', $_POST['filters'])
                    'filters' => $_POST['filtersNew']
                );
                $this->log('Data: '. json_encode($data), 'info');
                $result = $this->_model->saveFilterEdit($headers, json_encode($data));
                $this->log('result: '. json_encode($result), 'info');
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('filterSaved')
);
                        echo json_encode($response);
                        exit;
                    case (406):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('4062')
                        );
                        echo json_encode($result);
                        exit();
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }


    public function getUserODBPolicy(){
            $policyName = $this->session->get('odbPolicyName');
            if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
        );
                $result = $this->_model->getOneDrivePolicy($headers, $policyName);
                $this->log('result--------------->'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                $value = $result['body']->{'officeBackupPolicyElement'};
                    $policy = array(
                        'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                        'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                        'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                        'userExcludedFolderpaths' => (array)$value->{'excludedFolderpaths'},
                        'cpuUtilization' => (string)$value->{'cpuUtilization'},
                        'memoryUtilization' => (string)$value->{'memoryUtilization'},
                        'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                        'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                        'crawlLimit' => (string)$value->{'crawlLimit'},
                        'dcmEnabled' => (string)$value->{'dcmEnabled'},
                        'description' => (string)$value->{'description'},
                        'destination' => (string)$value->{'destination'},
                        'filterInclusionName' => (string)$value->{'filterInclusionName'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'lmts' => (string)$value->{'lmts'},
                        'maxFileSize' => (string)$value->{'maxFileSize'},
                        'maxVersions' => (string)$value->{'maxVersions'},
                        'shareEnabled' => (boolean)$value->{'shareEnabled'},
                        'complexPassword' => (string)$value->{'complexPassword'},
                        'shareExpireDateEnable' => (boolean)$value->{'shareExpireDateEnable'},
                        'allowDownload' => (string)$value->{'allowDownload'},
                        'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
                        'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
			'osType' => (string)$value->{'osType'},
                        'calloutScripts' => $value->{'calloutScripts'},
                        'compressionEnabled' => $value->{'compressionEnabled'},
                        'pftEnabled' => (string)$value->{'pftEnabled'},
                        'pftSize' => (string)$value->{'pftSize'},
                        'vssEnabled' => (string)$value->{'vssEnabled'},
                        'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                        'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                        'policyRefresh' => (string)$value->{'policyRefresh'},
                        'dedup' => (string)$value->{'dedup'},
                        'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
                        'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
                        'policygroupName' => (string)$value->{'policygroupName'},
                        'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                        'scheduleNames' => (array)$value->{'scheduleNames'},
                        'downloadAgent' => (boolean)$value->{'downloadAgent'},
                        'passwordChangeEnforce' => $value->{'passwordChangeEnforce'},
                        'canUserChangePassword' => $value->{'canUserChangePassword'},
                        'canAdminChangeUserPassword' => $value->{'canAdminChangeUserPassword'},
                        'menuOptions' => (array)$value->{'menuOptions'},
                        'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
                        'canAdminRestore' => (boolean)$value->{'canAdminRestore'},
			'canAdminDelete' => (boolean)$value->{'canAdminDelete'},
                        'daysToWaitForNextBackup' => (string)$value->{'daysToWaitForNextBackup'},
                    );
                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
		    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
	}
    }
	
    /*pagination starts*/	
	
	public function getAllPoliciesPagination(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true',
                'Content-Type'  => 'application/json',
                'Accept' => 'application/json'
            );
            $result = $this->_model->getAllPoliciesPagination($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
		    if(!empty($result['body']->{'data'}->{'backupPolicyElements'})){
			    foreach($result['body']->{'data'}->{'backupPolicyElements'} as $value){
				$policy = array(
				    /*'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
				    'cpuUtilization' => (string)$value->{'cpuUtilization'},
				    'memoryUtilization' => (string)$value->{'memoryUtilization'},
				    'crawlLimit' => (string)$value->{'crawlLimit'},
				    'description' => (string)$value->{'description'},
				    'mappedUserCount' => (int)$value->{'mappedUserCount'},
				    'dcmEnabled' => (string)$value->{'dcmEnabled'},
				    'destination' => (string)$value->{'destination'},
				    //'filterInclusionName' => $value->{'inclusionFilterElement'}->{'filterName'},
				    'filterInclusionName' => (array)$value->{'filterInclusionName'},
				    'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				    'lmts' => (string)$value->{'lmts'},
				    'maxFileSize' => (string)$value->{'maxFileSize'},
				    'maxVersions' => $value->{'maxVersions'},
				    'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
				    'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
				    'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
				    'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
				    'osType' => (string)$value->{'osType'},
				    'compressionEnabled' => (string)$value->{'compressionEnabled'},
				    'pftEnabled' => (string)$value->{'pftEnabled'},
				    'pftSize' => (string)$value->{'pftSize'},
				    'policyRefresh' => (string)$value->{'policyRefresh'},
				    'dedup' => (string)$value->{'dedup'},
				    'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
				    'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
				    'policygroupName' => (string)$value->{'policygroupName'},
				    'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
				    'scheduleNames' => (array)$value->{'scheduleNames'},
				    'blocked' => $value->{'blocked'},
				    'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
				    'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
				    'active' => (boolean)$value->{'active'},*/
	    			    'active' => (boolean)$value->{'active'},
				    'policygroupName' => (string)$value->{'policygroupName'},
				    'scheduleNames' => (array)$value->{'scheduleNames'},
				    'maxVersions' => $value->{'maxVersions'},
				    'filterInclusionName' => (array)$value->{'filterInclusionName'},
				    'mappedUserCount' => (int)$value->{'mappedUserCount'},
				);
				$policy['maxVersionsForSort'] = $policy['maxVersions'];
				if($policy['maxVersions'] == '-1'){
				    $policy['maxVersionsForSort'] = '10000000';
				}
				$policies = array_merge(array($policy), $policies);
			    }
		    }else{
			$policies = [];
		    }
		    if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		    }else{
			$metadata = [];
		    }
                    $response = array(
                        'result' => 'success',
                        'policies' => $policies,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
		    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
        }

    public function getAllPoliciesPaginationNavigate(){
        //Auth::allowOnly('admin');
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true',
                'Content-Type'  => 'application/json',
		'Accept' => 'application/json'
            );
            $result = $this->_model->getAllPoliciesPaginationNavigate($headers, $_POST['url']);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
		    if(!empty($result['body']->{'data'}->{'backupPolicyElements'})){
			    foreach($result['body']->{'data'}->{'backupPolicyElements'} as $value){
				$policy = array(
				    'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
				    'cpuUtilization' => (string)$value->{'cpuUtilization'},
				    'memoryUtilization' => (string)$value->{'memoryUtilization'},
				    'crawlLimit' => (string)$value->{'crawlLimit'},
				    'description' => (string)$value->{'description'},
				    'mappedUserCount' => (int)$value->{'mappedUserCount'},
				    'dcmEnabled' => (string)$value->{'dcmEnabled'},
				    'destination' => (string)$value->{'destination'},
				    //'filterInclusionName' => $value->{'inclusionFilterElement'}->{'filterName'},
				    'filterInclusionName' => (array)$value->{'filterInclusionName'},
				    'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				    'lmts' => (string)$value->{'lmts'},
				    'maxFileSize' => (string)$value->{'maxFileSize'},
				    'maxVersions' => $value->{'maxVersions'},
				    'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
				    'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
				    'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
				    'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
				    'osType' => (string)$value->{'osType'},
				    'compressionEnabled' => (string)$value->{'compressionEnabled'},
				    'pftEnabled' => (string)$value->{'pftEnabled'},
				    'pftSize' => (string)$value->{'pftSize'},
				    'policyRefresh' => (string)$value->{'policyRefresh'},
				    'dedup' => (string)$value->{'dedup'},
				    'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
				    'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
				    'policygroupName' => (string)$value->{'policygroupName'},
				    'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
				    'scheduleNames' => (array)$value->{'scheduleNames'},
				    'blocked' => $value->{'blocked'},
				    'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
				    'webBasedLogin' => (boolean)$value->{'webBasedLogin'},
				    'active' => (boolean)$value->{'active'},
				);
				$policy['maxVersionsForSort'] = $policy['maxVersions'];
				if($policy['maxVersions'] == '-1'){
				    $policy['maxVersionsForSort'] = '10000000';
				}
				$policies = array_merge(array($policy), $policies);
                    	}
		    }else{
			$policies = [];
		    }

		if(!empty($result['body']->{'metadata'})){
			$metadata = $result['body']->{'metadata'};
			$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }
                    $response = array(
                        'result' => 'success',
                        'policies' => $policies,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
		    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
 )
            );
        }
    }
	
	
    public function getAllPoliciesOfficePagination(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true',
		'Content-Type'  => 'application/json',
		'Accept' => 'application/json'		    
            );
            $result = $this->_model->getAllPoliciesOfficePagination($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
		    if(!empty($result['body']->{'data'}->{'officeBackupPolicyElements'})){
			    foreach($result['body']->{'data'}->{'officeBackupPolicyElements'} as $value){
				$policy = array(
				    'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
				    'cpuUtilization' => (string)$value->{'cpuUtilization'},
				    'memoryUtilization' => (string)$value->{'memoryUtilization'},
				    'crawlLimit' => (string)$value->{'crawlLimit'},
				    'description' => (string)$value->{'description'},
				    'mappedUserCount' => (int)$value->{'mappedUserCount'},
				    'dcmEnabled' => (string)$value->{'dcmEnabled'},
				    'destination' => (string)$value->{'destination'},
				    //'filterInclusionName' => (string)$value->{'filterInclusionName'},
				    'filterInclusionName' => (array)$value->{'filterInclusionName'},
				    'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				    'lmts' => (string)$value->{'lmts'},
				    'maxFileSize' => (string)$value->{'maxFileSize'},
				    'maxVersions' => $value->{'odMaxVersions'},
	//                            'maxVersions' => $value->{'maxVersions'},
				    'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
				    'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
				    'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
				    'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
				    'osType' => (string)$value->{'osType'},
				    'compressionEnabled' => (string)$value->{'compressionEnabled'},
				    'pftEnabled' => (string)$value->{'pftEnabled'},
				    'pftSize' => (string)$value->{'pftSize'},
				    'policyRefresh' => (string)$value->{'policyRefresh'},
				    'dedup' => (string)$value->{'dedup'},
				    'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
				    'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
				    'policygroupName' => (string)$value->{'policygroupName'},
				    'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
				    'scheduleNames' => (array)$value->{'scheduleNames'},
				    'blocked' => $value->{'blocked'},
				    'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
				    'active' => (boolean)$value->{'active'},
				);
				$policy['maxVersionsForSort'] = $policy['maxVersions'];
				if($policy['maxVersions'] == '-1'){
				    $policy['maxVersionsForSort'] = '10000000';
				}
				$policies = array_merge(array($policy), $policies);
			    }
		    }else{
			$policies = [];
		    }

		if(!empty($result['body']->{'metadata'})){
		        $metadata = $result['body']->{'metadata'};
		        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies,
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }



    public function getAllPoliciesOfficePaginationNavigate(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'loadOnlyBasic' => 'true',
		'Content-Type'  => 'application/json',
		'Accept' => 'application/json'
            );
            $result = $this->_model->getAllPoliciesOfficePaginationNavigate($headers, $_POST['url']);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
		    if(!empty($result['body']->{'data'}->{'officeBackupPolicyElements'})){
			    foreach($result['body']->{'data'}->{'officeBackupPolicyElements'} as $value){
				$policy = array(
				    'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
				    'cpuUtilization' => (string)$value->{'cpuUtilization'},
				    'memoryUtilization' => (string)$value->{'memoryUtilization'},
				    'crawlLimit' => (string)$value->{'crawlLimit'},
				    'description' => (string)$value->{'description'},
				    'mappedUserCount' => (int)$value->{'mappedUserCount'},
				    'dcmEnabled' => (string)$value->{'dcmEnabled'},
				    'destination' => (string)$value->{'destination'},
				    //'filterInclusionName' => (string)$value->{'filterInclusionName'},
				    'filterInclusionName' => (array)$value->{'filterInclusionName'},
				    'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				    'lmts' => (string)$value->{'lmts'},
				    'maxFileSize' => (string)$value->{'maxFileSize'},
				    'maxVersions' => $value->{'odMaxVersions'},
	//                            'maxVersions' => $value->{'maxVersions'},
				    'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
				    'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
				    'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
				    'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
				    'osType' => (string)$value->{'osType'},
				    'compressionEnabled' => (string)$value->{'compressionEnabled'},
				    'pftEnabled' => (string)$value->{'pftEnabled'},
				    'pftSize' => (string)$value->{'pftSize'},
				    'policyRefresh' => (string)$value->{'policyRefresh'},
				    'dedup' => (string)$value->{'dedup'},
				    'fullBackupEnabled' => (string)$value->{'fullBackupEnabled'},
				    'fullBackupStartDate' => date('d-m-Y', (int)$value->{'fullBackupStartDate'}),
				    'policygroupName' => (string)$value->{'policygroupName'},
				    'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
				    'scheduleNames' => (array)$value->{'scheduleNames'},
				    'blocked' => $value->{'blocked'},
				    'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
				    'active' => (boolean)$value->{'active'},
				);
				$policy['maxVersionsForSort'] = $policy['maxVersions'];
				if($policy['maxVersions'] == '-1'){
				    $policy['maxVersionsForSort'] = '10000000';
				}
				$policies = array_merge(array($policy), $policies);
			    }
		    }else{
			$policies = [];
		    }

		if(!empty($result['body']->{'metadata'})){
		        $metadata = $result['body']->{'metadata'};
		        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                }else{
                	$metadata = [];
                }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies,
			'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    /*pagination ends*/

}
