<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Backup;
use ZMQ;
use ZMQContext;
use ZMQPoll;
use ZMQSocket;
use Helpers\Auth;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */
class BackupController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;
    protected $_codeLength = 6;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('backup');
        $this->_model = new Backup();
        $this->verifyAndCleanItUp();
    }

    public function devices(){
	    $visible = '';
	    if($this->session->get('firstLogin1') == "true" && $this->session->get('localUser') == '1'){
            	$visible = 'visible';
            }
	    $devices = $this->getUserDevices1();	    
	    $data = array(
            'title' => $this->language->get('indexPageName'),
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('devices'),
            'active' => 'backup',
            'devices' => $devices,
            'selectedUser' => $this->session->get('userName'),
            'loggedInUser' => $this->session->all(),
	    'secret' => $this->session->get('googleSecretKey'),
 	    'popup' => $visible
        );
        $data['lastLoginTime'] = ''; 
        if($this->session->get('readOnlyAdmin') == "1" || $this->session->get('admin') == "1"){
            $lastLoginTime = "nil";
            $data['lastLoginTime'] = $lastLoginTime;
        }else{
            if($this->session->get('lastLoggedInTime') != ""){
                $lastLoginTime = date('d-M-y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
                $data['lastLoginTime'] = $lastLoginTime;
            }
        }
	 $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
	 );	
	$cloudProperties = $this->_model->getCloudProperties($headers);
	$showAuditHistory = $cloudProperties['body']->{'cloudPropertyElement'}->{'showAuditHistory'};
        $this->session->put('showAuditHistory',$showAuditHistory);
        if($this->session->get('admin') == true){
                $this->session->put('showAuditHistory',true);
        }else if($this->session->get('readOnlyAdmin') == true){
                $this->session->put('showAuditHistory',$showAuditHistory);
        }else{
                $this->session->put('showAuditHistory',true);
        }
	$data['session_cok'] = $_COOKIE['PARABLU_INC'];
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('backup/devices', $data);
        View::renderTemplate('footer', $data);
    }

    public function restoreFiles($deviceId, $deviceName, $deviceUUID){
        $this->session->put('currentDeviceUUID', $deviceUUID);
        $this->session->put('currentDeviceId', $deviceId);
        $this->session->put('currentDeviceName', $deviceName);
        if(empty($this->session->get('previousDeviceId'))){
            $this->session->put('previousDeviceId', $deviceId);
        }elseif($this->session->get('previousDeviceId') != $deviceId){
            $this->session->put('previousDeviceId', $deviceId);
            $this->session->put('filePath', '');
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('device'),
            'crumb2' => $deviceName,
            'active' => 'backup',
            'crumb3' => $this->language->get('files'),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('backup/restoreFiles', $data);
        View::renderTemplate('footer', $data);
    }

    public function files($deviceId, $deviceName, $deviceUUID, $deviceType, $deviceOs, $userName, $blocked){
	$deviceName = str_replace('_PB_', ' ', $deviceName);
	$deviceType = str_replace('_PB_', ' ', $deviceType);
	$deviceOs = str_replace('_PB_', ' ', $deviceOs);
        $this->session->put('currentDeviceUUID', $deviceUUID);
        $this->session->put('currentDeviceId', $deviceId);
        $this->session->put('currentDeviceName', $deviceName);
        if(empty($this->session->get('previousDeviceId'))){
            $this->session->put('previousDeviceId', $deviceId);
        }elseif($this->session->get('previousDeviceId') != $deviceId){
            $this->session->put('previousDeviceId', $deviceId);
            $this->session->put('filePath', '');
        }
        $headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
        $cloudProperties = $this->_model->getCloudProperties($headers);
        $extensionsToPdfView = $cloudProperties['body']->{'cloudPropertyElement'}->{'extensionsToPdfView'};
        $devices = $this->getUserDevices1();
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'csrf_token' => $this->setCSRFToken(),
            'device_type' => $deviceType,
            'device_OS' => $deviceOs,
            'crumb1' => $this->language->get('device'),
            'crumb2' => $deviceName,
            'active' => 'backup',
            //'policy' => $this->getPolicy(),
            'devices' => $devices,
            'extensionsToPdfView' => $extensionsToPdfView,
            'crumb3' => $this->language->get('files'),
            'loggedInUser' => $this->session->all(),
            'deviceUserName' => $userName,
            'isblocked' => $blocked,
            'uuid' => $deviceUUID,
            'isAdminDeleteBackupFile' => json_encode($cloudProperties['body']->{'cloudPropertyElement'}->{'isAdminDeleteBackupFile'}),
            'canAdminRestoreAll' => json_encode($cloudProperties['body']->{'cloudPropertyElement'}->{'canAdminRestoreAll'}),
	    'overridePolicySettings' => json_encode($cloudProperties['body']->{'cloudPropertyElement'}->{'overridePolicySettings'}),
        );
        if($deviceOs == 'windows' || $deviceOs == 'apple'){
                $data['policy'] = $this->getPolicy();
	}
        else{
                $data['policy'] = $this->getOneDrivePolicy();
        }
	$data['userType'] = 'user';
	$data['isAdmin'] = 'false';
        if($this->session->get('admin') == true){
            $data['isAdmin'] = 'true';
            $data['userType'] = 'admin';
        }
	$data['canAdminRestore'] = $data['policy']['canAdminRestore'];
        $data['allowEndUserTocontrolRestore'] = $data['policy']['allowEndUserTocontrolRestore'];
        $data['searchAlgoForPg'] = $data['policy']['searchAlgoForPg'];
	$data['shareDomainType'] = $data['policy']['shareDomainType'];
        $data['shareDomainIncExclusions'] = $data['policy']['shareDomainIncExclusions'];
	if($data['policy']['searchAlgoForPg'] == 'PRIORITY'){
                $data['privacyGatewayNames'] = implode(',',$data['policy']['privacyGatewayMappingElement']['privacyGatewayNames']);
        }else{
                $data['privacyGatewayNames'] = '';
        }
        $data['userName'] = base64_encode($this->session->get('userName'));
	if($this->session->get('oneDriveArchivingEnabled') == "true"){
                $data['oneDriveArchivingEnabled'] = 'true';
        }else{
                $data['oneDriveArchivingEnabled'] = 'false';
        }
	if($this->session->get('mailArchivingEnabled') == "true"){
                $data['mailArchivingEnabled'] = 'true';
        }else{
                $data['mailArchivingEnabled'] = 'false';
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('backup/files', $data);
        View::renderTemplate('footer', $data);
    }
    
    public function downloadFolder(){
            $headers = array(
                'token'         => $this->session->get('token')
            );
	    $this->log("filename--->".$_POST['fileName'],"info");
	    $this->log("username--->".$_POST['userName'],"info");
            $result = $this->_model->downloadFolder($headers, $_POST['userName'], $_POST['fileName'],
	    $_POST['syncRevisionId'],$_POST['filePath'],$_POST['deviceUUID'], $_POST['gatewayName'], $_POST['restoreDeletedFile']);
	    $this->log("--------11111------> : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'filePath' => $result['header']->container['file-download-path']
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function downloadFolderAsPst(){
	    if(is_array($_POST['syncRevisionId'])){
                    $_POST['syncRevisionId'] = implode(',', $_POST['syncRevisionId']);
            }
            $headers = array(
                'token'			=> $this->session->get('token'),
		'syncRevisionId' 	=> $_POST['syncRevisionId'],
		'pstName' 		=> $_POST['customeName']
            );
	    $this->log("syncRevisionId--->".$_POST['syncRevisionId'],"info");
            $this->log("filename--->".$_POST['fileName'],"info");
            $this->log("username--->".$_POST['userName'],"info");
	    $this->log("headers--->".json_encode($headers),"info");
            $result = $this->_model->downloadFolderAsPst($headers, $_POST['userName'], $_POST['fileName'],
            $_POST['syncRevisionId'],$_POST['filePath'],$_POST['deviceUUID'], $_POST['gatewayName']);
            $this->log("--------11111------> : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'filePath' => $result['header']->container['file-download-path']
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
		    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadFolderAsPstGlobal(){
            $headers = array(
		    'token'		=> $this->session->get('token'),
		    'pstName' 		=> $_POST['customeName']
            );
	    $this->log("--------11111------>ggggggggggggg : ".json_encode($_POST['userName']),"info");
	    $this->log("--------11111------>gggbackupId : ".json_encode($_POST['backupId']),"info");
	    if(!empty($_POST['backupId'])){
		    $_POST['backupId'] = implode(',', $_POST['backupId']);
	    }
	    $this->log("--------11111------>gggbackupId : ".json_encode($_POST['backupId']),"info");
	    $this->log("customeName : ".$_POST['customeName'], "info");
            $result = $this->_model->downloadFolderAsPstGlobal($headers, $_POST['batchId'], $_POST['userName'], $_POST['backupId']);
            $this->log("--------11111------> : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'filePath' => $result['header']->container['file-download-path']
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                    	 'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function selectedFles(){
	    $headers = array(
		    'Content-type'  => 'application/json',
            	    'Accept'        => 'application/json',
                    'token'         => $this->session->get('token')
            );
	    //$this->log("--------11111------>ggggggggggggg : ".json_encode($_POST['customeName']),"info");
	    $this->log("--------11111------>ggggggggggggg : ".json_encode($_POST['backupId']),"info");
	    $this->log("--------11111------>ggggggggggggg : ".json_encode($_POST['deviceUUID']),"info");
	    $bkpids = array();
	    $uuids = array();
	    foreach( $_POST['backupId'] as $key ) {
		$bkpids[]['backupId'] = $key;
	    }
	    $this->log("--------11111------>ggggggggggggg : ".json_encode($bkpids),"info");
	    foreach( $_POST['deviceUUID'] as $key ) {
                $uuids[]['deviceUUID'] = $key;
            }
	    $this->log("--------11111------>ggggggggggggg : ".json_encode($uuids),"info");
	    for($i=0;$i<sizeof($bkpids);$i++){
                    $this->log('Result_gggggggggggggggggggggggggggggggggg: ','info');
                    $bigDog[] = array_merge($bkpids[$i],$uuids[$i]);
	    }
	    $this->log("--------11111------>ggggggggggggg : ".json_encode($bigDog),"info");
	    $data = array(
		    //"pstName"=> $_POST['customeName'],
		    "downloadAsPst"=> true,
		    "pstBatchDetailElements" => $bigDog	    
	    );
            $this->log("--------11111------data : ".json_encode($data),"info");
            $result = $this->_model->selectedFles($headers, $data);
            $this->log("--------11111------> : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'batchId' => $result['header']->container['batchId']
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                         'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function downloadFileAsStream(){
        $this->log("inside filepath".$_GET['filePath'],"info");      
        $filePath = $_GET['filePath'];
        $fileName = basename($filePath);
        $this->log("inside fileName : ".$fileName,"info");

        if(file_exists($filePath)){
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename='.$fileName);
            header('Pragma: no-cache');
            ob_clean();
            //while(!feof($filePath)) {
            readfile($filePath);
            //}
            $this->log("Download Completed".readfile($filePath),"info");
            $headers = array(
                'file-download-path'         => $filePath
            );
            $result = $this->_model->downloadFileAsStream($headers);
            $this->log("after download as stream log".json_encode($result),"info");
            }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }	



    public function downloadFileee(){
        $this->log("inside filepath".$_GET['filePath'],"info");
        $filePath = $_GET['filePath'];
        $fileName = basename($filePath);
        $this->log("inside fileName : ".$fileName,"info");

        if(file_exists($filePath)){
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename='.$fileName);
            header('Pragma: no-cache');
            ob_clean();
            //while(!feof($filePath)) {
            readfile($filePath);
            //}
            $this->log("Download Completed".readfile($filePath),"info");
            $headers = array(
                'filePath'         => $filePath
            );
            $result = $this->_model->deleteFolderNew($headers);
            $this->log("after delete log".json_encode($result),"info");
            switch ($result['status']) {
                        case (200):
                            $response = array(
                                'result' => 'success',
                                'message' => 'File deleted Successfully.'
                            );
                            $this->log("after delete Deleted Successfully","info");
                            echo json_encode($response);
                            exit;
                        case (507):
                            $result = array(
                                'result' => 'fail',
                                'msg' => 'File not exist.'
                            );
                            echo json_encode($result);
                            exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }
            }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }

    public function getPolicy(){
        //$policyName = $this->session->get('policyName');
        //if(!empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token'),
                'userName' => $this->session->get('userName')
            );
            $result = $this->_model->getUserBackupPolicy($headers);
            $this->log('result'.json_encode($result), 'info');
            if($result['status'] == 200){
                $value = $result['body']->{'backupPolicyElement'};
		if(!empty($value->{'shareDomainIncExclusions'})){
                        $value->{'shareDomainIncExclusions'} = implode (",", $value->{'shareDomainIncExclusions'});
                }
                return array(
                    'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                    'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                    'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                    'cpuUtilization' => (string)$value->{'cpuUtilization'},
                    'memoryUtilization' => (string)$value->{'memoryUtilization'},
                    'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                    'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                    'crawlLimit' => (string)$value->{'crawlLimit'},
                    'dcmEnabled' => (string)$value->{'dcmEnabled'},
                    'destination' => (string)$value->{'destination'},
                    'filterInclusionName' => (array)$value->{'filterInclusionName'},
                    'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
//                    'lmts' => (string)$value->{'lmts'},
                    'maxFileSize' => (string)$value->{'maxFileSize'},
                    'maxVersions' => (string)$value->{'maxVersions'},
                    'shareEnabled' => (string)$value->{'shareEnabled'},
                    'complexPassword' => (string)$value->{'complexPassword'},
                    'shareExpireDateEnable' => (string)$value->{'shareExpireDateEnable'},
                    'allowDownload' => (string)$value->{'allowDownload'},
                    'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
		    'googleAuth' => (string)$value->{'googleAuth'},
                    'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                    'osType' => (string)$value->{'osType'},
                    'calloutScripts' => $value->{'calloutScripts'},
                    'compressionEnabled' => $value->{'compressionEnabled'},
                    'pftEnabled' => (string)$value->{'pftEnabled'},
                    'pftSize' => (string)$value->{'pftSize'},
                    'vssEnabled' => (string)$value->{'vssEnabled'},
                    'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                    'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                    'policyRefresh' => (string)$value->{'policyRefresh'},
                    'policygroupName' => (string)$value->{'policygroupName'},
                    'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                    'scheduleNames' => (array)$value->{'scheduleNames'},
		    'canAdminRestore' => (string)$value->{'canAdminRestore'},
                    'agentPassword' => !empty($value->{'agentPassword'}) ? $value->{'agentPassword'} : '',
                    'switchAgentPassword' => !empty($value->{'switchAgentPassword'}) ? (boolean)$value->{'switchAgentPassword'} : false,
                    'shareDomainType' => !empty($value->{'shareDomainType'}) ? $value->{'shareDomainType'} : 'Share only with these Email domains',
                    'shareDomainIncExclusions' => !empty($value->{'shareDomainIncExclusions'}) ? $value->{'shareDomainIncExclusions'} : '',
                    'allowEndUserTocontrolRestore' => !empty($value->{'allowEndUserTocontrolRestore'}) ? (boolean)$value->{'allowEndUserTocontrolRestore'} : false,
                    'menuOptions' => (array)$value->{'menuOptions'},
                    'userSizeAllowed' => (string)$value->{'userSizeAllowed'},
		    'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
		    'shareDomainIncExclusions'           => !empty($value->{'shareDomainIncExclusions'}) ? $value->{'shareDomainIncExclusions'} : '',
		    'showShareLink'   => (string)$value->{'showShareLink'},
		    'searchAlgoForPg' => (string)$value->{'searchAlgoForPg'},
		    'filterType' => (string)$value->{'filterType'},
		    //'shareDomainType' => !empty($value->{'shareDomainType'}) ? $value->{'shareDomainType'} : 'Share only with these Email domains',,

                );
            }else{
                return array();
            }

        /*}else{
            return array();
        }*/
    }
    
    public function getOneDrivePolicy(){
        //$policyName = $this->session->get('policyName');
            //if(!empty($policyName)){
            $this->log("newwwwwwww policy functionnnnnnnnn","info");
            $headers = array(
                'token' => $this->session->get('token'),
                'userName' => $this->session->get('userName')
            );
            $result = $this->_model->getOneDriveUserBackupPolicy($headers);
            $this->log('result'.json_encode($result), 'info');
            if($result['status'] == 200){
                $value = $result['body']->{'officeBackupPolicyElement'};
                return array(
                    'backupSystemFilesEnabled' => $value->{'backupSystemFilesEnabled'},
                    'legalHoldEnabled' => $value->{'legalHoldEnabled'},
                    'backupFolderPaths' => (array)$value->{'backupFolderPaths'},
                    'cpuUtilization' => (string)$value->{'cpuUtilization'},
                    'memoryUtilization' => (string)$value->{'memoryUtilization'},
                    'nwFromPGToCloud' => (string)$value->{'nwFromPGToCloud'},
                    'nwFromClientToPG' => (string)$value->{'nwFromClientToPG'},
                    'crawlLimit' => (string)$value->{'crawlLimit'},
                    'dcmEnabled' => (string)$value->{'dcmEnabled'},
                    'destination' => (string)$value->{'destination'},
                    'filterInclusionName' => (string)$value->{'filterInclusionName'},
                    'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                    'lmts' => (string)$value->{'lmts'},
                    'maxFileSize' => (string)$value->{'maxFileSize'},
                    'maxVersions' => (string)$value->{'maxVersions'},
                    'shareEnabled' => (string)$value->{'shareEnabled'},
                    'complexPassword' => (string)$value->{'complexPassword'},
                    'shareExpireDateEnable' => (string)$value->{'shareExpireDateEnable'},
                    'allowDownload' => (string)$value->{'allowDownload'},
                    'highSecureShareEnabled' => (string)$value->{'highSecureShareEnabled'},
                    'networkThrottlingNames' => (array)$value->{'networkThrottlingNames'},
                    'osType' => (string)$value->{'osType'},
                    'calloutScripts' => $value->{'calloutScripts'},
                    'compressionEnabled' => $value->{'compressionEnabled'},
                    'pftEnabled' => (string)$value->{'pftEnabled'},
                    'pftSize' => (string)$value->{'pftSize'},
                    'vssEnabled' => (string)$value->{'vssEnabled'},
                    'fileChunkableSize' => (string)$value->{'fileChunkableSize'},
                    'fullBackupSchedule' => (string)$value->{'fullBackupSchedule'},
                    'policyRefresh' => (string)$value->{'policyRefresh'},
                    'policygroupName' => (string)$value->{'policygroupName'},
                    'privacyGatewayMappingElement' => (array)$value->{'privacyGatewayMappingElement'},
                    'scheduleNames' => (array)$value->{'scheduleNames'},
                    'menuOptions' => (array)$value->{'menuOptions'},
                    'userSizeAllowed' => (string)$value->{'userSizeAllowed'}
                );
            }else{
                return array();
            }

        /*}else{
            return array();
        }*/
    }
    
    public function isShareCheck(){

        if(!empty($_POST)){
            $stat = $this->collectStats();
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token'),
                'productType'       => "backup",
                'deviceUUID' => $this->session->get('currentDeviceUUID'),
                'backupId' => $_POST['backupID']
            );
            if($_POST['type']){
                $headers['osType']  = $this->getOS($_SERVER['HTTP_USER_AGENT']);
                $headers['browser'] = $_SERVER['SERVER_NAME'];
                $headers['ip']      = $stat['remoteAdd'];
                $headers['accessType']    = $_POST['type'];
            }

            $headers['miniCloudName'] = '';
            $headers['devicePath'] = htmlspecialchars_decode($_POST['filePath']);
            $headers['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);

            $result = $this->_model->isSharedOrNot($headers);
            if($result['status'] == 302){
                $shared = $result['body']->{'sharedFileImageElement'};
                if($shared->{'passwordProtected'} == true){
                    $type = md5('protected');
                }else{
                    $type = md5('read');
                }
                $link = SHARE_PATH.$type.DS.$shared->{'key12'}.DS.$shared->{'key14'}.DS.$shared->{'key18'}.DS.$shared->{'key20'};
                $isShared = true;
		$googlesecret = $shared->{'secretkey'};
		$shared->{'validUntil'} = !(empty($shared->{'validUntil'})) ? date('d-M-Y', strtotime(date('d-M-Y', (((int)$shared->{'validUntil'}) / 1000)) . ' -1 day')) : null;		    
                //$shared->{'validUntil'} = !(empty($shared->{'validUntil'})) ? date('m/d/Y', strtotime(date('m/d/y', (((int)$shared->{'validUntil'}) / 1000)) . ' -1 day')) : null;
            }else{
		$website = PARACLOUD_IP; //Your Website
    		$title= 'Share';
    		$abc = $this->createSecret();
                $shared = array();
                $link = '';
		$googlesecret = $abc;
                $isShared = false;
            }

            $response = array(
                'data' => $shared,
                'result' => $isShared,
		'googlesecret' => $googlesecret,
                'link' => $link
            );
            echo json_encode($response);
            exit;

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getFiles(){
        if(empty($_POST) && empty($_POST['filePath'])){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }

        if($_POST['refresh'] == 'true'){
            $filePath = (!empty($this->session->get('filePath'))) ? $this->session->get('filePath') : '';
        }else{
            $filePath = ($_POST['filePath'] == 'root') ? '' : $_POST['filePath'];
        }
        $filePath = html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5);
        $headers = array(
            //'filePath'      => html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5),
            'filePath'      => base64_encode($filePath),
            'deviceId'      => $this->session->get('currentDeviceId'),
            'token'         => $this->session->get('token'),
	    'restoreDeletedFile'        => $_POST['restoreDeletedFile']
        );
        /*if($_POST['type'] == 'OUTLOOK'){
            $this->log("oooooooooooooooooooooooooooooooooooooooooooooooooo","info");
            $result = $this->_model->getFiles1($headers);
        }else{
            $result = $this->_model->getFiles($headers);
	}*/
	$result = $this->_model->getFiles($headers);
        $this->log('result: '.json_encode($result), 'info');
	$this->session->put('filePath', 'root');
        switch ($result['status']) {
            case (200):
                $items = array();
                if(!empty($result['body']->{'backup-file'})){
                    foreach($result['body']->{'backup-file'} as $value){
                        if($value->{'folder'} == 'true'){
                            $folder = array(
                                'backupId' => (string)$value->{'backupId'},
                                'checksum' => (string)$value->{'checksum'},
                                'exists' => (string)$value->{'exists'},
                                'name' => (string)$value->{'file-name'},
                                'user' => (string)$value->{'file-user'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'type' => 'Folder',
                                'icon' => 'folder',
                                'size' => '',
                                'filePath' => (string)$value->{'file-path'},
                                'fullPath' => (!empty((string)$value->{'file-path'})) ? (string)$value->{'file-path'}.'/'.(string)$value->{'file-name'} : (string)$value->{'file-name'},
                                'fsPath' => (string)$value->{'fs-path'},
                                'baseFolder' => (string)$value->{'is-basefolder'},
                                'externalStorage' => (string)$value->{'is-externalStorage'},
                                'clientModifiedTimeInMillis' => (int)$value->{'client-modified-time'},
                                'serverModifiedTimeInMillis' => (int)$value->{'server-modified-time'},
                                'clientModifiedTime' => (!empty($value->{'client-modified-time'}) && $value->{'client-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'client-modified-time'}) / 1000)) : '',
                                'serverModifiedTime' => (!empty($value->{'server-modified-time'}) && $value->{'server-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'server-modified-time'}) / 1000)) : '',
                                'status' => (string)$value->{'status'}
                            );
                            $items = array_merge(array($folder), $items);
                        }else{
                            $fileExt = explode('.', (string)$value->{'file-name'});
                            $file = array(
                                'backupId' => (string)$value->{'backupId'},
                                'checksum' => (string)$value->{'checksum'},
                                'exists' => (string)$value->{'exists'},
                                'name' => (string)$value->{'file-name'},
                                'user' => (string)$value->{'file-user'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'type' => 'File',
                                'filePath' => (string)$value->{'file-path'},
                                'fullPath' => (!empty((string)$value->{'file-path'})) ? (string)$value->{'file-path'}.'/'.(string)$value->{'file-name'} : (string)$value->{'file-name'},
                                'icon' => $this->getFileIcon(end($fileExt)),
                                'fsPath' => (string)$value->{'fs-path'},
                                'baseFolder' => (string)$value->{'is-basefolder'},
                                'storagePlace' => (!empty((string)$value->{'storagePlace'})) ? (string)$value->{'storagePlace'} : 'PG',
                                'externalStorage' => (string)$value->{'is-externalStorage'},
                                'clientModifiedTimeInMillis' => (int)$value->{'client-modified-time'},
                                'serverModifiedTimeInMillis' => (int)$value->{'server-modified-time'},
                                'clientModifiedTime' => (!empty($value->{'client-modified-time'}) && $value->{'client-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'client-modified-time'}) / 1000)) : '',
                                'serverModifiedTime' => (!empty($value->{'server-modified-time'}) && $value->{'server-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'server-modified-time'}) / 1000)) : '',
                                'rawSize' => (int)(string)$value->{'size'},
                                'size' => $this->getFileSize((string)$value->{'size'}),
                                'status' => (string)$value->{'status'}
                            );
                            $items = array_merge(array($file), $items);
                        }
                    }
                }
                if(!empty($items)){
                    $this->session->put('filePath', $filePath);
		}
		$metadata = [];
/*                if($_POST['type'] == 'OUTLOOK'){
                    if(!empty($result['body']->{'metadata'})){
                    $metadata = $result['body']->{'metadata'};
                    $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                    $metadata = [];
                    }
		}*/

                $response = array(
                    'result' => 'success',
                    'post' => html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5),
                    'items' => $items,
                    'metadata' => $metadata
                );
                if($_POST['refresh'] == 'true' && !empty($filePath)){
                    $response['crumb'] = explode('/', $filePath);
                    $response['crumbString'] = $filePath;
                }
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getDevices(){
        if(!empty($_POST) && !empty($_POST['userName'])){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getDevices($headers, !empty($_POST['userName']) ? $_POST['userName'] : base64_encode($this->session->get('userName')));
            switch ($result['status']) {
                case (200):
                    $devices = array();
                    if(!empty($result['body']->{'device-info'})){
                        foreach($result['body']->{'device-info'} as $value){
                            $device = array(
                                'name'          => (string)$value->{'device-name'},
                                'userName'      => base64_encode((string)$value->{'userName'}),
                                'decoupled'     => (string)$value->{'decoupled'},
                                'id'            => (string)$value->{'device-id'},
                                'uuId'          => (string)$value->{'device-uuid'},
                                'deviceType' => !empty((string)$value->{'deviceType'}) ? (string)$value->{'deviceType'} : 'Windows',
     				//'deviceType' => (string)$value->{'deviceType'},
                                'tempPath'      => (string)$value->{'device-temp-path'},
                                'status'        => ($value->{'is-blocked'} == 'false') ? 'Active' : 'In-Active',
                                'blocked'       => (string)$value->{'is-blocked'},
                                //'os'            => $this->getOsType($value->{'device-os-type'}),
                                'os' => ((string)$value->{'device-os-type'} == 'OUTLOOK') ? 'envelope' : $this->getOsType($value->{'device-os-type'}),
                                'version'       => (string)$value->{'device-os-version'},
                                //'icon'          => $this->getOsIcon($value->{'device-os-type'}),
                                'icon' => ((string)$value->{'device-os-type'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'device-os-type'}),
                                'modifiedOn'    => date('d-M-Y H:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                                'createdOn'     => date('d-M-Y H:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                                'lastSuccessfullBackup'          => (string)$value->{'lastSuccessfullBackup'},
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getFileVersions(){
        if(!empty($_POST['fileName']) && !empty($_POST['filePath'])){
            $_POST['filePath'] = html_entity_decode($_POST['filePath'], ENT_QUOTES | ENT_HTML5);
            $_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
            $headers = array(
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
                'Accept-Charset'=> 'utf-8',
                'token'         => $this->session->get('token'),
                //'filePath'      => html_entity_decode($_POST['filePath'], ENT_QUOTES | ENT_HTML5),
                'filePath'      => base64_encode($_POST['filePath']),
                'fileName'      => base64_encode($_POST['fileName']),
                'deviceId'      => $this->session->get('currentDeviceId')
            );
            $result = $this->_model->getFileVersions($headers);
            $this->log('Result:'. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $fileVersions = [];

                    if($result['body']->{'backupListElement'}->{'fileElementList'}){
			foreach($result['body']->{'backupListElement'}->{'fileElementList'} as $value){
			    $fileVersion = array(
                                'backupId'            => (string)$value->{'backupId'},
				'deviceUUID'            => (string)$value->{'deviceUUID'},
				'baseFolder'            => !empty($value->{'isBasefolder'}) ? (string)$value->{'isBasefolder'} : '',
                                'externalStorage'       => !empty($value->{'isExternalStorage'}) ? (string)$value->{'isExternalStorage'} : '',
                                'filePath'              => !empty($value->{'filePath'}) ? (string)$value->{'filePath'} : '',
                                'fileDevice'            => !empty($value->{'fileDeviceOwner'}) ? (string)$value->{'fileDeviceOwner'} : '',
                                'fileName'              => (string)$value->{'fileName'},
                                'fileUser'              => (string)$value->{'fileUserOwner'},
                                'folder'                => (string)$value->{'folder'},
                                'clientModifiedTimeInMillis'    => $value->{'lastClientModifiedTime'},
                                'serverModifiedTimeInMillis'    => $value->{'lastServerModifiedTime'},
                                'clientModifiedTime'    => (!empty($value->{'lastClientModifiedTime'}) && $value->{'lastClientModifiedTime'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'lastClientModifiedTime'}) / 1000)) : '',
                                'serverModifiedTime'    => (!empty($value->{'lastServerModifiedTime'}) && $value->{'lastServerModifiedTime'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'lastServerModifiedTime'}) / 1000)) : '',
                                'checkSum'              => (string)$value->{'md5Checksum'},
                                'exists'                => (string)$value->{'present'},
                                'rawSize'               => (int)$value->{'size'},
                                'size'                  => $this->getFileSize((string)$value->{'size'}),
                                'version'               => 'Version ',
                                'status'                => (string)$value->{'status'},
                                'storagePlace'          => (string)$value->{'storagePlace'},
                                'fsPath'                => (string)$value->{'fSPath'}
                            );
                            $fileVersions = array_merge(array($fileVersion), $fileVersions);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'fileVersions' => array_reverse($fileVersions)
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'post' => $_POST,
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getFileChunks(){
        if(!empty($_POST['backupId']) && !empty($_POST['userName'])){
            $headers = array(
                'token'         => $this->session->get('token'),
                'backupId'      => $_POST['backupId'],
                'userName'      => $_POST['userName']
            );
            $result = $this->_model->getFileChunks($headers);
            $this->log('Result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $chunks = [];

                    foreach($result['body']->{'chunkFileList'} as $value){
                        $one = array(
                            'cloudStoragePath'  => (string)$value->{'cloudStoragePath'},
                            'fSPath'            => (string)$value->{'fSPath'},
                            'fileId'            => (string)$value->{'fileId'},
                            'fileName'          => (string)$value->{'fileName'},
                            'fileSource'        => (string)$value->{'fileSource'},
                            'id'                => (string)$value->{'id'},
                            'md5'               => (string)$value->{'md5'},
                            'revision'          => (string)$value->{'revision'},
                            'rawSize'           => (int)$value->{'size'},
                            'size'              => $this->getFileSize(((int)$value->{'size'}/1024)),
                            'uploadedTimeStamp' => (!empty($value->{'uploadedTimeStamp'}) && $value->{'uploadedTimeStamp'} !== '0') ? date('d-M-Y h:i:s', (((int)$value->{'uploadedTimeStamp'}) / 1000)) : '',
                        );
                        $chunks = array_merge(array($one), $chunks);
                    }

                    $response = array(
                        'result' => 'success',
                        'chunks' => $chunks
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'post' => $_POST,
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function backupFileDelete(){
            $headers = array(
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName'),
                'device'            => $this->session->get('currentDeviceUUID')
            );
            $fileCompletePath = html_entity_decode($_POST['filePath'], ENT_QUOTES | ENT_HTML5);
            $fileName = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
            $fileString = array(
                'folder'               	=> $_POST['isFolder'],/*$_POST['isFolder']=="true" ? true :false,*/
                'fileCompletePath'     	=> base64_encode($fileCompletePath),
                'fileName'             	=> base64_encode($fileName),
		'deviceType' 		=> !empty($_POST['deviceType']) ? $_POST['deviceType'] : '',
                'backupId' 		=> !empty($_POST['backupId']) ? $_POST['backupId'] : '',
            );
            $result = $this->_model->backupFileDelete($headers, $fileString);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'fileVersions' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function getFileSize($sizeInKB){
        $bytes = ($sizeInKB*1024);
        if ($bytes >= 1073741824){
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }elseif ($bytes >= 1048576){
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }elseif ($bytes >= 1024){
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }elseif ($bytes > 1){
            $bytes = $bytes . ' bytes';
        }elseif ($bytes == 1){
            $bytes = $bytes . ' byte';
        }else{
            $bytes = '0 bytes';
        }
        return $bytes;
    }

    public function getFileIcon($ext){
        switch ($ext) {
            case ($ext == 'zip'):
                $icon = 'file-archive-o';
                break;
            case ($ext == 'mp3' || $ext == 'mp4'):
                $icon = 'file-audio-o';
                break;
            case ($ext == 'png' || $ext == 'jpeg' || $ext == 'jpg' || $ext == 'gif'):
                $icon = 'file-photo-o';
                break;
            case ($ext == 'pdf' || $ext == 'PDF'):
                $icon = 'file-pdf-o';
                break;
            case ($ext == 'xlsx' || $ext == 'xls'):
                $icon = 'file-excel-o';
                break;
            case ($ext == 'doc' || $ext == 'docx'):
                $icon = 'file-word-o';
                break;
            case ($ext == 'pptx' || $ext == 'PPTX' || $ext == 'ppt' || $ext == 'PPT'):
                $icon = 'file-powerpoint-o';
                break;
            case ($ext == 'txt'):
                $icon = 'file-text-o';
                break;
            default:
                $icon = 'file';
                break;
        }
        return $icon;
    }

    public function getOsType($deviceType){
        if((strpos($deviceType, 'Wind') === false )){
            if((strpos($deviceType, 'Lin') === false )){
                return 'MAC';
            }else{
                return 'Linux';
            }
        }else{
            return 'Windows';
        }
    }

    public function getOsIcon($deviceType){
    	if((strpos($deviceType, 'ONE') === false )){
            if((strpos($deviceType, 'Wind') === false )){
                if((strpos($deviceType, 'Lin') === false )){
                    if(strpos($deviceType, 'Android') === false){
                        $type =  'apple';
                    }else{
                        $type =  'android';
                    }
                }else{
                    $type =  'linux';
                }
            }else{
                $type =  'windows';
            }
        }else{
            $type =  'cloud';
        }
    return $type;
    }

    public function initiateRestore(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => 'Path to restore should not be empty'
                )
            );
            exit;
        }
        $newServer = !(empty($_POST['deviceName']) && ($_POST['deviceName'] != 'default')) ? $_POST['deviceName'] : '';
        $path = !(empty($_POST['path'])) ? $_POST['path'] : null;

        $data = array(
            'action'            => 'RESTORE',
            'isDeviceLevel'     => $_POST['deviceLevelRestore'],
            'isRestoreAllVersions'=> $_POST['restoreAllVersions'],
            'deviceUUID'        => !(empty($_POST['deviceUUID'])) ? $_POST['deviceUUID'] : $this->session->get('currentDeviceUUID'),
            'paths'             => $_POST['paths'],
            'destinationPath'   => $path
        );

        $hostName = !empty($newServer) ? $newServer : $this->session->get('currentDeviceName');

        $this->log('Data'. json_encode($data), 'info');
        $this->log('ServerName'. $hostName, 'info');

        $context = new ZMQContext();
        $client = $this->client_socket($context, $hostName);
        $sequence = 0;
        $retries_left = 3;
        $read = $write = array();
        while ($retries_left) {
            $client->send(json_encode($data));
            $expect_reply = true;
            while ($expect_reply) {
                $poll = new ZMQPoll();
                $poll->add($client, ZMQ::POLL_IN);
                $events = $poll->poll($read, $write, 30000);
                --$retries_left;
                if ($events > 0) {

                    $result = $client->recv();
                    $this->log('Result'. json_encode($result), 'info');
                    switch ($result) {
                        case (200):

                            $response = array(
                                'result' => 'success',
                                'post' => $_POST,
                                'msg' => $this->language->get('restoreInitiated')
                            );
                            echo json_encode($response);
                            exit;

                        case (421):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('421')
                            );
                            echo json_encode($result);
                            exit();

                        case (600):
                            $result = array(
                                'result' => 'fail',
                                'type' => 'restore',
                                'msg' => $this->language->get('600')
                            );
                            echo json_encode($result);
                            exit();

                        case (601):
                            $result = array(
                                'result' => 'fail',
                                'type' => 'busy',
                                'msg' => $this->language->get('601')
                            );
                            echo json_encode($result);
                            exit();

                        case (602):
                            $result = array(
                                'result' => 'fail',
                                'type' => 'busy',
                                'msg' => $this->language->get('602')
                            );
                            echo json_encode($result);
                            exit();

                        case (500):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('500')
                            );
                            echo json_encode($result);
                            exit();
                        case (0):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('0')
                            );
                            echo json_encode($result);
                            exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }
                } elseif ($retries_left == 0) {
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    break;
                } else {
                    $this->log('Retrying to connect to client:'.$hostName, 'info');
                    $client = $this->client_socket($context, $hostName);
                    $client->send($sequence);
                }
            }
        }
    }

    public function checkRestoreProgress(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        $newServer = !(empty($_POST['deviceName'])) ? $_POST['deviceName'] : '';
        $data = array(
            'action' => 'ISRESTORERUNNING'
        );
        $hostName = !empty($newServer) ? $newServer : $this->session->get('currentDeviceName');

        $this->log('Restore'. json_encode($hostName), 'info');

        $context = new ZMQContext();
        $client = $this->client_socket($context, $hostName);

        $sequence = 0;
        $retries_left = 3;
        $read = $write = array();

        while ($retries_left) {
            $client->send(json_encode($data));
            $expect_reply = true;
            while ($expect_reply) {

                $poll = new ZMQPoll();
                $poll->add($client, ZMQ::POLL_IN);
                $events = $poll->poll($read, $write, 3000);
                --$retries_left;
                if ($events > 0) {

                    $result = $client->recv();

                    switch ($result) {
                        case (200):

                            $response = array(
                                'result' => 'success',
                                'msg' => $this->language->get('restoreInProgress')
                            );
                            echo json_encode($response);
                            exit;

                        case (420):
                            $result = array(
                                'result' => 'fail',
                                'type' => 'restore',
                                'msg' => $this->language->get('420')
                            );
                            echo json_encode($result);
                            exit();

                        case (425):
                            $result = array(
                                'result' => 'fail',
                                'type' => 'busy',
                                'msg' => $this->language->get('425')
                            );
                            echo json_encode($result);
                            exit();

                        case (500):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('500')
                            );
                            echo json_encode($result);
                            exit();
                        case (0):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('0')
                            );
                            echo json_encode($result);
                            exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }
                } elseif ($retries_left == 0) {
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    break;
                } else {
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Re-Trying to connect to the server please wait'
                    );

                    $client = $this->client_socket($context, $_POST['serverHostName']);
                    $client->send($sequence);
                }
            }
        }
    }

    public function client_socket(ZMQContext $context, $hostName){
        $client = new ZMQSocket($context, ZMQ::SOCKET_REQ);
        try{
            $client->connect("tcp://".$hostName.":5555");
            $client->setSockOpt(ZMQ::SOCKOPT_LINGER, 0);
            return $client;
        }catch (\Exception $e){
            $this->log('Exception: '. $e, 'info');
            $result = array(
                'result' => 'fail',
                'message' => 'Could not connect to the Server'
            );
            echo json_encode($result);
            exit();
        }
    }

    public function getAllUnblockedDevices(){
        if(empty($_GET)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }

        $headers = array(
            'Content-Type' => 'application/json',
	    'Accept' => 'application/json',
            'token' => $this->session->get('token'),
            //'skipValue' => $_GET['skipValue']
            'skipValue' => '0'
        );
        $isCurrentDeviceBlocked = false;
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevices($headers);
        }else{
            $result = $this->_model->getAllDevices($headers);
        }

        switch ($result['status']) {
            case (200):

                $devices = [];

                if(empty($result['body'])){
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                }

                if(!empty($_GET['q']) && $_GET['q'] != 'all'){
			foreach($result['body']->{'data'}->{'devices'} as $value){
			    $device = array(
				'profilePic' => Url::profilePic((string)$value->{'userName'}),
				'decoupled' => (string)$value->{'decoupled'},
				'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
				'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
				'deviceName' => (string)$value->{'deviceName'},
				'osType' => (string)$value->{'osType'},
				'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
				'version' => (string)$value->{'osVersion'},
				'tempPath' => (string)$value->{'deviceTempPath'},
				'deviceUUID' => (string)$value->{'deviceUUID'},
				'blocked' => (string)$value->{'blocked'},
				'userName' => (string)$value->{'userName'},
			    );
			    if($device['blocked'] == false){
				$devices = array_merge(array($device), $devices);
			    }else{
				if($device['deviceName'] == $this->session->get('currentDeviceName')){
				    $isCurrentDeviceBlocked = true;
				}
			    }
			}
		}else{
			foreach($result['body']->{'deviceElementResponse'}->{'devices'} as $value){
				$device = array(
					'profilePic' => Url::profilePic((string)$value->{'userName'}),
					'decoupled' => (string)$value->{'decoupled'},
					'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
					'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
					'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
					'deviceName' => (string)$value->{'deviceName'},
					'osType' => (string)$value->{'osType'},
					'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
					'version' => (string)$value->{'osVersion'},
					'tempPath' => (string)$value->{'deviceTempPath'},
					'deviceUUID' => (string)$value->{'deviceUUID'},
					'blocked' => (string)$value->{'blocked'},
					'userName' => (string)$value->{'userName'},
				);
				if($device['blocked'] == false){
					$devices = array_merge(array($device), $devices);
				}else{
					if($device['deviceName'] == $this->session->get('currentDeviceName')){
						$isCurrentDeviceBlocked = true;
					}
				}
			}
		}
			
                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
	
    public function getAllUnblockedDevicesForDeviceList(){
        if(empty($_GET)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }

        $headers = array(
            'Content-Type' => 'application/json',
	    'Accept' => 'application/json',
            'token' => $this->session->get('token'),
            //'skipValue' => $_GET['skipValue']
            'skipValue' => '0'
        );
        $isCurrentDeviceBlocked = false;
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevices($headers);
        }else{
            $result = $this->_model->getAllDevices($headers);
        }

        switch ($result['status']) {
            case (200):

                $devices = [];

                if(empty($result['body'])){
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                }

                if(!empty($_GET['q']) && $_GET['q'] != 'all'){
			foreach($result['body']->{'data'}->{'devices'} as $value){
			    $device = array(
				'profilePic' => Url::profilePic((string)$value->{'userName'}),
				'decoupled' => (string)$value->{'decoupled'},
				'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
				'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
				'deviceName' => (string)$value->{'deviceName'},
				'osType' => (string)$value->{'osType'},
				'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
				'version' => (string)$value->{'osVersion'},
				'tempPath' => (string)$value->{'deviceTempPath'},
				'deviceUUID' => (string)$value->{'deviceUUID'},
				'blocked' => (string)$value->{'blocked'},
				'userName' => (string)$value->{'userName'},
			    );
				$devices = array_merge(array($device), $devices);			    
				if($device['deviceName'] == $this->session->get('currentDeviceName')){
				    $isCurrentDeviceBlocked = true;
				}			    
			}
		}else{
			foreach($result['body']->{'deviceElementResponse'}->{'devices'} as $value){
				$device = array(
					'profilePic' => Url::profilePic((string)$value->{'userName'}),
					'decoupled' => (string)$value->{'decoupled'},
					'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
					'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
					'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
					'deviceName' => (string)$value->{'deviceName'},
					'osType' => (string)$value->{'osType'},
					'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
					'version' => (string)$value->{'osVersion'},
					'tempPath' => (string)$value->{'deviceTempPath'},
					'deviceUUID' => (string)$value->{'deviceUUID'},
					'blocked' => (string)$value->{'blocked'},
					'userName' => (string)$value->{'userName'},
				);
					$devices = array_merge(array($device), $devices);
					if($device['deviceName'] == $this->session->get('currentDeviceName')){
						$isCurrentDeviceBlocked = true;
					}
			}
		}
			
                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function shareFile(){

        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'forceShare'        => 'true',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName'),
                'productType'       => "backup",
                'deviceUUID' => $this->session->get('currentDeviceUUID'),
                'backupId' => $_POST['backupId'],
            );
            
            $_POST['filePath'] = html_entity_decode($_POST['filePath'], ENT_QUOTES | ENT_HTML5);
            $_POST['filePath'] = base64_encode($_POST['filePath']);
            $_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
            $_POST['fileName'] = base64_encode($_POST['fileName']);

            $shareElements = array(
                'userName' => $this->session->get('userName'),
                'cloudName' => $this->session->get('cloudName'),
                'miniCloudName' => '',
                'devicePath' => $_POST['filePath'],
                'fileName' => $_POST['fileName'],
                'passwordProtected' => (string)$_POST['isPasswordProtected'],
                'passwordHash' => !empty($_POST['isPasswordProtected'] == true) ? md5($_POST['password']) : '',
                'validUntil' =>  !empty($_POST['validTill']) ? (strtotime($_POST['validTill']." +1 day")*1000) : 0,
                'download' => (string)$_POST['download'],
		'googleAuthIsEnabled' => (string)$_POST['googleAuthIsEnabled'],
                'view' => (string)$_POST['view']
            );
            $this->log(json_encode($shareElements), "info");
            $result = $this->_model->shareFile($headers, $shareElements);

            switch ($result['status']) {
                case (200):
                    $shared = $result['body']->{'sharedFileImageElement'};
                    if($shared->{'passwordProtected'} == true){
                        $type = md5('protected');
                    }else{
                        $type = md5('read');
                    }
                    $link = SHARE_PATH.$type.DS.$shared->{'key12'}.DS.$shared->{'key14'}.DS.$shared->{'key18'}.DS.$shared->{'key20'};

                    $response = array(
                        'result' => 'success',
                        'link' => $link,
                        'data' => $result['body']->{'sharedFileImageElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function updateSharePolicy(){

        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'forceShare'        => 'true',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName'),
                'productType'       => "backup",
                'backupId' => $_POST['backupId'],
            );

            list($key12, $key14, $key18, $key20) = explode('+', $_POST['key']);
            $shareElements		= array(
                'userName' => $this->session->get('userName'),
                'cloudName' => $this->session->get('cloudName'),
                'miniCloudName' => '',
                'devicePath' => htmlspecialchars_decode($_POST['filePath']),
                'fileName' => $_POST['fileName'],
                'passwordProtected' => (string)$_POST['isPasswordProtected'],
                'passwordHash' => !empty($_POST['isPasswordProtected'] == true) ? md5($_POST['password']) : '',
                'validUntil' =>  (strtotime($_POST['validTill']." +1 day")*1000),
                'download' => (string)$_POST['download'],
                'key12' => $key12,
                'key14' => $key14,
                'key18' => $key18,
                'key20' => $key20,
                'view' => (string)$_POST['view']
            );

            $result = $this->_model->updateSharePolicy($headers, $shareElements);

            switch ($result['status']) {
                case (200):
                    $shared = $result['body']->{'sharedFileImageElement'};
                    if($shared->{'passwordProtected'} == true){
                        $type = md5('protected');
                    }else{
                        $type = md5('read');
                    }
                    $link = SHARE_PATH.$type.DS.$shared->{'key12'}.DS.$shared->{'key14'}.DS.$shared->{'key18'}.DS.$shared->{'key20'};

                    $response = array(
                        'result' => 'success',
                        'link' => $link,
                        'data' => $result['body']->{'sharedFileImageElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function unShare(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token'             => $this->session->get('token'),
                'userName'          => $this->session->get('userName'),
                'backupId'          => $_POST['backupID'],
                'deviceUUID' => $this->session->get('currentDeviceUUID'),
                'productType'       => "backup"
            );
            
            $_POST['filePath'] = html_entity_decode($_POST['filePath'], ENT_QUOTES | ENT_HTML5);
            $_POST['filePath'] = base64_encode($_POST['filePath']);
            $_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
            $_POST['fileName'] = base64_encode($_POST['fileName']);
            
            $xml ='<share-info>
				<shared-time><![CDATA['.time().']]></shared-time>
				<user-name><![CDATA['.$this->session->get('userName').']]></user-name>
				<cloud-name><![CDATA['.$this->session->get('cloudName').']]></cloud-name>
				<mini-cloud-name><![CDATA[]]></mini-cloud-name>
				<device-path><![CDATA['.htmlspecialchars_decode($_POST['filePath']).']]></device-path>
				<file-name><![CDATA['.$_POST['fileName'].']]></file-name>
				<is-password-protected>false</is-password-protected>
				<password-hash></password-hash>
			</share-info>';
            $this->log(json_encode($headers), "info");
            $result = $this->_model->unShare($headers, $xml);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('fileUnshared'),
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;

                case (204):

                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('fileWasNotShared')
                    );
                    echo json_encode($result);
                    exit();

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function openFileLocation(){
        if($_GET['filePath']){
            $this->session->put('filePath', htmlentities($_GET['filePath']));
            Url::redirect('backup/files/'.htmlentities($_GET['deviceID']).'/'.htmlentities($_GET['deviceName']).'/'.htmlentities($_GET['deviceUUID']).'/'.htmlentities($_GET['deviceType']).'/'.htmlentities($_GET['deviceOs']).'/'.htmlentities($_GET['userName']).'/'.$_GET['blocked']);
        }else{
            Url::redirect('404');
        }
    }

    public function collectStats(){

        $browser = array(
            'version'   => '0.0.0',
            'majorver'  => 0,
            'minorver'  => 0,
            'build'     => 0,
            'name'      => 'unknown',
            'useragent' => ''
        );

        $browsers = array(
            'firefox', 'msie', 'opera', 'chrome', 'safari', 'mozilla', 'seamonkey', 'konqueror', 'netscape',
            'gecko', 'navigator', 'mosaic', 'lynx', 'amaya', 'omniweb', 'avant', 'camino', 'flock', 'aol'
        );

        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $browser['useragent'] = $_SERVER['HTTP_USER_AGENT'];
            $user_agent = strtolower($browser['useragent']);
            foreach($browsers as $_browser) {
                if (preg_match("/($_browser)[\/ ]?([0-9.]*)/", $user_agent, $match)) {
                    $browser['name'] = $match[1];
                    $browser['version'] = $match[2];
                    @list($browser['majorver'], $browser['build']) = explode('.', $browser['version']);
                    break;
                }
            }
        }
        $browserName = $browser['name'] .' - '. $browser['version'];
        if (getenv('HTTP_CLIENT_IP')){
            $ipAddress = getenv('HTTP_CLIENT_IP');
        }
        else if(getenv('HTTP_X_FORWARDED_FOR')) {
            $ipAddress = getenv('HTTP_X_FORWARDED_FOR');
        }
        else if(getenv('HTTP_X_FORWARDED')){
            $ipAddress = getenv('HTTP_X_FORWARDED');
        }
        else if(getenv('HTTP_FORWARDED_FOR')){
            $ipAddress = getenv('HTTP_FORWARDED_FOR');
        }
        else if(getenv('HTTP_FORWARDED')){
            $ipAddress = getenv('HTTP_FORWARDED');
        }
        else{
            $ipAddress = 'UNKNOWN';
        }
        $remote 	= $_SERVER['REMOTE_ADDR'] ;
        $language 	= $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        return array("ip" => $ipAddress,"remoteAdd" => $remote,
            "browser" => $browserName,"language" => $language);
    }

    public function getOS($user_agent) {

        $os_platform    =   "Unknown OS Platform";
        $os_array       =   array(
            '/windows nt 10/i'     =>  'Windows 10',
            '/windows nt 6.3/i'     =>  'Windows 8.1',
            '/windows nt 6.2/i'     =>  'Windows 8',
            '/windows nt 6.1/i'     =>  'Windows 7',
            '/windows nt 6.0/i'     =>  'Windows Vista',
            '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
            '/windows nt 5.1/i'     =>  'Windows XP',
            '/windows xp/i'         =>  'Windows XP',
            '/windows nt 5.0/i'     =>  'Windows 2000',
            '/windows me/i'         =>  'Windows ME',
            '/win98/i'              =>  'Windows 98',
            '/win95/i'              =>  'Windows 95',
            '/win16/i'              =>  'Windows 3.11',
            '/macintosh|mac os x/i' =>  'Mac OS X',
            '/mac_powerpc/i'        =>  'Mac OS 9',
            '/linux/i'              =>  'Linux',
            '/ubuntu/i'             =>  'Ubuntu',
            '/iphone/i'             =>  'iPhone',
            '/ipod/i'               =>  'iPod',
            '/ipad/i'               =>  'iPad',
            '/android/i'            =>  'Android',
            '/blackberry/i'         =>  'BlackBerry',
            '/webos/i'              =>  'Mobile'
        );
        foreach ($os_array as $regex => $value) {
            if (preg_match($regex, $user_agent)) {
                $os_platform    =   $value;
            }
        }
        return $os_platform;
    }
    
    //exchange related start
    public function getSearchResultsOutlook(){
        if(!empty($_POST)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'file-name' => $_POST['text'],
                'start' => $_POST['start'],
                'rows' => 500,
                'isMail' => 'true',
                'deviceId' => $this->session->get('currentDeviceId'),
                'file-path' => !(empty($_POST['filePath'])) ? $_POST['filePath'] : 'ParaBlu',
		'downloadAsPst' => !(empty($_POST['downloadAsPst'])) ? $_POST['downloadAsPst'] : '',
            );

            $result = $this->_model->getSearchResultsOutlook($headers, 'searchFiles', $_POST['start']);
            //$this->log('resulteeeee'. json_encode($result['body']->{'file'}), 'info');
            switch ($result['status']) {
                case (200):
                    $files = array();
		       if(!empty($result['body']->{'data'}->{'fileElementList'})){
			       foreach($result['body']->{'data'}->{'fileElementList'} as $value){
				$deviceId = (string)$value->{'deviceId'};
				$headers1 = array(
					'token'     => $this->session->get('token'),
					'Content-Type' => 'application/json',
					'Accept' => 'application/json',
				);
				$result1 = $this->_model->getDeviceId($headers1,$deviceId);
				$deviceUUID = $result1['body']->{'device'}->{'deviceUUID'};
				$file = array(
				    'exists' => (string)$value->{'exists'},
				    'fileName' => (string)$value->{'fileName'},
				    'filePath' => (string)$value->{'fileCompletePath'},
				    'showIcon' => substr((string)$value->{'from'},0,1),
				    'alphaColor' => $this->colorGen(),
				    'folder' => (string)$value->{'folder'},
				    'fileRevisionID' => (string)$value->{'fileRevisionId'},
				    'content' => (string)$value->{'meta-data'},
				    'modifiedTimestamp' => (int)$value->{'lastModifiedTimestamp'},
				    'size' => (int)$value->{'size'},
				    'deviceId' => (string)$value->{'deviceId'},
				    'bodyContent' => (string)$value->{'bodyContent'},
				    'subject' => (string)$value->{'subject'},
				    'userName' => (string)$value->{'fileUserOwner'},
				    'hasAttachments' => $value->{'hasAttachments'} ? 'true' : 'false',
				    'deviceUUID' => $deviceUUID
				);

				$files = array_merge(array($file), $files);
				}
		       }

                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        //$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                        }else{
                        $metadata = [];
                    }
			    $response = array(
                        'result' => 'success',
                        'files'  => $files,
                        'totalFilesCount' => $result['header']->{'container'}['totalFilesCount'],
			'batchId' => $result['body']->{'data'}->{'batchId'},
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
		default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
        }
    }

    public function getSearchResultsOutlookNavigate(){
        if(!empty($_POST)){

            $headers = array(
                'token'     => $this->session->get('token'),
                'file-name' => $_POST['text'],
                'start' => $_POST['start'],
                'rows' => 500,
                'isMail' => 'true',
                'deviceId' => $this->session->get('currentDeviceId'),
                'file-path' => !(empty($_POST['filePath'])) ? $_POST['filePath'] : 'ParaBlu'
            );
		$result = $this->_model->getSearchResultsOutlookNavigate($headers, 'searchFiles', $_POST['url']);
//            $this->log('resulteeeee'. json_encode($result['body']->{'file'}), 'info');
            switch ($result['status']) {
                case (200):
                    $files = array();
		      if(!empty($result['body']->{'data'}->{'fileElementList'})){
			      foreach($result['body']->{'data'}->{'fileElementList'} as $value){
				$deviceId = (string)$value->{'deviceId'};
				$headers1 = array(
					'token'     => $this->session->get('token'),
					'Content-Type' => 'application/json',
					'Accept' => 'application/json',
				);
				$result1 = $this->_model->getDeviceId($headers1,$deviceId);
				$deviceUUID = $result1['body']->{'device'}->{'deviceUUID'};
				$file = array(
				    'exists' => (string)$value->{'exists'},
				    'fileName' => (string)$value->{'fileName'},
				    'filePath' => (string)$value->{'fileCompletePath'},
				    'showIcon' => substr((string)$value->{'from'},0,1),
				    'alphaColor' => $this->colorGen(),
				    'folder' => (string)$value->{'folder'},
				    'fileRevisionID' => (string)$value->{'fileRevisionId'},
				    'content' => (string)$value->{'meta-data'},
				    'modifiedTimestamp' => (int)$value->{'lastModifiedTimestamp'},
				    'size' => (int)$value->{'size'},
				    'deviceId' => (string)$value->{'deviceId'},
				    'bodyContent' => (string)$value->{'bodyContent'},
				    'subject' => (string)$value->{'subject'},
				    'userName' => (string)$value->{'fileUserOwner'},
				    'hasAttachments' => $value->{'hasAttachments'} ? 'true' : 'false',
				    'deviceUUID' => $deviceUUID
				);
				$files = array_merge(array($file), $files);
				}
		      }

                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        //$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                        }else{
                        $metadata = [];
		    }

                    $response = array(
                        'result' => 'success',
                        'files'  => $files,
                        'totalFilesCount' => $result['header']->{'container'}['totalFilesCount'],
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
			 );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
);
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
        }
    }

    public function getFilesOutlookNavigate(){
        if(empty($_POST) && empty($_POST['filePath'])){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        if($_POST['refresh'] == 'true'){
            $filePath = (!empty($this->session->get('filePath'))) ? $this->session->get('filePath') : '';
        }else{
            $filePath = ($_POST['filePath'] == 'root') ? '' : $_POST['filePath'];
        }
        $filePath = html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5);
        $headers = array(
            //'filePath'      => html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5),
            'filePath'      => base64_encode($filePath),
            'deviceId'      => $this->session->get('currentDeviceId'),
            'token'         => $this->session->get('token'),
            'Content-type'  => 'application/json',
            'Accept'        => 'application/json',
	    'restoreDeletedFile'     => $_POST['restoreDeletedFile']
        );

        $result = $this->_model->getFilesOutlookNavigate($headers,$_POST['url']);
        //$this->log('result: '.json_encode($result), 'info');
        switch ($result['status']) {
            case (200):
                $items = array();
                if(!empty($result['body']->{'data'}->{'mailElementList'})){
                    foreach($result['body']->{'data'}->{'mailElementList'} as $value){
                        if($value->{'folder'} == true){
                            $folder = array(
				'userName' => (string)$value->{'userName'},
				'deviceUUID' => (string)$value->{'deviceUUID'},
                                'backupId' => (string)$value->{'backupId'},
                                'checksum' => (string)$value->{'checksum'},
                                'exists' => (string)$value->{'exists'},
				'present' => (string)$value->{'present'},
                                'name' => (!empty((string)$value->{'fileName'})) ? (string)$value->{'fileName'} : '<empty>',
                                'name1' => (!empty((string)$value->{'fileName'})) ? (string)$value->{'fileName'} : '<empty>',
                                'user' => (!empty((string)$value->{'file-user'})) ? (string)$value->{'file-user'} : '<empty>',
                                'type' => 'Folder',
				//'sentDate' => (string)$value->{'sentDate'},
				'sentDate' => date("d-M-Y", strtotime($value->{'sentDate'})),
                                'icon' => 'folder',
                                'size' => '',
                                'filePath' => (string)$value->{'file-path'},
                                'fullPath' => (!empty((string)$value->{'file-path'})) ? (string)$value->{'file-path'}.'/'.(string)$value->{'file-name'} : (string)$value->{'file-name'},
                                'fsPath' => (string)$value->{'fs-path'},
                                'baseFolder' => (string)$value->{'is-basefolder'},
                                'externalStorage' => (string)$value->{'is-externalStorage'},
                                'clientModifiedTimeInMillis' => (int)$value->{'client-modified-time'},
                                'serverModifiedTimeInMillis' => (int)$value->{'server-modified-time'},
                                'clientModifiedTime' => (!empty($value->{'client-modified-time'}) && $value->{'client-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'client-modified-time'}) / 1000)) : '',
                                'serverModifiedTime' => (!empty($value->{'server-modified-time'}) && $value->{'server-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'server-modified-time'}) / 1000)) : '',
                                'status' => (string)$value->{'status'}
                            );
                            $items = array_merge(array($folder), $items);
                        }else{
                            $fileExt = explode('.', (string)$value->{'file-name'});
                            $file = array(
                                'backupId' => (string)$value->{'backupId'},
                                'userName' => (string)$value->{'userName'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'subject' => (!empty((string)$value->{'subject'})) ? (string)$value->{'subject'} : '<empty>',
				'contactName'	=> (string)$value->{'fileName'},
				'taskSubject' => (!empty((string)$value->{'taskSubject'})) ? (string)$value->{'taskSubject'} : '',
                                'checksum' => (string)$value->{'checksum'},
                                'exists' => (string)$value->{'exists'},
				'present' => (string)$value->{'present'},
				'showIcon' => substr((string)$value->{'from'},0,1),
				'alphaColor' => $this->colorGen(),
                                'from' => (!empty((string)$value->{'from'})) ? (string)$value->{'from'} : '<empty>',
                                'to' => (string)$value->{'toRecipients'},
				'cc' => (!empty((string)$value->{'ccRecipients'})) ? (string)$value->{'ccRecipients'} : '',
				'bcc' => (!empty((string)$value->{'bccRecipients'})) ? (string)$value->{'bccRecipients'} : '',
				//'sentDate' => (string)$value->{'sentDate'},
				'sentDate' => date("d-M-Y", strtotime($value->{'sentDate'})),
				'displayContent' => (string)$value->{'displayContent'},
				'bodyContent' => (string)$value->{'bodyContent'},
				'bodyContent1' => strlen((string)$value->{'bodyContent'}) > 100 ? substr((string)$value->{'bodyContent'},0,100)."..." : (string)$value->{'bodyContent'},
				'hasAttachments' => (string)$value->{'hasAttachments'},
				'attachments' => $value->{'attachments'},
                                'name' => (!empty((string)$value->{'subject'})) ? (string)$value->{'subject'} : '<empty>',
                                'user' => (string)$value->{'file-user'},
                                'type' => 'File',
                                'filePath' => (string)$value->{'file-path'},
                                'fullPath' => (!empty((string)$value->{'file-path'})) ? (string)$value->{'file-path'}.'/'.(string)$value->{'file-name'} : (string)$value->{'file-name'},
                                'icon' => $this->getFileIcon(end($fileExt)),
                                'fsPath' => (string)$value->{'fs-path'},
                                'baseFolder' => (string)$value->{'is-basefolder'},
                                'storagePlace' => (!empty((string)$value->{'storagePlace'})) ? (string)$value->{'storagePlace'} : 'PG',
                                'externalStorage' => (string)$value->{'is-externalStorage'},
                                'clientModifiedTimeInMillis' => (int)$value->{'client-modified-time'},
                                'serverModifiedTimeInMillis' => (int)$value->{'server-modified-time'},
				'clientModifiedTime' => (!empty($value->{'client-modified-time'}) && $value->{'client-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'client-modified-time'}) / 1000)) : '',
				'serverModifiedTime' => (!empty($value->{'server-modified-time'}) && $value->{'server-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'server-modified-time'}) / 1000)) : '',
                                'rawSize' => (int)(string)$value->{'size'},
                                'status' => (string)$value->{'status'}
                            );
                            $items = array_merge(array($file), $items);
}
                    }
                }
                if(!empty($items)){
                    $this->session->put('filePath', $filePath);
                }
		if(!empty($result['body']->{'metadata'})){
		$metadata = $result['body']->{'metadata'};
		//$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
		$metadata = [];
		}
                $response = array(
                    'result' => 'success',
		    'post' => html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5),
		    'items' => array_reverse($items),
		    //'items' => $items,
		    'metadata' => $metadata
                );
                if($_POST['refresh'] == 'true' && !empty($filePath)){
                    $response['crumb'] = explode('/', $filePath);
                    $response['crumbString'] = $filePath;
                }
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
                case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
	
    function colorGen(){
        return sprintf('#%06X', mt_rand(0, 0xFFFFFF));
	//return sprintf('#%06X', mt_rand(0xFF9999, 0xFFFF00));
    }
    
    public function viewOutlook(){
	if(empty($_POST['deviceId'])){
		$deviceId = $this->session->get('currentDeviceId');
	}else{
		$deviceId = $_POST['deviceId'];
	}
            $headers = array(
                'token'         => $this->session->get('token'),
		'backupId' => $_POST['backupId'],
		'deviceId' => $deviceId,
            );
            $result = $this->_model->viewOutlook($headers);
	    $this->log("hhhhhhhhhh : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
		    $htmlContent = preg_replace("/<a(.*?)>/", "<a$1 target=\"_blank\">", $result['body']->{'mailElement'}->{'bodyContent'});
                    $response = array(
                        'result' => 'success',
                        'html' => $htmlContent,
			'subject' => (!empty($result['body']->{'mailElement'}->{'subject'})) ? $result['body']->{'mailElement'}->{'subject'} : '&lt;empty&gt;',
                        'userName' => (!empty($result['body']->{'mailElement'}->{'userName'})) ? $result['body']->{'mailElement'}->{'userName'} : '',
                        'from' => (!empty($result['body']->{'mailElement'}->{'from'})) ? $result['body']->{'mailElement'}->{'from'} : '',
                        'sentDate' => (!empty($result['body']->{'mailElement'}->{'sentDate'})) ? $result['body']->{'mailElement'}->{'sentDate'} : '',
                        'to' => (!empty($result['body']->{'mailElement'}->{'toRecipients'})) ? $result['body']->{'mailElement'}->{'toRecipients'} : '',
                        'cc' => (!empty($result['body']->{'mailElement'}->{'ccRecipients'})) ? $result['body']->{'mailElement'}->{'ccRecipients'} : '',
                        'bcc' => (!empty($result['body']->{'mailElement'}->{'bccRecipients'})) ? $result['body']->{'mailElement'}->{'bccRecipients'} : '',
                        'type' => 'text',
                        'hasAttachments' => (string)$result['body']->{'mailElement'}->{'hasAttachments'},
			'attachments' => $result['body']->{'mailElement'}->{'attachments'},
			'contactName' => $result['body']->{'mailElement'}->{'fileName'},
			'contactMobile'   => $result['body']->{'mailElement'}->{'contactMobile'},
			'contactAddrStreet'   => $result['body']->{'mailElement'}->{'contactAddrStreet'},
			'contactAddrCity'   => $result['body']->{'mailElement'}->{'contactAddrCity'},
			'contactAddrState'   => $result['body']->{'mailElement'}->{'contactAddrState'},
			'contactAddrCountry'   => $result['body']->{'mailElement'}->{'contactAddrCountry'},
			'contactAddrPostalCode'   => $result['body']->{'mailElement'}->{'contactAddrPostalCode'},
			'taskSubject' => (!empty($result['body']->{'mailElement'}->{'taskSubject'})) ? $result['body']->{'mailElement'}->{'taskSubject'} : '',
                        'taskStartDate' => (!empty($result['body']->{'mailElement'}->{'taskStartDate'})) ? $result['body']->{'mailElement'}->{'taskStartDate'} : '',
                        'taskDueDate' => (!empty($result['body']->{'mailElement'}->{'taskDueDate'})) ? $result['body']->{'mailElement'}->{'taskDueDate'} : '',
                        'taskReminderTime' => (!empty($result['body']->{'mailElement'}->{'taskReminderTime'})) ? $result['body']->{'mailElement'}->{'taskReminderTime'} : '',
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }

    public function getFilesOutlook(){
        if(empty($_POST) && empty($_POST['filePath'])){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }

        if($_POST['refresh'] == 'true'){
            $filePath = (!empty($this->session->get('filePath'))) ? $this->session->get('filePath') : '';
        }else{
            $filePath = ($_POST['filePath'] == 'root') ? '' : $_POST['filePath'];
        }
        $filePath = html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5);
        $headers = array(
            //'filePath'      => html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5),
            'filePath'      => base64_encode($filePath),
            'deviceId'      => $this->session->get('currentDeviceId'),
            'token'         => $this->session->get('token'),
            'Content-type'  => 'application/json',
            'Accept'        => 'application/json',
	    'restoreDeletedFile'     => $_POST['restoreDeletedFile']
        );
        $result = $this->_model->getFiles1($headers);
        //$this->log("kkkkkkk : ".json_encode($result['body']->{'data'}->{'mailElementList'}),"info");
        //$this->log('result: '.json_encode($result), 'info');
        switch ($result['status']) {
            case (200):
                $items = array();
                if(!empty($result['body']->{'data'}->{'mailElementList'})){
                  foreach($result['body']->{'data'}->{'mailElementList'} as $value){
                        if($value->{'folder'} == true){
				$folder = array(
				'userName' => (string)$value->{'userName'},
				'deviceUUID' => (string)$value->{'deviceUUID'},
                                'backupId' => (string)$value->{'backupId'},
                                'checksum' => (string)$value->{'checksum'},
                                'exists' => (string)$value->{'exists'},
				'present' => (string)$value->{'present'},
                                'name' => (!empty((string)$value->{'fileName'})) ? (string)$value->{'fileName'} : '<empty>',
                                'name1' => (!empty((string)$value->{'fileName'})) ? (string)$value->{'fileName'} : '<empty>',
                                'user' => (!empty((string)$value->{'file-user'})) ? (string)$value->{'file-user'} : '<empty>',
                                'type' => 'Folder',
				//'sentDate' => (string)$value->{'sentDate'},
				'sentDate' => date("d-M-Y", strtotime($value->{'sentDate'})),
                                'icon' => 'folder',
                                'size' => '',
                                'filePath' => (string)$value->{'file-path'},
                                'fullPath' => (!empty((string)$value->{'file-path'})) ? (string)$value->{'file-path'}.'/'.(string)$value->{'file-name'} : (string)$value->{'file-name'},
                                'fsPath' => (string)$value->{'fs-path'},
                                'baseFolder' => (string)$value->{'is-basefolder'},
                                'externalStorage' => (string)$value->{'is-externalStorage'},
                                'clientModifiedTimeInMillis' => $value->{'client-modified-time'},
                                'serverModifiedTimeInMillis' => $value->{'server-modified-time'},
                                'clientModifiedTime' => (!empty($value->{'client-modified-time'}) && $value->{'client-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'client-modified-time'}) / 1000)) : '',
                                'serverModifiedTime' => (!empty($value->{'server-modified-time'}) && $value->{'server-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'server-modified-time'}) / 1000)) : '',
                                'status' => (string)$value->{'status'}
                            );
                            $items = array_merge(array($folder), $items);
                        }else{
                            $fileExt = explode('.', (string)$value->{'file-name'});
			    $file = array(
				'backupId' => (string)$value->{'backupId'},
                                'userName' => (string)$value->{'userName'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'subject' => (!empty((string)$value->{'subject'})) ? (string)$value->{'subject'} : '<empty>',
				'contactName'	=> (string)$value->{'fileName'},
				'taskSubject' => (!empty((string)$value->{'taskSubject'})) ? (string)$value->{'taskSubject'} : '',
                                'checksum' => (string)$value->{'checksum'},
                                'exists' => (string)$value->{'exists'},
				'present' => (string)$value->{'present'},
				'showIcon' => substr((string)$value->{'from'},0,1),
				'alphaColor' => $this->colorGen(),
                                'from' => (!empty((string)$value->{'from'})) ? (string)$value->{'from'} : '<empty>',
                                'to' => (string)$value->{'toRecipients'},
				'cc' => (!empty((string)$value->{'ccRecipients'})) ? (string)$value->{'ccRecipients'} : '',
				'bcc' => (!empty((string)$value->{'bccRecipients'})) ? (string)$value->{'bccRecipients'} : '',
				//'sentDate' => (string)$value->{'sentDate'},
				'sentDate' => date("d-M-Y", strtotime($value->{'sentDate'})),
				'displayContent' => (string)$value->{'displayContent'},
				'bodyContent' => (string)$value->{'bodyContent'},
				'bodyContent1' => strlen((string)$value->{'bodyContent'}) > 100 ? substr((string)$value->{'bodyContent'},0,100)."..." : (string)$value->{'bodyContent'},
				'hasAttachments' => (string)$value->{'hasAttachments'},
				'attachments' => $value->{'attachments'},
                                'name' => (!empty((string)$value->{'subject'})) ? (string)$value->{'subject'} : '<empty>',
                                'user' => (string)$value->{'file-user'},
                                'type' => 'File',
                                'filePath' => (string)$value->{'file-path'},
                                'fullPath' => (!empty((string)$value->{'file-path'})) ? (string)$value->{'file-path'}.'/'.(string)$value->{'file-name'} : (string)$value->{'file-name'},
                                'icon' => $this->getFileIcon(end($fileExt)),
                                'fsPath' => (string)$value->{'fs-path'},
                                'baseFolder' => (string)$value->{'is-basefolder'},
                                'storagePlace' => (!empty((string)$value->{'storagePlace'})) ? (string)$value->{'storagePlace'} : 'PG',
                                'externalStorage' => (string)$value->{'is-externalStorage'},
                                'clientModifiedTimeInMillis' => $value->{'client-modified-time'},
                                'serverModifiedTimeInMillis' => $value->{'server-modified-time'},
				'clientModifiedTime' => (!empty($value->{'client-modified-time'}) && $value->{'client-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'client-modified-time'}) / 1000)) : '',
				'serverModifiedTime' => (!empty($value->{'server-modified-time'}) && $value->{'server-modified-time'} !== '0') ? date('d-M-Y h:i:s A', (((int)$value->{'server-modified-time'}) / 1000)) : '',
                                'rawSize' => (int)(string)$value->{'size'},
                                'status' => (string)$value->{'status'}

                            );
                            $items = array_merge(array($file), $items);
                        }
                    }
                }
                if(!empty($items)){
                    $this->session->put('filePath', $filePath);
                }
		if(!empty($result['body']->{'metadata'})){
		$metadata = $result['body']->{'metadata'};
		//$this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
		}else{
		$metadata = [];
		}
		//$this->log("meeeeeeeeeeeeemmmmmmmmmmmmm : ".json_encode($items),"info");
                $response = array(
                    'result' => 'success',
                    'post' => html_entity_decode($filePath, ENT_QUOTES | ENT_HTML5),
		    'items' => array_reverse($items),
		    //'items' => $items,
		    'metadata' => $metadata
                );
                if($_POST['refresh'] == 'true' && !empty($filePath)){
                    $response['crumb'] = explode('/', $filePath);
                    $response['crumbString'] = $filePath;
                }
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
    //exchange related end
    
    //initiate restore from portal start
    public function getDevicesForRestorePage(){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $deviceUUID = $this->session->get('currentDeviceUUID');
            $result = $this->_model->getDevicesForRestorePage($headers, $deviceUUID);
            switch ($result['status']) {
                case (200):
                    $devices = array();
                    $value = $result['body'];
                            $device = array(
                                'name'          => (string)$value->{'device-name'},
                                'userName'      => base64_encode((string)$value->{'userName'}),
                                'decoupled'     => (string)$value->{'decoupled'},
                                'id'            => (string)$value->{'device-id'},
                                'uuId'          => (string)$value->{'device-uuid'},
                                'tempPath'      => (string)$value->{'device-temp-path'},
                                'deviceType' => !empty((string)$value->{'deviceType'}) ? (string)$value->{'deviceType'} : 'Windows',
                                'status'        => ($value->{'is-blocked'} == 'false') ? 'Active' : 'In-Active',
                                'blocked'       => (string)$value->{'is-blocked'},
                                'os'            => $this->getOsType($value->{'device-os-type'}),
                                'version'       => (string)$value->{'device-os-version'},
                                //'icon'          => $this->getOsIcon($value->{'device-os-type'}),
                                'icon' => ((string)$value->{'device-os-type'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'device-os-type'}),
                                'modifiedOn'    => date('d-M-Y H:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                                'createdOn'     => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedMillis'}) / 1000)),
                            );
                            $devices = array_merge(array($device), $devices);
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                        );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                    case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    
    public function restore($deviceUUID, $deviceType, $deviceOs, $deviceName, $userName, $blocked){
	    $deviceName = str_replace('_PB_', ' ', $deviceName);
            $deviceType = str_replace('_PB_', ' ', $deviceType);
            $deviceOs = str_replace('_PB_', ' ', $deviceOs);
            $this->session->put('currentDeviceUUID', $deviceUUID);
            $data = array(
            'title' => $this->language->get('indexPageName'),
            'csrf_token' => $this->setCSRFToken(),
            'crumb1' => $this->language->get('Restore'),
            'active' => 'backup',
            'selectedUser' => $this->session->get('userName'),
            'deviceType' => $deviceType,
            'loggedInUser' => $this->session->all()
        );
	$lastLoginTime = "nil";
        if($this->session->get('readOnlyAdmin') == "1" || $this->session->get('admin') == "1"){            
            $data['lastLoginTime'] = $lastLoginTime;
        }else{
            if($this->session->get('lastLoggedInTime') != ""){
                $lastLoginTime = date('d-M-Y H:i:s', ((int)$this->session->get('lastLoggedInTime')/1000));
                $data['lastLoginTime'] = $lastLoginTime;
            }
        }
	if($deviceOs == 'windows'){
                $data['policy'] = $this->getPolicy();
        }
        else{
                $data['policy'] = $this->getOneDrivePolicy();
        }
        $data['canAdminRestore'] = $data['policy']['canAdminRestore'];
        $data['allowEndUserTocontrolRestore'] = $data['policy']['allowEndUserTocontrolRestore'];
        $data['device_OS'] = $deviceOs;
	$data['userType'] = 'user';
	$data['isAdmin'] = 'false';
        if($this->session->get('admin') == true){
                $data['isAdmin'] = 'true';
                $data['userType'] = 'admin';
        }
        $data['userName'] = base64_encode($this->session->get('userName'));
        $data['deviceName'] = rawurldecode($deviceName);
        $data['deviceUserName'] = base64_decode($userName);
        $data['deviceUUID'] = $deviceUUID;
        $data['isblocked'] = $blocked;
	if($this->session->get('oneDriveArchivingEnabled') == "true"){
                $data['oneDriveArchivingEnabled'] = 'true';
        }else{
                $data['oneDriveArchivingEnabled'] = 'false';
        }
	if($this->session->get('mailArchivingEnabled') == "true"){
                $data['mailArchivingEnabled'] = 'true';
        }else{
                $data['mailArchivingEnabled'] = 'false';
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('backup/restore', $data);
        View::renderTemplate('footer', $data);
    }

        public function getDevicesForRestore1(){
            $this->log("99999999999999999999999999999","info");
            $headers = array(
                'token'         => $this->session->get('token')
            );
                $result = $this->_model->getDevices($headers, !empty($_POST['userName']) ? $_POST['userName'] : $this->session->get('userName'));
                    $devices = array();
                    if(!empty($result['body']->{'device-info'})){
                        foreach($result['body']->{'device-info'} as $value){
                            $device = array(
                                'name'          => (string)$value->{'device-name'},
                                'userName'      => (string)$value->{'userName'},
                                'decoupled'     => (string)$value->{'decoupled'},
                                'id'            => (string)$value->{'device-id'},
                                'uuId'          => (string)$value->{'device-uuid'},
                                'tempPath'      => (string)$value->{'device-temp-path'},
                                'status'        => ($value->{'is-blocked'} == 'false') ? 'Active' : 'In-Active',
                                'blocked'       => (string)$value->{'is-blocked'},
                                'os'            => $this->getOsType($value->{'device-os-type'}),
                                'version'       => (string)$value->{'device-os-version'},
                                'deviceType' => !empty((string)$value->{'deviceType'}) ? (string)$value->{'deviceType'} : 'Windows',
                                //'icon'          => $this->getOsIcon($value->{'device-os-type'}),
                                'icon' => ((string)$value->{'device-os-type'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'device-os-type'}),
                                'modifiedOn'    => date('d-M-Y H:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                                'createdOn'     => date('d-M-Y H:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                                'lastSuccessfullBackup'          => (string)$value->{'lastSuccessfullBackup'},
                            );
                            if($this->session->get('currentDeviceUUID') == $value->{'device-uuid'}){
                                $devices = array_merge(array($device), $devices);
                            }
                        }
                    }
    return $devices;

    }
    public function getDevicesForRestore(){
        if(!empty($_POST) && !empty($_POST['userName'])){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getDevices($headers, !empty($_POST['userName']) ? $_POST['userName'] : $this->session->get('userName'));
            switch ($result['status']) {
                case (200):
                    $devices = array();
                    if(!empty($result['body']->{'device-info'})){
                        foreach($result['body']->{'device-info'} as $value){
                            $device = array(
                                'name'          => (string)$value->{'device-name'},
                                'userName'      => (string)$value->{'userName'},
                                'decoupled'     => (string)$value->{'decoupled'},
                                'id'            => (string)$value->{'device-id'},
                                'uuId'          => (string)$value->{'device-uuid'},
                                'tempPath'      => (string)$value->{'device-temp-path'},
                                'status'        => ($value->{'is-blocked'} == 'false') ? 'Active' : 'In-Active',
                                'blocked'       => (string)$value->{'is-blocked'},
                                'os'            => $this->getOsType($value->{'device-os-type'}),
                                'deviceType' => !empty((string)$value->{'deviceType'}) ? (string)$value->{'deviceType'} : 'Windows',
                                'version'       => (string)$value->{'device-os-version'},
                                //'icon'          => $this->getOsIcon($value->{'device-os-type'}),
                                'icon' => ((string)$value->{'device-os-type'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'device-os-type'}),
                                'modifiedOn'    => date('d-M-Y H:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                                'createdOn'     => date('d-M-Y H:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                                'lastSuccessfullBackup'          => (string)$value->{'lastSuccessfullBackup'},
                                );
                            $devices = array_merge(array($device), $devices);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function initiateRestores(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
	    if(isset($_POST['folder']) && $_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if(isset($_POST['inPlaceRestore']) && $_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            if(isset($_POST['restoreAllVersions']) && $_POST['restoreAllVersions'] == 'true'){
                $restoreAllVersions = true;
            }else{
                $restoreAllVersions = false;
            }
            if(isset($_POST['suspendBackup']) && $_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
            if(isset($_POST['restoreDeletedFiles']) && $_POST['restoreDeletedFiles'] == 'true'){
                $restoreDeletedFiles = true;
            }else{
                $restoreDeletedFiles = false;
            }
            if(isset($_POST['overwriteNewerFiles']) && $_POST['overwriteNewerFiles'] == 'true'){
                $overwriteNewerFiles = true;
            }else{
                $overwriteNewerFiles = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
                "destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                    "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder
                ),
                "inPlaceRestore" => $inPlaceRestore,
                "restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
                "suspendBackup" => $suspendBackup,
		"noOfThreads" => $_POST["noOfThreads"],
		"restoreDeletedFiles" => $restoreDeletedFiles,
                "overwriteNewerFiles" => $overwriteNewerFiles,
            );
            //$result = $this->_model->initiateRestores($headers, $data);
	    if($_POST['restoreTo'] == 'OneDrive'){
                $data['officePolicyName'] = 'pb-endpoint-to-onedrive-restore';
            }
            if($_POST['restoreTo'] != 'OneDrive'){
                $result = $this->_model->initiateRestores($headers, $data);
            }else{
                $result = $this->_model->initiateRestoresOneDrive($headers, $data);
            }
            $this->log("--------11111------> : ".json_encode($data),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => 'One Restore event already exists.'
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestores(){
            $headers = array(
                'token'         => $this->session->get('token'),
		'batchId'       => $_POST['batchId']
            );
            $result = $this->_model->deleteRestores($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }
    
    public function getUserDevices1(){

$this->log("------------------------>".json_encode($this->session->get('currentDeviceUUID')),"info");
        $headers = array(
            'token' => $this->session->get('token'),
            'userName' => $this->session->get('userName')
        );
//        $result = $this->_model->getUserSyncPolicy($headers);
$result = $this->_model->getAllDevices($headers);
        $this->log('result'.json_encode($result), 'info');
  //      $value = $result['body']->{'syncPolicyElement'};
//$value = $result['body']->{'device-info'};
//        $policy = [];
$devices = [];
        if(!empty($result['body']->{'device-info'})) {
foreach($result['body']->{'device-info'} as $value){
            $device = array(
                        'profilePic' => Url::profilePic((string)$value->{'userName'}),
                        'decoupled' => (string)$value->{'decoupled'},
                        'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                        'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                        'modifiedTimeStampUnix' => (int)$value->{'modified-timestamp'},
                        'deviceName' => (string)$value->{'device-name'},
                        'osType' => (string)$value->{'device-os-type'},
                        'icon' => (strpos((string)$value->{'device-os-type'},'Win') !== false ? 'windows' : 'apple'),
                        'deviceType' => (string)$value->{'deviceType'},
                        'version' => (string)$value->{'device-os-version'},
                        'tempPath' => (string)$value->{'device-temp-path'},
                        'deviceUUID' => (string)$value->{'device-uuid'},
                        'blocked' => (string)$value->{'is-blocked'},
                        'userName' => (string)$value->{'userName'},
                    );
if($device['blocked'] == 'false' && $this->session->get('currentDeviceUUID') == $value->{'device-uuid'}){
    $devices = array_merge(array($device), $devices);
                    }
$this->log("jjjjjjjjjjjjj : ".json_encode($devices),"info");
        }
}
        return $devices;
/*$response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;*/
    }

    
    //initiate restore from portal ends

//initiate restore from portal for onedrive starts
    public function initiateRestoresOneDrive(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            if($_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if($_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            if($_POST['restoreAllVersions'] == 'true'){
                $restoreAllVersions = true;
            }else{
                $restoreAllVersions = false;
            }
            if($_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
	    if($_POST['restoreLinks'] == 'true'){
                $restoreLinks = true;
            }else{
                $restoreLinks = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionBy" => $this->session->get('userName'),
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
                "destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                    "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder
                ),
                "inPlaceRestore" => $inPlaceRestore,
                "restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
                "suspendBackup" => $suspendBackup,
		"restoreLinks" => $restoreLinks
            );
            $result = $this->_model->initiateRestoresOneDrive($headers, $data);
            $this->log("--------11111------> : ".json_encode($data),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
		    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestoresOneDrive(){
            $headers = array(
                'token'         => $this->session->get('token'),
		'batchId' 	=> $_POST['batchId']
            );
            $result = $this->_model->deleteRestoresOneDrive($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
			'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }
    //initiate restore from portal for onedrive ends
	
	//initiate restore from portal for outlook starts
    public function initiateRestoresOutlook(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            if($_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if($_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            $restoreAllVersions = false;
	    if($_POST['restoreDeletedFiles'] == 'true'){
                $restoreDeletedFiles = true;
            }else{
                $restoreDeletedFiles = false;
            }
            if($_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
	    if($_POST['restoreLinks'] == 'true'){
                $restoreLinks = true;
            }else{
                $restoreLinks = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionBy" => $this->session->get('userName'),
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
                "destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder
                ),
                "inPlaceRestore" => $inPlaceRestore,
		"restoreDeletedFiles" => $restoreDeletedFiles,
		"restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
                "suspendBackup" => $suspendBackup,
		"restoreLinks" => $restoreLinks
            );
            $result = $this->_model->initiateRestoresOutlook($headers, $data);
            $this->log("--------11111------> : ".json_encode($data),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
			'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestoresOutlook(){
            $headers = array(
		    'token'         => $this->session->get('token')
            );
            $result = $this->_model->deleteRestoresOutlook($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
			    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }

    public function initiateRestoresOutlookFile(){
	    $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            if($_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if($_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            $restoreAllVersions = false;
	    if($_POST['restoreDeletedFiles'] == 'true'){
                $restoreDeletedFiles = true;
            }else{
                $restoreDeletedFiles = false;
            }
            if($_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
	    if($_POST['restoreLinks'] == 'true'){
                $restoreLinks = true;
            }else{
                $restoreLinks = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionBy" => $this->session->get('userName'),
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
                "destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder
                ),
                "inPlaceRestore" => $inPlaceRestore,
		"restoreDeletedFiles" => $restoreDeletedFiles,
                "restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
                "suspendBackup" => $suspendBackup,
		"restoreLinks" => $restoreLinks
            );
            $result = $this->_model->initiateRestoresOutlookFile($headers, $data);
            $this->log("--------11111------> : ".json_encode($data),"info");
	    switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
			exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestoresOutlookFile(){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->deleteRestoresOutlookFile($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
		    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
	}
    //initiate restore from portal for Outlook ends



    //initiate restore outlook device start
    public function initiateRestoresOutlookDevice(){
	    $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            if($_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if($_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            $restoreAllVersions = false;
	    if($_POST['restoreDeletedFiles'] == 'true'){
                $restoreDeletedFiles = true;
            }else{
                $restoreDeletedFiles = false;
            }
            if($_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
	    if($_POST['restoreLinks'] == 'true'){
                $restoreLinks = true;
            }else{
                $restoreLinks = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionBy" => $this->session->get('userName'),
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
                "destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder,
                    "device" => true,
                ),
                "inPlaceRestore" => $inPlaceRestore,
		"restoreDeletedFiles" => $restoreDeletedFiles,
                "restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
		"suspendBackup" => $suspendBackup,
		"restoreLinks" => $restoreLinks
            );
            $result = $this->_model->initiateRestoresOutlook($headers, $data);
            $this->log("--------11111------> : ".json_encode($data),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
		    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                        );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestoresOutlookDevice(){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->deleteRestoresOutlook($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
		case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
		    );
                    echo json_encode($result);
                    exit();
            }

        }
    //initiate restore outlook device end


    //initiate restore onedrive device start
    public function initiateRestoresOnedriveDevice(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            if($_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if($_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            $restoreAllVersions = false;
            if($_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
	    if($_POST['restoreLinks'] == 'true'){
                $restoreLinks = true;
            }else{
                $restoreLinks = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionBy" => $this->session->get('userName'),
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
		"destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder,
                    "device" => true,
                ),
                "inPlaceRestore" => $inPlaceRestore,
                "restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
                "suspendBackup" => $suspendBackup,
		"restoreLinks" => $restoreLinks
            );
            $result = $this->_model->initiateRestoresOneDrive($headers, $data);
            $this->log("--------11111------> : ".json_encode($data),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
		    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
			);
                        echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                        );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestoresOnedriveDevice(){
		$headers = array(
                'token'         => $this->session->get('token'),
		'backupId'	=> $_POST['backupId']
            );
            $result = $this->_model->deleteRestoresOneDrive($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
		    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
			'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }
    //initiate restore onedrive device end
	
	public function initiateRestoresOutlookSearchFile(){
	    $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            if($_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if($_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            $restoreAllVersions = false;
	    if($_POST['restoreDeletedFiles'] == 'true'){
                $restoreDeletedFiles = true;
            }else{
                $restoreDeletedFiles = false;
            }
            if($_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
	    if($_POST['restoreLinks'] == 'true'){
                $restoreLinks = true;
            }else{
                $restoreLinks = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionBy" => $this->session->get('userName'),
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
                "destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder
                ),
                "inPlaceRestore" => $inPlaceRestore,
		"restoreDeletedFiles" => $restoreDeletedFiles,
                "restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
                "suspendBackup" => $suspendBackup,
		"restoreLinks" => $restoreLinks
            );
            $result = $this->_model->initiateRestoresOutlookSearchFile($headers, $data);
            $this->log("--------11111------> : ".json_encode($data),"info");
	    switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
			exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestoresOutlookSearchFile(){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->deleteRestoresOutlookSearchFile($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
		    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
	}
	
	public function initiateRestoresOutlookSearchFileGS(){
	    $headers = array(
                'token'         => $this->session->get('token'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            if($_POST['folder'] == 'File'){
                $folder = false;
            }else{
                $folder = true;
            }
            if($_POST['inPlaceRestore'] == 'true'){
                $inPlaceRestore = true;
            }else{
                $inPlaceRestore = false;
            }
            $restoreAllVersions = false;
	    if($_POST['restoreDeletedFiles'] == 'true'){
                $restoreDeletedFiles = true;
            }else{
                $restoreDeletedFiles = false;
            }
            if($_POST['suspendBackup'] == 'true'){
                $suspendBackup = true;
            }else{
                $suspendBackup = false;
            }
	    if($_POST['restoreLinks'] == 'true'){
                $restoreLinks = true;
            }else{
                $restoreLinks = false;
            }
	    $_POST["fileCompletePath"] = html_entity_decode($_POST['fileCompletePath'], ENT_QUOTES | ENT_HTML5);
            $data = array(
                "actionBy" => $this->session->get('userName'),
                "actionOnDeviceUUID" => $_POST["actionOnDeviceUUID"],
                "destinationDeviceUUID" => $_POST["destinationDeviceUUID"],
                "destinationPath" => $_POST["destinationPath"],
                "fileElement" => array(
                "fileCompletePath" => $_POST["fileCompletePath"],
                    "backupId" => $_POST["backupId"],
                    "folder" => $folder
                ),
                "inPlaceRestore" => $inPlaceRestore,
		"restoreDeletedFiles" => $restoreDeletedFiles,
                "restoreDataBefore" => $_POST["restoreDataBefore"],
                "restoreAllVersions" => $restoreAllVersions,
                "suspendBackup" => $suspendBackup,
		"restoreLinks" => $restoreLinks
            );
            $result = $this->_model->initiateRestoresOutlookSearchFileGS($headers, $data);
            $this->log("--------11111------> : ".json_encode($data),"info");
	    switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'devices' => '',
                        'msg' => 'Restore has been queued.'
                        //'filePath' => $result['header']->container['filePath']
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $this->log("4444444111111111117777777777 : ".json_encode($result['body']->{'restoreEventsElement'}),"info");
                    $result = array(
                        'result' => 'restoreEventsElement_Exists',
                        'restoreEventsElement' => $result['body']->{'restoreEventsElement'},
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
			exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

    }

        public function deleteRestoresOutlookSearchFileGS(){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->deleteRestoresOutlookSearchFileGS($headers, $_POST['destinationDeviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Queued Restore has been removed.'
                    );
		    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
	}
	
	public function getAllUnblockedDevicesEndpoint(){
        if(empty($_GET)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }

        $headers = array(
            'Content-Type' => 'application/json',
	    'Accept' => 'application/json',
            'token' => $this->session->get('token'),
            //'skipValue' => $_GET['skipValue']
            'skipValue' => '0'
        );
        $isCurrentDeviceBlocked = false;
	$page = 0;
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevices($headers);
        }else{
            $result = $this->_model->getAllDevices11($headers,$page);
        }

        switch ($result['status']) {
            case (200):

                $devices = [];

                if(empty($result['body'])){
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                }

                foreach($result['body']->{'data'}->{'devices'} as $value){
		    $device = array(
                        'profilePic' => Url::profilePic((string)$value->{'userName'}),
                        'decoupled' => (string)$value->{'decoupled'},
                        'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                      //  'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                       // 'modifiedTimeStampUnix' => (int)$value->{'modified-timestamp'},
                        'deviceName' => (string)$value->{'deviceName'},
                        'device-os-type' => (string)$value->{'osType'},
                        'osType' => (string)$value->{'osType'},
                        'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
//                        'version' => (string)$value->{'device-os-version'},
  //                      'tempPath' => (string)$value->{'device-temp-path'},
                        'deviceUUID' => (string)$value->{'deviceUUID'},
                        'blocked' => (string)$value->{'blocked'},
                        'userName' => (string)$value->{'userName'},
                    );        
        	if($device['blocked'] == false && $device['osType'] != 'ONEDRIVE' && $device['osType'] != 'OUTLOOK' && $device['decoupled'] == false){
                        $devices = array_merge(array($device), $devices);
                    }else{
                        if($device['deviceName'] == $this->session->get('currentDeviceName')){
                            $isCurrentDeviceBlocked = true;
                        }
                    }
                }

                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }


public function getAllUnblockedDevicesOutlook(){
        if(empty($_GET)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }

        $headers = array(
            'Content-Type' => 'application/json',
	    'Accept' => 'application/json',
            'token' => $this->session->get('token'),
            //'skipValue' => $_GET['skipValue']
            'skipValue' => '0'
        );
        $isCurrentDeviceBlocked = false;
	$page = 0;
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevices($headers);
        }else{
            $result = $this->_model->getAllDevices11($headers,$page);
        }

        switch ($result['status']) {
            case (200):

                $devices = [];

                if(empty($result['body'])){
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                }

		foreach($result['body']->{'data'}->{'devices'} as $value){
		    $device = array(
                        'profilePic' => Url::profilePic((string)$value->{'userName'}),
                        'decoupled' => (string)$value->{'decoupled'},
                        'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                      //  'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                       // 'modifiedTimeStampUnix' => (int)$value->{'modified-timestamp'},
                        'deviceName' => (string)$value->{'deviceName'},
                        'device-os-type' => (string)$value->{'osType'},
                        'osType' => (string)$value->{'osType'},
                        'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
//                        'version' => (string)$value->{'device-os-version'},
  //                      'tempPath' => (string)$value->{'device-temp-path'},
                        'deviceUUID' => (string)$value->{'deviceUUID'},
                        'blocked' => (string)$value->{'blocked'},
                        'userName' => (string)$value->{'userName'},
                    );        
        	if($device['blocked'] == false && $device['osType'] == 'OUTLOOK' && $device['decoupled'] == false){
                        $devices = array_merge(array($device), $devices);
                    }else{
                        if($device['deviceName'] == $this->session->get('currentDeviceName')){
                            $isCurrentDeviceBlocked = true;
                        }
                    }
                }
                
                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }


public function getAllUnblockedDevicesOnedrive(){
        if(empty($_GET)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }

        $headers = array(
            'Content-Type' => 'application/json',
	    'Accept' => 'application/json',
            'token' => $this->session->get('token'),
            //'skipValue' => $_GET['skipValue']
            'skipValue' => '0'
        );
        $isCurrentDeviceBlocked = false;
	$page = 0;
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevices($headers);
        }else{
            $result = $this->_model->getAllDevices11($headers,$page);
        }

        switch ($result['status']) {
            case (200):

                $devices = [];

                if(empty($result['body'])){
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                }

		foreach($result['body']->{'data'}->{'devices'} as $value){
		    $device = array(
                        'profilePic' => Url::profilePic((string)$value->{'userName'}),
                        'decoupled' => (string)$value->{'decoupled'},
                        'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                      //  'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                       // 'modifiedTimeStampUnix' => (int)$value->{'modified-timestamp'},
                        'deviceName' => (string)$value->{'deviceName'},
                        'device-os-type' => (string)$value->{'osType'},
                        'osType' => (string)$value->{'osType'},
                        'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
//                        'version' => (string)$value->{'device-os-version'},
  //                      'tempPath' => (string)$value->{'device-temp-path'},
                        'deviceUUID' => (string)$value->{'deviceUUID'},
                        'blocked' => (string)$value->{'blocked'},
                        'userName' => (string)$value->{'userName'},
                    );        
        	if($device['blocked'] == false && $device['osType'] == 'ONEDRIVE' && $device['decoupled'] == false){
                        $devices = array_merge(array($device), $devices);
                    }else{
                        if($device['deviceName'] == $this->session->get('currentDeviceName')){
                            $isCurrentDeviceBlocked = true;
                        }
                    }
                }                

                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
	
    public function sendShareEmail(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'token'             => $this->session->get('token'),
                'toEmailList'       => $_POST['emails'],
                'downloadLink'      => $_POST['url'],
		'productType'       => "backup",
		'devicePath'        => base64_encode($_POST['filePath']),		
	);
	    $data = array(
		'fileName'   => base64_encode($_POST['fileName']),
		'devicePath' => base64_encode($_POST['devicePath']),
                'deviceUUID' => $_POST['deviceUUID'],
                'miniCloudName' => '',
		'cloudName' => $this->session->get('cloudName'),
		'googleAuthIsEnabled' => $_POST['googleAuthIsEnabled']
	);
	    $data['devicePath'] = base64_encode($_POST['filePath']);
	    $this->log("REQUEST HEADERS: ".json_encode($headers),"info");
	    $this->log("REQUEST BODY : ".json_encode($data),"info");
            $result = $this->_model->sendShareEmail($headers,$data);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Mail has been sent Successfully'
                    );
                    echo json_encode($response);
		    exit;
		case (417):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'User Limit exceeded, Mail has been sent Successfully'
                    );
                    echo json_encode($response);
                    exit;
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
		    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
	}

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function changePasswordForFirstlogin(){
            $headers = array(
                'token'         => $this->session->get('token'),
                'userName' => $this->session->get('userName'),
                'password' => hash('sha512', $_POST['password']),
            );
            $this->log("PASSWORD => ".$_POST['password'],"info");
            $result1 = $this->_model->getUserData(array('token' => $this->session->get('token'), 'loggedInUserName' => base64_encode($this->session->get('userName'))), base64_encode($this->session->get('userName')));
            $xml1   = new \SimpleXMLElement($result1['body']);
            $oldpass = $xml1->{'password-hash'};
            $newpass = hash('sha512', $_POST['password']);
	    $this->log('passwordNew: '. $newpass, 'info');
            /*$oldpassword_valuepost = hash('sha512', $_POST['oldpassword']);
            $this->log('passwordOld: '. $oldpass, 'info');            
            $similarity1 = strcmp($oldpassword_valuepost,$oldpass);                    
                    $similarity = strcmp($newpass,$oldpass);
                    if($similarity == 0 ){
                        $this->log('passwordOld and new are same: ', 'info');
                        $response = array(
                            'result' => 'oldNewSame',
                            'msg'  => 'passwordnotchanged'
                        );
                        echo json_encode($response);
                        exit;
                    }*/
            $result = $this->_model->changePasswordForFirstlogin($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success'
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                 $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                        );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    public function checkMailNew(){
            $headers = array(
		'mailId'  => $_POST['emailId'],
		'mfaLink' => 'https://'.PARACLOUD_IP.'/portal/share/qrcode/'
            );
            $result = $this->_model->sendQR($headers, $this->session->get('cloudName'));
            $this->log("RESULTTTTTT : ".json_encode($result),"info");
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg'  => 'A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.'
                    );
                    echo json_encode($response);
                            exit;
                        case (404):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'A link to the QR code will be automatically sent to the email ID you provided, if it is valid and registered with the system.  Please wait for a while and check your email.'
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
	
    /*----------------------------------------*/
//protected $_codeLength = 6;

    /**
     * Create new secret.
     * 16 characters, randomly chosen from the allowed base32 characters.
     *
     * @param int $secretLength
     * @return string
     */
    public function createSecret($secretLength = 16)
    {
        $validChars = $this->_getBase32LookupTable();
        unset($validChars[32]);

        $secret = '';
        for ($i = 0; $i < $secretLength; $i++) {
            $secret .= $validChars[array_rand($validChars)];
        }
        return $secret;
}

    /**
     * Calculate the code, with given secret and point in time
     *
     * @param string $secret
     * @param int|null $timeSlice
     * @return string
     */
    public function getCode($secret, $timeSlice = null)
    {
        if ($timeSlice === null) {
            $timeSlice = floor(time() / 30);
        }

        $secretkey = $this->_base32Decode($secret);

        // Pack time into binary string
	$time = chr(0).chr(0).chr(0).chr(0).pack('N*', $timeSlice);
        // Hash it with users secret key
        $hm = hash_hmac('SHA1', $time, $secretkey, true);
        // Use last nipple of result as index/offset
        $offset = ord(substr($hm, -1)) & 0x0F;
        // grab 4 bytes of the result
        $hashpart = substr($hm, $offset, 4);

        // Unpak binary value
        $value = unpack('N', $hashpart);
        $value = $value[1];
        // Only 32 bits
        $value = $value & 0x7FFFFFFF;

        $modulo = pow(10, $this->_codeLength);
        return str_pad($value % $modulo, $this->_codeLength, '0', STR_PAD_LEFT);
    }
/**
     * Get QR-Code URL for image, from google charts
     *
     * @param string $name
     * @param string $secret
     * @param string $title
     * @return string
     */
    public function getQRCodeGoogleUrl($name, $secret, $title = null) {
        $urlencoded = urlencode('otpauth://totp/'.$name.'?secret='.$secret.'');
    if(isset($title)) {
                $urlencoded .= urlencode('&issuer='.urlencode($title));
        }
        return 'https://chart.googleapis.com/chart?chs=200x200&chld=M|0&cht=qr&chl='.$urlencoded.'';
    }
/**
     * Check if the code is correct. This will accept codes starting from $discrepancy*30sec ago to $discrepancy*30sec from now
     *
     * @param string $secret
     * @param string $code
     * @param int $discrepancy This is the allowed time drift in 30 second units (8 means 4 minutes before or after)
     * @param int|null $currentTimeSlice time slice if we want use other that time()
     * @return bool
     */
    public function verifyCode($secret, $code, $discrepancy = 1, $currentTimeSlice = null)
    {
        if ($currentTimeSlice === null) {
            $currentTimeSlice = floor(time() / 30);
        }

        for ($i = -$discrepancy; $i <= $discrepancy; $i++) {
            $calculatedCode = $this->getCode($secret, $currentTimeSlice + $i);
		$this->log("CODE : ".json_encode($code),"info");
		$this->log("getCODE : ".json_encode($calculatedCode),"info");
            if ($calculatedCode == $code ) {
		return true;
            }
        }

        return false;
    }

    /**
     * Set the code length, should be >=6
     *
     * @param int $length
     * @return GoogleAuthenticator
     */
    public function setCodeLength($length)
    {
        $this->_codeLength = $length;
        return $this;
    }
/**
     * Helper class to decode base32
     *
     * @param $secret
     * @return bool|string
     */
    protected function _base32Decode($secret)
    {
        if (empty($secret)) return '';

        $base32chars = $this->_getBase32LookupTable();
        $base32charsFlipped = array_flip($base32chars);

        $paddingCharCount = substr_count($secret, $base32chars[32]);
        $allowedValues = array(6, 4, 3, 1, 0);
        if (!in_array($paddingCharCount, $allowedValues)) return false;
        for ($i = 0; $i < 4; $i++){
if ($paddingCharCount == $allowedValues[$i] &&
                substr($secret, -($allowedValues[$i])) != str_repeat($base32chars[32], $allowedValues[$i])) return false;
        }
        $secret = str_replace('=','', $secret);
        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i = $i+8) {
            $x = "";
            if (!in_array($secret[$i], $base32chars)) return false;
            for ($j = 0; $j < 8; $j++) {
                $x .= str_pad(base_convert(@$base32charsFlipped[@$secret[$i + $j]], 10, 2), 5, '0', STR_PAD_LEFT);
            }
            $eightBits = str_split($x, 8);
            for ($z = 0; $z < count($eightBits); $z++) {
                $binaryString .= ( ($y = chr(base_convert($eightBits[$z], 2, 10))) || ord($y) == 48 ) ? $y:"";
            }
        }
        return $binaryString;
}

    /**
     * Helper class to encode base32
     *
     * @param string $secret
     * @param bool $padding
     * @return string
     */
    protected function _base32Encode($secret, $padding = true)
    {
        if (empty($secret)) return '';

        $base32chars = $this->_getBase32LookupTable();

        $secret = str_split($secret);
        $binaryString = "";
        for ($i = 0; $i < count($secret); $i++) {
$binaryString .= str_pad(base_convert(ord($secret[$i]), 10, 2), 8, '0', STR_PAD_LEFT);
        }
        $fiveBitBinaryArray = str_split($binaryString, 5);
        $base32 = "";
        $i = 0;
        while ($i < count($fiveBitBinaryArray)) {
            $base32 .= $base32chars[base_convert(str_pad($fiveBitBinaryArray[$i], 5, '0'), 2, 10)];
            $i++;
        }
        if ($padding && ($x = strlen($binaryString) % 40) != 0) {
            if ($x == 8) $base32 .= str_repeat($base32chars[32], 6);
            elseif ($x == 16) $base32 .= str_repeat($base32chars[32], 4);
            elseif ($x == 24) $base32 .= str_repeat($base32chars[32], 3);
            elseif ($x == 32) $base32 .= $base32chars[32];
        }
        return $base32;
    }
/**
     * Get array with all 32 characters for decoding from/encoding to base32
     *
     * @return array
     */
    protected function _getBase32LookupTable()
    {
        return array(
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', //  7
            'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', // 15
            'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', // 23
            'Y', 'Z', '2', '3', '4', '5', '6', '7', // 31
            '='  // padding char
        );
    }
/*----------------------------------------*/
}
