#!/bin/bash
# DEVELOPED BY: Parablu Systems								#
# DEVELOPER: VAIBHAV K                                                                                      #
# PLATFORM: Ubuntu

PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

enablesite_conf="/etc/apache2/sites-enabled/default-ssl.conf"

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] ||  [ "$SERVER_TYPE" == "3 1" ]; then

	sed -i '/ServerName/d' $enablesite_conf
	sed -i "/ServerAdmin support@parablu.com/a ServerName $BLUVAULT_IP" $enablesite_conf

fi

if  [ "$SERVER_TYPE" == "2" ] || [ "$SERVER_TYPE" == "3" ]; then
	sed -i '/ServerName/d' $enablesite_conf
	sed -i "/ServerAdmin support@parablu.com/a ServerName $BLUKRYPT_IP" $enablesite_conf
fi

service apache2 restart

sudo apt-get -y update
apt-get -f install certbot python3-certbot-apache
sudo apt-get -y update

sleep 10s
tput clear
echo "Configuring Lets Encrypt"
sudo certbot --apache


sleep 5s
service apache2 restart

croncmd="sudo certbot renew --dry-run 2>&1 && /etc/init.d/apache2 restart"
cronjob="0 0 1 * * $croncmd"
( crontab -l | grep -v -F "$croncmd" ; echo "$cronjob" ) | crontab -
