<?php

use \Core\View;
use \Helpers\Url;
use \Core\Language;

/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SupportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='support'?></span>
            <div class="panel panel-default">
                    <div class="panel-heading"><h3>Support Overview<span <?php if(!isMobile()){ ?>class="pull-right" <?php } ?>><a class="btn btn-success btn-small" href="https://support.parablu.com" target="blank"><?=Language::show('create_support_ticket', 'keywords');?></a></span></h3></div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-6" block-ui="myBlockUI">
                                <div class="panel panel-default no-box-shadow widget-purple">
                                    <div class="background">
                                        <i class="fa fa-clock-o"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>Parablu Installation valid Until</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-clock-o"></i>
                                        <a class="pull-right" style="font-size: 23px;margin-top: -20px;"><span ng-cloak>{{ statistics.cloudValidityUntil }}</a>
                                    </div>
                                </div>
                            </div>
                            <?php if($data['showLicenseKey'] == 'true'){?>
                            <div class="col-lg-6" block-ui="myBlockUI" ng-click="sendMeTo('settings/licenseKey')" style="cursor:pointer;">
                                <div class="panel panel-default no-box-shadow widget-warning">
                                    <div class="background">
                                        <i class="fa fa-key"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <a>License Key Management</a>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-key"></i>
                                        <a class="pull-right" style="font-size: 23px;margin-top: -20px;"><span ng-cloak>{{ statistics.currentLicenseKey }}</a>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <ul class="list-group col-lg-6">
                            <li class="list-group-item" style="border-color:#f27331 !important;border-radius:10px !important;">Paracloud Installed Version <b <?php if(!isMobile()){ ?> class="pull-right" <?php } ?> ng-cloak>{{ statistics.parabluInstalledVerion }}</b></li>
                        </ul>
                    </div>
                </div>
            <div class="panel">
                <div class="panel-heading">
                    <h4>Support Logs</h4>
                </div>
                <div class="panel-body">
                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="getSupportLogs(search.deviceName)" data-parsley-validate>
                                    <div class="">
                                        <select class="searchDeviceName" style="width: 25%;" id="deviceName" ng-model="search.deviceName" data-parsley-trigger="change" required></select>
                                        <button type="submit" class="btn btn-default">Capture Support Logs</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                    <?php } ?>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <table class="table table-bordered table-striped supportLogTable" style="display: none;">
                            <colgroup>
                                <col class="col-xs-2">
                                <col class="col-xs-3">
                                <col class="col-xs-4">
                                <col class="col-xs-3">
                            </colgroup>
                            <thead>
                            <tr>
                                    <th class="clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('deviceName', 'keywords')?>
                                        <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="clickAble" ng-click="sortType = '_id'; sortReverse = !sortReverse">
                                        <?=Language::show('supportId', 'keywords')?>
                                        <span ng-show="sortType == '_id' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == '_id' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="clickAble" ng-click="sortType = 'convertedOne'; sortReverse = !sortReverse">
                                        <?=Language::show('date', 'keywords')?>
                                        <span ng-show="sortType == 'convertedOne' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'convertedOne' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in supportLogs | orderBy:sortType:sortReverse">
                                <td ng-cloak>{{ value.userName }}</td>
                                <td ng-cloak>{{ value.deviceName }}</td>
                                <td><a href="{{BASE_FOLDER+'/logDetails/'+value._id}}" ng-cloak>{{ value._id }}</a></td>
                                <td ng-cloak>{{ value.timeStamp }}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row supportLogTable" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="updatedSupportLogsNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="updatedSupportLogsNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="updatedSupportLogsNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="updatedSupportLogsNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SupportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"device/searchDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Server'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
