<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.5.3
 * @date 30/10/19
 * @time 5:40 PM
 * 
 */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
 <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='dashboard'?></span>
            <div class="row">
                <div class="panel col-lg-12">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Mongo Properties</h4>
                    </div>
                    <div class="panel-body">
			<form class="mongoProperties" id="mongoProperties" ng-submit="saveMongoProperties()" data-parsley-validate>
                            <div class="row" style="margin-left:0px !important;margin-right:0px !important;">
				<input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
                                <div class="d-none">
                                <label for="pubkey">Public Key</label><br/>
                                        <textarea id="pubkey" rows="15" cols="65">-----BEGIN PUBLIC KEY-----
                                    MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJa13jCuhhMNQfcXb6uRJEnKkQ
                                    BQxpl1Dp5U8EDbo16KrSDT++OytnYqVx6opHwJoZ9jwc8qUMheyPkvqRwkxBEulq
                                    Ig8Tca9eg/uVjg2DHs4wIyzNJ7P19n1d4KoF3I8ZU1IrdDa0aQ85Fc3ogakZY9+x
                                    VCPksMvihMgXe2xLdwIDAQAB
                                    -----END PUBLIC KEY-----</textarea><br/>
                                    </div>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="id">id</label>
                                    <input type="text" class="form-control" name="id" id="id" value="<?=$data['proxy'][0]->{'id'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="mongoIp">Mongo IP</label>
                                    <input type="text" class="form-control" name="mongoIp" id="mongoIp" value="<?=$data['proxy'][0]->{'mongoIp'}?>" placeholder="Enter your mongo IP" required autocomplete="off" <?php if($data['proxy'][0]->{'mongoIp'} != '') {?>readonly<?php }?>>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="proxyUserName">Proxy Username</label>
                                    <input type="text" class="form-control" name="proxyUserName" id="proxyUserName" value="<?=$data['proxy'][0]->{'proxyUserName'}?>" placeholder="Enter your proxy Username" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="proxyPort">Proxy Port</label>
                                    <input type="text" class="form-control" name="proxyPort" id="proxyPort" value="<?=$data['proxy'][0]->{'proxyPort'}?>" placeholder="Enter your Port" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="proxyHost">Proxy Host</label>
                                    <input type="text" class="form-control" name="proxyHost" id="proxyHost" value="<?=$data['proxy'][0]->{'proxyHost'}?>" placeholder="Enter your Proxy Host" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="proxyPassword">Proxy password</label>
                                    <input type="password" class="form-control" name="proxyPassword" id="proxyPassword" value="<?=$data['proxy'][0]->{'proxyPassword'}?>" placeholder="Enter your Proxy Password" required autocomplete="new-password">
                                </div>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="backupdir">Backup Directory</label>
                                    <input type="text" class="form-control" name="backupdir" id="backupdir" value="<?=$data['proxy'][0]->{'backupdir'}?>" placeholder="Enter your Backup Directory" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="archivedir">Archive Directory</label>
                                    <input type="text" class="form-control" name="archivedir" id="archivedir" value="<?=$data['proxy'][0]->{'archivedir'}?>" placeholder="Enter your Archive Directory" required autocomplete="off">
                                </div>                                
                                <div class="form-group col-lg-6 d-none">
                                    <label for="backblazeid">Backblaze Id</label>
                                    <input type="text" class="form-control" name="backblazeid" id="backblazeid" value="<?=$data['proxy'][0]->{'backblaze_id'}?>" placeholder="Enter your Backblaze Id" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="applicationkey">Application Key</label>
                                    <input type="text" class="form-control" name="applicationkey" id="applicationkey" value="<?=$data['proxy'][0]->{'application_key'}?>" placeholder="Enter your Application Key" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="backblaze_bucket">Backblaze Bucket</label>
                                    <input type="text" class="form-control" name="backblazebucket" id="backblazebucket" value="<?=$data['proxy'][0]->{'backblaze_bucket'}?>" placeholder="Enter your Backblaze Bucket" required autocomplete="off">
                                </div>                                
                                <div class="form-group col-lg-6 d-none">
                                    <label for="customername">Customer Name</label>
                                    <input type="text" class="form-control" name="customername" id="customername" value="<?=$data['proxy'][0]->{'customer_name'}?>" placeholder="Enter your Customer Name" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 d-none">
                                    <label for="backblazebackup">Backblaze Backup</label>
                                    <input type="text" class="form-control" name="backblazebackup" id="backblazebackup" value="<?=$data['proxy'][0]->{'backblaze_backup'}?>" placeholder="Enter your Backblaze Backup" required autocomplete="off">
                                </div>                                
                                <div class="form-group col-lg-6 d-none">
                                    <label for="encryptbackup">Encrypt Backup</label>
                                    <input type="text" class="form-control" name="encryptbackup" id="encryptbackup" value="<?=$data['proxy'][0]->{'encrypt_backup'}?>" placeholder="Enter your Encrypt Backup" required autocomplete="off">
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <button style="margin-right: 5px;" type="submit" class="btn btn-success float-right mongoSave">Save</button>
			    </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
