<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=URL::basePath()?>"><?=Language::show('Dashboard', 'report')?></a></h3></li>
                <?php if(BLUDRIVE_MODE == true) { ?>
                <li>Bludrive Overview Summary</li>
                <?php } else { ?>
                <li><?=$data['crumb1']?></li>
                <?php } ?>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <?php if(!empty($_SESSION['OverReportResult'])){ ?>
                <?php if($_SESSION['OverReportResult'] == 404){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 404</span>
                <?php }elseif($_SESSION['OverReportResult'] == 500){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 500</span>
                <?php }elseif($_SESSION['OverReportResult'] == 302){ ?>
                    <span class="resultError" style="display: none">Start date and end date should not be empty.</span>
                <?php } ?>
                <?php $_SESSION['OverReportResult'] = ''; ?>
            <?php } ?>
            <div class="row">
                <span class="csrf_token hide"><?=$data['csrf_token']?></span>
                <span class="currentPage hide"><?='syncCLoudUsage'?></span>
                <div class="panel">
                    <div class="panel-heading">
                        <?php if(BLUDRIVE_MODE == true) { ?>
                        <h3>Bludrive Overview Summary</div>
                        <?php } else { ?>
                        <h3><?=$data['crumb1']?></div>
                        <?php } ?>
                    <div class="panel-body">
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <br/><br/>
                        <div class="table-responsive">
                        <table id="SyncCLoudUsage" class="table table-bordered syncCLoudUsage" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center">
                                    <?=Language::show('Users', 'keywords')?>
                                </th>
                                <th class="text-center">
                                    <?=Language::show('Total Files Shared', 'keywords')?>
                                </th>
                                <th class="text-center">
                                    <?=Language::show('Total Files Downloaded', 'keywords')?>
                                </th>
                                <th class="text-center">
                                    <?=Language::show('Total Size uploaded', 'keywords')?>
                                </th>
                                <th class="text-center">
                                    <?=Language::show('Total Size Downloaded', 'keywords')?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr class="text-center">
                                <td class="text-center" ng-cloak>{{ syncCLoudUsage.totalUsers }}</td>
                                <td class="text-center" ng-cloak>{{ syncCLoudUsage.totalFilesShared }}</td>
                                <td class="text-center" ng-cloak>{{ syncCLoudUsage.totalFilesDownloaded }}</td>
                                <td class="text-center" ng-cloak>{{ syncCLoudUsage.totalSizeUploaded }}</td>
                                <td class="text-center" ng-cloak>{{ syncCLoudUsage.totalSizeDownloaded }}</td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="h4 syncCLoudUsageError text-center" style="display: none">No details found for Failed Backup</div>
                        <br/>
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateSyncCloudUsageDetails(search.from, search.to)" data-parsley-validate>
                                    <div class="form-group">
                                        <label for="from">From Date</label>
                                        <input type="text" class="form-control" id="from" ng-model="search.from" placeholder="From Date" data-parsley-trigger="change" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="to">To Date</label>
                                        <input type="text" class="form-control" value="" id="to" ng-model="search.to" placeholder="To Date" data-parsley-trigger="change" required>
                                    </div>
                                    <button type="submit" class="btn btn-default">View</button>
                                    <a ng-click="redirectToDownload('<?=Url::basePath('report/download/downloadOverViewReportSync/')?>', search.to, search.from)" class="btn btn-default clickAble">Download</a>
                                </form>
                            </div>
                        </div>
                        <br/><br/>
                        <div class="table-responsive">
                        <table id="SyncCLoudUsage" class="table table-bordered syncCLoudUsageWithDetails" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'overViewDate'; sortReverse = !sortReverse">
                                    <?=Language::show('overViewDate', 'keywords')?>
                                    <span ng-show="sortType == 'overViewDate' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'overViewDate' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'totalUsers'; sortReverse = !sortReverse">
                                    <?=Language::show('Users', 'keywords')?>
                                    <span ng-show="sortType == 'totalUsers' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'totalUsers' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'totalFilesShared'; sortReverse = !sortReverse">
                                    <?=Language::show('Total Files Shared', 'keywords')?>
                                    <span ng-show="sortType == 'totalFilesShared' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'totalFilesShared' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'totalFilesDownloaded'; sortReverse = !sortReverse">
                                    <?=Language::show('Total Files Downloaded', 'keywords')?>
                                    <span ng-show="sortType == 'totalFilesDownloaded' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'totalFilesDownloaded' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'totalSizeUploaded'; sortReverse = !sortReverse">
                                    <?=Language::show('Total Size uploaded', 'keywords')?>
                                    <span ng-show="sortType == 'totalSizeUploaded' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'totalSizeUploaded' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'totalSizeDownloaded'; sortReverse = !sortReverse">
                                    <?=Language::show('Total Size Downloaded', 'keywords')?>
                                    <span ng-show="sortType == 'totalSizeDownloaded' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'totalSizeDownloaded' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in syncCloudUsageDetails | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.overViewDate }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalUsers }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalFilesShared }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalFilesDownloaded }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalSizeUploaded }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalSizeDownloaded }}</td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js" type="text/javascript"></script>
<script>
    $('#from').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+0d',
        todayHighlight: true
    });
    $('#to').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        endDate: '+0d',
        todayHighlight: true
    });
</script>