<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?='Dashboard'?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-12 col-md-12 col-sm-12 ng-cloak">
            <?php if(!empty($_SESSION['OverReportResult'])){ ?>
                <?php if($_SESSION['OverReportResult'] == 404){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 404</span>
                <?php }elseif($_SESSION['OverReportResult'] == 500){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 500</span>
                <?php } ?>
                <?php $_SESSION['OverReportResult'] = ''; ?>
            <?php } ?>
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='overview'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h3><?=$data['crumb1']?>
                            <span class="overviewJobTime" ng-if="overviewJobTime.length > 0" style="font-size: 14px; display: none;">- SnapShot Timestamp: {{ overviewJobTime }}</span>
                        </h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                              <form ng-submit="searchUserInOverView(search.userName,search.searchPolicyName)">
                                    <div class="row">

<div class="col-lg-12" style="margin-bottom: 10px;">
    <label class="radio-inline">
      <input type="radio" name="userOption" value="policy" checked>Policy Name
    </label>
    <label class="radio-inline">
      <input type="radio" name="userOption" value="userNdDevice">User Id and Device name
    </label>
</div><br/>
<div class="col-lg-5" id="userNdDevice" style="display: none;">
                                        <div class="col-lg-6">
                                            <label for="searchUsername">User Id</label>
                                            <select name="searchUsername"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsername"
                                                    id="searchUsername"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceName">Device Name</label>
                                            <select class="searchDeviceName form-control" id="searchDeviceName" readonly>
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                    </div>

                                        <div class="col-lg-4" id="policy">
                                        <label for='searchPolicyName'>Policy Name</label>
                                        <select class="form-control selectPicker" id="searchPolicyName" name="searchPolicyName[]" id="searchPolicyName" title='Select Backup Policy Name' multiple data-selected-text-format="count>4">
                                            <option value="all" selected="selected">all</option>
                                                            <?php if(!empty($data['backupPolicies'])){ ?>
                                                                <?php foreach($data['backupPolicies'] as $value){ 
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                    <option value="<?=$value?>"><?=$label?></option>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        </select>                 
                                        </div>
					<div class="col-lg-3" style="margin-top:35px;">
                                            <input class="isUserWithoutDeviceEnabled" id="isUserWithoutDeviceEnabled" type="checkbox" name="isUserWithoutDeviceEnabled" ng-model="search.isUserWithoutDeviceEnabled">
                                            <label for="isUserWithoutDeviceEnabled">Include Users without a device installed</label><br>
                                              
                                            <input class="showBlockedUsers ng-pristine ng-untouched ng-valid" id="showBlockedUsers" type="checkbox" name="showBlockedUsers" checked>
                                            <label for="showBlockedUsers">Include blocked users</label><br>

                                            <input class="showBlockedDevices ng-pristine ng-untouched ng-valid" id="showBlockedDevices" type="checkbox" name="showBlockedDevices" checked>
                                            <label for="showBlockedDevices">Include blocked devices</label>
                                         </div>
                                        <div class="dropdown col-lg-4">
                                            <button style="margin-top: 25px" type="submit" class="btn tbn-default">View</button>
                                            <button style="margin-top: 25px" class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                Download as
                                                <span class="caret"></span>
                                              </button>
                                              <ul class="dropdown-menu" aria-labelledby="dropdownMenu1">
                                                <li><a ng-click="downloadOverview(search.userName, search.deviceName, search.searchPolicyName)">Excel</a></li>
                                                <li><a ng-click="downloadOverviewPdf(search.userName, search.deviceName, search.searchPolicyName)">PDF</a></li>
                                              </ul>
					      <a title="Schedule" class="btn btn-default" data-toggle="tooltip" data-placement="top" ng-click="schedule('sendBackupOverviewReportTimer')" style="margin-top: 25px;"><i class="fa fa-calendar"></i> Schedule</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="table-responsive">
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table class="table-bordered overviewListTable" style="display: none;">
                            <div class="h4 noBackupOverviewData text-center" style="display: none;">No details found</div>
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'userId'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="overviewSortType == 'userId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'userId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'emailId'; sortReverse = !sortReverse">
                                    <?=Language::show('email_address', 'keywords')?>
                                    <span ng-show="overviewSortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<th class="text-center clickAble" ng-click="overviewSortType = 'userActive'; sortReverse = !sortReverse">
                                    <?=Language::show('User Status', 'keywords')?>
                                    <span ng-show="overviewSortType == 'userActive' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'userActive' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('deviceName', 'keywords')?>
                                    <span ng-show="overviewSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'deviceActive'; sortReverse = !sortReverse">
                                    <?=Language::show('Device Status', 'keywords')?>
                                    <span ng-show="overviewSortType == 'deviceActive' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'deviceActive' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'clientVersion'; sortReverse = !sortReverse">
                                    <?=Language::show('Client Version', 'keywords')?>
                                    <span ng-show="overviewSortType == 'clientVersion' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'clientVersion' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
				<?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'policyName'; sortReverse = !sortReverse">
                                    <?=Language::show('Backup Policy Name', 'keywords')?>
                                    <span ng-show="overviewSortType == 'policyName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'policyName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'odbPolicyName'; sortReverse = !sortReverse">
                                    <?=Language::show('Office 365 Policy Name', 'keywords')?>
                                    <span ng-show="overviewSortType == 'odbPolicyName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'odbPolicyName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'isFirstBackupCompleted'; sortReverse = !sortReverse">
                                    <?=Language::show('Is First Backup Completed', 'keywords')?>
                                    <span ng-show="overviewSortType == 'isFirstBackupCompleted' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'isFirstBackupCompleted' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'lastSuccessfulBackupEndTimeInMillis'; sortReverse = !sortReverse">
                                    <?=Language::show('lastSuccessfulBackupEndTime', 'keywords')?>
                                    <span ng-show="overviewSortType == 'lastSuccessfulBackupEndTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'lastSuccessfulBackupEndTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'currentBkpStatus'; sortReverse = !sortReverse">
                                    <?=Language::show('currentBackupStatus', 'keywords')?>
                                    <span ng-show="overviewSortType == 'currentBkpStatus' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'currentBkpStatus' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'totalCurrentlyRunningBkpSizeInPer'; sortReverse = !sortReverse">
                                    <?=Language::show('currentBackupCompletionPercentage', 'keywords')?>
                                    <span ng-show="overviewSortType == 'totalCurrentlyRunningBkpSizeInPer' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'totalCurrentlyRunningBkpSizeInPer' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'currentlyRunningBkpTotalSizeOfFilesInKB'; sortReverse = !sortReverse">
                                    <?=Language::show('Current Backup Size', 'keywords')?>
                                    <span ng-show="overviewSortType == 'currentlyRunningBkpTotalSizeOfFilesInKB' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'currentlyRunningBkpTotalSizeOfFilesInKB' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'isBackupRunning'; sortReverse = !sortReverse">
                                    <?=Language::show('Is backup running', 'keywords')?>
                                    <span ng-show="overviewSortType == 'isBackupRunning' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'isBackupRunning' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'lastHeardTimeInMillis'; sortReverse = !sortReverse">
                                    <?=Language::show('lastHeardTime', 'keywords')?>
                                    <span ng-show="overviewSortType == 'lastHeardTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'lastHeardTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'storageUtilizedInKB'; sortReverse = !sortReverse">
                                    <?=Language::show('totalStorageUtilized', 'keywords')?>
                                    <span ng-show="overviewSortType == 'storageUtilizedInKB' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'storageUtilizedInKB' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'reason'; sortReverse = !sortReverse">
                                    <?=Language::show('Notes', 'keywords')?>
                                    <span ng-show="overviewSortType == 'reason' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'reason' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in overview | orderBy:overviewSortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak >{{ value.userId }}</td>
                                <td class="text-center" ng-cloak>{{ value.emailId }}</td>
                                <td class="text-center" ng-cloak>{{ value.userActive }}</td>
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td class="text-center" ng-cloak>{{value.deviceActive}}</td>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <td class="text-center" ng-if="!value.clientVersion" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.clientVersion" ng-cloak>{{ value.clientVersion }}</td>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                <td class="text-center" ng-show="value.policyName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.policyName != null" ng-cloak>{{ value.policyName }}</td>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                <td class="text-center" ng-show="value.odbPolicyName == null" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.odbPolicyName != null" ng-cloak>{{ value.odbPolicyName }}</td>
                                <?php } ?>
                                <td class="text-center" ng-cloak>{{ value.isFirstBackupCompleted }}</td>
                                <td class="text-center" ng-if="!value.lastSuccessfulBackupEndTime" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.lastSuccessfulBackupEndTime" ng-cloak>{{ value.lastSuccessfulBackupEndTime }}</td>
                                <td class="text-center" ng-if="!value.currentBkpStatus" ng-cloak> - </td>
                                <td class="text-center" ng-if="value.currentBkpStatus" ng-cloak>{{ value.currentBkpStatus }}</td>
                                <td class="text-center" ng-cloak>{{ value.totalCurrentlyRunningBkpSizeInPer }}</td>
                                <td class="text-center" ng-cloak>{{ value.currentlyRunningBkpTotalSizeOfFiles }}</td>
                                <td class="text-center" ng-cloak>{{ value.isBackupRunning }}</td>
                                <td class="text-center" ng-show="value.lastHeardTime == ''" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.lastHeardTime != ''" ng-cloak>{{ value.lastHeardTime }}</td>
                                <td class="text-center" ng-show="value.storageUtilized == ''" ng-cloak> - </td>
                                <td class="text-center" ng-show="value.storageUtilized != ''" ng-cloak>{{ value.storageUtilized }}</td>
                                <td class="text-center" ng-if="!value.reason" ng-cloak> - </td>
                                <td class="text-center"  ng-if="value.reason" ng-cloak>{{ value.reason }}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    </div>
                    <div class="row overviewListTable" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="searchUserInOverViewNavigate(search.userName,search.searchPolicyName,last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <!--<div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'overview')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>-->
                </div>
            </div>
        </div>
    </div>
	<!--modal start-->
<div class="modal fade" id="scheduleModalList" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <div class="modal-header">
                    <h4 class="modal-title"><?=Language::show('List of Schedules', 'keywords')?></h4>
                </div>
                <div class="modal-body">
                    <div class="row schedulesNotFound" style="display: none;">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h2 align="center"><?=Language::show('No Schedules found !!!!!!', 'keywords');?></h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row schedulesFound" style="display: none;">
                        <div class="table-responsive col-lg-12 schedulesTable">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Schedule Name</th>
                                        <th>Schedule Time</th>
                                        <th>Recipient email IDs</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in schedules">
                                        <td>{{value.scheduleName | limitTo:20}}{{value.scheduleName.length > 20 ? '...' : ''}}</td>
                                        <td>{{value.time}}</td>
                                        <td ng-if="value.allAdmins == 'false'" class="text-left" title="{{ value.emailIds }}" ng-cloak>{{ value.emailIds | limitTo:50}}{{value.emailIds.length > 50 ? '...' : ''}}</td>
                                        <td ng-if="value.allAdmins == 'true'" class="text-left" title="All admins" ng-cloak>All admins</td>
                                        <td>
                                            <a class="btn btn-small btn-success" ng-click="getSchedule(value.id)">Edit</a>
                                            <a class="btn btn-small btn-danger" ng-click="deleteScheduleConfirm(value.id, value.scheduleName)">Delete</a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="z-index: 10000000000;">
			<a href="" class="btn btn-success" ng-click="createSchedule()">Create New Schedule</a>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!--modal ends -->
<!--modal start-->
    <div class="modal fade" id="createScheduleModal" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                            'ng-submit' => 'saveSchedule(search.userName,search.searchPolicyName)',
                            'class' => 'saveSchedule',
                            'csrf' => $data['csrf_token'],
                            'data-parsley-validate' => true,
                            'autocomplete' => 'off'
                            )); ?>
                            <div class="modal-header">
                                <h4 class="modal-title"><?=Language::show('Schedule Settings', 'keywords')?></h4>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                            <p>
                                                Any saved schedules will need at least 5 minutes to take effect
                                            </p>
                                        </div>
                                    </div>
                                </div>
<!--start-->
<div class="col-lg-12 row" style="margin-bottom:10px;">
<div class="col-lg-12 row displayinfo" style="display:none;" ng-show="displayinfo == 'yes'">
<div class="form-group col-lg-6" style="border: 1px solid grey;border-radius:5px;">
<span>User Name : </span><span id="displayusername"></span><br>
<span>Device Name : </span><span id="displaydevicename"></span>
</div>
</div>
<div class="col-lg-6">
<div class="optionss">
    <label class="radio-inline">
      <input type="radio" name="userOption1" value="policy" checked>Policy Name
	    </label>
    <label class="radio-inline">
      <input type="radio" name="userOption1" value="userNdDevice">User Id and Device name
    </label>
</div>
<br>

                                    <div class="col-lg-12" id="userNdDevice1" style="display: none;">
                                        <div class="col-lg-6">
                                            <label for="searchUsername1">User Id</label>
                                            <select name="searchUsername1"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsername1"
                                                    id="searchUsername1"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceName1" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceName1 form-control" id="searchDeviceName1" readonly>
                                                <!--<option value="all">all</option>-->
                                            </select>
                                        </div>
                                    </div>

                                        <div class="col-lg-12" id="policy1">
                                        <label for='searchPolicyName'>Policy Name</label>
                                        <select class="form-control selectPicker" name="searchPolicyName[]" id="searchPolicyName1" title='Select Backup Policy Name' multiple data-selected-text-format="count>4">
						<option value="all">all</option>
                                                            <?php if(!empty($data['backupPolicies'])){ ?>
                                                                <?php foreach($data['backupPolicies'] as $value){
                                                                $label = $value;
                                                                if( strlen( $value ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                    <option value="<?=$value?>"><?=$label?></option>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        </select>
                                        </div>
                                        </div><br>
                                        <div class="col-lg-6">
                                            <input class="isUserWithoutDeviceEnabled" id="isUserWithoutDeviceEnabled1" type="checkbox" name="isUserWithoutDeviceEnabled">
                                            <label for="isUserWithoutDeviceEnabled">Include Users without a device installed</label><br>

                                            <input class="showBlockedUsers" id="showBlockedUsers1" type="checkbox" name="showBlockedUsers" checked>
                                            <label for="showBlockedUsers">Include blocked users</label><br>

                                            <input class="showBlockedDevices" id="showBlockedDevices1" type="checkbox" name="showBlockedDevices" checked>
                                            <label for="showBlockedDevices">Include blocked devices</label>
                                         </div>
</div>
<!--end-->
<br>
                                <div class="row">
				    <div class="form-group col-lg-12 hide">
                                        <label for="createdBy"><?=Language::show('createdBy', 'keywords')?></label>
                                            <input type="text" class="form-control" name="createdBy" id="createdBy" placeholder="" autocomplete="off">
				    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords')?></label>
					    <input type="text" class="form-control" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@', '_' and '.' Any other special characters are not allowed.">
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <label for="scheduleType">Schedule Type :</label>
                                        <select class="form-control" name="scheduleType" id="scheduleType">
                                            <option value="choiceDays"><?=Language::show('Days', 'settings')?></option>
                                            <option value="choiceMonths"><?=Language::show('Months', 'settings')?></option>
                                            <option value="choiceTime"><?=Language::show('Run Once', 'settings')?></option>
                                        </select>
                                    </div>
                                    <br>
                                    <div class="form-group col-lg-12 choiceDays">
                                        <label  class="col-lg-12"><?=Language::show('days', 'keywords');?> -
                                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Every Day</a>
                                        <select class="form-control selectPickerSchedule" name="days[]" id="days" required="" multiple title='Select days'>
                                            <option value="SUN"><?=Language::show('sunday', 'keywords')?></option>
                                            <option value="MON"><?=Language::show('monday', 'keywords')?></option>
                                            <option value="TUE"><?=Language::show('tuesday', 'keywords')?></option>
                                            <option value="WED"><?=Language::show('wednesday', 'keywords')?></option>
                                            <option value="THU"><?=Language::show('thursday', 'keywords')?></option>
                                            <option value="FRI"><?=Language::show('friday', 'keywords')?></option>
                                            <option value="SAT"><?=Language::show('saturday', 'keywords')?></option>
                                        </select>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceMonths" style="display:none;">
                                        <label class="col-lg-12"><?=Language::show('Month', 'keywords');?> -
                                        <a href="javascript:;" class="monthDaily" ng-click="toggleSelectPickerAllMonths()">Every Month</a>
                                        <div class="col-lg-12">
                                            <div class="col-lg-6 form-group">
                                                <input type="number" min='1' max="31" class="form-control" name="dayOfMonth" id="dayOfMonth" placeholder="Enter Day of Month" disabled="disabled">
						    </div>
                                            <div class="col-lg-6 form-group">
                                                <select class="form-control selectPickerScheduleMonth" name="months[]" id="months" multiple title='Select months'>
                                                    <option value="JAN"><?=Language::show('January', 'keywords')?></option>
                                                    <option value="FEB"><?=Language::show('February', 'keywords')?></option>
                                                    <option value="MAR"><?=Language::show('March', 'keywords')?></option>
                                                    <option value="APR"><?=Language::show('April', 'keywords')?></option>
                                                    <option value="MAY"><?=Language::show('May', 'keywords')?></option>
                                                    <option value="JUN"><?=Language::show('June', 'keywords')?></option>
                                                    <option value="JUL"><?=Language::show('July', 'keywords')?></option>
                                                    <option value="AUG"><?=Language::show('August', 'keywords')?></option>
                                                    <option value="SEP"><?=Language::show('September', 'keywords')?></option>
                                                    <option value="OCT"><?=Language::show('October', 'keywords')?></option>
                                                    <option value="NOV"><?=Language::show('November', 'keywords')?></option>
                                                    <option value="DEC"><?=Language::show('December', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-12 choiceTime" style="display:none;">
                                        <label class="col-lg-8"><?=Language::show('Run once', 'keywords');?>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="The schedule will be honored in the time zone under which the Parablu endpoint agent is operating."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                            <input type="text" class="form-control col-lg-4" name="date" id="date" placeholder="Enter Date" disabled="disabled">
                                        </label>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="scheduleStartTime"><?=Language::show('Schedule Time', 'keywords')?></label>
					    <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime" required>
                                    </div>
                                    <span class="hide ownerFor" id="ownerFor"></span>
                                </div>
                                <div class="row usersFound" id="usersFound" style="display: none;">
                                    <div class="table-responsive col-lg-4 usersTable">
                                        <table class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" class="select-all checkbox hide" name="select-all"/>
                                                </th>
                                                <th class="text-center clickAble" ng-click="currentBackupSortType = 'userName'; sortReverse = !sortReverse">
                                                    <?=Language::show('Administrators', 'keywords')?>
                                                    <span ng-show="currentBackupSortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                                    <span ng-show="currentBackupSortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
						<tr>
                                                    <td class="text-center">
                                                        <input type="checkbox" class="select-item checkbox" name="allAdmins" id="allAdmins" value="All admins" ng-checked="value.allAdmins == 'true'"/>
                                                    </td>
                                                    <td class="text-left" title="All admins" ng-cloak>All admins</td>
                                                </tr>
                                                <tr ng-repeat="value in users">
                                                    <td class="text-center">
                                                    	<input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.emailId }}" ng-click="itemSelect(value.emailId)" ng-checked="value.isCheck == 'yes'"/>
                                                    </td>
                                                    <td class="text-left emailId-item" title="{{ value.emailId }}" ng-cloak>{{ value.emailId | limitTo:20}}{{value.emailId.length > 20 ? '...' : ''}}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group row">
                                            <label for="selectedUsers"><?=Language::show('Email reports to', 'keywords');?></label><br/>
                                            <input type="text" data-role="tagsinput" value="" class="form-control selectedUsers" name="selectedUsers[]" id="selectedUsers" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Selected Users', 'keywords');?>" required autocomplete="off">
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success createScheduleBtn"><?=Language::show('Save', 'keywords')?></button>
                                <button type="button" id="closeScheduleModal" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
                            </div>
                <?= Form::close(); ?>
                 </div>
        </div>
    </div>
<!--modal ends -->
<!--confirm modal start-->
<div class="modal fade confirmChange" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirm Change</h4>
				</div>
                        <div class="modal-body">

                            <h4 class="modal-title">The username and device name you’ve picked will over-write the username and device name previously selected for this schedule.  Are you sure you wish to proceed?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="confirmChange()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm modal ends-->
<!--confirm modal start-->
<div class="modal fade confirmdelete" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirm Delete</h4>
                        </div>
                        <div class="modal-body">
                                <h4 class="modal-title">Are you sure you want to delete the selected schedule?</h4>

                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-default" ng-click="deleteSchedule()">Ok</button>
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm modal ends-->
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchUsername').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDevice",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select user'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
	document.getElementById("displayusername").innerHTML = $('#searchUsername1').val();
        if(users.devices != undefined) {
            if (users.devices.length > 0){
                $('.searchDeviceName').removeAttr("readonly", "readonly");
                var options = "";
                users.devices.forEach(function (device) {
                    options += '<option value="' + device + '">' + device + '</option>'
                });
                $('.searchDeviceName').html(options);
                $('.searchDeviceName').prepend('<option value="all" selected>all</option>');
            }else {
                $('.searchDeviceName').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }else{
            if(users.text == "all"){
                $('.searchDeviceName').html("<option selected>all</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }
        return users.text;
    }
	
    $('.searchUsername1').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDevice",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                    $('#searchUsername1').empty().trigger("change");
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResult1,
        templateSelection: selectTemplateSelection1,
        placeholder: 'Select user'
        });

    function selectTemplateResult1(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection1(users){
	$("#searchDeviceName1").empty();
        if(users.devices != undefined) {
                if (users.devices.length > 0){
                $('#searchDeviceName1').removeAttr("readonly", "readonly");
                var options = "";
                users.devices.forEach(function (device) {
                    options += '<option value="' + device + '">' + device + '</option>'
                });
                $('#searchDeviceName1').html(options);
                $('#searchDeviceName1').prepend('<option value="all" selected>all</option>');
            }else {
                $('#searchDeviceName1').html("<option value='all' selected>User has no devices configured</option>");
                $('#searchDeviceName1').attr("readonly", "readonly");
            }
        }else{
                if(users.text == "all"){
                $('#searchDeviceName1').html("<option selected>all</option>");
                $('#searchDeviceName1').attr("readonly", "readonly");
            }
        }
        return users.text;
    }
    
    $("input:radio").change(function () {
        var val = $('input[name=userOption]:checked').val();
        var policyBlock = document.getElementById("policy");
        var userNdDeviceBlock = document.getElementById("userNdDevice");
        if (val == 'policy') {
            policyBlock.style.display = "block";
            userNdDeviceBlock.style.display = "none";
        } else {
            $('#searchPolicyName').selectpicker('render');
            $('#searchPolicyName option:selected').removeAttr('selected');
            $('#searchPolicyName').find('option[value="all"]').attr("selected",true);
            policyBlock.style.display = "none";
            userNdDeviceBlock.style.display = "block";
        }
        });
	
    $("input:radio[name='userOption1']").change(function () {
            var val = $('input[name=userOption1]:checked').val();
            console.log("val : "+val);
        var policyBlock = document.getElementById("policy1");
        var userNdDeviceBlock = document.getElementById("userNdDevice1");
        if (val == 'policy') {
            policyBlock.style.display = "block";
            userNdDeviceBlock.style.display = "none";
            $('.displayinfo').hide();
        } else {
            $('#searchPolicyName').selectpicker('render');
            $('#searchPolicyName option:selected').removeAttr('selected');
            $('#searchPolicyName').find('option[value="all"]').attr("selected",true);
            policyBlock.style.display = "none";
            userNdDeviceBlock.style.display = "block";
            $('.displayinfo').show();
        }
    });
	
    $("#searchDeviceName1").change(function () {
            console.log("inside change"+$('#searchDeviceName1').val());
            if($('#displaydevicename').html() != '' && $('#displaydevicename').html() != $('#searchDeviceName1').val()){
                    console.log("got different name");
                    $('.confirmChange').modal('show');
            }else{
            document.getElementById("displayusername").innerHTML = $('#searchUsername1').val();
document.getElementById("displaydevicename").innerHTML = $('#searchDeviceName1').val();
            }
/*          var user = $('#searchUsername1').val();
            var device = $('#searchDeviceName1').val();
            document.getElementById("displayusername").innerHTML = user;
            document.getElementById("displaydevicename").innerHTML = device;*/

    });
</script>
<script>
$('.timePicker').timepicker({
        showMeridian: false,
//        defaultTime: '9:45'
    });
    $('.selectPickerSchedule').selectpicker('render');
    $('.selectPickerScheduleMonth').selectpicker('render');
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});

var currentDate = new Date();
    //$('#date').datepicker('update', currentDate);
    
$('#scheduleType').on('change', function(){
    var choice = $('#scheduleType').val();
    if(choice == 'choiceDays'){
        $('.choiceDays').show();
        $('.choiceMonths').hide();
        $('.choiceTime').hide();
        $('#days').attr('required', 'required');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').prop('disabled', false);
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    } else if(choice == 'choiceTime') {
        $('.choiceTime').show();
        $('.choiceDays').hide();
        $('.choiceMonths').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('.selectPickerScheduleMonth').selectpicker('val', '');
        $('#date').removeAttr('disabled');
        $('#days').removeAttr('required');
        $('#date').datepicker('update', currentDate);
        $('#days').prop('disabled', 'disabled');
        $('#months').removeAttr('required');
        document.getElementById("months").disabled=true;
        $('#dayOfMonth').attr('disabled', true);
        $('#dayOfMonth').removeAttr('required');
    }else {
        $('.choiceMonths').show();
        $('.choiceDays').hide();
        $('.choiceTime').hide();
        $('.selectPickerSchedule').selectpicker('val', '');
        $('#date').datepicker('update', '');
        $('#date').attr('disabled', true);
        $('#days').removeAttr('required');
        $('#days').prop('disabled', 'disabled');
        document.getElementById("months").disabled=false;
        $('#months').attr('required','required');
        $('#dayOfMonth').removeAttr('disabled');
        $('#dayOfMonth').attr('required','required');
    }
});
$('#date').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-0m',
        //endDate: '-0d',
        todayHighlight: true
    });
    $(function(){

        //button select all or cancel
        $("#select-all").click(function () {
            var all = $("input.select-all")[0];
            all.checked = !all.checked;
            var checked = all.checked;
            $("input.select-item").each(function (index,item) {
                item.checked = checked;
            });
        });

        //button select invert
        $("#select-invert").click(function () {
            $("input.select-item").each(function (index,item) {
                item.checked = !item.checked;
            });
            checkSelected();
        });

        //button get selected info
        $("#selected").click(function () {
            var items=[];
            $("input.select-item:checked:checked").each(function (index,item) {
                items[index] = item.value;
            });
            if (items.length < 1) {
                //document.getElementById("selected_users").innerHTML = "";
            }else {
                var values = items.join();
                console.log("items"+items);
                console.log(values);
                //var html = $("<div></div>");
                //document.getElementById("selected_users").innerHTML = arr;
                //html.html("selected:"+values);
                //html.appendTo("body");
            }
        });

        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            console.log("chhhhh");
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
            console.log("all clicked");
            var usersSelected;
            var arr = $('input.select-item:checkbox:checked').map(function () {
                return this.value;
            }).get();
            usersSelected = arr;
                    $('.selectedUsers').tagsinput('removeAll');
            $('.selectedUsers').tagsinput('add', usersSelected.join());
        });
        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            console.log(checked);
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        }


    });
    
    $("#closeScheduleModal").click(function() {
        $('#createScheduleModal').modal('hide');        
    });
	
    (function(){
        $("#closeScheduleModal").on("hidden.bs.modal", function(){
            $(this).removeData();
        });
    });

    </script>
<style>
.modal {
  overflow-y:auto;
}
</style>
