<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='oneDrivePolicy'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <?php if(create == false){ ?>
                     <h4><?=$data['crumb1']?><?php if($data['deactivateEdit'] != true){ ?><span class="pull-right tooltip-wrapper disabled" data-title="Create New Backup Policy is disabled in Lite Version"><a class="btn btn-success btn-small" disabled href="<?=Url::basePath('pms/policy/create')?>"><?=Language::show('create_new_policy', 'keywords');?></a></span><?php } ?></h4>
                     <?php } else {?>
                     <h4><?=$data['crumb1']?><?php if($data['deactivateEdit'] != true){ ?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/oneDrivePolicy/create')?>"><?=Language::show('create_new_policy', 'keywords');?></a></span><?php } ?></h4>
                     <?php } ?>
                </div>
                <div class="panel-body">
                    <div class="bs-example policyTable" style="display: none;" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th class="text-left clickAble" ng-click="sortType = 'policygroupName'; sortReverse = !sortReverse">
                                        <?=Language::show('policyName', 'keywords')?>
                                        <span ng-show="sortType == 'policygroupName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'policygroupName' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'maxVersionsForSort'; sortReverse = !sortReverse">
                                        <?=Language::show('maxVersions', 'keywords')?>
                                        <span ng-show="sortType == 'maxVersionsForSort' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'maxVersionsForSort' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <!--<th class="text-left clickAble" ng-click="sortType = 'scheduleNamesForSorting'; sortReverse = !sortReverse">
                                        <?=Language::show('scheduleNames', 'keywords')?>
                                        <span ng-show="sortType == 'scheduleNamesForSorting' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'scheduleNamesForSorting' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                        <th class="text-left clickAble" ng-click="sortType = 'filterInclusionName'; sortReverse = !sortReverse">
                                        <?=Language::show('Filter Name', 'keywords')?>
                                        <span ng-show="sortType == 'filterInclusionName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'filterInclusionName' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>-->
                                        <th class="text-left clickAble" ng-click="sortType = 'mappedUserCount'; sortReverse = !sortReverse">
                                        <?=Language::show('Users Mapped to Policy', 'keywords')?>
                                        <span ng-show="sortType == 'mappedUserCount' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'mappedUserCount' && sortReverse" class="fa fa-caret-down"></span>
                                        </th>
                                       <th class="text-left"><?=Language::show('action', 'keywords')?></th>
				                    </tr>
                                </thead>
                                <tbody>
				                    <tr ng-repeat="value in policies | orderBy:sortType:sortReverse">
                                        <td title="{{ value.policygroupName}}" ng-cloak>{{ value.policygroupName | limitTo:25}}{{value.policygroupName.length > 25 ? '...' : ''}}</td>
                                        <td ng-cloak ng-if="value.maxVersions > 0">{{ value.maxVersions }}</td>
                                        <td ng-cloak ng-if="value.maxVersions < 0">UNLIMITED</td>
                                        <!--<td  ng-cloak>{{ value.scheduleNames.join(', ') }}</td>
                                        <td  ng-cloak>{{ value.filterInclusionName.join(', ') }}</td>-->
                                        <td  ng-cloak>{{ value.mappedUserCount }}</td>
                                        <td>
                                           <?php if($data['V']  == true){ ?>
                                                <a title="View" href="" class="toolTip" data-toggle="tooltip" data-placement="top" ng-click="viewOneDrivePolicy(value.policygroupName)" style="margin:5px;"><i class="fa fa-eye"></i> </a>
                                            <?php } ?>    
                                            <?php if($data['ECD'] == true){ ?>
                                                <a title="Edit" class="toolTip" data-toggle="tooltip" data-placement="top" href="<?=Url::basePath('pms/oneDrivePolicy/edit/{{value.policygroupName}}')?>" style="margin:5px;"><i class="fa fa-edit"></i> </a>
                                                <a title="Clone" class="toolTip" data-toggle="tooltip" data-placement="top" href="<?=Url::basePath('pms/oneDrivePolicy/clone/{{value.policygroupName}}')?>"><i class="fa fa-copy" style="margin:5px;"></i> </a>
                                                <a title="Block" class="toolTip" data-toggle="tooltip" data-placement="top" ng-bootbox-confirm="<h4>Are you sure you want to block the selected policy?</h4>" ng-bootbox-confirm-action="blockOdbPolicy(value.policygroupName, 'true')" ng-bootbox-confirm-action-cancel="" style="margin:5px;"><i class="fa fa-ban"></i> </a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
		    <div class="row policyTable" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="getPolicesOfficeNavigate(first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="getPolicesOfficeNavigate(previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="getPolicesOfficeNavigate(next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="getPolicesOfficeNavigate(last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <div class="policyTableEmpty" style="display: none;">
                        <h2 class="-align-center"><?=Language::show('noPolicy', 'pms')?></h2>
                    </div>
                </div>
            </div>
        </div>
    
    <div class="modal fade viewPolicy">
            <div class="modal-dialog">
                <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">View Policy</h4>
                    </div>
                    <div class="modal-body">
                        <!-- start -->
                        <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                    <span class="hide currentPage"><?='viewPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <div class="row">
                        <div class="col-lg-7">
                            
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policygroupName" id="policygroupName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off" readonly>
                                </br>
                                <label for="description"><?=Language::show('Description', 'keywords');?></label>
                                <textarea style="width:100%" class="description" name="description" id="description" placeholder="Enter your policy description" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="512" readonly></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="active" style="display:unset !important;"><a data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#emailAlertConfigurations" aria-expanded="false" aria-controls="emailAlertConfigurations">Email Alert Configurations</a></li>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#uISettingsForAgent" aria-expanded="false" aria-controls="uISettingsForAgent">User action preferences</a></li>
			<?php if($data['searchEnabled'] == true){?>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#search" aria-expanded="false" aria-controls="advanced">Search</a></li>
			<?php } ?>
                      <li style="display:unset !important;"><a data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="active"><a data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a data-target="#emailAlertConfigurations" aria-controls="advanced" role="tab" data-toggle="tab">Email Alert Configurations</a></li>
                        <!--<li class="shareDetailsTab" role="presentation"><a data-target="#shareDetails" aria-controls="advanced" role="tab" data-toggle="tab">Secure Sharing</a></li>-->
                        <li role="presentation"><a data-target="#uISettingsForAgent" aria-controls="advanced" role="tab" data-toggle="tab">User action preferences</a></li>
			<?php if($data['searchEnabled'] == true){?>
                        <li role="presentation"><a data-target="#search" aria-controls="advanced" role="tab" data-toggle="tab">Search</a></li>
			<?php } ?>
                        <li role="presentation"><a data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
                    <?php } ?>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
		    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;margin-top:5px;">
		      <?php if($data['onedriveBackupEnabled'] == 'true'){?>
                      	<li <?php if($data['onedriveBackupEnabled'] == 'true'){?>class="active" <?php } ?> style="display:unset !important;"><a data-toggle="tab" data-target="#oneDriveForBackup" aria-expanded="true" aria-controls="oneDriveForBackup">OneDrive for Business</a></li>
		      <?php } ?>
		      <?php if($data['exchangeBackupEnabled'] == 'true'){?>
                      	<li <?php if($data['onedriveBackupEnabled'] == 'false'){ ?> class="active" <?php } ?> style="display:unset !important;"><a data-toggle="tab" data-target="#microsoftOutlook" aria-expanded="false" aria-controls="microsoftOutlook">Microsoft Exchange</a></li>
		      <?php } ?>                   
                    </ul>
                    <?php } ?>
                    <!-- for mobile end -->
                    <?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-size: small;font-weight: 600;margin-top:5px;">
			<?php if($data['onedriveBackupEnabled'] == 'true'){?>
                        	<li role="presentation" <?php if($data['onedriveBackupEnabled'] == 'true'){?>class="active" <?php } ?>><a data-target="#oneDriveForBackup" aria-controls="oneDriveForBackup" role="tab" data-toggle="tab">OneDrive for Business</a></li>
			<?php } ?>
			<?php if($data['exchangeBackupEnabled'] == 'true'){?>
                        	<li role="presentation" <?php if($data['onedriveBackupEnabled'] == 'false'){ ?> class="active" <?php } ?>><a data-target="#microsoftOutlook" aria-controls="microsoftOutlook" role="tab" data-toggle="tab">Microsoft Exchange</a></li>
			<?php } ?>
                    </ul>
		    <?php } ?>
		    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane <?php if($data['onedriveBackupEnabled'] == 'true'){ echo 'active';}?>" id="oneDriveForBackup">
<!-- start -->
<div class="row">
                                <div class="col-lg-7">
                                    <br/>
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('backup_information', 'keywords')?> - OneDrive for Business Backup</legend>
                                    <div class="form-group">
					<label for="schedules"><?=Language::show('schedules', 'keywords');?></label>
<input type="text" class="form-control" name="schedulesOdb" id="schedulesOdb" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchverOdb" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersionsOdb" id="maxVersionsOdb" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVerOdb()" disabled/>
                                            <span id="vererrorOdb" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
                    <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchsizeOdb" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxPermissibleFileSizeOdb" id="maxPermissibleFileSizeOdb" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionMPSOdb();" disabled/>
                                        <span id="sizeerrorOdb" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>hide<?php } ?>">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
                    <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchlimitOdb" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="perUserBackupStorageLimitOdb" id="perUserBackupStorageLimitOdb" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionUBSOdb();" disabled/>
                                        <span id="limiterrorOdb" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
<div class="form-group col-lg-12" style="padding-left:0%;">
                                        <label for="BlukryptipaddressOdb"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="BlukryptipaddressOdb" id="BlukryptipaddressOdb" readonly/>
                                    </div>
				    <div class="form-group col-lg-12" style="padding-left:0%;">
					<label for="msAppBluKrypt"><?=Language::show('Office 365 Backup Agent', 'keywords');?></label>
<input type="text" class="form-control" name="msAppBluKryptOdb" id="msAppBluKryptOdb" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Office 365 Backup Agent', 'keywords');?>" autocomplete="off" readonly/>
				    </div>
<div style="padding-left:0%;" class="form-group col-lg-12">
                                         <span><p>Purge deleted files from the catalog after</p></span>
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchpurgeDeletedFilesOlderThan" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="purgeDeletedFilesOlderThan" id="purgeDeletedFilesOlderThan"  autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctionpurgeDeletedFilesOlderThan();" disabled/>
                                             <span id="sizepurgeDeletedFilesOlderThan" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
                                         </div>
                                     </div>
                </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="defaultSchedulesOdb.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:45px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedulesOdb">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label class="hide" for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker hide" ng-model="osType" name="osType" id="osType" required="" title='Select OS Type'>
                                            <!--<option value="windows">Windows</option>
                                            <option value="mac">Mac</option>-->
                                            <option value="universal" selected>Universal</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div>
                                                        <ul class="list-group" ng-if="defaultUniversalFoldersOdb.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultUniversalFoldersOdb track by $index" class="list-group-item">{{ value }}</li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFoldersOdb.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div>
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversalOdb.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversalOdb track by $index">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversalOdb.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
			    </div>
<div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="File extensions that you wish to include or exclude" style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <!--<label for="filters"><?=Language::show('filters', 'keywords');?></label><br>-->
					<label for="filters"><?=Language::show('Filter type', 'keywords');?></label>
					<input type="text" class="form-control" name="filtersTypeOdb1" id="filtersTypeOdb1" readonly/></br>
					<h5 class="col-lg-2 inclusionBadgeOdb"><label class="label label-success"><i class="fa fa-plus-circle"></i></label></h5>
                                        <h5 class="col-lg-2 exclusionBadgeOdb" style="display:none;"><label class="label label-danger"><i class="fa fa-minus-circle"></i></label></h5>
					<input type="text" class="col-lg-10" name="filtersOdb" id="filtersOdb" readonly/>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultFilterOdb.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
						    <div class="table-responsive">
<table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilterOdb">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
<!-- end -->
			</div>
			<div role="tabpanel" class="tab-pane <?php if($data['onedriveBackupEnabled'] == 'false'){ echo 'active';}?>" id="microsoftOutlook">
<!-- start -->
<div class="row">
                                <div class="col-lg-7">
                                    <br/>
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('backup_information', 'keywords')?> for Microsoft Exchange</legend>
                                    <div class="form-group">
					<label for="schedules"><?=Language::show('schedules', 'keywords');?></label>
<input type="text" class="form-control" name="schedulesMail" id="schedulesMail" readonly/>
                                    </div>
                                    <div class="form-group hide">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchverMail" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersionsMail" id="maxVersionsMail" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererrorMail" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
                    <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchsizeMail" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxPermissibleFileSizeMail" id="maxPermissibleFileSizeMail" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionMPSMail();" disabled/>
                                        <span id="sizeerrorMail" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>hide<?php } ?>">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
                    <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchlimitMail" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="perUserBackupStorageLimitMail" id="perUserBackupStorageLimitMail" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionUBSMail();" disabled/>
                                        <span id="limiterrorMail" style="color: #f55753;font-size: 0.9em;"></span>
				    </div>
<div class="form-group col-lg-12" style="padding-left:0%;">
                                        <label for="BlukryptipaddressMail"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="BlukryptipaddressMail" id="BlukryptipaddressMail" readonly/>
                                    </div>
				    <div class="form-group col-lg-12" style="padding-left:0%;">
					<label for="msAppBluKrypt"><?=Language::show('Office 365 Backup Agent', 'keywords');?></label>
<input type="text" class="form-control" name="msAppBluKryptMail" id="msAppBluKryptMail" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Office 365 Backup Agent', 'keywords');?>" autocomplete="off" readonly/>
				    </div>
<div style="padding-left:0%;" class="form-group col-lg-12">
                                         <span><p>Purge deleted files from the catalog after</p></span>
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchpurgeDeletedMailsOlderThan" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="purgeDeletedMailsOlderThan" id="purgeDeletedMailsOlderThan"  autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctionpurgeDeletedMailsOlderThan();" disabled/>
                                             <span id="sizepurgeDeletedMailsOlderThan" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
                                         </div>
                                     </div>

<div style="padding-left:0%;" class="form-group col-lg-12">
                                         <span><p>Delete files from the archive after</p></span>
                                         <div class="col-lg-2" style="padding-left:0%;">
                                             <label class="switch">
                                             <input id="switchdeletedMailsOlderThan" type="checkbox">
                                             <div class="slider round"></div>
                                             </label>
                                         </div>
                                         <div class="col-lg-6">
                                             <input type="text" class="form-control" name="deletedMailsOlderThan" id="deletedMailsOlderThan"  autocomptocomplete="off" value="UNLIMITED" onfocusout="myFunctiondeletedMailsOlderThan();" disabled/>
                                             <span id="sizedeletedMailsOlderThan" style="color: #f55753;font-size: 0.9em;"></span>
                                         </div>
                                         <div class="col-lg-2">
                                             days
                                         </div>
                                     </div>
				     <div style="padding-left:0%;" class="form-group col-lg-12 hide">
                                       <label for="isInPlaceMailArchiveEnabled"><?=Language::show('Backup of In-Place Archive emails', 'keywords');?></label>
                                       <select class="form-control isInPlaceMailArchiveEnabled" name="isInPlaceMailArchiveEnabled" id="isInPlaceMailArchiveEnabled" required="" title='Select <?=Language::show('Backup of In-Place Archive emails', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                    </div>
				    <div style="padding-left:0%;" class="form-group col-lg-12 hide">
                                       <label for="isContactsEnabled"><?=Language::show('Backup Contacts', 'keywords');?></label>
                                       <select class="form-control isContactsEnabled" name="isContactsEnabled" id="isContactsEnabled" required="" title='Select <?=Language::show('Backup Contacts', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                    </div>
				    <div style="padding-left:0%;" class="form-group col-lg-12 hide">
                                       <label for="isTasksEnabled"><?=Language::show('Backup Tasks', 'keywords');?></label>
                                       <select class="form-control isTasksEnabled" name="isTasksEnabled" id="isTasksEnabled" required="" title='Select <?=Language::show('Backup Tasks', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                    </div> 
                </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="defaultSchedulesMail.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:45px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedulesMail">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div>
                                                        <ul class="list-group" ng-if="defaultUniversalFoldersMail.length >= 1">
                                                            <li style="word-wrap: break-word" ng-repeat="value in defaultUniversalFoldersMail track by $index" class="list-group-item">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFoldersMail.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div>
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversalMail.length">
                                                            <li style="word-wrap: break-word" class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversalMail track by $index">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversalMail.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
			    </div>
<div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('filters', 'keywords')?> <a href="" data-toggle="tooltip" data-placement="top" title="Emails with these attachments will be either included or excluded from the backup." style="font-size:12px;"><i class="fa fa-question-circle" aria-hidden="true"></i></a></legend>
                                    <div class="form-group">
                                        <!--<label for="filters"><?=Language::show('filters', 'keywords');?></label><br>-->
					<label for="filters"><?=Language::show('Filter type', 'keywords');?></label>
					<input type="text" class="form-control" name="filtersTypeMail1" id="filtersTypeMail1" readonly/></br>
					<h5 class="col-lg-2 inclusionBadgeMail"><label class="label label-success"><i class="fa fa-plus-circle"></i></label></h5>
                                        <h5 class="col-lg-2 exclusionBadgeMail" style="display:none;"><label class="label label-danger"><i class="fa fa-minus-circle"></i></label></h5>		
					<input type="text" class="col-lg-10" name="filtersMail" id="filtersMail" readonly/>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultFilterMail.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
						    <div class="table-responsive">
<table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilterMail">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
<!-- end -->
			</div>
</div>
                        <!--new exp end-->
<!--                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?></label>
                                        <input type="text" class="form-control" name="schedules" id="schedules" readonly/>
                                    </div>
                                    <div class="form-group maxVersionsDiv">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                       <input type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                       <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>hide<?php } ?>">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group hide">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <input type="text" class="form-control" name="osType" id="osType" readonly/>
                                    </div>
                                    
                                    <div class="form-group hide">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>

                                    <div class="form-group hide">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="osType != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                    <div  ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                                            <li ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="defaultWinFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                                            <li ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="defaultMacFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div  ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-if="defaultUniversalFolders.length >= 1">
                                                            <li ng-repeat="value in defaultUniversalFolders track by $index" class="list-group-item">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="defaultUniversalFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    </div>
                                                </div>
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Excluded Folders</h5>
                                                </div>
                                                <div class="panel-body" style="overflow-y: scroll;height: 150px;">
                                                    <div class="table-responsive">
                                                    <div ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersWindows.length">
                                                            <li class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersWindows track by $index">{{ value }}</li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersWindows.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersMac.length">
                                                            <li class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersMac track by $index">{{ value }}</li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersMac.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    <div ng-if="osType == 'universal'">
                                                        <ul class="list-group" ng-show="userExcludedFoldersUniversal.length">
                                                            <li class="list-group-item" ng-if="value != '' " ng-repeat="value in userExcludedFoldersUniversal track by $index">{{ value }}</li>
                                                        </ul>
                                                        <span ng-if="userExcludedFoldersUniversal.length <= 0">These folders will be excluded</span>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filters" id="filters" readonly/>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFilters" ng-if="defaultFilter.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters</h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>-->
                        </div>
                        <div role="tabpanel" class="tab-pane" id="emailAlertConfigurations">
                            <br>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Email Alert Configurations', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                    <select class="form-control userCreateAdmins" name="createUser[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userCreateReadonlyadmins" name="createUser[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Created', 'keywords');?></label>
                                        <select class="form-control userCreateUsers" name="createUser[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userDeletedAdmins" name="userDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userDeletedReadonlyadmins" name="userDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Deleted', 'keywords');?></label>
                                        <select class="form-control userDeletedUsers" name="userDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-6 hide">
                                    <div class="form-group">                                  
                                        <select class="form-control userBlockedAdmins" name="userBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>   
                                    </div>                                 
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userBlockedReadonlyadmins" name="userBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Blocked', 'keywords');?></label>
                                        <select class="form-control userBlockedUsers" name="userBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedAdmins" name="userLimitReached[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control userLimitReachedReadonlyadmins" name="userLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('User Limit Reached', 'keywords');?></label>
                                        <select class="form-control userLimitReachedUsers" name="userLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedAdmins" name="deviceDeleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control deviceDeletedReadonlyadmins" name="deviceDeleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Deleted', 'keywords');?></label>
                                        <select class="form-control deviceDeletedUsers" name="deviceDeleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">                             
                                        <select class="form-control deviceBlockedAdmins" name="deviceBlocked[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control deviceBlockedReadonlyadmins" name="deviceBlocked[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Blocked', 'keywords');?></label>
                                        <select class="form-control deviceBlockedUsers" name="deviceBlocked[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">                                  
                                        <select class="form-control deviceDecoupledAdmins" name="deviceDecoupled[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control deviceDecoupledReadonlyadmins" name="deviceDecoupled[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <label><?=Language::show('Device de-couple', 'keywords');?></label>
                                        <select class="form-control deviceDecoupledUsers" name="deviceDecoupled[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                    <select class="form-control deviceLimitReachedAdmins" name="deviceLimitReached[]">
                                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                                        </select>
                                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control deviceLimitReachedReadonlyadmins" name="deviceLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <label><?=Language::show('Device Limit Reached', 'keywords');?></label>
                                        <select class="form-control deviceLimitReachedUsers" name="deviceLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">                                  
                                        <select class="form-control weeklyBackupReportAdmins" name="weeklyBkpreport[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control weeklyBackupReportReadonlyadmins" name="weeklyBkpreport[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Weekly backup report', 'keywords');?></label>
                                        <select class="form-control weeklyBackupReportUsers" name="weeklyBkpreport[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group"> 
                                        <select class="form-control firstBackupCompletedAdmins" name="firstBkpCompleted[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control firstBackupCompletedReadonlyadmins" name="firstBkpCompleted[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('First backup completed', 'keywords');?></label>
                                        <select class="form-control firstBackupCompletedUsers" name="firstBkpCompleted[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">                                  
                                        <select class="form-control restoreInitiatedAdmins" name="restoreInitiated[]">
                                            <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control restoreInitiatedReadonlyadmins" name="restoreInitiated[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Restore initiated', 'keywords');?></label>
                                        <select class="form-control restoreInitiatedUsers" name="restoreInitiated[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                    <select class="form-control storageLimitReachedAdmins" name="storageLimitReached[]">
                                        <option value="admins" selected><?=Language::show('enabled', 'keywords')?></option>
                                        <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 hide">
                                    <div class="form-group">
                                        <select class="form-control storageLimitReachedReadonlyadmins" name="storageLimitReached[]">
                                            <option value="readonlyadmins" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value=""><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label><?=Language::show('Storage limit reached', 'keywords');?></label>
                                        <select class="form-control storageLimitReachedUsers" name="storageLimitReached[]">
                                            <option value="users"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="uISettingsForAgent">
                            <br>
                            <div class="row hide">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Agent  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="#" data-toggle="tooltip" data-placement="top" title="Changes will reflect on next relaunch of agent"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
				    <span class="help-line text-muted">Note:- These settings will have no effect for Exchange Online backup data.</span>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <select class="form-control bkpfiles" name="bkpfiles" id="bkpfiles" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <select class="form-control bkpsettings" name="bkpsettings" id="bkpsettings" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <select class="form-control support" name="support" id="support" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>                                    
                                    <?php if(DISABLE_BLOCK_NOTIFICATIONS==false){?>
                                    <div class="form-group">
                                        <label for="blockNotifications"><?=Language::show('BLOCK_NOTIFICATIONS', 'keywords');?></label>
                                        <select class="form-control blockNotifications" name="blockNotifications" id="blockNotifications" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                   <?php }?>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <select class="form-control restore" name="restore" id="restore" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <select class="form-control refbkppolicy" name="refbkppolicy" id="refbkppolicy" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                       <label for="updateAgent"><?=Language::show('UPDATE_AGENT', 'keywords');?></label>
                                        <select class="form-control updateAgent" name="updateAgent" id="updateAgent" required="" title='Select <?=Language::show('updateAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('EXIT', 'keywords');?></label>
                                        <select class="form-control exitt" name="exitt" id="exitt" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                <legend class="h4" style="color: #585f69;"><?=Language::show('Portal', 'keywords')?></legend>
                                    <div class="col-lg-6">
                                        <div class="form-group Open">
                                            <label for="Open"><?=Language::show('Open', 'keywords');?></label>
                                            <select class="form-control Open" name="Open" id="Open" required="" title='Select <?=Language::show('Open', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group Versions">
                                            <label for="Versions"><?=Language::show('Versions', 'keywords');?></label>
                                            <select class="form-control Versions" name="Versions" id="Versions" required="" title='Select <?=Language::show('Versions', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>  
                                        <div class="form-group Download">
                                            <label for="Download"><?=Language::show('Download', 'keywords');?></label>
                                            <select class="form-control Download" name="Download" id="Download" required="" title='Select <?=Language::show('Download', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>					
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group View">
                                            <label for="View"><?=Language::show('View', 'keywords');?></label>
                                            <select class="form-control View" name="View" id="View" required="" title='Select <?=Language::show('View', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group Share">
                                            <label for="Share"><?=Language::show('Share', 'keywords');?></label>
                                            <select class="form-control Share" name="Share" id="Share" required="" title='Select <?=Language::show('Share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
					<div class="form-group portalRestore">
                                            <label for="portalRestore"><?=Language::show('Restore', 'keywords');?></label>
                                            <select class="form-control portalRestore" name="portalRestore" id="portalRestore" required="" title='Select <?=Language::show('Restore', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row shareDetailsLabel">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>-->
                                    <div class="form-group highSecureShareEnabled">
                                        <label for="highSecureShareEnabled"><?=Language::show('highSecureShareEnabled', 'keywords');?></label>
                                        <select class="form-control highSecureShareEnabled" name="highSecureShareEnabled" id="highSecureShareEnabled" required="" title='Select <?=Language::show('highSecureShareEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="row highSecuredShareOptions">
                                        <div class="col-lg-1" style="margin-top: 35px;<?php if(!isMobile()){ ?>text-align: center;<?php }else { ?> text-align: left;<?php } ?>"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group complexPasswordRequired">
                                                <label for="complexPasswordRequired"><?=Language::show('complexPasswordRequired', 'keywords');?></label>
                                                <select class="form-control complexPasswordRequired" name="complexPasswordRequired" id="complexPasswordRequired" required="" title='Select <?=Language::show('complexPasswordRequired', 'keywords')?>'>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-1" style="margin-top: 35px;<?php if(!isMobile()){ ?>text-align: center;<?php }else { ?> text-align: left;<?php } ?>"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group preventDownloadEnabled">
                                                <label for="preventDownloadEnabled"><?=Language::show('preventDownloadEnabled', 'keywords');?></label>
                                                <select class="form-control preventDownloadEnabled" name="preventDownloadEnabled" id="preventDownloadEnabled" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                                    <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-1" style="margin-top: 35px;<?php if(!isMobile()){ ?>text-align: center;<?php }else { ?> text-align: left;<?php } ?>"><i class="fa fa-caret-square-o-right"></i></div>
                                        <div class="col-lg-11">
                                            <div class="form-group expiredDate">
                                                <label for="expiredDate"><?=Language::show('expiredDate', 'keywords');?></label>
                                                <select class="form-control expiredDate" name="expiredDate" id="expiredDate" required="" title='Select <?=Language::show('expiredDate', 'keywords')?>'>
                                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="search">
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Search  ', 'keywords')?>
                                    <a style="font-size:14px !important;" href="" data-toggle="tooltip" data-placement="top" title="Related to search."><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    </legend>
                                    <div class="col-lg-6">
                                        <div class="form-group contentIndexEnabled" <?php if($data['searchEnabled'] == false){?> style="pointer-events:none;"<?php } ?>>
                                            <label for="contentIndexEnabled"><?=Language::show('Content Index Enabled', 'keywords');?></label>
                                            <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('Content Index Enabled', 'keywords')?>' <?php if($data['searchEnabled'] == false){?> readonly <?php } ?>>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Content Index Filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble hide" ng-click="addNewFilter()" style="font-size: small;font-weight: 600;">Create New Filter</a></label>
                                        <label for="filters"><?=Language::show('Filter type', 'keywords');?></a></label><br>
					<input type="text" class="form-control" name="searchfiltersType" id="searchfiltersType" readonly/>
					<input type="text" class="form-control" name="searchFilterInclusionName" id="searchFilterInclusionName" readonly/>
                                        <!--<select class="form-control selectSearchFilterTypePicker" id="searchfiltersType" title='Select Filter Type'>
                                            <option value="inclusion">Inclusion</option>
                                            <option value="exclusion">Exclusion</option>
                                        </select>
                                            <select class="form-control selectSearchFilterPicker incSearch" name="searchfilters[]" id="searchfilters" title='Select Filters' multiple>
                                            <?php if(!empty($data['IncFilters'])){ ?>
                                                <?php foreach($data['IncFilters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                            </select>
                                            <select class="form-control selectSearchFilterPicker excSearch" name="searchfilters[]" id="searchfilters1" title='Select Filters' multiple>
                                           <?php if(!empty($data['ExcFilters'])){ ?>
                                                <?php foreach($data['ExcFilters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>-->
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultSearchFilter.length >= 1">
                                    <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Filters </h5>
                                                </div>
                                                <div class="panel-body" style="word-break:break-all;">
                                                    <div class="table-responsive">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSearchFilter">
                                                            <td style="white-space:unset !important;">
                                                                <p><b>{{ value.filterName }} :</b></p>
                                                                <span style="word-break:break-all;">{{value.filters}}</span>
                                                            </td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            <div class="row hide">
                                <div class="col-lg-7">
                                    <legend class="h4 hide" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group partial hide">
                                        <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <!--<div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromClientToPG }}" onfocusout="myFunction();" disabled/>
                                        <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>-->
				                    <div class="form-group">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                            <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In Mbps)</label>
                                            <div class="col-lg-8">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                              <div class="col-lg-6">
                                              <input type="text" class="form-control" name="nwFromClientToPGMB" id="nwFromClientToPGMB" placeholder="" required autocomplete="off" value="UNLIMITED" data-parsley-min="1" data-parsley-max="1024" onfocusout="myFunctionMB();" disabled/>
                                              <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                              </div>
                                              <div class="col-lg-6">
                                                <select class="form-control" name="networkThrottlingUnit" id="networkThrottlingUnit" required="" title='Select <?=Language::show('networkThrottlingUnit', 'keywords')?>' disabled>
                                                    <option value="kbps"><?=Language::show('kbps', 'keywords')?></option>
                                                    <option value="mbps" selected><?=Language::show('mbps', 'keywords')?></option>
                                                    <option value="gbps"><?=Language::show('gbps', 'keywords')?></option>
                                                </select>
                                              </div>
                                        </fieldset>
                                    </div>

                                    <div class="form-group hide">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.crawlLimit }}" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5 hide">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" data-parsley-type="integer" data-parsley-min="1" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" readonly/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('options', 'keywords')?></legend>
                                    <div class="form-group">
                                        <div class="checkbox check-primary">
                                            <input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                            <span class="systemFolders" style="display: none;">
                                                <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                                <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="webBasedLogin"><?=Language::show('Web Based Login', 'keywords');?></label>
                                        <select class="form-control webBasedLogin" name="webBasedLogin" id="webBasedLogin" required="" title='Select <?=Language::show('Web Based Login', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" <?php if($data['canAdminRestoreAll'] == false){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminRestore"><?=Language::show('Can Administrator Restore User Data', 'keywords');?></label>
                                        <select class="form-control canAdminRestore" name="canAdminRestore" id="canAdminRestore" required="" title='Select <?=Language::show('Can Admin Restore', 'keywords')?>'>
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group" <?php if($data['canAdminDelete'] == false){?> style="pointer-events:none;opacity: 0.4;"<?php } ?>>
                                        <label for="canAdminDelete"><?=Language::show('Can Administrator Delete User Data', 'keywords');?></label>
                                        <select class="form-control canAdminDelete" name="canAdminDelete" id="canAdminDelete" required="" title='Select <?=Language::show('Can Admin Delete', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false"><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                        <input type="text" class="form-control" name="dedup" id="dedup" readonly/>
                                    </div>                   
                                    <div class="form-group hide">
                                        <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group vssContainer hide" style="display: none;">
                                        <label for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <select class="form-control vssEnabled" name="vssEnabled" id="vssEnabled" required="" title='Select <?=Language::show('vss', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg hide">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <input type="text" class="form-control" name="searchAlgoForPg" id="searchAlgoForPg" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="1" max="23" required="" readonly>
				    </div>
				    <div class="form-group hide">
                                        <fieldset data-role="controlgroup" data-type="horizontal">
                                        <label class="col-lg-12" for="endpointDomainCheck" style="margin-left:-14px;"><?=Language::show('Endpoint Domain Check', 'keywords');?></label>
                                            <div class="col-lg-8">
                                                <label class="switch">
                                                    <input id="switchAllowedDomains" name="switchAllowedDomains" type="checkbox">
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="allowedDomains" style="margin-left:-14px;"><?=Language::show('Allowed Domains', 'keywords');?></label>
                                                <input type="text" class="form-control" name="allowedDomains" id="allowedDomains" placeholder="" autocomplete="off" value=""  readonly/>
                                                <span id="switcherrorAllowedDomains" style="color: #f55753;font-size: 0.9em;"></span>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="cpuThrottling"><?=Language::show('CPU Throttling', 'keywords');?></label></br>
                                            <div class="""slidecontainer">
                                            <input type="range" min="1" max="10" value="" name="cpuThrottling" class="slidercpu" id="myRange">
                                              <p>Value: <span id="demo"></span></p>
                                            </div>
                                    <div class="form-group hide">
                                       <label for="canBackupHiddenFiles"><?=Language::show('canBackupHiddenFiles', 'keywords');?></label>
                                       <select class="form-control canBackupHiddenFiles" name="canBackupHiddenFiles" id="canBackupHiddenFiles" required="" title='Select <?=Language::show('canBackupHiddenFiles', 'keywords')?>'>
                                           <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                   <div style="padding-left:3%;" class="form-group row hide">
                                        <span style="color:#93a3b5;"><p>Fairness Algorithm</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="switchFairnessAlgorithm" type="checkbox">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input type="number" class="form-control" min="0" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup"  autocomptocomplete="off" value="0" disabled/>
                                            <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                   <div class="form-group hide">
                                       <label for="downloadAgent"><?=Language::show('downloadAgent', 'keywords');?></label>
                                       <select class="form-control downloadAgent" name="downloadAgent" id="downloadAgent" required="" title='Select <?=Language::show('downloadAgent', 'keywords')?>'>
                                           <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                           <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                       </select>
                                   </div>
                                    <div class="form-group hide">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row hide">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Password Enforcement', 'keywords')?></legend>
                                    <?php if($data["passwordChangeEnforce"] == true){?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePasswordNE" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>

                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPasswordNE" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } else {?>
                                    <div class="form-group">
                                        <label for="canUserChangePassword"><?=Language::show('Can User Change Password', 'keywords');?></label>
                                        <select class="form-control canUserChangePassword" name="canUserChangePassword" id="canUserChangePassword" required="" title='Select <?=Language::show('Can User Change Password', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="canAdminChangeUserPassword"><?=Language::show('Can Admin Change User Password', 'keywords');?></label>
                                        <select class="form-control canAdminChangeUserPassword" name="canAdminChangeUserPassword" id="canAdminChangeUserPassword" required="" title='Select <?=Language::show('Allow Admin To Change User Password', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                <?php } ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                        <!-- end -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('close', 'keywords')?></button>
                    </div>
                </div>
            </div>
        </div>
    
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
$('.filterType').selectpicker('render');
		$('.filterTypeMail').selectpicker('render');
$('.selectSearchFilterPicker').selectpicker('render');
$('.selectSchedulePickerOdb').selectpicker('render');
    $('.selectSchedulePickerMail').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
    $(function() {
     $('.tooltip-wrapper').tooltip({position: "bottom"});
 });

    $( document ).ready(function() {
$('tr > ul').addClass('hide');
});

    $(".acc").click(function(){
    $(".aa").toggleClass("hide");
$(".bb").toggleClass("show");
$('.currentBackupText').toggleClass('hide');
});

$(".bb").click(function(){
    $('.currentBackupText').toggleClass('show');
    });
	
$("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});	
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?php echo microtime(); ?>" type="text/javascript"></script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}

.tooltip-wrapper.disabled {
   cursor: not-allowed;
 }
</style>
<style type="text/css">
    .disabled {
    pointer-events:none; //This makes it not clickable
    opacity:0.6;         //This grays it out to look disabled
}
h5{
color:black;
}
</style>
