<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?="Settings"?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='paracloudblukrypt'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <ul class="nav nav-tabs" role="tablist" style="<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>font-weight: 600;">
                    <li role="presentation" class="active"><a data-target="#paracloud" aria-controls="paracloud" role="tab" data-toggle="tab">Paracloud</a></li>
                    <li role="presentation"><a data-target="#blukrypt" aria-controls="blukrypt" role="tab" data-toggle="tab">BluKrypt</a></li>
                </ul>
            <!-- Tab panes -->
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="paracloud">
                        <div class="panel">
                            <div class="panel-heading">
                                <?php if(maxParacloud == false){ ?>
                                <h4><?=Language::show('listOfBluvaults', 'keywords')?><span class="pull-right toolTip" data-toggle="tooltip" data-placement="top" title="This feature is disabled in Lite Version" style="cursor: not-allowed";><a class="btn btn-success btn-small" disabled href="" data-toggle="modal" data-target="#addParacloud" style="font-weight: 600;"><?=Language::show('add_paracloud', 'keywords');?></a></span></h4>
                                <?php } else {?>
                                <h4><?=Language::show('listOfBluvaults', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="" data-toggle="modal" data-target="#addParacloud" style="font-weight: 600;"><?=Language::show('add_paracloud', 'keywords');?></a></span></h4>
                                <?php } ?>
                            </div>
                            <div class="panel-body">
                                <div class="row col-lg-12">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Paracloud Host Name</th>
                                                <th><?=Language::show('action', 'keywords')?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="bluvaultListTable">
                                            <tr ng-repeat="value in bluvaults track by $index">
                                                <td><span ng-cloak>{{ value.bluVaultName }}</span></td>
                                                <td class="text-left" style="white-space:unset !important;"><a ng-class="{false:'disabled'}[bluvaults.length > 1]"  class="btn btn-danger btn-small"
                                                    ng-bootbox-confirm="<div><h4 class='modal-title' id='myModalLabel'>Confirm Delete Paracloud</h4><hr></div><?=Language::show('confirmDelete', 'keywords')?> {{value.bluVaultName}} <?=Language::show('paracloud', 'keywords')?> ?"
                                                    ng-bootbox-confirm-action="removeBluvault(value.id, value.bluVaultName, $index)"
                                                    ng-bootbox-confirm-action-cancel=""
                                                    href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords')?></a>
                                                    <a class="btn btn-default btn-small" ng-click="editBluvault($index)" <?php if(isMobile()){ ?> style="margin-top:5px;" <?php } ?>>Edit</a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="row hide">
                                    <div class="col-lg-12">
                                        <?=
                                            Form::open(array(
                                                'csrf' => $data['csrf_token'],
                                                'class' => 'filterForm',
                                                'autocomplete' => 'off',
                                                'ng-submit' => 'saveBluvault(bluvault)',
                                                'data-parsley-validate' => true
                                            ));
                                        ?>
                                        <div class="form-group">
                                            <label for="bluvault"><?=Language::show('paracloudIPs', 'keywords');?></label>
                                            <input type="text" class="form-control" name="bluvaultadd" id="bluvaultadd" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('bluvault', 'keywords');?>" required autocomplete="off" autofocus>
                                        </div>
                                        <button type="submit" class="submitBluvault btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                                        <?=
                                            Form::close();
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="blukrypt">
                        <?php if(BLUKRYPT_PAGE == true){ ?>
                            <div class="panel">
                                <div class="panel-heading">
                                    <?php if(maxBlukrypt == false){ ?>
                                    <h4><?=Language::show('listOfBlukrypts', 'keywords')?><span class="pull-right toolTip" data-toggle="tooltip" data-placement="top" title="This feature is disabled in Lite Version" style="cursor: not-allowed";><a class="btn btn-success btn-small disabled" href="" data-toggle="modal" data-target="#addBlukrypt" style="font-weight: 600;"><?=Language::show('add_blukrypt', 'keywords');?></a></span></h4>
                                    <?php } else {?>
                                    <h4><?=Language::show('listOfBlukrypts', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="" data-toggle="modal" data-target="#addBlukrypt" style="font-weight: 600;"><?=Language::show('add_blukrypt', 'keywords');?></a></span></h4>
                                    <?php } ?>
                                </div>
                                <div class="panel-body">
                                    <div class="row col-lg-12">
                                        <table class="table table-bordered">
                                            <thead>
                                            <tr>
                                                <th>BluKrypt Host Name</th>
                                                <th class="hide"><?=Language::show('noOfThreadsUsed', 'keywords')?></th>
                                                <th><?=Language::show('action', 'keywords')?></th>
                                            </tr>
                                            </thead>
                                            <tbody class="blukryptltListTable">
                                            <!--<tr ng-if="blukrypts.length == 1" ng-repeat="value in blukrypts track by $index">
                                                <td><span class="text-center" ng-cloak>{{ value.gatewayName }}</span></td>
                                            </tr>
                                            <tr ng-if="blukrypts.length > 1" ng-repeat="value in blukrypts">
                                                <td>
                                                    <span class="text-center" ng-cloak>{{ value.gatewayName+' ('+value.type+')' }}</span>
                                                    <button ng-click="removeBluKrypt(value.gatewayName, $index)" class="btn btn-small btn-danger pull-right">remove</button>
                                                </td>
                                            </tr>-->
                                            <tr ng-repeat="value in blukrypts track by $index">
                                                <td ng-if="value.type != 'both'"><span ng-cloak>{{ value.gatewayName+' ('+value.type+' backup preferred )' }}</span></td>
                                                <td ng-if="value.type == 'both'"><span ng-cloak>{{ value.gatewayName }}</span></td>
                                                <td class="hide" ng-cloak>{{ value.noOfThreadsUsed }}</td>
                                                <td class="text-left" style="white-space:unset !important;"><a ng-class="{false:'disabled'}[blukrypts.length > 1]"  class="btn btn-danger btn-small"
                                                    ng-bootbox-confirm="<div><h4 class='modal-title' id='myModalLabel'>Delete Blukrypt</h4><hr></div><?=Language::show('confirmDelete', 'keywords')?> {{value.gatewayName}} <?=Language::show('blukrypt', 'keywords')?> ?"
                                                    ng-bootbox-confirm-action="removeBluKrypt(value.gatewayName, $index)"
                                                    ng-bootbox-confirm-action-cancel=""
                                                    href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords')?></a>
                                                    <a class="btn btn-default btn-small" ng-click="editBlukrypts($index)" <?php if(isMobile()){ ?> style="margin-top:5px;" <?php } ?>>Edit</a>
                                        
                                            </td>
                                                
                                                
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
        </div>
    </div>
    <div id="addParacloud" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Add/Edit Paracloud</h4>
                </div>
                <div class="modal-body">
                        <?=
                            Form::open(array(
                                        'csrf' => $data['csrf_token'],
                                        'class' => 'bluvaultForm',
                                        'autocomplete' => 'off',
                                        'ng-submit' => 'saveBluvault()',
                                        'data-parsley-validate' => true
                                        ));
                        ?>
                        <div class="modal-title">
                            <div class="form-group">
                                            <label for="bluvault"><?=Language::show('paracloud_IpAddress', 'keywords');?></label>
                                            <input type="text" class="form-control" ng-model="bluvault" name="bluvault" id="bluvault" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('bluvault', 'keywords');?>" required autocomplete="off" autofocus>
                            </div>
                            <!--<div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('componentProperties', 'settings')?></legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="superUserName"><?=Language::show('superUserName', 'settings');?></label>
                                        <input type="text" class="form-control" id="superUserName" name="superUserName" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="paracloudDownloadPath"><?=Language::show('paracloudDownloadPath', 'settings');?></label>
                                        <input type="text" class="form-control" id="paracloudDownloadPath" name="paracloudDownloadPath" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="updateParacloudScriptName"><?=Language::show('updateParacloudScriptName', 'settings');?></label>
                                        <input type="text" class="form-control" id="updateParacloudScriptName" name="updateParacloudScriptName" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="azureStorageAccountName"><?=Language::show('azureStorageAccountName', 'settings');?></label>
                                        <input type="text" class="form-control" id="azureStorageAccountName" name="azureStorageAccountName" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="devAllowPerCollection"><?=Language::show('devAllowPerCollection', 'settings');?></label>
                                        <input type="number" class="form-control" id="devAllowPerCollection" name="devAllowPerCollection" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="chunkTotalBucketsParacloud"><?=Language::show('chunkTotalBuckets', 'settings');?></label>
                                        <input type="number" class="form-control" id="chunkTotalBucketsParacloud" name="chunkTotalBucketsParacloud" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="devicesPerUser"><?=Language::show('devicesPerUser', 'settings');?></label>
                                        <input type="number" class="form-control" id="devicesPerUser" name="devicesPerUser" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="devcertprivkeypath"><?=Language::show('devcertprivkeypath', 'settings');?></label>
                                        <input type="text" class="form-control" id="devcertprivkeypath" name="devcertprivkeypath" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="chunkColQueryRequiredParacloud"><?=Language::show('chunkColQueryRequired', 'settings');?></label>
                                        <select class="form-control chunkColQueryRequiredParacloud" name="chunkColQueryRequiredParacloud" id="chunkColQueryRequiredParacloud" title='Select <?=Language::show('chunkColQueryRequired', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="bkpColQueryRequiredParacloud"><?=Language::show('bkpColQueryRequired', 'settings');?></label>
                                        <select class="form-control bkpColQueryRequiredParacloud" name="bkpColQueryRequiredParacloud" id="bkpColQueryRequiredParacloud" title='Select <?=Language::show('bkpColQueryRequired', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="showAddADAttributeEnabled"><?=Language::show('showAddADAttributeEnabled', 'settings');?></label>
                                        <select class="form-control showAddADAttributeEnabled" name="showAddADAttributeEnabled" id="showAddADAttributeEnabled" title='Select <?=Language::show('showAddADAttributeEnabled', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="restoreurl"><?=Language::show('restoreurl', 'settings');?></label>
                                        <input type="text" class="form-control" id="restoreurl" name="restoreurl" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="keyForLoad"><?=Language::show('keyForLoad', 'settings');?></label>
                                        <input type="text" class="form-control" id="keyForLoad" name="keyForLoad" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="impUsersPolicyNames"><?=Language::show('impUsersPolicyNames', 'settings');?></label>
                                        <input type="text" class="form-control" id="impUsersPolicyNames" name="impUsersPolicyNames" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="azureStorageAccountKey"><?=Language::show('azureStorageAccountKey', 'settings');?></label>
                                        <input type="text" class="form-control" id="azureStorageAccountKey" name="azureStorageAccountKey" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="paracloudUrlParacloud"><?=Language::show('paracloudUrl', 'settings');?></label>
                                        <input type="text" class="form-control" id="paracloudUrlParacloud" name="paracloudUrlParacloud" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="noOfMonthsOldRecordToDeleteForSyncOverview"><?=Language::show('noOfMonthsOldRecordToDeleteForSyncOverview', 'settings');?></label>
                                        <input type="number" class="form-control" id="noOfMonthsOldRecordToDeleteForSyncOverview" name="noOfMonthsOldRecordToDeleteForSyncOverview" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="azureGateway"><?=Language::show('azureGateway', 'settings');?></label>
                                        <input type="text" class="form-control" id="azureGateway" name="azureGateway" value="">
                                    </div>
                                </div>
                            </div>-->
                        </div>
           
                        <div class="modal-footer ">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                            <!--<button type="submit" class="btn btn-default btn-primary" >Create</button>-->
                            <button type="submit" id="addSaveBluvault" class="submitBluvault btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                            <a class="btn btn-primary pull-right" id="editSaveBluvault" ng-click="editSaveBluvault()" style="display: none;"><?=Language::show('save', 'keywords');?></a>
                        </div>
                        <?=
                            Form::close();
                        ?>      
                </div>
            </div>
        </div>
    </div>
    
    <div id="addBlukrypt" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Add/Edit Blukrypt</h4>
            </div>
            <div class="modal-body">
                        <?=
                            Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'blukryptForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'saveBlukrypt()',
                            'data-parsley-validate' => true
                            ));
                        ?>
                        
                            <div class="form-group">
                                <label for="blukryptIP"><?=Language::show('blukrypt_IpAddress', 'keywords');?></label>
                                <input type="text" class="form-control" ng-model="blukrypt" name="blukryptIP" id="blukryptIP" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('blukrypt', 'keywords');?> <?=Language::show('Host Name', 'keywords');?>" required autocomplete="off" autofocus>
                            </div>
                            <div class="form-group">
                                <label for="blukryptEdit"><?=Language::show('blukryptType', 'keywords');?></label>
                                    <select class="form-control" name="blukryptEdit" id="blukryptEdit" required>
                                        <option value="full">Full backup preferred</option>
                                        <option value="incremental">Incremental backup preferred</option>
                                        <option value="both">Both</option>
                                    </select>
                            </div>
                            <?php if($data['loggedInUser']['backupEnabled'] == true || \Helpers\Auth::checkCloudPermission('office365')){ ?>
                                <div class="form-group hide">
                            <?php } else { ?>
                                <div class="form-group">
                            <?php } ?>
                                    <label for="productEdit">Product Type</label>
                                        <select class="form-control" name="productEdit" id="productEdit" required>
                                            <option value="blusync" >BluSync</option>
                                            <option value="bluvault">BluVault</option>
                                            <option selected value="both">Both</option>
                                        </select>
                                </div>
                                <div class="form-group">
                                    <label for="active">Watchdog status </label>
                                    <select class="form-control active" name="active" id="active" title='Select <?=Language::show('Select ', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                </div>
                                

                            <!--<div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('componentProperties', 'settings')?></legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="ftpHost"><?=Language::show('ftpHost', 'settings');?></label>
                                        <input type="text" class="form-control" id="ftpHost" name="ftpHost" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="ftpUser"><?=Language::show('ftpUser', 'settings');?></label>
                                        <input type="text" class="form-control" id="ftpUser" name="ftpUser" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="odbFrequencyCallValue"><?=Language::show('odbFrequencyCallValue', 'settings');?></label>
                                        <input type="text" class="form-control" id="odbFrequencyCallValue" name="odbFrequencyCallValue" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="proxyPort"><?=Language::show('policyRefresh', 'settings');?></label>
                                        <input type="number" class="form-control" id="proxyPort" name="proxyPort" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="proxyPassword"><?=Language::show('proxyPassword', 'settings');?></label>
                                        <input type="password" class="form-control" id="proxyPassword" name="proxyPassword" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="updateGatewayWhenChunkNotFound"><?=Language::show('updateGatewayWhenChunkNotFound', 'settings');?></label>
                                        <input type="text" class="form-control" id="updateGatewayWhenChunkNotFound" name="updateGatewayWhenChunkNotFound" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="odbRetryFolderVal"><?=Language::show('odbRetryFolderVal', 'settings');?></label>
                                        <input type="text" class="form-control" id="odbRetryFolderVal" name="odbRetryFolderVal" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="gatewayName"><?=Language::show('gatewayName', 'settings');?></label>
                                        <input type="text" class="form-control" id="gatewayName" name="gatewayName" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="noOfJobThreads"><?=Language::show('noOfJobThreads', 'settings');?></label>
                                        <input type="number" class="form-control" id="noOfJobThreads" name="noOfJobThreads" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="pgOverLoadInactivityPeriod"><?=Language::show('pgOverLoadInactivityPeriod', 'settings');?></label>
                                        <input type="number" class="form-control" id="pgOverLoadInactivityPeriod" name="pgOverLoadInactivityPeriod" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="pgOverloadLimit"><?=Language::show('pgOverloadLimit', 'settings');?></label>
                                        <input type="number" class="form-control" id="pgOverloadLimit" name="pgOverloadLimit" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="paracloudUrlBlukrypt"><?=Language::show('paracloudUrl', 'settings');?></label>
                                        <input type="text" class="form-control" id="paracloudUrlBlukrypt" name="paracloudUrlBlukrypt" value="">
                                    </div>  
                                    <div class="form-group">
                                        <label for="encryptionEnabled"><?=Language::show('encryptionEnabled', 'settings');?></label>
                                        <select class="form-control encryptionEnabled" name="encryptionEnabled" id="encryptionEnabled" title='Select <?=Language::show('encryptionEnabled', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="syncFtpEnabled"><?=Language::show('syncFtpEnabled', 'settings');?></label>
                                        <select class="form-control syncFtpEnabled" name="syncFtpEnabled" id="syncFtpEnabled" title='Select <?=Language::show('syncFtpEnabled', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="localStorageEnabled"><?=Language::show('localStorageEnabled', 'settings');?></label>
                                        <select class="form-control localStorageEnabled" name="localStorageEnabled" id="localStorageEnabled" title='Select <?=Language::show('localStorageEnabled', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>    
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="syncUploadPath"><?=Language::show('syncUploadPath', 'settings');?></label>
                                        <input type="text" class="form-control" id="syncUploadPath" name="syncUploadPath" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="ftpPwd"><?=Language::show('ftpPwd', 'settings');?></label>
                                        <input type="password" class="form-control" id="ftpPwd" name="ftpPwd" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="proxyUserName"><?=Language::show('proxyUserName', 'settings');?></label>
                                        <input type="text" class="form-control" id="proxyUserName" name="proxyUserName" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="proxyHost"><?=Language::show('proxyHost', 'settings');?></label>
                                        <input type="text" class="form-control" id="proxyHost" name="proxyHost" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="deleteBkpTblWhenChnkNotFound"><?=Language::show('deleteBkpTblWhenChnkNotFound', 'settings');?></label>
                                        <input type="text" class="form-control" id="deleteBkpTblWhenChnkNotFound" name="deleteBkpTblWhenChnkNotFound" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="odbUserAgentVal"><?=Language::show('odbUserAgentVal', 'settings');?></label>
                                        <input type="text" class="form-control" id="odbUserAgentVal" name="odbUserAgentVal" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="localdbhost"><?=Language::show('localdbhost', 'settings');?></label>
                                        <input type="text" class="form-control" id="localdbhost" name="localdbhost" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="chunkUpdateMaxRetry"><?=Language::show('chunkUpdateMaxRetry', 'settings');?></label>
                                        <input type="number" class="form-control" id="chunkUpdateMaxRetry" name="chunkUpdateMaxRetry" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="chunkTotalBucketsBlukrypt"><?=Language::show('chunkTotalBuckets', 'settings');?></label>
                                        <input type="number" class="form-control" id="chunkTotalBucketsBlukrypt" name="chunkTotalBucketsBlukrypt" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="queryLimit"><?=Language::show('queryLimit', 'settings');?></label>
                                        <input type="number" class="form-control" id="queryLimit" name="queryLimit" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="noOfThreads"><?=Language::show('noOfThreads', 'settings');?></label>
                                        <input type="number" class="form-control" id="noOfThreads" name="noOfThreads" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="resoreQueryLimit"><?=Language::show('resoreQueryLimit', 'settings');?></label>
                                        <input type="number" class="form-control" id="resoreQueryLimit" name="resoreQueryLimit" value="">
                                    </div>
                                    <div class="form-group">
                                        <label for="chunkColQueryRequiredBlukrypt"><?=Language::show('chunkColQueryRequired', 'settings');?></label>
                                        <select class="form-control chunkColQueryRequiredBlukrypt" name="chunkColQueryRequiredBlukrypt" id="chunkColQueryRequiredBlukrypt" title='Select <?=Language::show('chunkColQueryRequired', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="bkpColQueryRequiredBlukrypt"><?=Language::show('bkpColQueryRequired', 'settings');?></label>
                                        <select class="form-control bkpColQueryRequiredBlukrypt" name="bkpColQueryRequiredBlukrypt" id="bkpColQueryRequiredBlukrypt" title='Select <?=Language::show('bkpColQueryRequired', 'settings')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="stopJobsEnabled"><?=Language::show('stopJobsEnabled', 'settings');?></label>
                                        <select class="form-control stopJobsEnabled" name="stopJobsEnabled" id="stopJobsEnabled" title='Select <?=Language::show('stopJobsEnabled', 'settings')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    
                                </div>
                            </div>-->


           
                        <div class="modal-footer ">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <!--<button type="submit" class="btn btn-default btn-primary" >Create</button>-->
                        <button type="submit" id="addSaveBlukrypt" class="submitBlukrypt btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        <a class="btn btn-primary pull-right" id="editSaveBlukrypt" ng-click="editSaveBlukrypt()" style="display: none;"><?=Language::show('save', 'keywords');?></a>
                        </div>
                        <?=
                            Form::close();
                        ?>      
                    </div>
            </div>
        </div>
    </div>
<!--</div>-->

<!-- modal confirm starts -->
<div id="addBlukryptConfirm" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content smallModal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Confirm Add Blukrypt</h4>
            </div>
            <div class="modal-body">
                                <p>Are you sure you want to add ?</p>
                                <input type="text" class="form-control hide" ng-model="confblukrypt" name="confblukrypt" id="confblukrypt">
                                <input type="text" class="form-control hide" name="confblukryptEdit" id="confblukryptEdit">
                                <input type="text" class="form-control hide" name="confproductEdit" id="confproductEdit">
                        </div>

                        <div class="modal-footer ">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <a ng-click="ConfirmAddBlukrypt()" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
                        </div>

                    </div>
            </div>
        </div>
<!-- modal confirm ends -->

<!-- modal confirm starts -->
<div id="addParacloudConfirm" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content smallModal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Confirm Add Paracloud</h4>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to add ?</p>
                <input type="text" class="form-control hide" ng-model="confbluvault" name="confbluvault" id="confbluvault" />
            </div>
            <div class="modal-footer ">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a ng-click="ConfirmAdd()" class="btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></a>
            </div>
        </div>
    </div>
</div>
    </div>
<!-- modal confirm ends -->
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?php echo microtime();?>" type="text/javascript"></script>
<script>
    $('#blukryptType').selectpicker('render');
</script>
<script>
    $(function() {
        $('#addParacloud').on('hidden.bs.modal', function(){
            $('input').val('');
            $('input').removeClass("parsley-error");
            $('.parsley-errors-list').remove();
            $('#add_title_paracloud').addClass("show");
            $('#edit_title_paracloud').addClass("hide"); 
        });
    });
    $(function() {
        $('#addBlukrypt').on('hidden.bs.modal', function(){
            $('input').val('');
            $('input').removeClass("parsley-error");
            $('.parsley-errors-list').remove();
            $('#add_title').addClass("show");
            $('#edit_title').addClass("hide"); 
        });
    });
    $(function() {
    $('.tooltip-wrapper').tooltip({position: "bottom"});
});
</script>
