/**
 * Created by parablu-dev on 6/5/15.
 */



(function() {
    var morphSearch = document.getElementById( 'morphsearch' ),
        input = morphSearch.querySelector( 'input.morphsearch-input' ),
        ctrlClose = morphSearch.querySelector( 'span.morphsearch-close' ),
        isOpen = isAnimating = false,

        checkForKey = function(keyCode){
            if(keyCode >= 48 && keyCode <= 57){
                return true;
            }else if(keyCode >= 65 && keyCode <= 90){
                return true;
            }else{
                return false;
            }
        },

        toggleSearch = function(evt) {
            if( evt.type.toLowerCase() === 'focus' && isOpen ) return false;

            var offsets = morphsearch.getBoundingClientRect();
            if( isOpen ) {
                classie.remove( morphSearch, 'open' );
                if( input.value !== '' ) {
                    setTimeout(function() {
                        classie.add( morphSearch, 'hideInput' );
                        setTimeout(function() {
                            classie.remove( morphSearch, 'hideInput' );
                            input.value = '';
                        }, 300 );
                    }, 500);
                }

                input.blur();
            }
            else {
                classie.add( morphSearch, 'open' );
            }
            isOpen = !isOpen;
        };

    input.addEventListener( 'focus', toggleSearch );
    ctrlClose.addEventListener( 'click', toggleSearch );


    document.addEventListener( 'keydown', function( ev ) {
        var keyCode = ev.keyCode || ev.which;
        var focusedElement = $(document.activeElement);
        if(focusedElement.context.localName != 'input' && focusedElement.context.localName != 'textarea'){
            if( keyCode === 27 && isOpen ) {
                toggleSearch(ev);
            }
        }
    } );


    document.addEventListener( 'keydown', function( ev ) {
        if(!ev.ctrlKey && !ev.shiftKey && !ev.altKey){
            var keyCode = ev.keyCode || ev.which;
            var focusedElement = $(document.activeElement);
            if(focusedElement.context.localName != 'input' && focusedElement.context.localName != 'textarea'){
                if (checkForKey(keyCode) && !isOpen) {
                    toggleSearch(ev);
                    document.getElementById("morphsearch-input").focus();
                }
            }
        }
    } );

    morphSearch.querySelector( 'button[type="submit"]' ).addEventListener( 'click', function(ev) {
        ev.preventDefault();

        var value = $('.morphsearch-input').val();

        $('.status-text').html('<span class="text-muted h3">Searching for <b>"'+value+'"</b> <img width="3%" style="margin-top: -10px;" src="/app/templates/default/images/gears.gif" /></span>');
        $('.search-results').hide();

        setTimeout(function(){
            $('.status-text').html('Search Results');
            $('.search-results').show();
        }, 3000);

    });

})();