/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('SupportController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI,BASE_FOLDER) {

    $scope.sortReverse = true;
    $scope.sortType = 'convertedOne';
    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.parabluInstalledVerion = '';
    $scope.statistics = {};
    $scope.pageNumber = 1;
    $scope.currentpageCount = '';
    $scope.totalpageCount = '';

    $scope.updatedSupportLogs = function(){
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var pageNumber = $scope.pageNumber;
        $.ajax({
            url: $scope.BASE_FOLDER+'/support',
            data: {secret: '',csrf_token: $('.csrf_token').html(),pageNumber:pageNumber},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                $('.first').show();
                }
                /*if($scope.self){
                $('.self').show();
                }*/
                if($scope.previous){
                $('.previous').show();
                }
                if($scope.next){
                $('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }
                console.log("prev : "+jData.metadata.links.previous);
                console.log("next : "+jData.metadata.links.next);
                console.log("last : "+jData.metadata.links.last);
                //console.log("self : "+jData.metadata.links.self);
                console.log("first : "+jData.metadata.links.first);
                if(jData.supportLogs.length > 0){
                    $('.loading').hide();
                    $('.supportLogTable').show();
                    $scope.supportLogs = jData.supportLogs;
                    $scope.$apply();
                }else{
                    $('.loading').show();
                    $('.loading').html('<h4>There was no support logs found</h4>');
                    $('.supportLogTable').hide();
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updatedSupportLogsNavigate = function(url){
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        var pageNumber = $scope.pageNumber;
        $.ajax({
            url: $scope.BASE_FOLDER+'/support1',
            data: {secret: '',csrf_token: $('.csrf_token').html(),url:url},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.previous = jData.metadata.links.previous;
                $scope.next = jData.metadata.links.next;
                $scope.last = jData.metadata.links.last;
                //$scope.self = jData.metadata.links.self;
                $scope.first = jData.metadata.links.first;
                $scope.currentpageCount = jData.metadata.pageNumber;
                $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                if($scope.first){
                $('.first').show();
                }
                /*if($scope.self){
                $('.self').show();
                }*/
                if($scope.previous){
                $('.previous').show();
                }
                if($scope.next){
                $('.next').show();
                }
                if($scope.last){
                $('.last').show();
                }
                console.log("prev : "+jData.metadata.links.previous);
                console.log("next : "+jData.metadata.links.next);
                console.log("last : "+jData.metadata.links.last);
                //console.log("self : "+jData.metadata.links.self);
                console.log("first : "+jData.metadata.links.first);
                if(jData.supportLogs.length > 0){
                    $('.loading').hide();
                    $('.supportLogTable').show();
                    $scope.supportLogs = jData.supportLogs;
                    $scope.$apply();
                }else{
                    $('.loading').show();
                    $('.loading').html('<h4>There was no support logs found</h4>');
                    $('.supportLogTable').hide();
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getSupportLogs = function(serverHostName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/getSupportLogs',
            data: {csrf_token: $('.csrf_token').html(), serverHostName: serverHostName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.message, 'Successful!!!', {allowHtml: true});
                $scope.updatedSupportLogs();
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.overview = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/supportOverview',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                //$scope.parabluInstalledVerion = jData.parabluInstalledVerion;
                $scope.statistics = jData.statistics;
                $scope.updatedSupportLogs();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadLog = function(log){
        window.location.href = log;
    };
    
    $scope.sendMeTo = function(location){
        window.location.href = location;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'support'){
            blockUI.start();
            $scope.overview();
            //$scope.updatedSupportLogs();
        }
    });

}]);
