<?php
namespace Helpers;

use Helpers\Session;
use Helpers\Url;

class Auth {

    /**
     * Private Variables
     */
    private $session;

    /**
     * Auto Session construction
     */
    public function __construct(){
        $this->session = new Session();
    }

    public function loginCheck(){
        if(!$this->session->get('loggedIn')){
            $this->session->put('redirectUrl', $_SERVER['REQUEST_URI']);
            if(empty($_POST) && !empty($this->session->all())){
                Url::redirect('login');
            }else{
                header("HTTP/1.0 401 Un Authorized");
                exit;
            }
        }
    }

    public function checkLoggedInUser($userName){
        if(self::checkUserPermission('admin') != true){
            if($userName != $this->session->get('userName')){
                Url::redirect('403');
                exit;
            }
        }
    }

    public function tokenCheck(){
        if($this->session->get('loggedIn')){
            if(!$this->session->get('token') || $this->session->get('token') == null){
                $this->session->put('redirectUrl', $_SERVER['REQUEST_URI']);
                Url::redirect('sleep');
                exit;
            }
        }
    }

    public function loggedOutCheck(){
        if($this->session->get('loggedIn')){
            Url::redirect('');
        }
    }

    public function checkForUserPermission($userType){
        switch($userType){
            case('admin'):
                if($this->session->get('admin') != true){
                    Url::redirect('/403');
                }
                break;
            case('readOnly'):
                if($this->session->get('readOnlyAdmin') != true || $this->session->get('admin') != true){
                    Url::redirect('/403');
                }
                break;
            default:
                Url::redirect('/403');
        }
    }

    public static function checkUserPermission($userType){
        switch($userType){
            case('admin'):
                if($_SESSION['admin'] == true){
                    return true;
                }else{
                    return false;
                }
                break;
            case('readOnlyAdmin'):
                if($_SESSION['readOnlyAdmin'] == true || $_SESSION['admin'] == true){
                    return true;
                }else{
                    return false;
                }
                break;
            case('guest'):
                if($_SESSION['guest'] == true){
                    return false;
                }else{
                    return true;
                }
                break;
            default:
                return false;
        }
    }

    public function checkForCloudPermission($cloudType){
        switch($cloudType){
            case('sync'):
                if($this->session->get('syncEnabled') != true){
                    Url::redirect('/403');
                }
                break;
            case('backup'):
                if($this->session->get('backupEnabled') != true){
                    Url::redirect('/403');
                }
                break;
            case('serverBackup'):
                if($this->session->get('serverBackupEnabled') != true){
                    Url::redirect('/403');
                }
                break;
            case('both'):
                if($this->session->get('syncEnabled') != true && $this->session->get('backupEnabled') != true){
                    Url::redirect('/403');
                }
                break;
            default:
                Url::redirect('/403');
        }
    }

    public static function checkCloudPermission($cloudType){
        switch($cloudType){
            case('sync'):
                //if($_SESSION['syncEnabled'] != true){
                if($_SESSION['sync_enabled'] != 'true'){
                    return false;
                }else{
                    return true;
                }
            case('backup'):
                //if($_SESSION['backupEnabled'] != true){
                if($_SESSION['backup_enabled'] != 'true'){
                    return false;
                }else{
                    return true;
                }
            case('office365'):
                //if($_SESSION['onedriveBkpEnabled'] != true){
                if($_SESSION['one_drive_backup_enabled'] == 'true' || $_SESSION['exchange_backup_enabled'] == 'true'){
                    return true;
                }else{
                    return false;
                }
            case('onedrive'):
                if($_SESSION['one_drive_backup_enabled'] == 'true'){
                    return true;
                }else{
                    return false;
                }
            case('exchange'):
                if($_SESSION['exchange_backup_enabled'] == 'true'){
                    return true;
                }else{
                    return false;
                }
            case('serverBackup'):
                if($_SESSION['serverBackupEnabled'] != true){
                    return false;
                }else{
                    return true;
                }
            case('both'):
                if($_SESSION['syncEnabled'] != true && $_SESSION['backupEnabled'] != true){
                    return false;
                }else{
                    return true;
                }
            default:
                return false;
        }
    }

    public static function allowOnly($userType){
        if($_SERVER['REQUEST_METHOD'] != 'POST'){
            switch($userType){
                case('admin'):
                    if(self::checkUserPermission($userType) != true){
                        Url::redirect('404');
                    }
                    break;
                case('readOnlyAdmin'):
                    if(self::checkUserPermission('readOnlyAdmin') != true){
                        Url::redirect('404');
                    }
                    break;
                default:
                    Url::redirect('404');
            }
        }else{
            switch($userType){
                case('admin'):
                    if(self::checkUserPermission($userType) != true){
                        header("HTTP/1.0 404 Page Not found");
                    }
                    break;
                case('readOnlyAdmin'):
                    if(self::checkUserPermission('readOnlyAdmin') != true){
                        header("HTTP/1.0 404 Page Not found");
                    }
                    break;
                default:
                    header("HTTP/1.0 404 Page Not found");
            }
        }

    }

}
