/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Task;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class TaskHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Task> {
    private StringBuilder currentText = new StringBuilder();
    private Task.Builder builder = Task.builder();

    @Override
    public Task getResult() {
        try {
            Task task = this.builder.build();
            return task;
        }
        finally {
            this.builder = Task.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "guid")) {
            this.builder.guid(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "code")) {
            this.builder.statusCode(Task.StatusCode.valueOf(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "message")) {
            this.builder.message(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "resultUrl")) {
            this.builder.resultUrl(URI.create(SaxUtils.currentOrNull(this.currentText)));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

