/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public abstract class ElementTextHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<String> {
    private final String textElement;
    private StringBuilder currentText = new StringBuilder();
    private String text = null;

    private ElementTextHandler(String textElement) {
        this.textElement = Preconditions.checkNotNull(textElement, "textElement");
    }

    @Override
    public String getResult() {
        return Preconditions.checkNotNull(this.text, "%s not present in the response", this.textElement);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, this.textElement)) {
            this.text = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    public static class DirectionalPoolRecordID
    extends ElementTextHandler {
        public DirectionalPoolRecordID() {
            super("DirectionalPoolRecordID");
        }
    }

    public static class DirPoolID
    extends ElementTextHandler {
        public DirPoolID() {
            super("DirPoolID");
        }
    }

    public static class PoolRecordID
    extends ElementTextHandler {
        public PoolRecordID() {
            super("poolRecordID");
        }
    }

    public static class TCPoolID
    extends ElementTextHandler {
        public TCPoolID() {
            super("TCPoolID");
        }
    }

    public static class RRPoolID
    extends ElementTextHandler {
        public RRPoolID() {
            super("RRPoolID");
        }
    }

    public static class Guid
    extends ElementTextHandler {
        public Guid() {
            super("guid");
        }
    }
}

