/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.location.Provider;

public class SOAPWrapWithPasswordAuth
implements HttpRequestFilter {
    static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    static final String PASSWORD_TEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    static final String SOAP_PREFIX = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" " + "xmlns:v01=\"http://webservice.api.ultra.neustar.com/v01/\"><soapenv:Header>" + "<wsse:Security soapenv:mustUnderstand=\"1\" xmlns:wsse=\"" + "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" + "\"><wsse:UsernameToken>" + "<wsse:Username>%s</wsse:Username>" + "<wsse:Password Type=\"" + "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" + "\">%s</wsse:Password>" + "</wsse:UsernameToken></wsse:Security></soapenv:Header><soapenv:Body>";
    static final String SOAP_SUFFIX = "</soapenv:Body></soapenv:Envelope>";
    private final Supplier<Credentials> creds;

    @Inject
    public SOAPWrapWithPasswordAuth(@Provider Supplier<Credentials> creds) {
        this.creds = creds;
    }

    @Override
    public HttpRequest filter(HttpRequest request) {
        Preconditions.checkNotNull(request.getPayload(), "request is not ready to wrap; payload not present");
        Credentials current = this.creds.get();
        String body = request.getPayload().getRawContent().toString();
        StringPayload wrappedPayload = Payloads.newStringPayload(String.format(SOAP_PREFIX, current.identity, current.credential) + body + SOAP_SUFFIX);
        wrappedPayload.getContentMetadata().setContentType("application/xml");
        return ((HttpRequest.Builder)request.toBuilder().payload(wrappedPayload)).build();
    }
}

