/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.Fallbacks;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.ultradns.ws.domain.RoundRobinPool;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.internal.RoundRobinPoolRecordTypeToString;
import org.jclouds.ultradns.ws.xml.ElementTextHandler;
import org.jclouds.ultradns.ws.xml.ResourceRecordListHandler;
import org.jclouds.ultradns.ws.xml.RoundRobinPoolListHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface RoundRobinPoolApi {
    @Named(value="getLoadBalancingPoolsByZone")
    @POST
    @XMLResponseParser(value=RoundRobinPoolListHandler.class)
    @Payload(value="<v01:getLoadBalancingPoolsByZone><zoneName>{zoneName}</zoneName><lbPoolType>RR</lbPoolType></v01:getLoadBalancingPoolsByZone>")
    public FluentIterable<RoundRobinPool> list() throws ResourceNotFoundException;

    @Named(value="getRRPoolRecords")
    @POST
    @XMLResponseParser(value=ResourceRecordListHandler.class)
    @Payload(value="<v01:getRRPoolRecords><lbPoolId>{poolId}</lbPoolId></v01:getRRPoolRecords>")
    public FluentIterable<ResourceRecordDetail> listRecords(@PayloadParam(value="poolId") String var1) throws ResourceNotFoundException;

    @Named(value="addRRLBPool")
    @POST
    @XMLResponseParser(value=ElementTextHandler.RRPoolID.class)
    @Payload(value="<v01:addRRLBPool><transactionID /><zoneName>{zoneName}</zoneName><hostName>{hostName}</hostName><description>{description}</description><poolRecordType>{poolRecordType}</poolRecordType><rrGUID /></v01:addRRLBPool>")
    public String createForDNameAndType(@PayloadParam(value="description") String var1, @PayloadParam(value="hostName") String var2, @PayloadParam(value="poolRecordType") @ParamParser(value=RoundRobinPoolRecordTypeToString.class) int var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="addRecordToRRPool")
    @POST
    @XMLResponseParser(value=ElementTextHandler.Guid.class)
    @Payload(value="<v01:addRecordToRRPool><transactionID /><roundRobinRecord lbPoolID=\"{lbPoolID}\" info1Value=\"{address}\" ZoneName=\"{zoneName}\" Type=\"1\" TTL=\"{ttl}\"/></v01:addRecordToRRPool>")
    public String addARecordWithAddressAndTTL(@PayloadParam(value="lbPoolID") String var1, @PayloadParam(value="address") String var2, @PayloadParam(value="ttl") int var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="updateRecordOfRRPool")
    @POST
    @Payload(value="<v01:updateRecordOfRRPool><transactionID /><resourceRecord rrGuid=\"{guid}\" lbPoolID=\"{lbPoolID}\" info1Value=\"{address}\" TTL=\"{ttl}\"/></v01:updateRecordOfRRPool>")
    public void updateRecordWithAddressAndTTL(@PayloadParam(value="lbPoolID") String var1, @PayloadParam(value="guid") String var2, @PayloadParam(value="address") String var3, @PayloadParam(value="ttl") int var4) throws ResourceNotFoundException;

    @Named(value="deleteRecordOfRRPool")
    @POST
    @Payload(value="<v01:deleteRecordOfRRPool><transactionID /><guid>{guid}</guid></v01:deleteRecordOfRRPool>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteRecord(@PayloadParam(value="guid") String var1);

    @Named(value="addRecordToRRPool")
    @POST
    @XMLResponseParser(value=ElementTextHandler.Guid.class)
    @Payload(value="<v01:addRecordToRRPool><transactionID /><roundRobinRecord lbPoolID=\"{lbPoolID}\" info1Value=\"{address}\" ZoneName=\"{zoneName}\" Type=\"28\" TTL=\"{ttl}\"/></v01:addRecordToRRPool>")
    public String addAAAARecordWithAddressAndTTL(@PayloadParam(value="lbPoolID") String var1, @PayloadParam(value="address") String var2, @PayloadParam(value="ttl") int var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="deleteLBPool")
    @POST
    @Payload(value="<v01:deleteLBPool><transactionID /><lbPoolID>{lbPoolID}</lbPoolID><DeleteAll>Yes</DeleteAll><retainRecordId /></v01:deleteLBPool>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PayloadParam(value="lbPoolID") String var1);
}

