/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class Zone {
    private final String id;
    private final String name;
    private final Type type;
    private final int typeCode;
    private final String accountId;
    private final String ownerId;
    private final DNSSECStatus dnssecStatus;
    private final Optional<String> primarySrc;

    private Zone(String id, String name, Type type, int typeCode, String accountId, String ownerId, DNSSECStatus dnssecStatus, Optional<String> primarySrc) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name for %s", id);
        Preconditions.checkArgument(typeCode >= 0, "typeCode of %s must be >= 0", id);
        this.typeCode = typeCode;
        this.type = Preconditions.checkNotNull(type, "type for %s", name);
        this.accountId = Preconditions.checkNotNull(accountId, "accountId for %s", name);
        this.ownerId = Preconditions.checkNotNull(ownerId, "ownerId for %s", name);
        this.dnssecStatus = Preconditions.checkNotNull(dnssecStatus, "dnssecStatus for %s", name);
        this.primarySrc = Preconditions.checkNotNull(primarySrc, "primarySrc for %s", name);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public DNSSECStatus getDNSSECStatus() {
        return this.dnssecStatus;
    }

    public Optional<String> getPrimarySrc() {
        return this.primarySrc;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.accountId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Zone that = (Zone)Zone.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.accountId, that.accountId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("type", (Object)this.type).add("accountId", this.accountId).add("ownerId", this.ownerId).add("dnssecStatus", (Object)this.dnssecStatus).add("primarySrc", this.primarySrc.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Zone.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private Type type;
        private int typeCode = -1;
        private String accountId;
        private String ownerId;
        private DNSSECStatus dnssecStatus;
        private Optional<String> primarySrc = Optional.absent();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder typeCode(int typeCode) {
            this.typeCode = typeCode;
            this.type = Type.fromValue(typeCode);
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder dnssecStatus(DNSSECStatus dnssecStatus) {
            this.dnssecStatus = dnssecStatus;
            return this;
        }

        public Builder primarySrc(String primarySrc) {
            this.primarySrc = Optional.fromNullable(primarySrc);
            return this;
        }

        public Zone build() {
            return new Zone(this.id, this.name, this.type, this.typeCode, this.accountId, this.ownerId, this.dnssecStatus, this.primarySrc);
        }

        public Builder from(Zone in) {
            return this.id(in.id).name(in.name).typeCode(in.typeCode).type(in.type).accountId(in.accountId).ownerId(in.ownerId).dnssecStatus(in.dnssecStatus).primarySrc((String)in.primarySrc.orNull());
        }
    }

    public static enum DNSSECStatus {
        SIGNED,
        UNSIGNED,
        UNRECOGNIZED;


        public static DNSSECStatus fromValue(String status) {
            try {
                return DNSSECStatus.valueOf(Preconditions.checkNotNull(status, "status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        PRIMARY(1),
        SECONDARY(2),
        ALIAS(3),
        UNRECOGNIZED(-1);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type fromValue(String type) {
            return Type.fromValue(Integer.parseInt(Preconditions.checkNotNull(type, "type")));
        }

        public static Type fromValue(int code) {
            switch (code) {
                case 1: {
                    return PRIMARY;
                }
                case 2: {
                    return SECONDARY;
                }
                case 3: {
                    return ALIAS;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

