/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.domain.IdAndName;

public class DirectionalPoolRecordDetail {
    private final String zoneName;
    private final String name;
    private final String id;
    private final Optional<IdAndName> group;
    private final Optional<IdAndName> geolocationGroup;
    private final Optional<IdAndName> sourceIpGroup;
    private final DirectionalPoolRecord record;

    private DirectionalPoolRecordDetail(String zoneName, String name, String id, Optional<IdAndName> group, Optional<IdAndName> geolocationGroup, Optional<IdAndName> sourceIpGroup, DirectionalPoolRecord record) {
        this.zoneName = Preconditions.checkNotNull(zoneName, "zoneName");
        this.name = Preconditions.checkNotNull(name, "name");
        this.id = Preconditions.checkNotNull(id, "id");
        this.group = Preconditions.checkNotNull(group, "group of %s/%s/%s", zoneName, name, id);
        this.geolocationGroup = Preconditions.checkNotNull(geolocationGroup, "geolocationGroup of %s/%s/%s", zoneName, name, id);
        this.sourceIpGroup = Preconditions.checkNotNull(sourceIpGroup, "sourceIpGroup of %s/%s/%s", zoneName, name, id);
        this.record = Preconditions.checkNotNull(record, "record of %s/%s/%s", zoneName, name, id);
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Optional<IdAndName> getGroup() {
        return this.group;
    }

    public Optional<IdAndName> getGeolocationGroup() {
        return this.geolocationGroup;
    }

    public Optional<IdAndName> getSourceIpGroup() {
        return this.sourceIpGroup;
    }

    public DirectionalPoolRecord getRecord() {
        return this.record;
    }

    public int hashCode() {
        return Objects.hashCode(this.zoneName, this.name, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectionalPoolRecordDetail that = (DirectionalPoolRecordDetail)DirectionalPoolRecordDetail.class.cast(obj);
        return Objects.equal(this.zoneName, that.zoneName) && Objects.equal(this.name, that.name) && Objects.equal(this.id, that.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("zoneName", this.zoneName).add("name", this.name).add("id", this.id).add("group", this.group.orNull()).add("geolocationGroup", this.geolocationGroup.orNull()).add("sourceIpGroup", this.sourceIpGroup.orNull()).add("record", this.record).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DirectionalPoolRecordDetail.builder().from(this);
    }

    public static final class Builder {
        private String zoneName;
        private String name;
        private String id;
        private Optional<IdAndName> group = Optional.absent();
        private Optional<IdAndName> geolocationGroup = Optional.absent();
        private Optional<IdAndName> sourceIpGroup = Optional.absent();
        private DirectionalPoolRecord record;

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder group(IdAndName group) {
            this.group = Optional.fromNullable(group);
            return this;
        }

        public Builder geolocationGroup(IdAndName geolocationGroup) {
            this.geolocationGroup = Optional.fromNullable(geolocationGroup);
            return this;
        }

        public Builder sourceIpGroup(IdAndName sourceIpGroup) {
            this.sourceIpGroup = Optional.fromNullable(sourceIpGroup);
            return this;
        }

        public Builder record(DirectionalPoolRecord record) {
            this.record = record;
            return this;
        }

        public Builder record(DirectionalPoolRecord.Builder record) {
            this.record = record.build();
            return this;
        }

        public DirectionalPoolRecordDetail build() {
            return new DirectionalPoolRecordDetail(this.zoneName, this.name, this.id, this.group, this.geolocationGroup, this.sourceIpGroup, this.record);
        }

        public Builder from(DirectionalPoolRecordDetail in) {
            return this.zoneName(in.zoneName).name(in.name).id(in.id).group((IdAndName)in.group.orNull()).geolocationGroup((IdAndName)in.geolocationGroup.orNull()).sourceIpGroup((IdAndName)in.sourceIpGroup.orNull()).record(in.record);
        }
    }
}

