/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.ultradns.ws.domain.DirectionalPool;

public final class AccountLevelGroup {
    private final String id;
    private final String name;
    private final DirectionalPool.Type type;
    private final int recordCount;

    private AccountLevelGroup(String id, String name, DirectionalPool.Type type, int recordCount) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name of %s", id);
        this.type = Preconditions.checkNotNull(type, "type of %s", id);
        this.recordCount = recordCount;
        Preconditions.checkArgument(recordCount >= 0, "recordCount of %s must be >= 0", id);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DirectionalPool.Type getType() {
        return this.type;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountLevelGroup that = (AccountLevelGroup)AccountLevelGroup.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal((Object)this.type, (Object)that.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("type", (Object)this.type).add("recordCount", this.recordCount).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AccountLevelGroup.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private DirectionalPool.Type type;
        private int recordCount = -1;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(DirectionalPool.Type type) {
            this.type = type;
            return this;
        }

        public Builder recordCount(int recordCount) {
            this.recordCount = recordCount;
            return this;
        }

        public AccountLevelGroup build() {
            return new AccountLevelGroup(this.id, this.name, this.type, this.recordCount);
        }

        public Builder from(AccountLevelGroup in) {
            return this.id(in.id).name(in.name).type(in.type).recordCount(in.recordCount);
        }
    }
}

