/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.binders;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.ultradns.ws.domain.ResourceRecord;

public class ZoneAndResourceRecordToXML
implements MapBinder {
    private static final String template = "<v01:createResourceRecord><transactionID /><resourceRecord ZoneName=\"%s\" Type=\"%s\" DName=\"%s\" TTL=\"%s\">%s</resourceRecord></v01:createResourceRecord>";

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        String zoneName = postParams.get("zoneName").toString();
        ResourceRecord record = (ResourceRecord)ResourceRecord.class.cast(postParams.get("resourceRecord"));
        String xml = ZoneAndResourceRecordToXML.toXML(zoneName, record);
        Optional<Object> guid = Optional.fromNullable(postParams.get("guid"));
        if (guid.isPresent()) {
            xml = ZoneAndResourceRecordToXML.update(guid.get(), xml);
        }
        return (R)((HttpRequest.Builder)request.toBuilder().payload(xml)).build();
    }

    @VisibleForTesting
    static String toXML(String zoneName, ResourceRecord record) {
        StringBuilder values = new StringBuilder("<InfoValues");
        for (int i = 0; i < record.getRData().size(); ++i) {
            values.append(' ').append("Info").append(i + 1).append("Value=").append('\"').append(record.getRData().get(i)).append('\"');
        }
        values.append(" />");
        return String.format(template, zoneName, record.getType(), record.getName(), record.getTTL(), values.toString());
    }

    static String update(Object guid, String xml) {
        return xml.replace("createResourceRecord", "updateResourceRecord").replace("<resourceRecord", String.format("<resourceRecord Guid=\"%s\"", guid));
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

