/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.binders;

import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.ultradns.ws.domain.UpdatePoolRecord;

public class UpdatePoolRecordToXML
implements MapBinder {
    private static final String HEADER = "<v01:updatePoolRecord><transactionID /><poolRecordID>%s</poolRecordID><parentPoolId /><childPoolId />";
    private static final String FOOTER = "</v01:updatePoolRecord>";

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        StringBuilder xml = new StringBuilder();
        xml.append(String.format(HEADER, postParams.get("poolRecordID")));
        UpdatePoolRecord update = (UpdatePoolRecord)UpdatePoolRecord.class.cast(postParams.get("update"));
        xml.append("<pointsTo>").append(update.getRData()).append("</pointsTo>");
        xml.append("<priority>").append(update.getPriority()).append("</priority>");
        xml.append("<failOverDelay>").append(update.getFailOverDelay()).append("</failOverDelay>");
        xml.append("<ttl>").append(update.getTTL()).append("</ttl>");
        xml.append("<weight>").append(update.getWeight()).append("</weight>");
        xml.append("<mode>").append(update.getMode()).append("</mode>");
        xml.append("<threshold>").append(update.getThreshold()).append("</threshold>");
        xml.append(FOOTER);
        return (R)((HttpRequest.Builder)request.toBuilder().payload(xml.toString())).build();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

