/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.xml;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public abstract class TextFromSingleElementHandler<V>
extends ParseSax.HandlerForGeneratedRequestWithResult<V>
implements Function<String, V> {
    private final String elementName;
    private StringBuilder currentText = new StringBuilder();
    private String text;

    protected TextFromSingleElementHandler(String elementName) {
        this.elementName = Preconditions.checkNotNull(elementName, "elementName");
    }

    @Override
    public V getResult() {
        return (V)this.apply(this.text);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals(this.elementName)) {
            this.text = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

