/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class SendMessageOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Integer delaySeconds;

    public SendMessageOptions delaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        Multimap<String, String> params = super.buildFormParameters();
        if (this.delaySeconds != null) {
            params.put("DelaySeconds", this.delaySeconds.toString());
        }
        return params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.delaySeconds);
    }

    public SendMessageOptions clone() {
        return new SendMessageOptions().delaySeconds(this.delaySeconds);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SendMessageOptions other = (SendMessageOptions)SendMessageOptions.class.cast(obj);
        return Objects.equal(this.delaySeconds, other.delaySeconds);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("delaySeconds", this.delaySeconds).toString();
    }

    public static class Builder {
        public static SendMessageOptions delaySeconds(Integer delaySeconds) {
            return new SendMessageOptions().delaySeconds(delaySeconds);
        }
    }
}

