/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class CreateQueueOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private ImmutableMap.Builder<String, String> attributes = ImmutableMap.builder();

    public CreateQueueOptions visibilityTimeout(int visibilityTimeout) {
        return this.attribute("VisibilityTimeout", visibilityTimeout + "");
    }

    public CreateQueueOptions attributes(Map<String, String> attributes) {
        this.attributes = ImmutableMap.builder().putAll(attributes);
        return this;
    }

    public CreateQueueOptions attribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        Multimap<String, String> params = super.buildFormParameters();
        ImmutableMap<String, String> attributes = this.attributes.build();
        if (!attributes.isEmpty()) {
            int nameIndex = 1;
            for (Map.Entry attribute : attributes.entrySet()) {
                params.put("Attribute." + nameIndex + ".Name", (String)attribute.getKey());
                params.put("Attribute." + nameIndex + ".Value", (String)attribute.getValue());
                ++nameIndex;
            }
        }
        return params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.attributes.build());
    }

    public CreateQueueOptions clone() {
        return new CreateQueueOptions().attributes(this.attributes.build());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateQueueOptions other = (CreateQueueOptions)CreateQueueOptions.class.cast(obj);
        return Objects.equal(this.attributes.build(), other.attributes.build());
    }

    @Override
    public String toString() {
        ImmutableMap<String, String> attributes = this.attributes.build();
        return MoreObjects.toStringHelper(this).omitNullValues().add("attributes", !attributes.isEmpty() ? attributes : null).toString();
    }

    public static class Builder {
        public static CreateQueueOptions visibilityTimeout(Integer visibilityTimeout) {
            return new CreateQueueOptions().visibilityTimeout(visibilityTimeout);
        }

        public static CreateQueueOptions attribute(String name, String value) {
            return new CreateQueueOptions().attribute(name, value);
        }

        public static CreateQueueOptions attributes(Map<String, String> attributes) {
            return new CreateQueueOptions().attributes(attributes);
        }
    }
}

