/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class Password {
    private final int id;
    private final String username;
    private final String password;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromPassword(this);
    }

    @ConstructorProperties(value={"id", "username", "password"})
    public Password(int id, String username, @Nullable String password) {
        this.id = id;
        this.username = Preconditions.checkNotNull(Strings.emptyToNull(username), "username cannot be null or empty:" + username);
        this.password = password;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Password that = (Password)Password.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("username", this.username).add("password", this.password).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String username;
        protected String password;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T username(String username) {
            this.username = username;
            return this.self();
        }

        public T password(String password) {
            this.password = password;
            return this.self();
        }

        public Password build() {
            return new Password(this.id, this.username, this.password);
        }

        public T fromPassword(Password in) {
            return ((Builder)((Builder)this.id(in.getId())).username(in.getUsername())).password(in.getPassword());
        }
    }
}

