/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.compute.functions.internal.OperatingSystems;
import org.jclouds.softlayer.domain.SoftwareDescription;
import org.jclouds.softlayer.domain.SoftwareLicense;

@Singleton
public class OperatingSystemToImage
implements Function<org.jclouds.softlayer.domain.OperatingSystem, Image> {
    private static final String UNRECOGNIZED = "UNRECOGNIZED";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Override
    public Image apply(org.jclouds.softlayer.domain.OperatingSystem operatingSystem) {
        Preconditions.checkNotNull(operatingSystem, "operatingSystem");
        SoftwareLicense defaultSoftwareLicense = SoftwareLicense.builder().softwareDescription(SoftwareDescription.builder().build()).build();
        SoftwareLicense softwareLicense = Optional.fromNullable(operatingSystem.getSoftwareLicense()).or(defaultSoftwareLicense);
        Optional<String> optOSReferenceCode = Optional.fromNullable(softwareLicense.getSoftwareDescription().getReferenceCode());
        Optional<String> optVersion = Optional.fromNullable(softwareLicense.getSoftwareDescription().getVersion());
        Optional<String> optLongDescription = Optional.fromNullable(softwareLicense.getSoftwareDescription().getLongDescription());
        OsFamily osFamily = OsFamily.UNRECOGNIZED;
        String osVersion = UNRECOGNIZED;
        Integer bits = null;
        if (optOSReferenceCode.isPresent()) {
            String operatingSystemReferenceCode = optOSReferenceCode.get();
            osFamily = OperatingSystems.osFamily().apply(operatingSystemReferenceCode);
            bits = OperatingSystems.bits().apply(operatingSystemReferenceCode);
        }
        if (optVersion.isPresent()) {
            osVersion = OperatingSystems.version().apply(optVersion.get());
        }
        if (osFamily == OsFamily.UNRECOGNIZED) {
            this.logger.debug("Cannot determine os family for item: %s", operatingSystem);
        }
        if (osVersion == null) {
            this.logger.debug("Cannot determine os version for item: %s", operatingSystem);
        }
        if (bits == null) {
            this.logger.debug("Cannot determine os bits for item: %s", operatingSystem);
        }
        OperatingSystem os = OperatingSystem.builder().description(optLongDescription.or(UNRECOGNIZED)).family(osFamily).version(osVersion).is64Bit(Objects.equal(bits, 64)).build();
        return new ImageBuilder().ids(optOSReferenceCode.or(operatingSystem.getId())).description(optOSReferenceCode.or(UNRECOGNIZED)).operatingSystem(os).status(Image.Status.AVAILABLE).build();
    }
}

