/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.DeleteResult;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class ErrorEntryHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Map.Entry<String, DeleteResult.Error>> {
    private StringBuilder accumulator = new StringBuilder();
    private String key;
    private String code;
    private String message;

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.accumulator.append(chars, start, length);
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "Key")) {
            this.key = this.accumulator.toString().trim();
        } else if (SaxUtils.equalsOrSuffix(qName, "Code")) {
            this.code = this.accumulator.toString().trim();
        } else if (SaxUtils.equalsOrSuffix(qName, "Message")) {
            this.message = this.accumulator.toString().trim();
        }
        this.accumulator.setLength(0);
    }

    @Override
    public Map.Entry<String, DeleteResult.Error> getResult() {
        return Maps.immutableEntry(this.key, new DeleteResult.Error(this.code, this.message));
    }
}

