/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.io.ContentMetadata;
import org.jclouds.s3.domain.CanonicalUser;

public interface ObjectMetadata
extends Comparable<ObjectMetadata> {
    public String getKey();

    public String getBucket();

    public URI getUri();

    public CanonicalUser getOwner();

    public StorageClass getStorageClass();

    @Deprecated
    public String getCacheControl();

    public Date getLastModified();

    public String getETag();

    public Map<String, String> getUserMetadata();

    public ContentMetadata getContentMetadata();

    public static enum StorageClass {
        STANDARD(Tier.STANDARD),
        STANDARD_IA(Tier.INFREQUENT),
        ONEZONE_IA(Tier.INFREQUENT),
        REDUCED_REDUNDANCY(Tier.STANDARD),
        GLACIER(Tier.ARCHIVE),
        DEEP_ARCHIVE(Tier.ARCHIVE);

        private final Tier tier;

        private StorageClass(Tier tier) {
            this.tier = Preconditions.checkNotNull(tier, "tier");
        }

        public static StorageClass fromTier(Tier tier) {
            switch (tier) {
                case STANDARD: {
                    return STANDARD;
                }
                case INFREQUENT: {
                    return STANDARD_IA;
                }
                case ARCHIVE: {
                    return DEEP_ARCHIVE;
                }
            }
            throw new IllegalArgumentException("invalid tier: " + (Object)((Object)tier));
        }

        public Tier toTier() {
            return this.tier;
        }
    }
}

