/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.domain.MutableObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.internal.MutableObjectMetadataImpl;

public class BlobToObjectMetadata
implements Function<BlobMetadata, MutableObjectMetadata>,
InvocationContext<BlobToObjectMetadata> {
    private String bucket;

    @Override
    public MutableObjectMetadata apply(BlobMetadata from) {
        if (from == null) {
            return null;
        }
        MutableObjectMetadataImpl to = new MutableObjectMetadataImpl();
        HttpUtils.copy(from.getContentMetadata(), to.getContentMetadata());
        to.setUri(from.getUri());
        to.setETag(from.getETag());
        to.setKey(from.getName());
        to.setBucket(this.bucket);
        to.setLastModified(from.getLastModified());
        if (from.getUserMetadata() != null) {
            for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
                to.getUserMetadata().put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        if (from.getTier() != null) {
            to.setStorageClass(ObjectMetadata.StorageClass.fromTier(from.getTier()));
        }
        return to;
    }

    @Override
    public BlobToObjectMetadata setContext(HttpRequest request) {
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "note this handler requires a GeneratedHttpRequest");
        return this.setBucket(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getInvocation().getArgs().get(0).toString());
    }

    private BlobToObjectMetadata setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }
}

