/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import java.util.Date;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.Change;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ChangeHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Change> {
    private final DateService dateService;
    private StringBuilder currentText = new StringBuilder();
    private String id;
    private Change.Status status;
    private Date submittedAt;

    @Inject
    protected ChangeHandler(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public Change getResult() {
        try {
            Change change = Change.create(this.id, this.status, this.submittedAt);
            return change;
        }
        finally {
            this.id = null;
            this.status = null;
            this.submittedAt = null;
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Id")) {
            this.id = SaxUtils.currentOrNull(this.currentText).replace("/change/", "");
        } else if (qName.equals("Status")) {
            this.status = Change.Status.fromValue(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("SubmittedAt")) {
            this.submittedAt = this.dateService.iso8601DateParse(SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

