/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.xml.ErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.route53.InvalidChangeBatchException;
import org.jclouds.route53.xml.InvalidChangeBatchHandler;

@Singleton
public class Route53ErrorHandler
implements HttpErrorHandler {
    private final ParseSax.Factory factory;
    private final Provider<ErrorHandler> handlers;
    private final Provider<InvalidChangeBatchHandler> batchHandlers;

    @Inject
    Route53ErrorHandler(ParseSax.Factory factory, Provider<ErrorHandler> handlers, Provider<InvalidChangeBatchHandler> batchHandlers) {
        this.factory = factory;
        this.handlers = handlers;
        this.batchHandlers = batchHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        Exception exception = new HttpResponseException(command, response);
        try {
            String message;
            byte[] data = HttpUtils.closeClientButKeepContentStream(response);
            String string = message = data != null ? new String(data) : null;
            if (message != null) {
                exception = new HttpResponseException(command, response, message);
                if (message.indexOf("ErrorResponse") != -1) {
                    AWSError error = (AWSError)this.factory.create(this.handlers.get()).parse(message);
                    exception = this.refineException(new AWSResponseException(command, response, error));
                } else if (message.indexOf("InvalidChangeBatch") != -1) {
                    ImmutableList errors = (ImmutableList)this.factory.create(this.batchHandlers.get()).parse(message);
                    exception = new InvalidChangeBatchException(errors, new HttpResponseException(command, response));
                }
            }
        }
        finally {
            HttpUtils.releasePayload(response);
            command.setException(exception);
        }
    }

    private Exception refineException(AWSResponseException in) {
        int statusCode = in.getResponse().getStatusCode();
        String errorCode = in.getError().getCode();
        String message = in.getError().getMessage();
        if (statusCode == 403 || "RequestExpired".equals(errorCode)) {
            return new AuthorizationException(message, in);
        }
        if (statusCode == 400) {
            if (ImmutableSet.of("InvalidAction", "AccessDenied").contains(errorCode)) {
                return new UnsupportedOperationException(message, in);
            }
            if ("Throttling".equals(errorCode)) {
                return new InsufficientResourcesException(message, in);
            }
            if (message.indexOf("not found") != -1) {
                return new ResourceNotFoundException(message, in);
            }
            return new IllegalArgumentException(message, in);
        }
        return in;
    }
}

