/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.domain.HostedZone;
import org.jclouds.route53.features.HostedZoneApi;

@Beta
public class HostedZonesToPagedIterable
extends CallerArg0ToPagedIterable<HostedZone, HostedZonesToPagedIterable> {
    private final Route53Api api;

    @Inject
    protected HostedZonesToPagedIterable(Route53Api api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    protected Function<Object, IterableWithMarker<HostedZone>> markerToNextForCallingArg0(String ignored2) {
        final HostedZoneApi zoneApi = this.api.getHostedZoneApi();
        return new Function<Object, IterableWithMarker<HostedZone>>(){

            @Override
            public IterableWithMarker<HostedZone> apply(Object input) {
                return zoneApi.listAt(input.toString());
            }

            public String toString() {
                return "listHostedZones()";
            }
        };
    }
}

