/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.handlers;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class ParseCloudLoadBalancersErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final Pattern RESOURCE_PATTERN = Pattern.compile("^/v1[^/]*/[0-9]+/([^/]+)/([0-9]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        void var3_9;
        HttpResponseException httpResponseException = new HttpResponseException(command, response);
        try {
            String content = this.parseErrorFromContentOrNull(command, response);
            HttpResponseException httpResponseException2 = content != null ? new HttpResponseException(command, response, content) : httpResponseException;
            switch (response.getStatusCode()) {
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException(httpResponseException2.getMessage(), httpResponseException2);
                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    Matcher matcher = RESOURCE_PATTERN.matcher(path);
                    String message = matcher.find() ? String.format("%s %s not found", matcher.group(1), matcher.group(2)) : path;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message);
                    break;
                }
                case 409: {
                    IllegalStateException illegalStateException = new IllegalStateException(content);
                    break;
                }
                default: {
                    HttpResponseException httpResponseException3 = new HttpResponseException(command, response, content);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.releasePayload(response);
            command.setException(httpResponseException);
            throw throwable;
        }
        HttpUtils.releasePayload(response);
        command.setException((Exception)var3_9);
    }

    String parseErrorFromContentOrNull(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Strings2.toStringAndClose(response.getPayload().openStream());
            }
            catch (IOException e) {
                this.logger.warn(e, "exception reading error from response", response);
            }
        }
        return null;
    }
}

