/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;

public class VirtualIPWithId
extends VirtualIP {
    private final int id;
    private final String address;

    public VirtualIPWithId(VirtualIP.Type type, VirtualIP.IPVersion ipVersion, int id, String address) {
        super(type, ipVersion);
        this.id = id;
        this.address = Preconditions.checkNotNull(address, "address");
    }

    public int getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("address", this.address).add("ipVersion", (Object)this.getIpVersion()).add("type", (Object)this.getType());
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualIPWithId that = (VirtualIPWithId)VirtualIPWithId.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }
}

