/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseLoadBalancer;

public class UpdateLoadBalancer {
    private final String name;
    private final String protocol;
    private final Integer port;
    private final BaseLoadBalancer.Algorithm algorithm;
    private final Integer timeout;
    private final Boolean halfClosed;

    protected UpdateLoadBalancer(@Nullable String name, @Nullable String protocol, @Nullable Integer port, @Nullable BaseLoadBalancer.Algorithm algorithm, @Nullable Integer timeout, @Nullable Boolean halfClosed) {
        this.name = name;
        this.protocol = protocol;
        this.port = port;
        this.algorithm = algorithm;
        this.timeout = timeout;
        this.halfClosed = halfClosed;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Integer getPort() {
        return this.port;
    }

    public BaseLoadBalancer.Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Boolean isHalfClosed() {
        return this.halfClosed;
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("algorithm", (Object)this.algorithm).add("port", this.port).add("protocol", this.protocol).add("timeout", this.timeout).add("halfClosed", this.halfClosed);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.name, this.algorithm, this.port, this.protocol, this.timeout, this.halfClosed});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateLoadBalancer that = (UpdateLoadBalancer)UpdateLoadBalancer.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal((Object)this.algorithm, (Object)that.algorithm) && Objects.equal(this.port, that.port) && Objects.equal(this.protocol, that.protocol) && Objects.equal(this.timeout, that.timeout) && Objects.equal(this.halfClosed, that.halfClosed);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder {
        private String name;
        private String protocol;
        private Integer port;
        private BaseLoadBalancer.Algorithm algorithm;
        private Integer timeout;
        private Boolean halfClosed;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder algorithm(BaseLoadBalancer.Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder halfClosed(Boolean halfClosed) {
            this.halfClosed = halfClosed;
            return this;
        }

        public UpdateLoadBalancer build() {
            return new UpdateLoadBalancer(this.name, this.protocol, this.port, this.algorithm, this.timeout, this.halfClosed);
        }

        public Builder from(UpdateLoadBalancer lb) {
            return this.name(lb.getName()).port(lb.getPort()).protocol(lb.getProtocol()).algorithm(lb.getAlgorithm()).timeout(lb.getTimeout()).halfClosed(lb.isHalfClosed());
        }
    }
}

