/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;

public final class AccountUsage {
    private final int numPublicVIPs;
    private final int numServiceNetVIPs;
    private final int numLoadBalancers;
    private final Date startTime;
    private final Optional<Date> endTime;

    @ConstructorProperties(value={"numPublicVips", "numServicenetVips", "numLoadBalancers", "startTime", "endTime"})
    protected AccountUsage(int numPublicVIPs, int numServiceNetVIPs, int numLoadBalancers, Date startTime, Date endTime) {
        this.numPublicVIPs = numPublicVIPs;
        this.numServiceNetVIPs = numServiceNetVIPs;
        this.numLoadBalancers = numLoadBalancers;
        this.startTime = Preconditions.checkNotNull(startTime, "startTime");
        this.endTime = Optional.fromNullable(endTime);
    }

    public int getNumPublicVIPs() {
        return this.numPublicVIPs;
    }

    public int getNumServiceNetVIPs() {
        return this.numServiceNetVIPs;
    }

    public int getNumLoadBalancers() {
        return this.numLoadBalancers;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Optional<Date> getEndTime() {
        return this.endTime;
    }

    public int hashCode() {
        return Objects.hashCode(this.numPublicVIPs, this.numServiceNetVIPs, this.numLoadBalancers, this.startTime, this.endTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccountUsage that = (AccountUsage)AccountUsage.class.cast(obj);
        return Objects.equal(this.numPublicVIPs, that.numPublicVIPs) && Objects.equal(this.numServiceNetVIPs, that.numServiceNetVIPs) && Objects.equal(this.numLoadBalancers, that.numLoadBalancers) && Objects.equal(this.startTime, that.startTime) && Objects.equal(this.endTime, that.endTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("numPublicVIPs", this.numPublicVIPs).add("numServiceNetVIPs", this.numServiceNetVIPs).add("numLoadBalancers", this.numLoadBalancers).add("startTime", this.startTime).add("endTime", this.endTime.orNull()).toString();
    }
}

