/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import javax.inject.Named;

public class CDNContainer
implements Comparable<CDNContainer> {
    private String name;
    @Named(value="cdn_enabled")
    private boolean enabled;
    @Named(value="log_retention")
    private boolean logRetention;
    private int ttl;
    @Named(value="cdn_uri")
    private URI uri;
    @Named(value="cdn_ssl_uri")
    private URI sslUri;
    @Named(value="cdn_streaming_uri")
    private URI streamingUri;
    @Named(value="cdn_ios_uri")
    private URI iosUri;

    @ConstructorProperties(value={"name", "cdn_enabled", "log_retention", "ttl", "cdn_uri", "cdn_ssl_uri", "cdn_streaming_uri", "cdn_ios_uri"})
    public CDNContainer(String name, boolean enabled, boolean logRetention, int ttl, URI uri, URI sslUri, URI streamingUri, URI iosUri) {
        this.name = Preconditions.checkNotNull(name, "name required");
        this.enabled = enabled;
        this.logRetention = logRetention;
        this.ttl = ttl;
        this.uri = Preconditions.checkNotNull(uri, "uri required");
        this.sslUri = Preconditions.checkNotNull(sslUri, "sslUri required");
        this.streamingUri = Preconditions.checkNotNull(streamingUri, "streamingUri required");
        this.iosUri = Preconditions.checkNotNull(iosUri, "iosUri required");
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLogRetentionEnabled() {
        return this.logRetention;
    }

    public int getTtl() {
        return this.ttl;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getSslUri() {
        return this.sslUri;
    }

    public URI getStreamingUri() {
        return this.streamingUri;
    }

    public URI getIosUri() {
        return this.iosUri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CDNContainer that = (CDNContainer)CDNContainer.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.enabled, that.enabled) && Objects.equal(this.logRetention, that.logRetention) && Objects.equal(this.ttl, that.ttl) && Objects.equal(this.uri, that.uri) && Objects.equal(this.sslUri, that.sslUri) && Objects.equal(this.streamingUri, that.streamingUri) && Objects.equal(this.iosUri, that.iosUri);
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.isEnabled(), this.isLogRetentionEnabled(), this.getTtl(), this.getUri(), this.getSslUri(), this.getStreamingUri(), this.getIosUri());
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("name", this.getName()).add("enabled", this.isEnabled()).add("logRetention", this.isLogRetentionEnabled()).add("ttl", this.getTtl()).add("uri", this.getUri()).add("sslUri", this.getSslUri()).add("streamingUri", this.getStreamingUri()).add("iosUri", this.getIosUri());
    }

    @Override
    public int compareTo(CDNContainer that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.getName().compareTo(that.getName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private boolean enabled;
        private boolean logRetention;
        private int ttl;
        private URI uri;
        private URI sslUri;
        private URI streamingUri;
        private URI iosUri;

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder logRetention(boolean logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder sslUri(URI sslUri) {
            this.sslUri = sslUri;
            return this;
        }

        public Builder streamingUri(URI streamingUri) {
            this.streamingUri = streamingUri;
            return this;
        }

        public Builder iosUri(URI iosUri) {
            this.iosUri = iosUri;
            return this;
        }

        public CDNContainer build() {
            return new CDNContainer(this.name, this.enabled, this.logRetention, this.ttl, this.uri, this.sslUri, this.streamingUri, this.iosUri);
        }

        public Builder fromContainer(CDNContainer from) {
            return this.name(from.getName()).enabled(from.isEnabled()).logRetention(from.isLogRetentionEnabled()).ttl(from.getTtl()).uri(from.getUri()).sslUri(from.getSslUri()).streamingUri(from.getStreamingUri()).iosUri(from.getIosUri());
        }
    }
}

