/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.clouddns.v1.domain.Domain;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.domain.Subdomain;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecord;

public class ParseDomain
implements Function<HttpResponse, Domain> {
    private final ParseJson<RawDomain> json;

    @Inject
    ParseDomain(ParseJson<RawDomain> json) {
        this.json = Preconditions.checkNotNull(json, "json");
    }

    @Override
    public Domain apply(HttpResponse response) {
        RawDomain rawDomain = this.json.apply(response);
        if (rawDomain == null) {
            return null;
        }
        return rawDomain.getDomain();
    }

    static class RawDomain
    extends Domain {
        @ConstructorProperties(value={"id", "name", "emailAddress", "comment", "created", "updated", "accountId", "ttl", "nameservers", "subdomains", "recordsList"})
        protected RawDomain(int id, String name, String emailAddress, String comment, Date created, Date updated, int accountId, int ttl, Iterable<Map<String, String>> nameservers, SubdomainsWithTotalEntries subdomainsWTE, RecordsWithTotalEntries recordsWTE) {
            super(id, name, emailAddress, comment, created, updated, accountId, ttl, RawDomain.transform(nameservers), RawDomain.transform(subdomainsWTE), RawDomain.transform(recordsWTE));
        }

        public Domain getDomain() {
            return this.from(this);
        }

        private static Set<String> transform(Iterable<Map<String, String>> nameserversNasty) {
            ImmutableSet.Builder nameservers = ImmutableSet.builder();
            for (Map<String, String> nameToNameserver : nameserversNasty) {
                nameservers.add(nameToNameserver.get("name"));
            }
            return nameservers.build();
        }

        private static Set<Subdomain> transform(SubdomainsWithTotalEntries subdomainsWTE) {
            if (subdomainsWTE == null) {
                return null;
            }
            return ImmutableSet.copyOf(subdomainsWTE.subdomains);
        }

        private static Set<RecordDetail> transform(RecordsWithTotalEntries recordsWTE) {
            if (recordsWTE == null) {
                return null;
            }
            ImmutableSet<RecordDetail> recordDetails = FluentIterable.from(recordsWTE.records).transform(ParseRecord.toRecordDetails).toSet();
            return recordDetails;
        }

        private static class RecordsWithTotalEntries {
            private Set<ParseRecord.RawRecord> records;

            @ConstructorProperties(value={"records"})
            protected RecordsWithTotalEntries(Set<ParseRecord.RawRecord> records) {
                this.records = records;
            }
        }

        private static class SubdomainsWithTotalEntries {
            @Named(value="domains")
            private Iterable<Subdomain> subdomains;

            @ConstructorProperties(value={"domains"})
            protected SubdomainsWithTotalEntries(Iterable<Subdomain> subdomains) {
                this.subdomains = subdomains;
            }
        }
    }
}

