/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.loadbalancer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.domain.LoadBalancer;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.http.parser.firewall.FirewallListResponseHandler;
import org.jclouds.profitbricks.http.parser.loadbalancer.BaseLoadBalancerResponseHandler;
import org.jclouds.profitbricks.http.parser.server.ServerListResponseHandler;
import org.xml.sax.SAXException;

public class LoadBalancerListResponseHandler
extends BaseLoadBalancerResponseHandler<List<LoadBalancer>> {
    private final List<LoadBalancer> loadBalancers = Lists.newArrayList();

    @Inject
    LoadBalancerListResponseHandler(DateService dateService, ServerListResponseHandler balancedServerResponseHandler, FirewallListResponseHandler firewallListResponseHandler) {
        super(dateService, balancedServerResponseHandler, firewallListResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.useBalancedServerParser) {
            this.balancedServerResponseHandler.endElement(uri, localName, qName);
        } else if (this.useFirewallParser) {
            this.firewallListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName)) {
                this.loadBalancers.add(this.builder.dataCenter(this.dataCenterBuilder.build()).firewalls((List<Firewall>)this.firewallListResponseHandler.getResult()).balancedServers((List<Server>)this.balancedServerResponseHandler.getResult()).build());
                this.balancedServerResponseHandler.reset();
                this.firewallListResponseHandler.reset();
                this.builder = LoadBalancer.builder();
            }
            this.clearTextBuffer();
        }
        if ("firewall".equals(qName)) {
            this.useFirewallParser = false;
        } else if ("balancedServers".equals(qName)) {
            this.useBalancedServerParser = false;
        }
    }

    @Override
    public void reset() {
        this.dataCenterBuilder = DataCenter.builder();
    }

    @Override
    public List<LoadBalancer> getResult() {
        return this.loadBalancers;
    }
}

