/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute.strategy;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.logging.Logger;
import org.jclouds.profitbricks.ProfitBricksApi;
import org.jclouds.profitbricks.compute.strategy.TemplateWithDataCenter;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Location;

@Singleton
@Beta
public class AssignDataCenterToTemplate
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ProfitBricksApi api;
    private final Predicate<String> waitDcUntilAvailable;

    @Inject
    protected AssignDataCenterToTemplate(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, ProfitBricksApi api, @Named(value="jclouds.profitbricks.predicate.datacenter") Predicate<String> waitDcUntilAvailable) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = api;
        this.waitDcUntilAvailable = waitDcUntilAvailable;
    }

    @Override
    public Map<?, ListenableFuture<Void>> execute(String group, int count, final Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        this.logger.info(">> looking for a datacenter in %s", template.getLocation().getId());
        DataCenter dataCenter = Iterables.find(this.api.dataCenterApi().getAllDataCenters(), new Predicate<DataCenter>(){

            @Override
            public boolean apply(DataCenter input) {
                DataCenter details = AssignDataCenterToTemplate.this.api.dataCenterApi().getDataCenter(input.id());
                return details != null && template.getLocation().getId().equals(details.location().getId());
            }
        }, null);
        if (dataCenter == null) {
            String name = this.namingConvention.create().sharedNameForGroup(group);
            this.logger.info(">> no datacenter was found. Creating a new one named %s in %s...", name, template.getLocation().getId());
            dataCenter = this.api.dataCenterApi().createDataCenter(DataCenter.Request.creatingPayload(name, Location.fromId(template.getLocation().getId())));
            this.waitDcUntilAvailable.apply(dataCenter.id());
        }
        return super.execute(group, count, new TemplateWithDataCenter(template, dataCenter), goodNodes, badNodes, customizationResponses);
    }
}

