/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute.concurrent;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.jclouds.concurrent.config.WithSubmissionTrace;
import org.jclouds.logging.Logger;
import org.jclouds.profitbricks.compute.concurrent.ProvisioningJob;

public final class ProvisioningManager
implements Closeable {
    @Resource
    private Logger logger = Logger.NULL;
    private final Map<String, ListeningExecutorService> workers = new ConcurrentHashMap<String, ListeningExecutorService>(1);
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public Object provision(ProvisioningJob job) {
        if (this.terminated.get()) {
            this.logger.warn("Job(%s) submitted but the provisioning manager is already closed", job);
            return null;
        }
        this.logger.debug("Job(%s) submitted to group '%s'", job, job.getGroup());
        ListeningExecutorService workerGroup = this.getWorkerGroup(job.getGroup());
        return Futures.getUnchecked(workerGroup.submit(job));
    }

    protected ListeningExecutorService newExecutorService() {
        return WithSubmissionTrace.wrap(MoreExecutors.listeningDecorator(Executors.newSingleThreadExecutor()));
    }

    private void newWorkerGroupIfAbsent(String name) {
        if (!this.workers.containsKey(name)) {
            this.workers.put(name, this.newExecutorService());
        }
    }

    private ListeningExecutorService getWorkerGroup(String name) {
        this.newWorkerGroupIfAbsent(name);
        return this.workers.get(name);
    }

    @Override
    public void close() throws IOException {
        this.terminated.set(true);
        Collection<ListeningExecutorService> executors = this.workers.values();
        for (ListeningExecutorService executor : executors) {
            List<Runnable> runnables = executor.shutdownNow();
            if (runnables.isEmpty()) continue;
            this.logger.warn("when shutting down executor %s, runnables outstanding: %s", executor, runnables);
        }
    }
}

