/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.packet.domain.Plan;
import org.jclouds.packet.domain.Specs;

@Singleton
public class PlanToHardware
implements Function<Plan, Hardware> {
    @Override
    public Hardware apply(Plan plan) {
        HardwareBuilder builder = new HardwareBuilder().ids(plan.slug()).name(plan.name()).hypervisor("none").processors(this.getProcessors(plan)).ram(this.getMemory(plan)).volumes(this.getVolumes(plan));
        return builder.build();
    }

    private Integer getMemory(Plan plan) {
        if (plan.specs() == null || plan.specs().drives() == null) {
            return 0;
        }
        String total = plan.specs().memory().total();
        if (total.endsWith("GB")) {
            return Integer.valueOf(total.substring(0, total.length() - 2)) * 1024;
        }
        throw new IllegalArgumentException("Cannot parse memory: " + plan.specs().memory());
    }

    private Iterable<Volume> getVolumes(Plan plan) {
        if (plan.specs() == null || plan.specs().drives() == null) {
            return Lists.newArrayList();
        }
        return Iterables.transform(plan.specs().drives(), new Function<Specs.Drive, Volume>(){

            @Override
            public Volume apply(Specs.Drive drive) {
                return new VolumeImpl(drive.type(), Volume.Type.LOCAL, Float.valueOf(Float.parseFloat(drive.size().substring(0, drive.size().length() - 2))), null, true, false);
            }
        });
    }

    private Iterable<Processor> getProcessors(Plan plan) {
        if (plan.specs() == null || plan.specs().cpus() == null) {
            return Lists.newArrayList();
        }
        return Iterables.transform(plan.specs().cpus(), new Function<Specs.CPU, Processor>(){

            @Override
            public Processor apply(Specs.CPU input) {
                return new Processor(input.count().intValue(), input.count().intValue());
            }
        });
    }
}

