/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class BindGrantUserToJson
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        List<String> databases = Lists.newArrayList();
        if (postParams.get("databaseName") != null) {
            databases.add((String)postParams.get("databaseName"));
        } else if (postParams.get("databases") != null) {
            databases = (List)postParams.get("databases");
        }
        ArrayList databaseList = Lists.newArrayList();
        for (String databaseName : databases) {
            HashMap<String, String> singleDatabase = Maps.newHashMap();
            singleDatabase.put("name", databaseName);
            databaseList.add(singleDatabase);
        }
        return this.jsonBinder.bindToRequest(request, (Object)ImmutableMap.of("databases", databaseList));
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("Grant user is a PUT operation");
    }
}

